<?php
/** PHP 7.4 features added */
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly
/**
 *   The Template for displaying all single posts.
 */
/*! ** DO NOT EDIT THIS FILE! It will be overwritten when the theme is updated! ** */

weaverx_set_cur_page_id(0);    // no page for this type
$sb_layout = weaverx_page_lead('single');

// and next the content area.
weaverx_sb_precontent('single');

// generate page content

$cats = weaverx_getopt_checked('single_nav_link_cats');
while (have_posts()) {
    weaverx_post_count_clear();
    the_post(); ?>
    <nav id="nav-above" class="navigation">
        <h3 class="assistive-text"><?php esc_html_e('Post navigation', 'weaver-xtreme'); ?></h3>

        <?php if (weaverx_getopt('single_nav_style') == 'prev_next') { ?>
            <div class="nav-previous"><?php previous_post_link('%link', '<span class="meta-nav">' . esc_html(_x('&larr;', 'Previous post link', 'weaver-xtreme')) . '</span> ' . esc_html__('Previous', 'weaver-xtreme'), $cats); ?></div>

            <div class="nav-next"><?php next_post_link('%link', esc_html__('Next', 'weaver-xtreme') . ' <span class="meta-nav">' . esc_html(_x('&rarr;', 'Next Post link', 'weaver-xtreme')) . '</span>', $cats); ?></div>

        <?php } elseif (weaverx_getopt('single_nav_style') == 'title') { ?>

            <div class="nav-previous"><?php previous_post_link('%link', '<span class="meta-nav">' . esc_html(_x('&larr;', 'Previous post link', 'weaver-xtreme')) . '</span> %title', $cats); ?>
            </div>
            <div class="nav-next"><?php next_post_link('%link', '%title <span class="meta-nav">' . esc_html(_x('&rarr;', 'Next post link', 'weaver-xtreme')) . '</span>', $cats); ?></div>

        <?php } ?>
    </nav><!-- #nav-above -->

    <?php get_template_part('templates/content', 'single'); ?>

    <nav id="nav-below" class="navigation">
        <h3 class="assistive-text"><?php esc_html_e('Post navigation', 'weaver-xtreme'); ?></h3>
        <?php if (weaverx_getopt('single_nav_style') == 'prev_next') { ?>
            <div class="nav-previous"><?php previous_post_link('%link', '<span class="meta-nav">' . esc_html(_x('&larr;', 'Previous post link', 'weaver-xtreme')) . '</span> ' . esc_html__('Previous', 'weaver-xtreme'), $cats); ?></div>

            <div class="nav-next"><?php next_post_link('%link', esc_html__('Next', 'weaver-xtreme') . ' <span class="meta-nav">' . esc_html(_x('&rarr;', 'Next Post link', 'weaver-xtreme')) . '</span>', $cats); ?></div>

        <?php } elseif (weaverx_getopt('single_nav_style') == 'title') { ?>
            <div class="nav-previous"><?php previous_post_link('%link', '<span class="meta-nav">' . esc_html(_x('&larr;', 'Previous post link', 'weaver-xtreme')) . '</span> %title', weaverx_getopt_checked('single_nav_link_cats')); ?></div>
            <div class="nav-next"><?php next_post_link('%link', '%title <span class="meta-nav">' . esc_html(_x('&rarr;', 'Next post link', 'weaver-xtreme')) . '</span>', $cats); ?></div>
        <?php } ?>
    </nav><!-- #nav-below -->

    <?php comments_template('', true);

} // end of the loop.

weaverx_sb_postcontent('single');

weaverx_page_tail('single', $sb_layout);    // end of page wrap
