<?php
/** PHP 7.4 features added */
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly
/**
 * The Header for Weaver Xtreme
 *
 * Displays all of the <head> section and everything up till < div id="container" >
 *
 * @package WordPress
 * @subpackage Weaver X
 * @since Weaver Xtreme 1.0
 *
 *    >>>> DO NOT EDIT THIS FILE <<<<
 *
 * Warning! DO NOT EDIT THIS FILE, or any other theme file! If you edit ANY theme
 * file, all your changes will be LOST when you update the theme to a newer version.
 * Instead, if you need to change theme functionality, CREATE A CHILD THEME!
 *
 *    >>>> DO NOT EDIT THIS FILE <<<<
 */
if (!isset($GLOBALS['weaverx_page_who'])) {
    $GLOBALS['weaverx_page_who'] = 'unknown';
}
do_action('weaverx_alt_theme', 'raw');

?><!DOCTYPE html>
<html <?php language_attributes(); ?>> <!--<![endif]-->
<head>
    <meta charset="<?php bloginfo('charset'); ?>"/>
    <?php
    $viewport = "<meta name='viewport' content='width=device-width,initial-scale=1.0' />\n"; /* use full horizontal size on iPad */
    echo $viewport;
    ?>

    <link rel="pingback" href="<?php esc_url(get_bloginfo('pingback_url')); ?>"/>

    <!-- Weaver Xtreme Standard Google Fonts -->
    <?php

    if (!weaverx_getopt('disable_google_fonts')) {
        $fontUrl = $fontPath = weaverx_relative_url('assets/css/fonts/google/google-fonts.css') . '?ver=' . WEAVERX_VERSION;
        $url = get_site_url();
        echo("<link href='$url$fontUrl' rel='stylesheet' type='text/css'>\n");
    }


    // ++++ FAVICON - only if option has been set ++++
    $icon = weaverx_getopt('_favicon_url');
    if ($icon != '') {
        $url = esc_url(apply_filters('weaverx_css', parse_url($icon, PHP_URL_PATH)));
        echo "<link rel=\"shortcut icon\"  href=\"$url\" />\n";
    }
    ?>
    <style>
        html, body, div, span, iframe {
            background: transparent;
            border: 0;
            margin: 0;
            outline: 0;
            padding: 0;
            vertical-align: baseline;
        }
    </style>

    <?php
    global $post;
    if (is_object($post)) {
        weaverx_set_cur_page_id(get_the_ID());
    }    // we're on a page now, so set the post id for the rest of the session
    else {
        weaverx_set_cur_page_id(0);
    }    // no page

    $per_page_code = weaverx_get_per_page_value('page-head-code');

    if (!empty($per_page_code)) {
        echo($per_page_code);
    }
    ?>

</head>

<body class="raw">
<div id="wrap" class="hfeed">
