<?php
/** PHP 7.4 features added */
/** @noinspection PhpRedundantOptionalArgumentInspection */
/** @noinspection PhpUnusedParameterInspection */
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly
/**
 * Weaver Xtreme functions and definitions
 *
 *    >>>> DO NOT EDIT THIS FILE <<<<
 *
 * Warning! DO NOT EDIT THIS FILE, or any other theme file! If you edit ANY theme
 * file, all your changes will be LOST when you update the theme to a newer version.
 * Instead, if you need to change theme functionality, CREATE A CHILD THEME!
 *
 *    >>>> DO NOT EDIT THIS FILE <<<<
 *
 * Sets up the theme and provides some helper functions. Some helper functions
 * are used in the theme as custom template tags. Others are attached to action and
 * filter hooks in WordPress to change core functionality.
 *
 * The first function, weaverx_setup(), sets up the theme by registering support
 * for various features in WordPress, such as post thumbnails, navigation menus, and the like.
 *
 * This file formatted 4/8 on tabs
 *
 *    >>>> DO NOT EDIT THIS FILE <<<<
 */

add_action('after_setup_theme', 'weaverx_setup');     // run weaverx_setup() when the 'after_setup_theme' hook is run

if (!function_exists('weaverx_setup')) :
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which runs
     * before the init hook. The init hook is too late for some features, such as indicating
     * support post thumbnails.
     *
     * To override weaverx_setup() in a child theme, add your own weaverx_setup to your child theme's
     * functions.php file.
     *
     * @uses load_theme_textdomain() For translation/localization support.
     * @uses add_editor_style() To style the visual editor.
     * @uses add_theme_support() To add support for post thumbnails, automatic feed links, and Post Formats.
     * @uses register_nav_menus() To add support for navigation menus.
     * @uses register_default_headers() To register the default custom header images provided with the theme.
     * @uses set_post_thumbnail_size() To set a custom post thumbnail size
     * @uses add_theme_support('custom-header', $weaverx_header ) for WP 3.4+ custom header
     *
     *
     */
    function weaverx_setup(): void
    {

        if (!isset($GLOBALS['content_width'])) {
            $GLOBALS['content_width'] = ( int )(WEAVERX_THEME_WIDTH * .75);
        }
        $GLOBALS['weaverx_wooshop'] = 0;           // to handle Woocommerce Shop page

        /*
        * Make theme available for translation.
        * Translations can be filed in the /languages/ directory.
        */
        load_theme_textdomain('weaver-xtreme', get_theme_file_path('/languages'));        // now theme's translations as fallback

        // ******** add theme support possibilities ********


        // Add default posts and comments RSS feed links to head.
        add_theme_support('automatic-feed-links');

        // Let WordPress manage the document title.
        add_theme_support('title-tag');

        // Enable support for Post Thumbnails on posts and pages.
        add_theme_support('post-thumbnails');

        // Add theme support for selective refresh for widgets.
        add_theme_support('customize-selective-refresh-widgets');

        // html5 for search
        // 	future: comment-form, comment-list, gallery, caption
        add_theme_support('html5', array('search-form'));

        // Add support for responsive embedded content.
        add_theme_support('responsive-embeds');        // gutenberg


        // Add support for a variety of post formats ( not supported: chat )
        add_theme_support('post-formats', array(
            'aside',
            'audio',
            'gallery',
            'image',
            'link',
            'quote',
            'status',
            'video',
        ));


        // now, need Weaver Xtreme settings available for everything else

        weaverx_init_opts('functions');

        // Now add all the support needed for the editor - both classic and block editor

        // Weaver Xtreme provides its own block styles, so we don't want to include
        //    add_theme_support( 'wp-block-styles' );
        // because it pulls in  wp-includes/css/dist/block-library/theme.min.css

        // Add support for default block styles.
        add_theme_support('wp-block-styles');

        // Add support for full and wide align images.
        add_theme_support('align-wide');

        // Add support for editor styles.
        add_theme_support('editor-styles');


        if (weaverx_getopt('_hide_editor_style')) {
            // Enqueue editor styles - without theme editor styles
            add_editor_style(array(
                'editor-style.css',        // classic editor
                'assets/css/blocks-editor-base-style' . WEAVERX_MINIFY . '.css',   // gutenberg
                'assets/css/fonts/google/google-fonts.css', // pre V6: WEAVERX_GOOGLE_FONTS_URL,
            ));    // from settings.php - in %7C format
        } else {
            weaverx_check_editor_style();        // see if we need an update...
            $vers = weaverx_getopt('style_version');
            if (!$vers) {
                $vers = '1';
            } else {
                $vers = sprintf("%d", $vers);
            }        // need version for cloudflare or other caching services

            $upload_dir = wp_upload_dir(); // Grab uploads folder array
            $dir = trailingslashit($upload_dir['basedir']) . WEAVERX_SUBTHEMES_DIR . DIRECTORY_SEPARATOR; // Set storage directory path
            $url = trailingslashit($upload_dir['baseurl']) . WEAVERX_SUBTHEMES_DIR . DIRECTORY_SEPARATOR; // Set storage directory path


            $file_name = $dir . 'classic-editor-style-wvrx.css'; // filename
            $css_url = $url . 'classic-editor-style-wvrx.css'; // filename


            if (@file_exists($file_name)) {              // need to see if the generated classic editor .css file has been generated
                // Enqueue editor styles - without theme editor styles
                add_editor_style(array(
                    'editor-style.css',        // classic editor
                    'assets/css/blocks-editor-base-style' . WEAVERX_MINIFY . '.css',    // gutenberg
                    $css_url . '?vers=' . $vers,
                    'assets/css/fonts/google/google-fonts.css',     // pre V6: WEAVERX_GOOGLE_FONTS_URL,
                ));
            } else {    // don't have theme support plugin to generate the classic-editor-style-wvrx.css file, or just inline editor css
                add_editor_style(array(
                    'editor-style.css',        // classic editor
                    'assets/css/blocks-editor-base-style' . WEAVERX_MINIFY . '.css',    // gutenberg
                    'assets/css/fonts/google/google-fonts.css',     // pre V6: WEAVERX_GOOGLE_FONTS_URL,
                ));
            }


            // ToDo: Use 'tiny_mce_before_init'
        }

        weaverx_dark_theme_check();        // add Block Editor dark theme support if theme settings have dark bg

        $width = weaverx_getopt_default('theme_width_int', WEAVERX_THEME_WIDTH);

        $height = weaverx_getopt_default('header_image_height_int', 188);        // now that everything is responsive, we can just set this to an arbitrary height.

        // Enable support for custom logo.

        add_theme_support('custom-logo',
            array(
                'height' => $height,
                'width' => $width,
                'flex-height' => true,
            )
        );

        $weaverx_header_args = array(
            'default-image' => '%s/assets/images/headers/winter-fog.jpg',
            'random-default' => true,
            'width' => $width,
            'height' => $height,
            'flex-height' => true,
            'flex-width' => true,
            'default-text-color' => '',
            'header-text' => false,
            'uploads' => true,
            'video' => true,
            'wp-head-callback' => '',
            'admin-head-callback' => 'weaverx_admin_header_style',
            'admin-preview-callback' => '',
        );


        $GLOBALS['content_width'] = $width;    // let the WP $content_width be the same as theme width, and let our responsive CSS make it work.

        add_theme_support('custom-header', $weaverx_header_args);
        add_theme_support('custom-background');


        if (WEAVERX_DEV_MODE) {
            if (defined('E_DEPRECATED')) {
                error_reporting(E_ALL & ~E_WARNING & ~E_DEPRECATED);
            }
        } else {
            if (defined('E_DEPRECATED')) {
                error_reporting(E_ALL & ~E_DEPRECATED & ~E_USER_DEPRECATED);
            }
        }

        // We'll be using post thumbnails for custom header images on posts and pages.
        // We want them to be the size of the header image that we just defined
        // Larger images will be auto-cropped to fit, smaller ones will be ignored. See header.php.

        weaverx_register_header_images();

        // Weaver Xtreme supports two main nav menus
        register_nav_menus(array(
            'primary' => esc_html__('Primary Navigation: if specified, used instead of Default menu', 'weaver-xtreme'),
            'secondary' => esc_html__('Secondary Navigation: if specified, adds 2nd menu bar', 'weaver-xtreme'),
            'header-mini' => esc_html__('Header Mini Menu: if specified, adds horizontal mini-menu to header', 'weaver-xtreme'),
        ));
    }
endif; // weaverx_setup
//--

if (!function_exists('weaverx_init_opts')) :
    function weaverx_init_opts($who = ''): void
    {
        // this sets either the current settings, or the default values.

        remove_action('admin_enqueue_scripts', 'weaverxplus_admin_enqueue_scripts');    // fix for deprecated jQuery.fn.load
        weaverx_clear_opt_cache('weaverx_init_opts');    // start with a clear cache

        $themename = weaverx_getopt('themename'); // load the theme from the db if there ( weaverx_getopt loads the options if there )

        if ($themename == '') {
            require_once(get_theme_file_path('/includes/get-default-settings.php'));  // load a set of defaults
            weaverx_get_default_settings();
            //$themename = weaverx_getopt('themename');
        }


        // Keep some info for max_input_vars detection. These have to be collected here because the
        // WP settings API clears $_POST after the after_setup_theme action

        $GLOBALS['WVRX_POSTS'] = count($_POST, COUNT_RECURSIVE);    // count all elements
        $GLOBALS['WVRX_GETS'] = count($_GET, COUNT_RECURSIVE);
        $GLOBALS['WVRX_COOKIES'] = count($_COOKIE, COUNT_RECURSIVE);
    }
endif;
//--

if (!function_exists('weaverx_dark_theme_check')) :
    function weaverx_dark_theme_check(): void
    {

        $bg = '';
        if (($val = weaverx_getopt_default('editor_bgcolor', 'inherit')) && $val != 'inherit') {           /* alt bg color */
            $bg = $val;
        } elseif (($val = weaverx_getopt_default('content_bgcolor', 'inherit')) && $val != 'inherit') {    /* #content */
            $bg = $val;
        } elseif (($val = weaverx_getopt_default('container_bgcolor', 'inherit')) && $val != 'inherit') { /* #container */
            $bg = $val;
        } elseif (($val = weaverx_getopt_default('wrapper_bgcolor', 'inherit')) && $val != 'inherit') {    /* #wrapper */
            $bg = $val;
        } elseif (($val = weaverx_getopt_default('body_bgcolor', 'inherit')) && $val != 'inherit') {    /* Outside BG */
            $bg = $val;
        } elseif (($name = weaverx_getopt('themename')) && strpos($name, 'Transparent Dark') !== false) {    // fix in V3.0.5
            $bg = '#222';
        }


        // now decide if we need to add alternate styling for the editor icons

        $need_alt = $bg && $bg[0] != '#';                // always use alt styling for non-hex bg colors

        if (!$need_alt) {
            // Normalize a proper hex string with length 6 = but assume started as a #hex
            $hex = preg_replace("/[^0123456789abcdef]/", '', strtolower($bg));

            if (strlen($hex) == 3) {
                $hex = preg_replace("/(.)(.)(.)/", '\1\1\2\2\3\3', $hex);
            }
            if (preg_match('/^[0123456789abcdef]{6}$/', $hex)) {            // have a valid hex string
                if (hexdec($hex) < hexdec('888888'))    // hex values less than #888888 are "dark"
                {
                    $need_alt = true;
                }
            }
        }

        if ($need_alt) {
            add_theme_support('dark-editor-style');
        }
    }
endif; // dark theme check
//--

/**
 */
if (!function_exists('weaverx_register_header_images')) :
    function weaverx_register_header_images(): void
    {
        // Default custom headers packaged with the theme. %s is a placeholder for the theme template directory URI.
        register_default_headers(array(
            'webb-space' => array(
                'url' => '%s/assets/images/headers/webb-space.jpg',
                'thumbnail_url' => '%s/assets/images/headers/webb-space-thumbnail.jpg',
                /* translators: header image description */
                'description' => esc_html__('Webb Telescope', 'weaver-xtreme'),
            ),
            'maroon-bells' => array(
                'url' => '%s/assets/images/headers/maroon-bells.jpg',
                'thumbnail_url' => '%s/assets/images/headers/maroon-bells-thumbnail.jpg',
                /* translators: header image description */
                'description' => esc_html__('Maroon Bells', 'weaver-xtreme'),
            ),
            'beckwith-mtn' => array(
                'url' => '%s/assets/images/headers/beckwith-mtn.jpg',
                'thumbnail_url' => '%s/assets/images/headers/beckwith-mtn-thumbnail.jpg',
                /* translators: header image description */
                'description' => esc_html__('Colorado Autumn', 'weaver-xtreme'),
            ),
            'winter-fog' => array(
                'url' => '%s/assets/images/headers/winter-fog.jpg',
                'thumbnail_url' => '%s/assets/images/headers/winter-fog-thumbnail.jpg',
                /* translators: header image description */
                'description' => esc_html__('Wintry Fog', 'weaver-xtreme'),
            ),

        ));
    }
endif;
//--


if (!function_exists('weaverx_admin_header_style')) {
    /**
     * Styles the header image displayed on the Appearance > Header admin panel.
     */
    function weaverx_admin_header_style(): void
    {
        ?>
        <style>
            #headimg img {
                width: <?php echo weaverx_getopt_default('theme_width_int',WEAVERX_THEME_WIDTH);?>px;
                height: auto;
                max-width: 100%;
            }
        </style>
        <?php
    }
} // weaverx_admin_header_style
//--


add_action('widgets_init', 'weaverx_widgets_init_action');

/**
 * Register our sidebars and widgetized areas.
 *
 * @since Weaver Xtreme 1.0
 */
function weaverx_widgets_init_action(): void
{


    // Top located at the top of the sidebar.
    weaverx_register_sidebar(esc_html__('Primary Sidebar', 'weaver-xtreme'),
        'primary-widget-area',
        esc_html__('Primary sidebar widget area, displays on top, or left side for split sidebars', 'weaver-xtreme'));

    weaverx_register_sidebar(esc_html__('Secondary Sidebar', 'weaver-xtreme'),
        'secondary-widget-area',
        esc_html__('Secondary sidebar widget area, displays on bottom, or right side for split sidebars', 'weaver-xtreme'));


    ## Site-wide top area
    weaverx_register_sidebar(esc_html__('Sitewide Top Widget Area', 'weaver-xtreme'),
        'sitewide-top-widget-area',
        esc_html__('This widget area appears at the top of the content area on all site static pages and post pages ( including special post pages ) EXCEPT pages using the blank or iframe page templates.', 'weaver-xtreme'));

    ## Site-wide bottom area
    weaverx_register_sidebar(esc_html__('Sitewide Bottom Widget Area', 'weaver-xtreme'),
        'sitewide-bottom-widget-area',
        esc_html__('This widget area appears at the bottom of the content area on all site static pages and post pages ( including special post pages ) EXCEPT pages using the blank or iframe page templates.', 'weaver-xtreme'));

    ## page top widget area
    weaverx_register_sidebar(esc_html__('Pages Top Widget Area', 'weaver-xtreme'),
        'page-top-widget-area',
        esc_html__('The top widget area appears above the content area of pages. It is not displayed on archive-like post pages ( archives, etc. ).', 'weaver-xtreme'));

    ## page bottom widget area
    weaverx_register_sidebar(esc_html__('Pages Bottom Widget Area', 'weaver-xtreme'),
        'page-bottom-widget-area', esc_html__('The bottom widget area appears below the content area. It is not displayed on archive-like post pages.', 'weaver-xtreme'));

    ## posts top widget area
    weaverx_register_sidebar(esc_html__('Blog Top Widget Area', 'weaver-xtreme'),
        'blog-top-widget-area',
        esc_html__('The blog top widget area appears above the content area of blog pages, including page with posts templates, and post single page. It is not displayed on archive-like post pages.', 'weaver-xtreme'));

    ## posts blog bottom widget area
    weaverx_register_sidebar(esc_html__('Blog Bottom Widget Area', 'weaver-xtreme'),
        'blog-bottom-widget-area', esc_html__('The blog bottom widget area appears below the content area of blog pages, including page with posts templates, and post single page. It is not displayed on archive-like post pages.', 'weaver-xtreme'));


    ## Special Post Pages Top Widget area
    weaverx_register_sidebar(esc_html__('Archive-like Pages Top Widget Area', 'weaver-xtreme'),
        'postpages-widget-area',
        esc_html__('This widget area will appear at the top of archive-like post pages ( date archives, author, category, tag, search ).', 'weaver-xtreme'));


    // located in the header. Empty by default.
    weaverx_register_sidebar(esc_html__('Header Widget Area', 'weaver-xtreme'),
        'header-widget-area',
        esc_html__('The header widget area. Widgets in this area can be displayed horizontally.', 'weaver-xtreme'));

    // located in the footer. Empty by default.
    weaverx_register_sidebar(esc_html__('Footer Widget Area', 'weaver-xtreme'),
        'footer-widget-area',
        esc_html__('The footer widget area. Widgets in this area can be displayed horizontally.', 'weaver-xtreme'));

    $extra_areas = weaverx_getopt('_perpagewidgets');    // create extra areas?
    if (strlen($extra_areas) > 0) {
        $extra_list = explode(',', $extra_areas);
        foreach ($extra_list as $area) {
            weaverx_register_sidebar(esc_html__('Per Page Area ', 'weaver-xtreme') . $area,
                'per-page-' . $area,
                esc_html__('This widget area can be added using "', 'weaver-xtreme') .
                $area . esc_html__('" as the name for Per Page options or the Weaver Xtreme Plus [widget_area] shortcode. Style it using: ', 'weaver-xtreme') .
                '".per-page-' . $area . '".'
            );
        }
    }

}


if (!function_exists('weaverx_register_sidebar')) {
    /**
     * Register widgetized areas
     *
     * @param        $name
     * @param        $id
     * @param        $desc
     * @param string $altclass
     *
     * @since Weaver Xtreme 1.0
     */
    function weaverx_register_sidebar($name, $id, $desc, string $altclass = ''): void
    {
        if ('' != $altclass) {
            $altclass .= ' ';
        }
        register_sidebar(array(
            'name' => $name,
            'id' => $id,
            'description' => $desc,
            'before_widget' => '<aside id="%1$s" class="widget ' . $altclass . '%2$s">',
            'after_widget' => '</aside>',
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '</h3>',
        ));
    }
}
//--


// ================================ Weaver Xtreme admin ================================

add_action('wp_head', 'weaverx_wp_head_action');
/**
 * Theme wphead generation
 *
 * @since Weaver Xtreme 1.0
 *
 */
function weaverx_wp_head_action(): void
{    // action definition
    require_once(get_theme_file_path('/includes/wphead.php'));        // ( Not a template file )
    weaverx_generate_wphead();
}

//--


if (!function_exists('weaverx_enqueue_styles_action')) {
    /**
     * Enqueue theme stylesheets
     *
     * @since Weaver Xtreme 1.0
     *
     */
    function weaverx_enqueue_styles_action(): void
    {
        // Add stylesheets
        $sheet = get_theme_file_uri('/assets/css/fonts' . WEAVERX_MINIFY . '.css');
        wp_enqueue_style('weaverx-font-sheet', $sheet, array(), WEAVERX_VERSION, 'all');

        // Start with the "real" stylesheet ( so child theme style.css can override )

        $sheet = get_theme_file_uri('/assets/css/style-weaverx' . WEAVERX_MINIFY . '.css');

        wp_enqueue_style('weaverx-style-sheet', $sheet, array('weaverx-font-sheet'), WEAVERX_VERSION, 'all');
        //ToDo:  wp_enqueue_style( 'classicEditorNewStyles', get_theme_file_uri( '/assets/css/classic-edit-wvr.css' ) );
        //ToDo:  wp_add_inline_style('classicEditorNewStyles', '.mce-content-body {background-color: blue;}' );

        // Only add style.css if a child theme

        if (is_child_theme()) {  // don't bother with empty main style.css
            $sheet_dev = get_stylesheet_directory_uri() . '/style.css';    // get style.css
            $sheet = str_replace('.css', WEAVERX_MINIFY . '.css', $sheet_dev); // default sheet
            $sheet_file = get_stylesheet_directory() . '/style' . WEAVERX_MINIFY . '.css';
            if (!@file_exists($sheet_file)) {
                $sheet = $sheet_dev;
            }                   // no style.min.css available ( need this check for child themes )

            wp_enqueue_style('weaverx-root-style-sheet', $sheet, array('weaverx-style-sheet'), WEAVERX_VERSION, 'all');
        }

        // note: new theme settings will override Child CSS if there

        require_once(get_theme_file_path('/includes/generatecss.php'));    // include only now at runtime.

        // enqueue inline style - generate CSS rules in$GLOBALS['weaverx_css_saved'], then wp_add_line_style it.

        unset($GLOBALS['weaverx_css_saved']);
        $GLOBALS['weaverx_css_saved'] = '';
        weaverx_generate_style_css();
        //••echo "<-- ******* " . $GLOBALS['weaverx_css_saved'] . ' ***************************** -->';
        wp_add_inline_style('weaverx-style-sheet', weaverx_minify_css($GLOBALS['weaverx_css_saved']));
    }
}

//--
add_action('wp_enqueue_scripts', 'weaverx_enqueue_styles_action', 11);    // styles in normal order
add_action('wp_enqueue_scripts', 'weaverx_enqueue_scripts_action', 8);    // early priority so load before most other scripts ( added: 3.1.7 )
/**
 * Enqueue theme scripts
 *
 * @since Weaver Xtreme 1.0
 *
 */
function weaverx_enqueue_scripts_action(): void
{    // action definition

    // need to know the page template for some conditional script inclusion
    global $weaverx_cur_template;

    $weaverx_cur_template = (is_page()) ? get_page_template() : 'nonpage';

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }

    //-- Weaver Xtreme js lib - requires jQuery...

    // put this one in <head> to enhance performance slightly for menu fix-up

    wp_enqueue_script('weaver-xtreme-JSLib', get_theme_file_uri('/assets/js/weaverxjslib' . WEAVERX_MINIFY . '.js'), array('jquery'), WEAVERX_VERSION);

    $useSM = weaverx_getopt('use_smartmenus') ? '1' : '0';

    if ($useSM) {
        // must be weaverxSMLib handle so Weaver Xtreme Plus won't also load its version.
        wp_enqueue_script('weaverxSMLib', get_theme_file_uri('/assets/js/smartmenus/jquery.smartmenus' . WEAVERX_MINIFY . '.js'), array('jquery'), WEAVERX_VERSION);
    }

    $altsw = weaverx_getopt('mobile_alt_switch');
    if ($useSM == '0' || $altsw < 10) {
        $altsw = '767';
    }
    $altLabel = weaverx_getopt('mobile_alt_label');

    global $post;

    if (!weaverx_get_cur_page_id() && is_object($post)) {
        weaverx_set_cur_page_id(get_the_ID());
    }            // this must go before weaverx_get_video_render() call

    $GLOBALS['weaverx_wooshop'] = 0;                            // use weaverx_set/get_cur_page_id exclusively
    if (weaverx_is_archive()) {
        if (function_exists('is_shop')) {
            /** @noinspection PhpUndefinedFunctionInspection */
            $GLOBALS['weaverx_wooshop'] = wc_get_page_id('shop');
            weaverx_set_cur_page_id($GLOBALS['weaverx_wooshop']);
        }
    }


    $primary_move = weaverx_getopt('m_primary_move') ? '1' : '0';
    $secondary_move = weaverx_getopt('m_secondary_move') ? '1' : '0';

    $local = array(
        'useSmartMenus' => $useSM,
        'menuAltswitch' => $altsw,
        'mobileAltLabel' => $altLabel,
        'primaryScroll' => weaverx_getopt('m_primary_fixedtop'),
        'primaryMove' => $primary_move,
        'secondaryScroll' => weaverx_getopt('m_secondary_fixedtop'),
        'secondaryMove' => $secondary_move,
        'headerVideoClass' => weaverx_get_video_render(),
    );

    wp_localize_script('weaver-xtreme-JSLib', 'wvrxOpts', $local);

    wp_enqueue_script('weaver-xtreme-JSLibEnd', get_theme_file_uri('/assets/js/weaverxjslib-end' . WEAVERX_MINIFY . '.js'), array('jquery'), WEAVERX_VERSION, true);

    weaverx_masonry('enqueue-script');
}

//--

// Load files required to make the theme work!

require_once(get_theme_file_path('/settings.php'));                   // settings stay in theme root directory ( Not a template file )
require_once(get_theme_file_path('/includes/lib-content.php'));       // page/post display support ( Not a template file )
require_once(get_theme_file_path('/includes/lib-runtime.php'));       // standard runtime library ( Not a template file )
require_once(get_theme_file_path('/includes/lib-layout.php'));       // content layout support ( Not a template file )

require_once(get_theme_file_path('/includes/filters.php'));           // other filter and action definitions ( Not a template file )

if (is_user_logged_in()) {
    if (current_user_can('edit_posts')) {
        require_once(get_theme_file_path(WEAVERX_ADMIN_DIR . '/admin-core/wvrx-editor-style.php'));    // the editor file generator
    }

    if (current_user_can('edit_theme_options') || current_user_can('manage_options')) {
        require_once(get_theme_file_path(WEAVERX_ADMIN_DIR . '/admin-core/load-admin-core.php'));    // load admin files
        require_once(get_theme_file_path(WEAVERX_ADMIN_DIR . '/customizer/trt-customize-pro/trt-customize-pro-top.php'));

    }
}

do_action('weaver_xtreme_load_admin');
do_action('weaverx_load_customizer');    // load the customizer based option interface if code loaded


// ============================== MORE WEAVER THEME ACTIONS ===================

remove_filter('nav_menu_description', 'strip_tags');
add_filter('wp_setup_nav_menu_item', 'weaverx_wp_setup_nav_menu_item_filter');
/**
 * Filter: Allow HTML descriptions in WordPress Menu
 */
function weaverx_wp_setup_nav_menu_item_filter($menu_item)  // ** no type
{
    $menu_item->description = apply_filters('nav_menu_description', $menu_item->post_content);

    return $menu_item;
}


/**
 * Add theme support for infinite scroll
 *
 * @uses add_theme_support
 * @action after_setup_theme
 */
function weaverx_infinite_scroll_init_action(): void
{

    add_theme_support('infinite-scroll', array(
        'container' => 'content',
        'type' => 'click',
        'render' => 'weaverx_render_infinite_scroll_cb',

    ));
}

add_action('after_setup_theme', 'weaverx_infinite_scroll_init_action');


/** @noinspection PhpUnused
 * @noinspection PhpDuplicateSwitchCaseBodyInspection
 */
function weaverx_render_infinite_scroll_cb(): void
{
    $GLOBALS['weaverx_page_who'] = 'blog';
    $num_cols = weaverx_getopt('blog_cols');
    if (!$num_cols || $num_cols > 3) {
        $num_cols = 1;
    }

    $col = 0;
    $masonry_wrap = false;    // need this for one-column posts


    /* Start the Loop */

    weaverx_post_count_clear();
    echo '<div class="wvrx-posts clear-both">';

    while (have_posts()) {
        the_post();
        weaverx_post_count_bump();

        if (!$masonry_wrap) {
            $masonry_wrap = true;
            if (weaverx_masonry('begin-posts'))    // wrap all posts
            {
                $num_cols = 1;
            }        // force to 1 cols
        }
        weaverx_masonry('begin-post');    // wrap each post
        switch ($num_cols) {
            case 1:
                get_template_part('templates/content', get_post_format());
                break;

            case 2:
                $col++;
                echo('<div class="content-2-col clearfix">' . "\n");

                get_template_part('templates/content', get_post_format());
                echo("</div> <!-- content-2-col -->\n");
                break;

            case 3:
                $col++;
                echo('<div class="content-3-col clearfix">' . "\n");
                get_template_part('templates/content', get_post_format());
                echo("</div> <!-- content-3-col -->\n");
                break;

            default:
                get_template_part('templates/content', get_post_format());
                break;
        }   // end switch num cols
        weaverx_masonry('end-post');
    }    // end while have posts
    weaverx_masonry('end-posts');
    echo "</div><div class='clear-both'>\n";    // fix 3.1.3

}

function weaverx_infinite_scroll_settings($js_settings): string
{
    $js_settings['text'] = esc_html__('Load more posts&hellip;', 'weaver-xtreme');

    return $js_settings;
}

add_filter('infinite_scroll_js_settings', 'weaverx_infinite_scroll_settings');


if (!function_exists('weaverx_increase_max_srcset_image_width')) {
    /**
     * Increase the maximum image width to be included in a 'srcset' attribute.
     *
     * @param int $max_width The maximum image width to be included in the 'srcset'. Default '1600'.
     *
     * @return int Filtered maximum image width.
     */
    function weaverx_increase_max_srcset_image_width(int $max_width): int
    {
        return ($max_width <= 1920) ? 1920 : $max_width;
    }

    add_filter('max_srcset_image_width', 'weaverx_increase_max_srcset_image_width');
}

// Checking if WooCommerce is active, load support if it is
if (class_exists('WooCommerce')) {
    require_once(get_theme_file_path('/woocommerce-support.php'));    //  ( Not a template file )
}

// THE END OF functions.php
