<?php
/** PHP 7.4 features added */
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly
/**
 *  Specific page output template
 */
/*! ** DO NOT EDIT THIS FILE! It will be overwritten when the theme is updated! ** */

weaverx_set_cur_page_id(0);    // no page for this type

$sb_layout = weaverx_page_lead('archive');

// and next the content area.
weaverx_sb_precontent('archive');

// content for archive page

if (have_posts()) {
    $archive = esc_html__('Archive', 'weaver-xtreme');
    if (is_day()) {
        $msg = apply_filters('weaverx_daily_archives', esc_html__('Daily Archives: %s', 'weaver-xtreme'));
        $archive = '<span class="title-archive-label">' . sprintf($msg,
                '</span><span class="archive-info">' . get_the_date()) . '</span>';
    } elseif (is_month()) {
        $msg = apply_filters('weaverx_monthly_archives', esc_html__('Monthly Archives: %s', 'weaver-xtreme'));
        $archive = '<span class="title-archive-label">' . sprintf($msg,
                '</span><span class="archive-info">' . get_the_date('F Y')) . '</span>';
    } elseif (is_year()) {
        $msg = apply_filters('weaverx_yearly_archives', esc_html__('Yearly Archives: %s', 'weaver-xtreme'));
        $archive = '<span class="title-archive-label">' . sprintf($msg,
                '</span><span class="archive-info">' . get_the_date('Y')) . '</span>';
    } elseif (is_tax()) {        // these improve presentation of custom tax titles
        $archive = '<span class="title-archive-single-term">' . single_term_title('', false) . '</span>';
    } else {
        $archive = '<span class="title-archive-post-type">' . post_type_archive_title('', false) . '</span>';
    } ?>
    <header class="page-header">
        <?php
        weaverx_archive_title($archive, 'archive');

        $term_description = esc_html(term_description());
        if (!empty($term_description)) {
            echo apply_filters('taxonomy_archive_meta', '<div class="tax-archive-meta">' . $term_description . '</div>');
        }
        ?>
    </header>
    <?php

    weaverx_content_nav('nav-above');
    /* The Loop */
    weaverx_archive_loop('archive');

    weaverx_content_nav('nav-below');

} else {
    weaverx_not_found_search();
}

weaverx_sb_postcontent('archive');

weaverx_page_tail('archive', $sb_layout);    // end of page wrap
?>
