<?php
/** PHP 7.4 features added */

/**
 * Display per page and per post options - meta_boxes.
 *
 * @since Version 4
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
// Admin panel that gets added to the page edit page for per page options


// ========================================== PER PAGE & POST OPTION DEFINITIONS FOLLOW ====================================

function weaverx_pp_isp_true($val): bool
{
    if ($val) {
        return true;
    }

    return false;
}

function weaverx_pp_page_extras(): void
{
    // ------------------------------- Display Per Page Options on WP Page editor -------------------
    global $post;

    $opts = weaverx_get_db_options();    // need to fetch Weaver Xtreme options

    if (!(current_user_can('edit_themes')
        || (current_user_can('edit_theme_options') && !isset($opts['_hide_mu_admin_per']))    // multi-site regular admin
        || (current_user_can('edit_pages') && !isset($opts['_hide_editor_per']))    // Editor
        || (current_user_can('edit_posts') && !isset($opts['_hide_author_per'])))    // Author/Contributor
    ) {
        if (isset($opts['_show_per_post_all']) && $opts['_show_per_post_all']) {
            echo '<p>' .
                esc_html__('You can enable Weaver Xtreme Per Page Options for Custom Post Types on the Weaver Xtreme:Advanced Options:Admin Options tab.', 'weaver-xtreme') .
                '</p>';
        } else {
            echo '<p>' . esc_html__('Weaver Xtreme Per Page Options not available for your User Role.', 'weaver-xtreme') . '</p>';
        }

        return;    // don't show per post panel
    }

    echo("<div style=\"line-height:150%;border: 1px solid #888;list-style-type: none;\"><p>\n");
    if (get_the_ID() == get_option('page_on_front')) { ?>
        <div style="padding:2px; border:2px solid yellow; background:#FF8;">
            <?php echo wp_kses_post(__('Information: This page has been set to serve as your front page in the <em>Dashboard:Settings:Reading</em> \'Front page:\' option.', 'weaver-xtreme')); ?>
        </div><br/>
        <?php
    }

    if (get_the_ID() == get_option('page_for_posts')) { ?>
        <div style="padding:2px; border:2px solid red; background:#FAA;">
            <?php echo wp_kses_post(__('<strong>WARNING!</strong>
You have the <em>Dashboard:Settings:Reading Posts page:</em> option set to this page.
You may intend to do this, but note this means that <em>only</em> this page\'s Title will be used
on the default WordPress blog page, and any content you may have entered above is <em>not</em> used.
If you want this page to serve as your blog page, and enable Weaver Xtreme Per Page options,
including the option of using the Page with Posts page template,
then the <em>Settings:Reading:Posts page</em> selection <strong>must</strong> be set to
the <em>&mdash; Select &mdash;</em> default value.', 'weaver-xtreme')); ?>
        </div><br/>
        <?php
        return;
    }

    if (function_exists('wc_get_page_id')) {     // Special Woocommerce pages

        if (wc_get_page_id('shop') === get_the_ID() ||
            wc_get_page_id('cart') === get_the_ID() ||
            wc_get_page_id('checkout') === get_the_ID() ||
            wc_get_page_id('myaccount') === get_the_ID() ||
            wc_get_page_id('terms') === get_the_ID()
        ) { ?>
            <div style="margin-left:4px; margin-right:4px;padding:2px; border:2px solid black; background:yellow;">
                <?php echo wp_kses_post(__('<strong>NOTE!</strong> This page is a special page used by your Woocommerce Shop. You can add your own content to the top of this page with the editor, however, the main contents of this page are generated by Woocommerce. Because of this, some of the Per Page Options provided below may not work as expected for this Woocommerce page. This page will display sidebars as set for a normal page by default, or can use the Per Page sidebar layout setting.', 'weaver-xtreme')); ?>
            </div><br/>
            <?php
        }
    }

    weaverx_check_editor_style();        // see if we need an update...

    echo '<strong>' . esc_html__('Page Templates', 'weaver-xtreme') . '</strong>';
    weaverx_help_link('help.html#PageTemplates', esc_html__('Help for Weaver Xtreme Page Templates', 'weaver-xtreme'));
    echo '<span style="float:right;">( ' . esc_html__('This Page\'s ID: ', 'weaver-xtreme');
    the_ID();
    echo ' )</span>';
    weaverx_html_br();
    esc_html_e('Please click the ( ? ) for more information about all the Weaver Xtreme Page Templates.', 'weaver-xtreme');
    if (!!get_post_meta(get_the_ID(), '_elementor_edit_mode', true)) {
        weaverx_html_br();
        echo wp_kses_post(__('<strong>NOTE:</strong> This page has been created with <em>Elementor</em>. You may want to consider using the <em>For Your Page Builder Plugin</em> Page Template to display this page.', 'weaver-xtreme'));
    }

    $template = !empty($post->page_template) ? $post->page_template : "Default Template";
    $raw_template = in_array($template, array('paget-raw.php'));

    weaverx_html_br();

    weaverx_showtabs($raw_template, $template);
    ?>
    <div style="clear:both;"></div>
    <input type='hidden' id='post_meta' name='post_meta' value='post_meta'/>
    </div>
    <?php
}

function weaverx_showtabs($raw_template = false, $template = 'default'): void
{
    ?>
    <div id="tabwrap-per-page" style="padding-left:4px;">
        <div id="tab-container-page"
             style="border:1px solid #888;padding: 2px 1% 2px 1%; width:97.9%;" class='yetiisub'>
            <ul id="tab-container-page-nav" style="border-bottom:2px solid #999;" class='yetiisub'>
                <?php
                weaverx_pp_elink('#pp-visibility', esc_html__('Per Page Options affecting element visibility.', 'weaver-xtreme'), esc_html__('Visibility', 'weaver-xtreme'), '<li>', '</li>');
                weaverx_pp_elink('#pp-layout', esc_html__('Settings for Per Page Layout', 'weaver-xtreme'), esc_html__('Layout', 'weaver-xtreme'), '<li>', '</li>');
                weaverx_pp_elink('#pp-content', esc_html__('Settings to control content display.', 'weaver-xtreme'), esc_html__('Content', 'weaver-xtreme'), '<li>', '</li>');
                weaverx_pp_elink('#pp-misc', esc_html__('Misc per page options', 'weaver-xtreme'), esc_html__('Misc Options', 'weaver-xtreme'), '<li>', '</li>');
                weaverx_pp_elink('#pp-pwp', esc_html__('Settings for Page with Posts.', 'weaver-xtreme'), esc_html__('Page with Posts', 'weaver-xtreme'), '<li>', '</li>');
                weaverx_pp_elink('#pp-builder', esc_html__('Settings for Page Builders.', 'weaver-xtreme'), esc_html__('Page Builders', 'weaver-xtreme'), '<li>', '</li>');
                weaverx_pp_elink('#pp-xplus', esc_html__('Per Page settings from Weaver Xtreme Plus.', 'weaver-xtreme'), esc_html__('Xtreme Plus', 'weaver-xtreme'), '<li>', '</li>');
                ?>
            </ul>

            <div id="pp-visibility" class="tab_mainopt">
                <!-- ******************* visibility ********************* -->
                <?php
                weaverx_pp_page_visibility($raw_template);
                ?>
            </div>
            <!-- ******************* /visibility ********************* -->

            <div id="pp-layout" class="tab_mainopt">
                <!-- ******************* layout ********************* -->
                <?php
                weaverx_pp_pg_layout($raw_template);
                ?>
            </div>
            <!-- ******************* /layout ********************* -->


            <div id="pp-content" class="tab_mainopt">
                <!-- ******************* content ********************* -->
                <?php
                weaverx_pp_page_content($raw_template);
                ?>
            </div>
            <!-- ******************* /content ********************* -->

            <div id="pp-misc" class="tab_mainopt">
                <!-- ******************* misc ********************* -->
                <?php weaverx_pp_page_misc_opts($raw_template); ?>
            </div>
            <!-- ******************* /misc ********************* -->


            <div id="pp-pwp" class="tab_mainopt">
                <!-- ******************* PWP ********************* -->
                <?php weaverx_pp_page_with_posts_opts($raw_template, $template); ?>
            </div>

            <!-- ******************* /PWP ********************* -->

            <div id="pp-builder" class="tab_mainopt">
                <!-- ******************* PWP ********************* -->
                <?php weaverx_pp_page_builder_opts('page'); ?>
            </div>
            <!-- ******************* /PWP ********************* -->

            <div id="pp-xplus" class="tab_mainopt">
                <!-- ******************* X-Plus ********************* -->
                <?php weaverx_pp_page_xtreme_plus($raw_template); ?>
            </div>
            <!-- ******************* X-Plus ********************* -->


        </div> <!-- #tab-container-page -->
    </div>    <!-- #tabwrap-per-page -->

    <script type="text/javascript">
        var tabberMainOpts = new Yetii({
            id: 'tab-container-page',
            tabclass: 'tab_mainopt',
            persist: true
        });
    </script>
    <?php
}

function weaverx_pp_elink($href, $title, $label, $before = '', $after = ''): void
{
    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    echo $before . '<a href="' . esc_url($href) . '" title="' . $title . '">' . $label . '</a>' . $after;
}

function weaverx_pp_page_visibility($raw_template = false): void
{
    global $post;

    echo '<span style="font-weight:bold;font-size:140%;">' . esc_html__('Visibility', 'weaver-xtreme') . '</span>';
    weaverx_help_link('help.html#optsperpage', esc_html__('Help for Per Page Options', 'weaver-xtreme'));

    weaverx_html_br();
    if ($raw_template) {
        esc_html_e('Not options when using the RAW Page Template', 'weaver-xtreme');

        return;
    }

    esc_html_e('These settings let you hide various elements on a per page basis.', 'weaver-xtreme');

    weaverx_pp_page_title(esc_html__('Header Area Visibility', 'weaver-xtreme'), 80, 1);

    weaverx_pp_page_checkbox('_pp_hide_header', esc_html__('Hide Entire Header', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_hide_site_title', esc_html__('Hide Site Title/Tagline', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_hide_header_image', esc_html__('Hide Standard Header Image', 'weaver-xtreme'), 33, 1);

    weaverx_pp_page_checkbox('_pp_hide_header_html', esc_html__('Hide Header HTML Area', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_hide_customlogo', esc_html__('Hide Custom Logo', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_hide_headersearch', esc_html__('Hide Header Search', 'weaver-xtreme'), 33, 1);

    weaverx_pp_page_checkbox('_pp_hide_menus', esc_html__('Hide Header Menus', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_hide_mini_menu', esc_html__('Hide Header Mini Menu', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_header-widget-area', esc_html__('Hide Header Widget Area', 'weaver-xtreme'), 33, 2);


    weaverx_pp_page_title(esc_html__('Footer Area Visibility', 'weaver-xtreme'), 80, 1);

    weaverx_pp_page_checkbox('_pp_hide_footer', esc_html__('Hide Entire Footer', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_hide_footer_html', esc_html__('Hide Footer HTML Area', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_footer-widget-area', esc_html__('Hide Footer Widget Area', 'weaver-xtreme'), 33, 2);


    weaverx_pp_page_title(esc_html__('Content Area Visibility', 'weaver-xtreme'), 80, 1);

    weaverx_pp_page_checkbox('_pp_hide_page_infobar', esc_html__('Hide Info Bar on this page', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_hide_page_title', esc_html__('Hide Page Title', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_full_browser_height', esc_html__('Force full browser height', 'weaver-xtreme'), 33, 2);


    weaverx_pp_page_title(esc_html__('Page Widget Areas Visibility', 'weaver-xtreme'), 80, 1);

    weaverx_pp_page_checkbox('_pp_primary-widget-area', esc_html__('Hide Primary Sidebar', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_secondary-widget-area', esc_html__('Hide Secondary Sidebar', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_sitewide-top-widget-area', esc_html__('Hide Sitewide Top Area', 'weaver-xtreme'), 33, 1);

    weaverx_pp_page_checkbox('_pp_sitewide-bottom-widget-area', esc_html__('Hide Sitewide Bottom Area', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_top-widget-area', esc_html__('Hide Pages Top Area', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_bottom-widget-area', esc_html__('Hide Pages Bottom Area', 'weaver-xtreme'), 33, 2);

}


function weaverx_pp_pg_layout($raw_template = false): void
{        // ------------------------------- Page Layout -------------------
    global $post;

    echo '<span style="font-weight:bold;font-size:140%;">' . esc_html__('Layout', 'weaver-xtreme') . '</span><br/>';
    esc_html_e('These settings let you control layout on a per page basis.', 'weaver-xtreme');

    weaverx_html_br(2);
    if ($raw_template) {
        esc_html_e('Not options when using the RAW Page Template', 'weaver-xtreme');

        return;
    }

    weaverx_pp_page_title(esc_html__('Sidebars &amp; Widgets', 'weaver-xtreme'), 80, 1);
    weaverx_pp_page_layout();
    ?>
    <br/>
    <input type="text" size="4" id="_pp_sidebar_width" name="_pp_sidebar_width"
           value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_sidebar_width", true)); ?>"/>
    <?php echo wp_kses_post(__('% &nbsp;- <em>Sidebar Width</em> - Per Page Sidebar width (applies to all layouts)', 'weaver-xtreme')); ?>
    <br/><br/>

    <?php


    weaverx_pp_page_title(esc_html__('Featured Image', 'weaver-xtreme'), 80, 1);

    $opts3 = array(
        'id' => '_pp_fi_location',
        'info' => esc_html__('How to display Page FI on this page', 'weaver-xtreme'),
        'value' => array(
            array('val' => '', 'desc' => esc_html__('Default Blog FI', 'weaver-xtreme')),
            array('val' => 'content-top', 'desc' => esc_html__('With Content - top', 'weaver-xtreme')),
            array('val' => 'content-bottom', 'desc' => esc_html__('With Content - bottom', 'weaver-xtreme')),
            array('val' => 'title-before', 'desc' => esc_html__('With Title', 'weaver-xtreme')),
            array('val' => 'title-banner', 'desc' => esc_html__('Banner above Title', 'weaver-xtreme')),
            array('val' => 'header-image', 'desc' => esc_html__('Header Image Replacement', 'weaver-xtreme')),
            array('val' => 'post-before', 'desc' => esc_html__('Beside Page, no wrap', 'weaver-xtreme')),
            array('val' => 'post-bg', 'desc' => esc_html__('As BG Image, Tile', 'weaver-xtreme')),
            array('val' => 'post-bg-cover', 'desc' => esc_html__('As BG Image, Cover', 'weaver-xtreme')),
            array('val' => 'post-bg-parallax', 'desc' => esc_html__('As BG Image, Parallax', 'weaver-xtreme')),
            array('val' => 'post-bg-parallax-full', 'desc' => esc_html__('As BG Image, Parallax Full', 'weaver-xtreme')),
            array('val' => 'hide', 'desc' => esc_html__('Hide FI for this Post', 'weaver-xtreme')),
        ),
    );
    weaverx_pp_pp_select_id($opts3);

    ?>
    <br/>
    <input type="text" size="30" id='_pp_fi_link' name='_pp_fi_link'
           value="<?php echo esc_textarea(get_post_meta($post->ID, '_pp_fi_link', true)); ?>"/>
    <?php echo wp_kses_post(__(' <em>Featured Image Link</em> - Full URL to override default link target from FI', 'weaver-xtreme')); ?>
    <br style="clear:both;"/>
    <br/>

    <?php
    weaverx_pp_page_title(esc_html__('Full Width - Extend Areas to Full Width Display', 'weaver-xtreme'), 80, 1);
    weaverx_pp_page_checkbox('_pp_header_full', esc_html__('Full Width Header', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_container_full', esc_html__('Full Width Container', 'weaver-xtreme'));
    weaverx_pp_page_checkbox('_pp_footer_full', esc_html__('Full Width Footer', 'weaver-xtreme'), 33, 2);


    weaverx_pp_page_title(esc_html__('Content Columns', 'weaver-xtreme'), 80, 1);
    weaverx_pp_page_cols();
}


function weaverx_pp_page_content($raw_template = false): void
{        // ------------------------------- Page Content -------------------
    global $post;

    echo '<span style="font-weight:bold;font-size:140%;">' . esc_html__('Per Page Content Replacement', 'weaver-xtreme') . '</span><br/>';
    esc_html_e('These settings let you replace widget areas, as well as HTML content in the header and footer.', 'weaver-xtreme');
    weaverx_html_br(2);
    if ($raw_template) {
        esc_html_e('Not options when using the RAW Page Template', 'weaver-xtreme');

        return;
    }

    weaverx_pp_page_title(esc_html__('Header / Footer HTML Content', 'weaver-xtreme'), 80, 2);
    esc_html_e('Specify Per Page Header / Footer HTML content.', 'weaver-xtreme');
    weaverx_html_br();
    esc_html_e('Header HTML: ', 'weaver-xtreme');
    ?>
    &nbsp;<textarea class="wvrx-edit" placeholder=" " name="_pp_header_html" rows=1
                    style="width: 75%"><?php
    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    echo(get_post_meta($post->ID, "_pp_header_html", true)); ?></textarea>

    <?php
    weaverx_html_br();
    esc_html_e('Footer HTML: ', 'weaver-xtreme');
    ?>
    &nbsp;&nbsp;<textarea class="wvrx-edit" placeholder=" " name="_pp_footer_html" rows=1
                          style="width: 75%"><?php
    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    echo(get_post_meta($post->ID, "_pp_footer_html", true)); ?></textarea>

    <?php

    weaverx_html_br(2);
    weaverx_pp_page_title(esc_html__('Widget Area Replacements', 'weaver-xtreme'), 80, 1);
    ?>
    <p>
        <?php echo wp_kses_post(__('Select extra widget areas to replace the default widget areas for this page.
To add areas to the widget area lists below, you <strong>must</strong> first define extra widget areas on the bottom of the <em>Main Options &rarr; Sidebars &amp; Layout</em> tab.', 'weaver-xtreme')); ?>
    </p>
    <?php
    weaverx_pp_pp_replacement(esc_html__('Primary Sidebar', 'weaver-xtreme'), 'primary-widget-area');
    weaverx_pp_pp_replacement(esc_html__('Secondary Sidebar', 'weaver-xtreme'), 'secondary-widget-area');

    weaverx_pp_pp_replacement(esc_html__('Header Widget Area', 'weaver-xtreme'), 'header-widget-area');
    weaverx_pp_pp_replacement(esc_html__('Footer Widget Area', 'weaver-xtreme'), 'footer-widget-area');

    weaverx_pp_pp_replacement(esc_html__('Sitewide Top Widget Area', 'weaver-xtreme'), 'sitewide-top-widget-area');
    weaverx_pp_pp_replacement(esc_html__('Sitewide Bottom Widget Area', 'weaver-xtreme'), 'sitewide-bottom-widget-area');

    weaverx_pp_pp_replacement(esc_html__('Pages Top Widget Area', 'weaver-xtreme'), 'page-top-widget-area');
    weaverx_pp_pp_replacement(esc_html__('Pages Bottom Widget Area', 'weaver-xtreme'), 'page-bottom-widget-area');
    ?>
    <div style="clear:both;"></div>
    <?php
}

function weaverx_pp_page_misc_opts($raw_template = false): void
{        // ------------------------------- Misc Options -------------------
    global $post;
    echo '<span style="font-weight:bold;font-size:140%;">' . esc_html__('Misc Menu, Editor, and CSS Options', 'weaver-xtreme') . '</span><br/>';

    //weaverx_pp_page_title( esc_html__( 'Misc Menu, Editor, and CSS Options','weaver-xtreme'),80,1 );

    weaverx_pp_page_checkbox('_pp_hide_on_menu', esc_html__('Hide Page on the default Primary Menu', 'weaver-xtreme'), 90, 1);

    weaverx_pp_page_checkbox('_pp_stay_on_page', esc_html__('Menu "Placeholder" page. Useful for top-level menu item - don\'t go anywhere when menu item is clicked.', 'weaver-xtreme'), 90, 1);

    weaverx_pp_page_checkbox('_pp_hide_visual_editor', esc_html__('Disable Visual Editor for this page. Useful if you enter simple HTML or other code.', 'weaver-xtreme'), 90, 1);

    if (weaverx_allow_multisite()) {
        weaverx_pp_page_checkbox('_pp_raw_html', esc_html__('Allow Raw HTML and scripts. Disables auto paragraph, texturize, and other processing.', 'weaver-xtreme'), 90, 1);
    }
    ?>
    <p>
        <input type="text" size="25" id="bodyclass" name="_pp_bodyclass"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_bodyclass", true)); ?>"/>

        <?php echo wp_kses_post(__(' <em>Per Page body Class</em> - CSS class name to add to HTML &lt;body&gt; block. Allows Per Page custom styling.', 'weaver-xtreme')); ?>
    </p>
    <?php
    if ($raw_template) {
        echo '<p>';
        echo wp_kses_post(__(' <strong>You are using the RAW page template.</strong><br /><ol>
		<li>Check the "Allow Raw HTML" option above to prevent WP processing of your content for this page. If you leave it
		unchecked, you will get the WP paragraph and texturize processing.</li>
		<li>You can add custom HTML code to include in the &lt;head&gt; block by defining a Custom Field named <em>page-head-code</em>
		and including that HTML code in the Value for that field.</li></ol>', 'weaver-xtreme'));
        echo '</p>';
    }
}


function weaverx_pp_page_with_posts_opts($raw_template, $template): void
{        // ------------------------------- Page with Post Options -------------------
    global $post;
    ?>
    <span style="font-weight:bold;font-size:120%;">
    <?php
    esc_html_e('Settings for "Page with Posts" Template', 'weaver-xtreme'); ?>
    </span><?php
    weaverx_help_link('help.html#PerPostTemplate', esc_html__('Help for Page with Posts Template', 'weaver-xtreme'));

    $template = !empty($post->page_template) ? $post->page_template : "Default Template";
    if (in_array($template, apply_filters('weaverx_paget_posts', array('paget-posts.php')))) {
        ?>
        <p>
            <?php esc_html_e('These settings are optional, and can filter which posts are displayed when you use the "Page with Posts" template.
Use commas to separate items in lists.
The settings will be combined for the final filtered list of posts displayed.
(If you make mistakes in your settings, it won\'t be apparent until you display the page.)', 'weaver-xtreme'); ?>
        </p>

        <input type="text" size="30" id="_pp_category" name="_pp_category"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_category", true)); ?>"/>
        <?php echo wp_kses_post(__(' <em>Category</em> - Enter list of category slugs of posts to include. (-slug will exclude specified category)', 'weaver-xtreme')); ?>
        <br/>

        <input type="text" size="30" id="_pp_tag" name="_pp_tag"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_tag", true)); ?>"/>
        <?php echo wp_kses_post(__(" <em>Tags</em> - Enter list of tag slugs of posts to include.", 'weaver-xtreme')); ?>
        <br/>

        <input type="text" size="30" id="_pp_onepost" name="_pp_onepost"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_onepost", true)); ?>"/>
        <?php echo wp_kses_post(__(" <em>Single Post</em> - Enter post slug of a single post to display. ( Use [show_posts] filter to include specific list of posts.)", 'weaver-xtreme')); ?>
        <br/>

        <input type="text" size="30" id="_pp_orderby" name="_pp_orderby"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_orderby", true)); ?>"/>
        <?php echo wp_kses_post(__(" <em>Order by</em> - Enter method to order posts by: author, date, title, or rand.", 'weaver-xtreme')); ?>
        <br/>

        <input type="text" size="30" id="_pp_sort_order" name="_pp_sort_order"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_sort_order", true)); ?>"/>
        <?php echo wp_kses_post(__(" <em>Sort order</em> - Enter ASC or DESC for sort order.", 'weaver-xtreme')); ?>
        <br/>

        <input type="text" size="30" id="_pp_posts_per_page" name="_pp_posts_per_page"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_posts_per_page", true)); ?>"/>
        <?php echo wp_kses_post(__(" <em>Posts per Page</em> - Enter maximum number of posts per page.", 'weaver-xtreme')); ?>
        <br/>

        <input type="text" size="30" id="_pp_author" name="_pp_author"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_author", true)); ?>"/>
        <?php echo wp_kses_post(__(' <em>Author</em> - Enter author ( use username, including spaces ), or list of author IDs', 'weaver-xtreme')); ?>
        <br/>

        <input type="text" size="30" id="_pp_post_type" name="_pp_post_type"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_post_type", true)); ?>"/>
        <?php echo wp_kses_post(__(' <em>Custom Post Type</em> - Enter slug of one custom post type to display', 'weaver-xtreme')); ?>
        <br/>

        <?php weaverx_pp_pwp_atw_show_post_filter(); ?>

        <?php weaverx_pp_pwp_type(); ?><br/>
        <?php weaverx_pp_pwp_cols(); ?><br/>
        <input type="text" size="5" id="_pp_fullposts" name="_pp_fullposts"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_fullposts", true)); ?>"/>
        <?php echo wp_kses_post(__(" <em>Don't excerpt 1st <em>\"n\"</em> Posts</em> - Display the non-excerpted post for the first \"n\" posts.", 'weaver-xtreme')); ?>
        <br/>

        <input type="text" size="5" id="_pp_hide_n_posts" name="_pp_hide_n_posts"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_hide_n_posts", true)); ?>"/>
        <?php echo "<em><span class=\"dashicons dashicons-visibility\"></span>" .
            wp_kses_post(__(" Hide first \"n\" posts</em> - Start with post n+1.
Useful with plugin that will display first n posts using a shortcode. ( e.g., Post slider )", 'weaver-xtreme')); ?>

        <br/><br/>

        <?php weaverx_pp_page_checkbox('_pp_hide_infotop', esc_html__('Hide top info line', 'weaver-xtreme'), 40); ?>
        <?php weaverx_pp_page_checkbox('_pp_hide_infobottom', esc_html__('Hide bottom info line', 'weaver-xtreme'), 40, 1); ?>
        <?php weaverx_pp_page_checkbox('_pp_hide_sticky', esc_html__('No special treatment for Sticky Posts', 'weaver-xtreme'), 40); ?>


        <div style="clear:both;"></div>

        <?php
    } else {    // NOT a page with posts
        ?>    <p>
            <?php
            echo wp_kses_post(__(' <strong>Note:</strong> After you choose the "Page with Posts" template from the <em>Template</em>
option in the <em>Page Attributes</em> box, <strong>and</strong> <em>Publish</em> or <em>Save Draft</em>,
settings for "Page with Posts" will be displayed here. Current page template:', 'weaver-xtreme'));
            // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            echo $template; ?>
        </p>
        <?php
    }
}


function weaverx_pp_page_builder_opts($post_type = 'page'): void
{

    global $post;

    echo '<span style="font-weight:bold;font-size:140%;">' . esc_html__('Page Builder Header/Footer Replacement', 'weaver-xtreme') . '</span><br/>';
    if ($post_type == 'page') {
        esc_html_e('These settings let you replace the header or footer areas with content from a page builder page. They override the global replacement settings.', 'weaver-xtreme');
    } else {
        esc_html_e('These settings let you replace the header or footer areas of the Single Page Post view with content from a page builder page. They override the global replacement settings.', 'weaver-xtreme');
    }
    weaverx_html_br(2);

    // HEADER ----------------

    weaverx_pp_page_title(esc_html__('Header Area Replacement', 'weaver-xtreme'), 80, 1);
    ?>
    <p>
        <?php
        $cur = get_post_meta(get_the_ID(), '_pp_pb_header_hide_menus', true);
        ?>

        <select id="_pp_pb_header_hide_menus" name="_pp_pb_header_hide_menus">
            <option value='' <?php echo $cur == '' ? ' selected="selected"' : ''; ?>><?php esc_html_e('Global Menus Setting', 'weaver-xtreme'); ?></option>
            <option value='hide' <?php echo $cur == 'hide' ? ' selected="selected"' : ''; ?>><?php esc_html_e('Hide Menus', 'weaver-xtreme'); ?></option>
            <option value='show' <?php echo $cur == 'show' ? ' selected="selected"' : ''; ?>><?php esc_html_e('Show Menus', 'weaver-xtreme'); ?></option>
        </select>
        <?php echo wp_kses_post(__(' <em>Hide or Show Menus</em> - Select how to display menus with Header Replacement.', 'weaver-xtreme')); ?>
    </p>

    <input type="text" size="10" id='_pp_pb_header_replace_page_id'
           name='_pp_pb_header_replace_page_id'
           value="<?php echo esc_textarea(get_post_meta($post->ID, '_pp_pb_header_replace_page_id', true)); ?>"/>
    <?php esc_html_e("Specify any page or post ID to serve as header replacement. Overrides list selection below.", 'weaver-xtreme'); ?>
    <br style="clear:both;"/>

    <?php
    if (defined('ELEMENTOR_VERSION')) {                // only provide if elementor is active
        // Elementor selection

        $pargs = array(
            'post_type' => 'page',
        );
        $posts = get_pages($pargs);
        ?>
        <p>
            <?php echo wp_kses_post(__(' <em>Select an Elementor Page.</em> (Override this selection in Page/Post field above to select Page OR Post by ID.)', 'weaver-xtreme')); ?>
            <br/>
            <select id="_pp_elementor_header_replacement" name="_pp_elementor_header_replacement">
                <option value=''>&nbsp;</option>
                <?php
                $cur = get_post_meta(get_the_ID(), '_pp_elementor_header_replacement', true);
                foreach ($posts as $cur_post) {
                    if (!!get_post_meta($cur_post->ID, '_elementor_edit_mode', true)) {
                        $selected = ($cur == $cur_post->ID) ? ' selected="selected"' : '';
                        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                        echo '<option' . $selected . ' value="' . $cur_post->ID . '">' . substr($cur_post->post_title, 0, 60) . '</option>';        // make the title fit, more or less
                    }
                }

                $posts = get_posts(array('post_type' => 'post'));
                foreach ($posts as $cur_post) {
                    if (!!get_post_meta($cur_post->ID, '_elementor_edit_mode', true)) {
                        $selected = ($cur == $cur_post->ID) ? ' selected="selected"' : '';
                        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                        echo '<option' . $selected . ' value="' . $cur_post->ID . '">' . substr($cur_post->post_title, 0, 60) .
                            ' ' . esc_html__('(post)', 'weaver-xtreme') . '</option>';        // make the title fit, more or less
                    }
                }
                ?>
            </select>
        </p>
        <?php
    }
    $posts = '';
    if (defined('SITEORIGIN_PANELS_VERSION')) :        // only provide if siteorigins is active

        // SiteOrigin selection
        $pargs = array(
            'post_type' => 'page',
        );
        $posts = get_pages($pargs);
        ?>
        <p>
            <?php echo wp_kses_post(__(' <em>Select a SiteOrigin Page Builder Page.</em> (Override this selection in Page/Post field above to select Page OR Post by ID.)', 'weaver-xtreme')); ?>
            <br/>
            <select id="_pp_siteorigin_header_replacement" name="_pp_siteorigin_header_replacement">
                <option value=''>&nbsp;</option>
                <?php
                $cur = get_post_meta(get_the_ID(), '_pp_siteorigin_header_replacement', true);
                foreach ($posts as $cur_post) {
                    if (!!get_post_meta($cur_post->ID, 'panels_data', true)) {
                        $selected = $cur == $cur_post->ID ? ' selected="selected"' : '';
                        echo '<option' . $selected . ' value="' . $cur_post->ID . '">' . substr($cur_post->post_title, 0, 60) . '</option>';        // make the title fit, more or less
                    }
                }
                $posts = get_posts(array('post_type' => 'post'));
                foreach ($posts as $cur_post) {
                    if (!!get_post_meta($cur_post->ID, 'panels_data', true)) {
                        $selected = ($cur == $cur_post->ID) ? ' selected="selected"' : '';
                        echo '<option' . $selected . ' value="' . $cur_post->ID . '">' . substr($cur_post->post_title, 0, 60) .
                            ' ' . esc_html__('(post)', 'weaver-xtreme') . '</option>';        // make the title fit, more or less
                    }
                }
                ?>
            </select>
        </p>
    <?php
    endif; // SiteOrigin

    if (!defined('ELEMENTOR_VERSION') && !defined('SITEORIGIN_PANELS_VERSION')) {
        echo '<p>';
        esc_html_e('Sorry, Weaver can only list page builder pages from Elementor or SiteOrigin Page Builder. Please install and activate one of those plugins.', 'weaver-xtreme');
        echo '</p>';
    }

    // FOOTER -----------------

    weaverx_html_br(1);
    weaverx_pp_page_title(esc_html__('Footer Area Replacement', 'weaver-xtreme'), 80, 1);
    ?>
    <input type="text" size="10" id='_pp_pb_footer_replace_page_id'
           name='_pp_pb_footer_replace_page_id'
           value="<?php echo esc_textarea(get_post_meta($post->ID, '_pp_pb_footer_replace_page_id', true)); ?>"/>
    <?php esc_html_e("Specify any page or post ID to serve as footer replacement. Overrides list selection below.", 'weaver-xtreme'); ?>
    <br style="clear:both;"/>
    <?php

    if (defined('ELEMENTOR_VERSION')) :                // only provide if elementor is active
        // Elementor selection
        $pargs = array(
            'post_type' => 'page',
        );
        $posts = get_pages($pargs);
        ?>
        <p>
            <?php echo wp_kses_post(__(' <em>Select an Elementor Page.</em> (Override this selection in Page/Post field above to select Page OR Post by ID.)', 'weaver-xtreme')); ?>
            <br/>
            <select id="_pp_elementor_footer_replacement" name="_pp_elementor_footer_replacement">
                <option value=''>&nbsp;</option>
                <?php
                $cur = get_post_meta(get_the_ID(), '_pp_elementor_footer_replacement', true);
                foreach ($posts as $cur_post) {
                    if (!!get_post_meta($cur_post->ID, '_elementor_edit_mode', true)) {
                        $selected = $cur == $cur_post->ID ? ' selected="selected"' : '';
                        echo '<option' . $selected . ' value="' . $cur_post->ID . '">' . substr($cur_post->post_title, 0, 60) . '</option>';        // make the title fit, more or less
                    }
                }
                $posts = get_posts(array('post_type' => 'post'));
                foreach ($posts as $cur_post) {
                    if (!!get_post_meta($cur_post->ID, '_elementor_edit_mode', true)) {
                        $selected = ($cur == $cur_post->ID) ? ' selected="selected"' : '';
                        echo '<option' . $selected . ' value="' . $cur_post->ID . '">' . substr($cur_post->post_title, 0, 54) .
                            ' ' . esc_html__('(post)', 'weaver-xtreme') . '</option>';        // make the title fit, more or less
                    }
                }
                ?>
            </select>
        </p>
    <?php
    endif; // Elementor
    $posts = '';
    if (defined('SITEORIGIN_PANELS_VERSION')) :        // only provide if siteorigins is active

        // SiteOrigin selection
        $pargs = array(
            'post_type' => 'page',
        );
        $posts = get_pages($pargs);
        ?>
        <p>
            <?php echo wp_kses_post(__(' <em>Select a SiteOrigin Page Builder Page.</em> (Override this selection in Page/Post field above to select Page OR Post by ID.)', 'weaver-xtreme')); ?>
            <br/>
            <select id="_pp_siteorigin_footer_replacement" name="_pp_siteorigin_footer_replacement">
                <option value=''>&nbsp;</option>
                <?php
                foreach ($posts as $cur_post) {
                    $cur = get_post_meta(get_the_ID(), '_pp_siteorigin_footer_replacement', true);
                    if (!!get_post_meta($cur_post->ID, 'panels_data', true)) {
                        $selected = $cur == $cur_post->ID ? ' selected="selected"' : '';
                        echo '<option' . $selected . ' value="' . $cur_post->ID . '">' . substr($cur_post->post_title, 0, 60) .
                            '</option>';        // make the title fit, more or less
                    }
                }
                $posts = get_posts(array('post_type' => 'post'));
                foreach ($posts as $cur_post) {
                    if (!!get_post_meta($cur_post->ID, 'panels_data', true)) {
                        $selected = ($cur == $cur_post->ID) ? ' selected="selected"' : '';
                        echo '<option' . $selected . ' value="' . $cur_post->ID . '">' . substr($cur_post->post_title, 0, 54) .
                            ' ' . esc_html__('(post)', 'weaver-xtreme') . '</option>';        // make the title fit, more or less
                    }
                }
                ?>
            </select>
        </p>
    <?php
    endif; // SiteOrigin
    if (!defined('ELEMENTOR_VERSION') && !defined('SITEORIGIN_PANELS_VERSION')) {
        echo '<p>';
        esc_html_e('Sorry, Weaver can only list page builder pages from Elementor or SiteOrigin Page Builder. Please install and activate one of those plugins.', 'weaver-xtreme');
        echo '</p>';
    }
    echo '<div style="clear:both;"></div>';
}


function weaverx_pp_page_xtreme_plus($raw_template): void
{        // ------------------------------- Weaver Xtreme Plus -------------------
    global $post;
    echo '<h3>Weaver Xtreme Plus Per Page Options  (&#9733;Plus)</h3>';
    echo '<strong>' . esc_html__('Per Page Style', 'weaver-xtreme') . '</strong> (&#9733;Plus)' /*a*/
    ;

    do_action('weaverx_pp_xp_perpage_style', $raw_template);
}


function weaverx_pp_page_color($opt, $msg): void
{        // used by XPlus
    global $post;

    $pclass = 'color {hash:true, adjust:false}';    // starting with V 1.3, allow text in color pickers
//echo '<span class="dashicons dashicons-admin-appearance"></span>&nbsp';

    ?>
    <label><input class="<?php echo $pclass; ?>" id="<?php echo($opt); ?>"
                  name="<?php echo($opt); ?>" type="text" style="width:90px"
                  value="<?php echo esc_textarea(get_post_meta($post->ID, $opt, true)); ?>"/></label>
    <?php
    echo '&nbsp;' . $msg;
}

function weaverx_pp_simple_checkbox($opt, $msg): void
{
    global $post;
    ?>
    <label><input type="checkbox" id="<?php echo($opt); ?>" name="<?php echo($opt); ?>"
            <?php checked(weaverx_pp_isp_true(get_post_meta($post->ID, $opt, true))); ?> /><?php echo $msg; ?>
    </label>
    <?php
}

function weaverx_pp_page_checkbox($opt, $msg, $width = 33, $br = 0): void
{
    if ($width != 'auto') {
        $width = "$width%";
    }
    ?>
    <div
    style="float:left;width:<?php echo $width; ?>"><?php weaverx_pp_simple_checkbox($opt, $msg); ?>
    </div><?php
    for ($i = 0; $i < $br; $i++) {
        echo '<br class="page_checkbox" style="clear:both;" />';
    }

}

function weaverx_pp_page_title($msg, $width = 33, $br = 0): void
{
    if ($width != 'auto') {
        $width = "$width%";
    }
    ?>
    <div style="float:left;font-weight:bold;font-style:italic;width:<?php echo $width; ?>">
        <?php
        echo $msg;
        ?>
    </div>
    <?php
    for ($i = 0; $i < $br; $i++) {
        echo '<br class="page_checkbox" style="clear:both;" />';
    }

}

function weaverx_pp_page_layout($page = 'page'): void
{

    if ($page == 'page') {
        $msg = wp_kses_post(__(' Select <em>Sidebar Layout</em> for this page - overrides default Page layout.', 'weaver-xtreme'));
    } else {
        $msg = wp_kses_post(__(' Select Single Page View <em>Sidebar Layout</em> for this post - overrides default Single View layout.', 'weaver-xtreme'));
    }

    $opts = array(
        'id' => '_pp_page_layout',
        'info' => $msg,
        'value' => array(
            array('val' => '', 'desc' => esc_html__('Use Default', 'weaver-xtreme')),
            array('val' => 'right', 'desc' => esc_html__('Sidebars on Right', 'weaver-xtreme')),
            array('val' => 'right-top', 'desc' => esc_html__('Sidebars on Right (stack top)', 'weaver-xtreme')),
            array('val' => 'left', 'desc' => esc_html__('Sidebars on Left', 'weaver-xtreme')),
            array('val' => 'left-top', 'desc' => esc_html__('Sidebars on Left (stack top)', 'weaver-xtreme')),
            array('val' => 'split', 'desc' => esc_html__('Split - Sidebars on Right and Left', 'weaver-xtreme')),
            array('val' => 'split-top', 'desc' => esc_html__('Split (stack top)', 'weaver-xtreme')),
            array('val' => 'one-column', 'desc' => esc_html__('No sidebars, content only', 'weaver-xtreme')),
        ),
    );
    weaverx_pp_pp_select_id($opts);
}

//--


function weaverx_pp_pp_replacement($desc, $id): void
{
    global $post;
    global $wp_registered_sidebars;

    $id = '_' . $id;

    echo "\n<div style='float:left;width:40%;'><select name='{$id}' id='{$id}'> <option value=''>&nbsp;</option>\n";


    foreach (( array )$wp_registered_sidebars as $key => $value) {
        $area_name = $value['id']; //sanitize_title( $value['name'] );
        if (strpos($area_name, 'per-page-') !== false) {
            echo ' <option value="' . $area_name . '"';
            selected(weaverx_pp_isp_true(get_post_meta($post->ID, $id, true) == $area_name));
            echo '>' . substr($area_name, 9) . "</option>\n";

        }
    }
    echo '</select>&nbsp;&nbsp;' . $desc . "</div>\n";
}

//--


function weaverx_pp_pp_select_id($value): void
{
    global $post;

    if (isset($value['name']) && $value['name'] != '') {
        echo "\n{$value['name']}&nbsp;&nbsp;&nbsp;\n";
    }

    echo "\n<select name=\"" . $value['id'] . '" id="' . $value['id'] . "\">\n";

    foreach ($value['value'] as $option) {
        if ($option['val'] == '') {
            echo '<option value="">';
        } else {
            echo ' <option value="' . $option['val'] . '"';
            selected(weaverx_pp_isp_true(get_post_meta($post->ID, $value['id'], true) == $option['val']));
            echo ">";
        }
        echo $option['desc'] . "</option>\n";
    }
    echo '</select>&nbsp;' . $value['info'] . "\n";
}

//--


function weaverx_pp_pwp_atw_show_post_filter(): void
{
    // use plugin options...
    global $post;

    if (function_exists('atw_showposts_installed')) {
        $filters = atw_posts_getopt('filters');

        $first = true;
        echo '<select id="_pp_post_filter" name="_pp_post_filter" >';
        foreach ($filters as $filter => $val) {     // display dropdown of available filters
            if ($first) {
                $first = false;
                echo '<option value="" ' . selected(get_post_meta($post->ID, '_pp_post_filter', true) == '') . '>Use above post filtering options</option>';
            } else {
                echo '<option value="' . $filter . '" ' . selected(get_post_meta($post->ID, '_pp_post_filter', true) == $filter) . '>' . $val['name'] . '</option>';
            }
        }
        echo '</select>&nbsp;' .
            wp_kses_post(__(' Use a Filter from <em>Weaver Show Posts Plugin</em> <strong>instead</strong> of above post selection options.', 'weaver-xtreme')) .
            '<br /> <span style="margin-left:8em;"><span>' .
            wp_kses_post(__(' (Note: Weaver Show Posts <em>Post Display</em> options and <em>Use Paging</em> option <strong>not</strong> used for posts when using this filter.)', 'weaver-xtreme')) .
            '<br />' . '<br />';
    } else {
        echo wp_kses_post(__(' <strong>Want More Post Filtering Options?</strong> Install the <em>Show Posts</em> plugin for more filtering options.', 'weaver-xtreme')); ?>
        <br/><br/>
    <?php }
}

//--


function weaverx_pp_pwp_type(): void
{
    $opts = array(
        'name' => esc_html__('Display posts as:', 'weaver-xtreme'),
        'id' => '_pp_wvrx_pwp_type',
        'info' => esc_html__('How to display posts on this Page with Posts (Default: global Full Post/Excerpt setting)', 'weaver-xtreme'),
        'value' => array(
            array('val' => '', 'desc' => '&nbsp;'),
            array('val' => 'full', 'desc' => esc_html__('Full post', 'weaver-xtreme')),
            array('val' => 'excerpt', 'desc' => esc_html__('Excerpt', 'weaver-xtreme')),
            array('val' => 'title', 'desc' => esc_html__('Title only', 'weaver-xtreme')),
            array('val' => 'title_featured', 'desc' => esc_html__('Title + Featured Image', 'weaver-xtreme')),
        ),
    );
    weaverx_pp_pp_select_id($opts);
}


function weaverx_pp_page_cols(): void
{

    $opts = array(
        'name' => '',
        'id' => '_pp_page_cols',
        'info' => esc_html__('Display page content in this many columns using CSS column rules.', 'weaver-xtreme'),
        'value' => array(
            array('val' => '', 'desc' => '&nbsp;'),
            array('val' => '1', 'desc' => esc_html__('1 Column', 'weaver-xtreme')),
            array('val' => '2', 'desc' => esc_html__('2 Columns', 'weaver-xtreme')),
            array('val' => '3', 'desc' => esc_html__('3 Columns', 'weaver-xtreme')),
            array('val' => '4', 'desc' => esc_html__('4 Columns', 'weaver-xtreme')),
        ),
    );
    weaverx_pp_pp_select_id($opts);

    weaverx_html_br();
    weaverx_html_br();
}


function weaverx_pp_pwp_cols(): void
{

    $opts = array(
        'name' => esc_html__('Display post columns:', 'weaver-xtreme'),
        'id' => '_pp_wvrx_pwp_cols',
        'info' => esc_html__('Display posts in this many columns - left to right, then top to bottom', 'weaver-xtreme'),
        'value' => array(
            array('val' => '', 'desc' => '&nbsp;'),
            array('val' => '1', 'desc' => esc_html__('1 Column', 'weaver-xtreme')),
            array('val' => '2', 'desc' => esc_html__('2 Columns', 'weaver-xtreme')),
            array('val' => '3', 'desc' => esc_html__('3 Columns', 'weaver-xtreme')),
        ),
    );
    weaverx_pp_pp_select_id($opts);

    weaverx_html_br();

    $opts2 = array(
        'name' => wp_kses_post(__(' Use <em>Masonry</em> columns:', 'weaver-xtreme')),
        'id' => '_pp_pwp_masonry',
        'info' => wp_kses_post(__(' Use <em>Masonry</em> for multi-column display. <em>Not compatible with FI BG images.</em>', 'weaver-xtreme')),
        'value' => array(
            array('val' => '', 'desc' => '&nbsp;'),
            array('val' => '2', 'desc' => esc_html__('2 Columns', 'weaver-xtreme')),
            array('val' => '3', 'desc' => esc_html__('3 Columns', 'weaver-xtreme')),
            array('val' => '4', 'desc' => esc_html__('4 Columns', 'weaver-xtreme')),
            array('val' => '5', 'desc' => esc_html__('5 Columns', 'weaver-xtreme')),
        ),
    );
    weaverx_pp_pp_select_id($opts2);

    ?>
    <br/>
    <?php
    weaverx_pp_page_checkbox('_pp_pwp_compact', wp_kses_post(__(' For posts with <em>Post Format</em> specified, use compact layout on blog/archive pages.', 'weaver-xtreme')), 90, 1);
    weaverx_pp_page_checkbox('_pp_pwp_compact_posts', wp_kses_post(__(' For regular, <em>non-PostFormats</em> posts, show <em>title + first image</em> on blog pages.', 'weaver-xtreme')), 90, 1);
}


//================================================================ Per Post Options ========================================================


function weaverx_pp_post_extras(): void
{
    global $post;
    $opts = weaverx_get_db_options();    // need to fetch Weaver Xtreme options
    if (!(current_user_can('edit_themes')
        || (current_user_can('edit_theme_options') && !isset($opts['_hide_mu_admin_per']))    // multi-site regular admin
        || (current_user_can('edit_pages') && !isset($opts['_hide_editor_per']))    // Editor
        || (current_user_can('edit_posts') && !isset($opts['_hide_author_per']))) // Author/Contributor
    ) {
        echo '<p>' . esc_html__('Weaver Xtreme Per Post Options not available for your User Role.', 'weaver-xtreme') . '</p>';

        return;    // don't show per post panel
    }
    ?>
    <div style="line-height:150%;border: 1px solid #888;list-style-type: none;">
        <p>
            <?php
            weaverx_check_editor_style();        // see if we need an update...

            echo '<strong>' . esc_html__('Per Post Options', 'weaver-xtreme') . '</strong>';
            weaverx_help_link('help.html#PerPage', esc_html__('Help for Per Post Options', 'weaver-xtreme'));
            echo '<span style="float:right;">( ' . esc_html__('This Post\'s ID: ', 'weaver-xtreme');
            the_ID();
            echo ' )</span>';
            weaverx_html_br();
            esc_html_e('These settings let you control display of this individual post. Many of these options override global options set on the Weaver Xtreme admin tabs.', 'weaver-xtreme');
            weaverx_html_br();

            weaverx_show_post_tabs();

            ?>
        <p>
            <?php echo('<strong>Post Format</strong>');
            weaverx_help_link('help.html#gallerypost', esc_html__('Help for Per Post Format', 'weaver-xtreme'));
            weaverx_html_br();
            esc_html_e('Weaver Xtreme supports Post Formats. Click the ? for more info. Post Formats are set in the "Formats" option box.', 'weaver-xtreme');
            weaverx_html_br();
            ?>

        </p>
        <input type='hidden' id='post_meta' name='post_meta' value='post_meta'/>
        <div style="clear:both;"></div>
    </div>
    <?php
}

function weaverx_show_post_tabs(): void
{
    ?>
    <div id="tabwrap-per-post" style="padding-left:4px;">
        <div id="tab-container-post"
             style="border:1px solid #888;padding: 2px 1% 2px 1%; width:97.9%;" class='yetiisub'>
            <ul id="tab-container-post-nav" style="border-bottom:2px solid #999;" class='yetiisub'>
                <?php
                weaverx_pp_elink('#pp-post-blog', esc_html__('Per Post options when displayed in blog or archive.', 'weaver-xtreme'), esc_html__('Post Blog/Archive Options', 'weaver-xtreme'), '<li>', '</li>');
                weaverx_pp_elink('#pp-post-single', esc_html__('Per Post options for single page view.', 'weaver-xtreme'), esc_html__('Post Single Page Options', 'weaver-xtreme'), '<li>', '</li>');
                weaverx_pp_elink('#pp-post-misc', esc_html__('Misc per post options', 'weaver-xtreme'), esc_html__('Misc Options', 'weaver-xtreme'), '<li>', '</li>');
                weaverx_pp_elink('#pp-builder', esc_html__('Settings for Page Builders.', 'weaver-xtreme'), esc_html__('Page Builders', 'weaver-xtreme'), '<li>', '</li>');
                weaverx_pp_elink('#pp-post-xplus', esc_html__('Per Post settings from Weaver Xtreme Plus.', 'weaver-xtreme'), esc_html__('Xtreme Plus', 'weaver-xtreme'), '<li>', '</li>');
                ?>
            </ul>

            <div id="pp-post-blog" class="tab_mainopt">
                <!-- ******************* blog/archive ********************* -->
                <?php
                weaverx_post_blog_opts();
                ?>
            </div>
            <!-- ******************* /blog-archive ********************* -->

            <div id="pp-post-single" class="tab_mainopt">
                <!-- ******************* single page ********************* -->
                <?php
                weaverx_post_single_opts();
                ?>
            </div>
            <!-- ******************* /single page ********************* -->

            <div id="pp-misc" class="tab_mainopt">
                <!-- ******************* misc ********************* -->
                <?php weaverx_post_misc_opts(); ?>
            </div>
            <!-- ******************* /misc ********************* -->

            <div id="pp-builder" class="tab_mainopt">
                <!-- ******************* PWP ********************* -->
                <?php weaverx_pp_page_builder_opts('post'); ?>
            </div>
            <!-- ******************* /PWP ********************* -->


            <div id="pp-post-xplus" class="tab_mainopt">
                <!-- ******************* X-Plus ********************* -->
                <?php weaverx_post_xplus_opts(); ?>
            </div>
            <!-- ******************* X-Plus ********************* -->


        </div> <!-- #tab-container-post -->
    </div>    <!-- #tabwrap-per-post -->


    <script type="text/javascript">
        var tabberMainOpts = new Yetii({
            id: 'tab-container-post',
            tabclass: 'tab_mainopt',
            persist: true
        });
    </script>
    <?php
}


function weaverx_post_blog_opts(): void
{
    ?>
    <strong><?php esc_html_e('Per Post Options when displayed on Blog or Archive-like view', 'weaver-xtreme'); ?></strong>
    <br/><br/>

    <?php

    weaverx_pp_page_checkbox('_pp_force_post_excerpt', esc_html__('Display post as excerpt', 'weaver-xtreme'), 40);
    weaverx_pp_page_checkbox('_pp_force_post_full', esc_html__('Display as full post where normally excerpted', 'weaver-xtreme'), 55, 1);


    weaverx_pp_page_checkbox('_pp_show_post_avatar', esc_html__('Show author avatar with post', 'weaver-xtreme'), 40);
    weaverx_pp_page_checkbox('_show_post_bubble', esc_html__('Show the comment bubble', 'weaver-xtreme'), 40, 1);

    weaverx_pp_page_checkbox('_pp_hide_post_format_label', wp_kses_post(__(' Hide <em>Post Format</em> label', 'weaver-xtreme')), 40);
    weaverx_pp_page_checkbox('_pp_hide_post_title', esc_html__('Hide post title', 'weaver-xtreme'), 40, 1);

    weaverx_pp_page_checkbox('_pp_hide_top_post_meta', esc_html__('Hide top post info line', 'weaver-xtreme'), 40);
    weaverx_pp_page_checkbox('_pp_hide_bottom_post_meta', esc_html__('Hide bottom post info line', 'weaver-xtreme'), 40, 1);
    weaverx_pp_page_checkbox('_pp_masonry_span2', wp_kses_post(__(' For <em>Masonry</em> multi-columns: make this post span two columns.', 'weaver-xtreme')), 90, 1);

    weaverx_pp_page_checkbox('_pp_post_add_link', esc_html__('Show a "link to single page" icon at bottom of post - useful with compact posts', 'weaver-xtreme'), 90);
    ?>
    <br style="clear:both;"/><strong><p>
        <?php echo wp_kses_post(__(' <em>Post Blog/Archive View:</em> Featured Image', 'weaver-xtreme')); ?>
</strong></p>
    <?php
    $opts3 = array(
        'id' => '_pp_post_fi_location',
        'info' => wp_kses_post(__(" Override <em>Post</em> setting for where to display FI ( for both excerpt and full content ). Don't forget Single view, too.", 'weaver-xtreme')),
        'value' => array(
            array('val' => '', 'desc' => esc_html__('Default Blog FI', 'weaver-xtreme')),
            array('val' => 'content-top', 'desc' => esc_html__('With Content - top', 'weaver-xtreme')),
            array('val' => 'content-bottom', 'desc' => esc_html__('With Content - bottom', 'weaver-xtreme')),
            array('val' => 'title-before', 'desc' => esc_html__('With Title', 'weaver-xtreme')),
            array('val' => 'title-banner', 'desc' => esc_html__('Banner above Title', 'weaver-xtreme')),
            array('val' => 'header-image', 'desc' => esc_html__('Header Image Replacement', 'weaver-xtreme')),
            array('val' => 'post-before', 'desc' => esc_html__('Beside Post, no wrap', 'weaver-xtreme')),
            array('val' => 'post-bg', 'desc' => esc_html__('As BG Image, Tile', 'weaver-xtreme')),
            array('val' => 'post-bg-cover', 'desc' => esc_html__('As BG Image, Cover', 'weaver-xtreme')),
            array('val' => 'post-bg-parallax', 'desc' => esc_html__('As BG Image, Parallax', 'weaver-xtreme')),
            array('val' => 'post-bg-parallax-full', 'desc' => esc_html__('As BG Image, Parallax Full', 'weaver-xtreme')),
            array('val' => 'hide', 'desc' => esc_html__('Hide FI for this Post', 'weaver-xtreme')),
        ),
    );
    weaverx_pp_pp_select_id($opts3);

    echo '<div style="clear:both;" /></div>';

}

function weaverx_post_single_opts(): void
{
    global $post;
    ?>
    <strong><?php echo wp_kses_post(__(' <em>Single Page View:</em> Sidebars', 'weaver-xtreme')); ?></strong>
    <br/><br/>

    <?php
    weaverx_pp_page_layout('post');
    ?>
    <input type="text" size="4" id="_pp_category" name="_pp_sidebar_width"
           value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_sidebar_width", true)); ?>"/>
    <?php echo wp_kses_post(__(" % &nbsp;- <em>Sidebar Width</em> - Post Single View Sidebar width ( applies to all layouts )", 'weaver-xtreme')); ?>
    <br/><br/>
    <?php

    weaverx_pp_page_checkbox('_pp_primary-widget-area', esc_html__('Hide Primary Sidebar, Single View', 'weaver-xtreme'), 40);
    weaverx_pp_page_checkbox('_pp_secondary-widget-area', esc_html__('Hide Secondary Sidebar, Single View', 'weaver-xtreme'), 40, 1);

    weaverx_pp_page_checkbox('_pp_sitewide-top-widget-area', esc_html__('Hide Sitewide Top Area, Single View', 'weaver-xtreme'), 40);
    weaverx_pp_page_checkbox('_pp_sitewide-bottom-widget-area', esc_html__('Hide Sitewide Bottom Area, Single View', 'weaver-xtreme'), 40, 1);

    weaverx_pp_page_checkbox('_pp_top-widget-area', esc_html__('Hide Blog Top Area, Single View', 'weaver-xtreme'), 40);
    weaverx_pp_page_checkbox('_pp_bottom-widget-area', esc_html__('Hide Blog Bottom Area, Single View', 'weaver-xtreme'), 40, 1);

    weaverx_pp_page_checkbox('_pp_header-widget-area', esc_html__('Hide Header Area, Single View', 'weaver-xtreme'), 40);
    weaverx_pp_page_checkbox('_pp_footer-widget-area', esc_html__('Hide Footer Area, Single View', 'weaver-xtreme'), 40, 1);
    ?>
    </p>
    <p>
        <strong><?php echo wp_kses_post(__(' <em>Single Page View:</em> Widget Area Replacements', 'weaver-xtreme')); ?></strong>
    </p>
    <p>
        <?php echo wp_kses_post(__(' Select extra widget areas to replace the default widget areas for <em>Single Page</em> view of this post.
To add areas to the widget area lists below, you <strong>must</strong> first define extra widget areas on the bottom of the <em>Main Options &rarr; Sidebars &amp; Layout</em> tab.', 'weaver-xtreme')); ?>
    </p>
    <?php
    weaverx_pp_pp_replacement(esc_html__('Primary Sidebar', 'weaver-xtreme'), 'primary-widget-area');
    weaverx_pp_pp_replacement(esc_html__('Secondary Sidebar', 'weaver-xtreme'), 'secondary-widget-area');

    weaverx_pp_pp_replacement(esc_html__('Header Widget Area', 'weaver-xtreme'), 'header-widget-area');
    weaverx_pp_pp_replacement(esc_html__('Footer Widget Area', 'weaver-xtreme'), 'footer-widget-area');

    weaverx_pp_pp_replacement('Sitewide Top Widget Area', 'sitewide-top-widget-area');
    weaverx_pp_pp_replacement('Sitewide Bottom Widget Area', 'sitewide-bottom-widget-area');
    ?>
    <br style="clear:both;"/><p>
    <strong><?php echo wp_kses_post(__(' <em>Single Page View:</em> Featured Image', 'weaver-xtreme')); ?></strong>
</p>
    <?php
    $opts3 = array(
        'id' => '_pp_fi_location',
        'info' => wp_kses_post(
            esc_html__("Override <em>Single Page</em> setting for where to display FI. Don't forget blog view, too.", 'weaver-xtreme')),
        'value' => array(
            array('val' => '', 'desc' => esc_html__('Default Blog FI', 'weaver-xtreme')),
            array('val' => 'content-top', 'desc' => esc_html__('With Content - top', 'weaver-xtreme')),
            array('val' => 'content-bottom', 'desc' => esc_html__('With Content - bottom', 'weaver-xtreme')),
            array('val' => 'title-before', 'desc' => esc_html__('With Title', 'weaver-xtreme')),
            array('val' => 'title-banner', 'desc' => esc_html__('Banner above Title', 'weaver-xtreme')),
            array('val' => 'header-image', 'desc' => esc_html__('Header Image Replacement', 'weaver-xtreme')),
            array('val' => 'post-before', 'desc' => esc_html__('Beside Page, no wrap', 'weaver-xtreme')),
            array('val' => 'post-bg', 'desc' => esc_html__('As BG Image, Tile', 'weaver-xtreme')),
            array('val' => 'post-bg-cover', 'desc' => esc_html__('As BG Image, Cover', 'weaver-xtreme')),
            array('val' => 'post-bg-parallax', 'desc' => esc_html__('As BG Image, Parallax', 'weaver-xtreme')),
            array('val' => 'post-bg-parallax-full', 'desc' => esc_html__('As BG Image, Parallax Full', 'weaver-xtreme')),
            array('val' => 'hide', 'desc' => esc_html__('Hide FI for this Post', 'weaver-xtreme')),
        ),
    );
    weaverx_pp_pp_select_id($opts3);
    ?>
    <br/>
    <input type="text" size="30" id='_pp_fi_link' name='_pp_fi_link'
           value="<?php echo esc_textarea(get_post_meta($post->ID, '_pp_fi_link', true)); ?>"/>
    <?php echo wp_kses_post(__(" <em>Featured Image Link</em> - Full URL to override default link target from FI", 'weaver-xtreme')); ?>
    <br style="clear:both;"/>
    <br/>

    <?php
    echo '<div style="clear:both;"/></div>';
}


function weaverx_post_misc_opts(): void
{
    ?>

    <p>
        <strong><?php esc_html_e('Post Editor Options', 'weaver-xtreme'); ?></strong>

        <?php
        weaverx_pp_page_checkbox('_pp_hide_visual_editor', esc_html__('Disable Visual Editor for this page. Useful if you enter simple HTML or other code.', 'weaver-xtreme'), 90, 1);

        if (weaverx_allow_multisite()) {
            weaverx_pp_page_checkbox('_pp_raw_html', esc_html__('Allow Raw HTML and scripts. Disables auto paragraph, texturize, and other processing.', 'weaver-xtreme'), 90, 1);
        }
        ?>
    </p>
    <?php

}


function weaverx_post_xplus_opts(): void
{

    echo '<div style="clear:both;">';
    echo('<h3>Weaver Xtreme Plus Per Post Options  (&#9733;Plus)</h3><strong>Per Post Style</strong>' /*a*/);
    weaverx_help_link('help.html#perpoststyle', esc_html__('Help for Per Post Style', 'weaver-xtreme'));
    echo '<br />' .
        esc_html__('Weaver Xtreme Plus supports optional per post CSS style rules.', 'weaver-xtreme');
    echo '<br />';

    do_action('weaverx_pp_xp_perpoststyle');
    weaverx_html_br();

    do_action('weaverxplus_add_per_post');
    echo '</div>';

}


function weaverx_pp_save_post_fields($post_id): void
{

    // NOTE - Update weaverx-ts.php when this changes...

    $default_post_fields = array(
        '_pp_category',
        '_pp_tag',
        '_pp_onepost',
        '_pp_orderby',
        '_pp_sort_order',
        '_pp_author',
        '_pp_posts_per_page',
        '_pp_primary-widget-area',
        '_pp_secondary-widget-area',
        '_pp_sidebar_width',
        '_pp_top-widget-area',
        '_pp_bottom-widget-area',
        '_pp_sitewide-top-widget-area',
        '_pp_sitewide-bottom-widget-area',
        '_pp_post_type',
        '_pp_hide_page_title',
        '_pp_hide_site_title',
        '_pp_hide_menus',
        //'_pp_hide_primary_menu',
        //'_pp_hide_secondary_menu',
        '_pp_hide_header_image',
        '_pp_hide_footer',
        '_pp_hide_header',
        '_pp_hide_sticky',
        '_pp_force_post_full',
        '_pp_force_post_excerpt',
        '_pp_show_post_avatar',
        '_pp_bodyclass',
        '_pp_fi_link',
        '_pp_fi_location',
        '_pp_post_fi_location',
        '_pp_post_styles',
        '_pp_hide_top_post_meta',
        '_pp_hide_bottom_post_meta',
        '_pp_stay_on_page',
        '_pp_hide_on_menu',
        '_pp_show_featured_img',
        '_pp_hide_infotop',
        '_pp_hide_infobottom',
        '_pp_hide_visual_editor',
        '_pp_masonry_span2',
        '_show_post_bubble',
        '_pp_hide_post_title',
        '_pp_post_add_link',
        '_pp_hide_post_format_label',
        '_pp_page_layout',
        '_pp_wvrx_pwp_type',
        '_pp_wvrx_pwp_cols',
        '_pp_post_filter',
        '_pp_header-widget-area',
        '_pp_footer-widget-area',
        '_pp_hide_page_infobar',
        '_pp_hide_n_posts',
        '_pp_fullposts',
        '_pp_pwp_masonry',
        '_pp_pwp_compact',
        '_pp_pwp_compact_posts',
        '_primary-widget-area',
        '_secondary-widget-area',
        '_header-widget-area',
        '_footer-widget-area',
        '_sitewide-top-widget-area',
        '_sitewide-bottom-widget-area',
        '_page-top-widget-area',
        '_page-bottom-widget-area',
        '_pp_full_browser_height',
        '_pp_page_cols',
        '_pp_header_full',
        '_pp_container_full',
        '_pp_footer_full',
        '_pp_hide_footer_html',
        '_pp_hide_header_html',
        '_pp_hide_customlogo',
        '_pp_hide_mini_menu',
        '_pp_hide_headersearch',
        '_pp_header_html',
        '_pp_footer_html',
        '_pp_elementor_header_replacement',
        '_pp_elementor_footer_replacement',
        '_pp_siteorigin_header_replacement',
        '_pp_elementor_footer_replacement',
        '_pp_pb_header_hide_menus',
        '_pp_pb_header_replace_page_id',
        '_pp_pb_footer_replace_page_id',


        // Plus options
        '_pp_bgcolor',
        '_pp_color',
        '_pp_bg_fullwidth',
        '_pp_lr_padding',
        '_pp_tb_padding',
        '_pp_margin',
        '_pp_post_class',
        '_pp_bgimg',
        '_pp_mobile_bgimg',
        '_pp_parallax_height',
        '_pp_use_parallax',
        '_pp_parallax_not_wide',
        '_pp_footer_add_class',
        '_pp_container_add_class',
        '_pp_content_add_class',
        '_pp_post_add_class',
        '_pp_infobar_add_class',
        '_pp_wrapper_add_class',
        '_pp_header_add_class',
        '_pp_header_image_html_text',
        '_pp_alt_primary_menu',
        '_pp_alt_secondary_menu',
        '_pp_alt_mini_menu',
        '_pp_video_active',
        '_pp_video_url',
        '_pp_video_aspect',
        '_pp_video_render',
        '_pp_alt_theme',
    );

    if (weaverx_allow_multisite()) {
        array_push($default_post_fields, '_pp_raw_html');
    }

    $all_post_fields = $default_post_fields;

    if (isset($_POST['post_meta'])) {
        foreach ($all_post_fields as $post_field) {
            if (isset($_POST[$post_field])) {
                $data = $_POST[$post_field];
                if ($post_field != '_pp_post_styles') {
                    $data = stripslashes($data);
                }        // passed via post, so strip slashes

                if (get_post_meta($post_id, $post_field) == '') {
                    add_post_meta($post_id, $post_field, weaverx_filter_textarea($data), true);
                } elseif ($data != get_post_meta($post_id, $post_field, true)) {
                    update_post_meta($post_id, $post_field, weaverx_filter_textarea($data));
                } elseif ($data == '') {
                    delete_post_meta($post_id, $post_field, get_post_meta($post_id, $post_field, true));
                }
            } else {
                delete_post_meta($post_id, $post_field, get_post_meta($post_id, $post_field, true));
            }
        }
    }
}

add_action("save_post", "weaverx_pp_save_post_fields");
add_action("publish_post", "weaverx_pp_save_post_fields");

// } end of former XP check

// XP

if (function_exists('weaverxplus_plugin_installed')) :

    add_action('weaverx_pp_xp_perpage_style', 'weaverx_pp_xp_perpage_style_action');

    function weaverx_pp_xp_perpage_style_action($raw_template): void
    {

        global $post;


        weaverx_help_link('help.html#perpoststyle', esc_html__('Help for Per Page Style', 'weaver-xtreme'));
        if (!$raw_template) {
            echo '<p><small>' .
                wp_kses_post(__(' Enter optional per page CSS style rules. <strong>Do not</strong> include the &lt;style> and &lt;/style> tags.
Include the complete "selector {}" for each rule you define.
Custom styles will not be displayed by the Page Editor.
Example - full width page with centered, indented header, container, and footer:<br />
<code>#wrapper{max-width:100%;}
#header{width:80%;margin-left:auto;margin-right:auto;}
#container{width:80%;margin-left:auto;margin-right:auto;}
#colophon{width:80%;margin-left:auto;margin-right:auto;}</code>', 'weaver-xtreme'));
        } else {
            echo '<p><br /><small>' .
                wp_kses_post(__(' Enter optional per page CSS style rules. <strong>Do not</strong> include the &lt;style> and &lt;/style> tags.
Include the complete "selector {}" for each rule you define. Rules with no selector apply to entire page.
Custom styles will not be displayed by the Page Editor.'
                    , 'weaver-xtreme'));
        }
        ?>
        <br/><br/>
        <textarea class="wvrx-edit" placeholder=" " name="_pp_post_styles" rows=2
                  style="width: 95%"><?php echo(get_post_meta($post->ID, "_pp_post_styles", true)); ?></textarea>
        </small><br/><br/>
        <?php

        if (!$raw_template) {
            echo wp_kses_post(__(' <strong>Per Page Area Added Classes</strong><br />Add classes to selected wrapping areas for this page only. Useful for full width layouts - e.g. Parallax.', 'weaver-xtreme'));
            // 'footer', 'container', 'content', 'post', 'infobar', 'wrapper', 'header' as "_pp_{$area}_add_class"
            $areas = array('wrapper', 'header', 'infobar', 'container', 'content', 'post', 'footer');

            $afters = array('<br />', '<span style="margin-left:4em;"></span>');
            $count = 0;

            weaverx_html_br();

            foreach ($areas as $area) {
                if (($count++) % 2 == 0) {
                    $after = $afters[1];
                } else {
                    $after = $afters[0];
                }

                weaverx_pp_xp_text_option($post->ID, "_pp_{$area}_add_class",
                    " <strong>$area</strong>", '', $after);
            }
            weaverx_html_br();

            // Weaver X Plus options for making horizontal bar layouts
            weaverx_pp_page_color('_pp_bgcolor', esc_html__('Page BG Color', 'weaver-xtreme'));


            $menus = get_terms('nav_menu', array('hide_empty' => false));

            // If no menus exists, direct the user to go and create some.
            if (!$menus) {
                echo '<p>' . sprintf('No menus have been created yet. <a href="%s">Create some</a>.', admin_url('nav-menus.php')) . '</p>';
            } else {
                ?>
                <hr/>
                <p>
                    <?php
                    echo wp_kses_post(__(" <strong>Replacement Menus</strong><br />You may replace one of the standard Header Menus ( Primary, Secondary, or Header Mini ) on this page. If the menu hasn't been set in the Menus options, then you can set that menu for just this page.", 'weaver-xtreme'));
                    ?>
                    <br/>
                    <label for="_pp_alt_primary_menu"><strong><?php echo('Alternate Primary Menu' /*a*/); ?></strong></label>
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <select id="_pp_alt_primary_menu" name="_pp_alt_primary_menu">
                        <option value=''></option>
                        <?php
                        foreach ($menus as $menu) {
                            $selected = get_post_meta($post->ID, "_pp_alt_primary_menu", true) == $menu->term_id ? ' selected="selected"' : '';
                            echo '<option' . $selected . ' value="' . $menu->term_id . '">' . $menu->name . '</option>';
                        }
                        ?>
                    </select>

                    <br/><label
                            for="_pp_alt_secondary_menu"><strong><?php echo('Alternate Secondary Menu' /*a*/); ?></strong></label>
                    &nbsp;&nbsp;&nbsp;
                    <select id="_pp_alt_secondary_menu" name="_pp_alt_secondary_menu">
                        <option value=''></option>
                        <?php
                        foreach ($menus as $menu) {
                            $selected = get_post_meta($post->ID, "_pp_alt_secondary_menu", true) == $menu->term_id ? ' selected="selected"' : '';
                            echo '<option' . $selected . ' value="' . $menu->term_id . '">' . $menu->name . '</option>';
                        }
                        ?>
                    </select>
                    <br/><label
                            for="_pp_alt_mini_menu"><strong><?php echo('Alternate Header Mini Menu' /*a*/); ?></strong></label>
                    &nbsp;
                    <select id="_pp_alt_mini_menu" name="_pp_alt_mini_menu">
                        <option value=''></option>
                        <?php
                        foreach ($menus as $menu) {
                            $selected = get_post_meta($post->ID, "_pp_alt_mini_menu", true) == $menu->term_id ? ' selected="selected"' : '';
                            echo '<option' . $selected . ' value="' . $menu->term_id . '">' . $menu->name . '</option>';
                        }
                        ?>
                    </select>
                </p>
                <?php
            }
            echo '<p>';
            echo wp_kses_post(__(" <strong>Alternate Subtheme</strong><br />You may specify an alternate Weaver Xtreme subtheme that you have saved on your host filesystem for this page. See Legacy Weaver Xtreme Admin : Save/Restore tab to save a subtheme.", 'weaver-xtreme'));

            echo '<br /><br />';
            if (version_compare(WEAVER_XPLUS_VERSION, '3.1', '>=')) {
                echo wp_kses_post(__('<em>Please select a previously saved theme settings file saved from the <strong>Save Current Theme Related Settings to File (★Xtreme Plus)</strong> option from the Weaver Xtreme Admin &rarr; Save/Restore tab ( either .wxt or .wxb ).</em>', 'weaver-xtreme'));
                esc_html_e('Note: This page will still use the default site subtheme settings to display in the Page Editor ( i.e., on this screen ).', 'weaver-xtreme');

                // build the theme file list
                $themes = weaverx_pp_get_alt_themes();
                ?>
                <br/>

                <label for="_pp_alt_theme"><strong><?php echo('Alternate Subtheme for this Page: ' /*a*/); ?></strong></label> &nbsp;
                <select id="_pp_alt_theme" name="_pp_alt_theme">
                    <option value=''></option>
                    <?php
                    foreach ($themes as $subtheme) {
                        $selected = get_post_meta($post->ID, "_pp_alt_theme", true) == $subtheme ? ' selected="selected"' : '';
                        echo '<option' . $selected . ' value="' . $subtheme . '">' . $subtheme . '</option>';
                    }
                    ?>
                </select>
                <?php


            } else {
                echo wp_kses_post(__(' <em>This option requires Weaver Xtreme Plus version 3.1 or greater.</em>', 'weaver-xtreme'));
            }


            echo '<br /><hr /><span style="clear:both;"/></span><strong>' . esc_html__('Header Image Replacement HTML', 'weaver-xtreme') . '</strong> (&#9733;Plus)';
            ?>
            </p>
            <p>
                <?php
                if (version_compare(WEAVER_XPLUS_VERSION, '2.90', '>=')) :
                    esc_html_e('Replace Header image with arbitrary HTML for this page only. Useful for slider shortcodes in place of image. FI as Header Image has priority over HTML replacement. This will work with [show_slider] or almost any other slider that supports a shortcode.', 'weaver-xtreme')
                    ?>
                    <textarea class="wvrx-edit" placeholder=" " name="_pp_header_image_html_text"
                              rows=1
                              style="width: 95%"><?php echo(get_post_meta($post->ID, '_pp_header_image_html_text', true)); ?></textarea>
                <?php endif; // new version ?>
            </p>
            <?php
            echo '<span style="clear:both;"/></span><strong>' . esc_html__('Header Video Options', 'weaver-xtreme') . '</strong> (&#9733;Plus)';

            $showopts = array(
                array('val' => '', 'desc' => esc_html__('Default: only if this page is the front page', 'weaver-xtreme')),
                array('val' => 'yes', 'desc' => esc_html__('Yes', 'weaver-xtreme')),
                array('val' => 'no', 'desc' => esc_html__('Never', 'weaver-xtreme')),
            );
            $aspectopts = array(
                array('val' => '', 'desc' => esc_html__('Global Aspect Ratio', 'weaver-xtreme')),
                array('val' => '16:9', 'desc' => esc_html__('16:9 HDTV', 'weaver-xtreme')),
                array('val' => '4:3', 'desc' => esc_html__('4:3 Std TV', 'weaver-xtreme')),
                array('val' => '3:2', 'desc' => esc_html__('3:2 35mm Photo', 'weaver-xtreme')),
                array('val' => '5:3', 'desc' => esc_html__('5:3 Alternate Photo', 'weaver-xtreme')),
                array('val' => '64:27', 'desc' => esc_html__('2.37:1 Cinemascope', 'weaver-xtreme')),
                array('val' => '37:20', 'desc' => esc_html__('1.85:1 VistaVision', 'weaver-xtreme')),
                array('val' => '3:1', 'desc' => esc_html__('3:1 Banner', 'weaver-xtreme')),
                array('val' => '4:1', 'desc' => esc_html__('4:1 Banner', 'weaver-xtreme')),
                array('val' => '9:16', 'desc' => esc_html__('9:16 Vertical HD (Please avoid!)', 'weaver-xtreme')),
            );
            $renderopts = array(
                array('val' => '', 'desc' => esc_html__('Global Rendering Setting', 'weaver-xtreme')),
                array('val' => 'has-header-video', 'desc' => esc_html__('As video in header only', 'weaver-xtreme')),
                array('val' => 'has-header-video-cover', 'desc' => esc_html__('As full cover Parallax BG Video', 'weaver-xtreme')),
                array('val' => 'has-header-video-none', 'desc' => esc_html__('Disable Header Video', 'weaver-xtreme')),

            );
            ?>
            <p>
                <label for='_pp_video_active'><strong><?php echo('Display Video on This Page:' /*a*/); ?></strong></label>
                &nbsp;
                <select id='_pp_video_active' name='_pp_video_active'>
                    <?php
                    foreach ($showopts as $opt) {
                        $selected = get_post_meta($post->ID, '_pp_video_active', true) == $opt['val'] ? ' selected="selected"' : '';
                        echo '<option' . $selected . ' value="' . $opt['val'] . '">' . $opt['desc'] . '</option>';
                    }
                    ?>
                </select>
            </p>
            <p>
                <label for='_pp_video_url'><strong><?php echo('Video URL for This Page:' /*a*/); ?></strong></label>
                &nbsp;
                <textarea class="wvrx-edit" placeholder=" " name='_pp_video_url' rows=1
                          style="width: 45%"><?php echo(get_post_meta($post->ID, '_pp_video_url', true)); ?></textarea>
                <?php
                if (!has_header_video() && get_post_meta($post->ID, '_pp_video_url', true)) { ?>
                    <br/><strong>
                        <em style="color:red;">
                            IMPORTANT: There is NO Header Video set on the <u>Customizer : Images :
                                Header Media ( Content )</u> menu. Please set one.</em>
                        Due to current restrictions with the WordPress Header Media video
                        implementation,
                        you MUST always define some Header Video selection in that menu, even if you
                        are specifying an alternative Per Page Video URL here.
                        We think this is a flaw in the WP core, and have requested that the
                        restriction be removed in the future.</strong>
                <?php } ?>
            </p>
            <p>
                <label for='_pp_video_aspect'><strong><?php echo('Aspect Ratio:' /*a*/); ?></strong></label>
                &nbsp;
                <select id='_pp_video_aspect' name='_pp_video_aspect'>
                    <?php
                    foreach ($aspectopts as $opt) {
                        $selected = get_post_meta($post->ID, '_pp_video_aspect', true) == $opt['val'] ? ' selected="selected"' : '';
                        echo '<option' . $selected . ' value="' . $opt['val'] . '">' . $opt['desc'] . '</option>';
                    }
                    ?>
                </select> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                <label for='_pp_video_render'><strong><?php echo('Header Video Rendering:' /*a*/); ?></strong></label>
                &nbsp;
                <select id='_pp_video_render' name='_pp_video_render'>
                    <?php
                    foreach ($renderopts as $opt) {
                        $selected = get_post_meta($post->ID, '_pp_video_render', true) == $opt['val'] ? ' selected="selected"' : '';
                        echo '<option' . $selected . ' value="' . $opt['val'] . '">' . $opt['desc'] . '</option>';
                    }
                    ?>
                </select>
            </p>
            <div style="clear:both"></div>
            <hr/>
            <p style="line-height:1.3em;">
                <?php echo('<strong>Per Page Code Insertion</strong>' /*a*/);
                weaverx_help_link('help.html#ExtraPP', 'Help for Extra Per Page Options');
                ?>
                Weaver Xtreme Plus supports code and HTML insertion for some areas. To add code,
                manually define the specified
                <em>Custom Field Name</em> and <em>Value</em>. Click the help ? for more details.
            </p>

            <?php
        }
    }    // end of action function

    function weaverx_pp_get_alt_themes(): array
    {
        $themes = array();
        $upload_dir = wp_upload_dir();
        $theme_dir = trailingslashit($upload_dir['basedir']) . WEAVERX_SUBTHEMES_DIR . '/';
        if ($media_dir = opendir($theme_dir)) {
            while ($m_file = readdir($media_dir)) {
                $len = strlen($m_file);
                $ext = $len > 4 ? substr($m_file, $len - 4, 4) : '';
                if ($ext == '.wxt' || $ext == '.wxb') {
                    $themes[] = $m_file;
                }
            }
        }

        return $themes;
    }

    add_action('weaverx_pp_xp_perpoststyle', 'weaverx_pp_xp_perpoststyle_action');

    function weaverx_pp_xp_perpoststyle_action(): void
    {
        global $post;

        echo '<br />' .
            wp_kses_post(__(' Enter optional per post CSS style rules. <strong>Do not</strong> include the &lt;style> and &lt;/style> tags.
Include the {}\'s. Don\'t use class names if rules apply to whole post, but do include class names
( e.g., <em>.entry-title a</em> ) for specific elements. Custom styles will not be displayed by the Post Editor.', 'weaver-xtreme')); ?>
        <br/>
        <textarea placeholder=" " class="wvrx-edit" name="_pp_post_styles" rows=2
                  style="width: 95%"><?php echo(get_post_meta($post->ID, "_pp_post_styles", true)); ?></textarea>

        <br/><input type="text" size="24" id="_pp_post_class" name="_pp_post_class"
                    value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_post_class", true)); ?>"/>&nbsp;
        <?php esc_html_e('Add Classes to this post', 'weaver-xtreme'); ?>
        <br/>
        <input type="text" size="24" id="bodyclass" name="_pp_bodyclass"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_bodyclass", true)); ?>"/>

        <?php echo wp_kses_post(__(' <em>Per Post body Class</em> - CSS class name to add to HTML &lt;body&gt; block when this post is displayed on Single Page.', 'weaver-xtreme')); ?>
        <br/>
        <?php
        // Weaver X Plus options for making horizontal bar layouts
        echo '<small>';
        echo wp_kses_post(__(' <em>Note:</em> The following options are especially useful for creating full-width stacked posts with different BG colors using the RAW page template and the Weaver Show Posts plugin.', 'weaver-xtreme'));
        echo '</small><br />';
        weaverx_pp_page_color('_pp_bgcolor', esc_html__('Post BG Color', 'weaver-xtreme'));
        echo '<span style="margin-left:40px;"></span>';
        weaverx_pp_page_color('_pp_bg_fullwidth', esc_html__('Extend BG color to full theme width on Desktop View (obsolete: will be removed in future versions)', 'weaver-xtreme'));
        echo '<br />';
        weaverx_pp_page_color('_pp_color', esc_html__('Post Text Color', 'weaver-xtreme'));
        ?>
        <br/>
        <input type="text" size="4" id="_pp_lr_padding" name="_pp_lr_padding"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_lr_padding", true)); ?>"/>
        <?php esc_html_e('em &nbsp;- Left and Right Padding for post', 'weaver-xtreme'); ?>

        <input style="margin-left:3em;" type="text" size="4" id="_pp_tb_padding"
               name="_pp_tb_padding"
               value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_tb_padding", true)); ?>"/>
        <?php esc_html_e('em &nbsp;- Top and Bottom Padding for post', 'weaver-xtreme'); ?>
        <br/><input type="text" size="11" id="_pp_margin" name="_pp_margin"
                    value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_margin", true)); ?>"/>&nbsp;
        <?php esc_html_e('Margins - Use CSS "margin:t r b l" notation. Recommended 0 for stacked posts.', 'weaver-xtreme'); ?>
        <br/><br/>


        <?php echo wp_kses_post(__(' <em><strong>Background Image</strong></em> - Full URL for BG image - add <code>background: position/size repeat origin clip attachment</code> options to Per Post Style above in class-less {} rule. Example: <code>{background-repeat: no-repeat;}</code>', 'weaver-xtreme')); ?>
        <br/>
        <input type="text" size="70" id='_pp_bgimg' name='_pp_bgimg'
               value="<?php echo esc_textarea(get_post_meta($post->ID, '_pp_bgimg', true)); ?>"/>
        &nbsp;: <?php echo wp_kses_post(__(' <strong>Desktop BG Image URL</strong>', 'weaver-xtreme')); ?>
        <br/>
        <input type="text" size="70" id='_pp_mobile_bgimg' name='_pp_mobile_bgimg'
               value="<?php echo esc_textarea(get_post_meta($post->ID, '_pp_mobile_bgimg', true)); ?>"/>
        &nbsp;: <?php echo wp_kses_post(__(' <strong>Mobile BG Image URL</strong> - optional', 'weaver-xtreme')); ?>
        <br/>

        <p><strong><?php echo wp_kses_post(__(' <em>Parallax</em> ', 'weaver-xtreme')); ?></strong>
            <?php weaverxplus_help_link('plus-help.html#parallax', esc_html__('Help for Parallax', 'weaver-xtreme')); ?>
            <br/>
            <?php echo wp_kses_post(__(' You can make a set of posts into a great looking Parallax page using a common tag/category,
custom BG images, and Page with Posts or [show_posts]. Create custom content to be displayed
over the BG image by creating a Manual Excerpt for this post. Do <em>not</em> specify any background
CSS options for the Parallax BG image. See Parallax Help!', 'weaver-xtreme')) ?>
            <br/>
            <?php
            weaverx_pp_page_checkbox('_pp_use_parallax', esc_html__('Make this Post a Parallax post', 'weaver-xtreme'));
            weaverx_pp_page_checkbox('_pp_parallax_not_wide', wp_kses_post(__(' Do <em>not</em> make BG image full width of enclosing area.', 'weaver-xtreme')), 'auto', 1);

            ?>

            <input type="text" size="4" id="_pp_parallax_height" name="_pp_parallax_height"
                   value="<?php echo esc_textarea(get_post_meta($post->ID, "_pp_parallax_height", true)); ?>"/>
            <?php esc_html_e('px &nbsp;- Specify visible height of Parallax image. (Default:400px)', 'weaver-xtreme'); ?>
        </p>
        <?php

        if (version_compare(WEAVER_XPLUS_VERSION, '2.90', '>=')) :

            echo '<hr /><br style="clear:both;"/><strong>' . esc_html__('Header Image Replacement HTML', 'weaver-xtreme') . '</strong> (&#9733;Plus)' /*a*/
            ;
            ?>
            </p><p>
            <?php
            esc_html_e('Replace Header image with arbitrary HTML for this post single page view only. Useful for slider shortcodes in place of image. FI as Header Image has priority over HTML replacement. This will work with [show_slider] or almost any other slider that supports a shortcode.', 'weaver-xtreme')
            ?>
            <textarea class="wvrx-edit" placeholder=" " name="_pp_header_image_html_text" rows=1
                      style="width: 95%"><?php echo(get_post_meta($post->ID, '_pp_header_image_html_text', true)); ?></textarea>
        </p>
        <?php endif; // new version
        ?>


        <hr/>
        <p style="line-height:1.3em;">
            <?php echo('<strong>Per Page Code Insertion for Single Page View</strong>' /*a*/);
            weaverx_help_link('help.html#ExtraPP', 'Help for Extra Per Page Options');
            ?>
            Weaver Xtreme Plus supports code and HTML insertion for some areas of the Post Single
            View page. To add code, manually define the specified
            <em>Custom Field Name</em> and <em>Value</em>. Click the help ? for more details.
        </p>

        <?php
    }


//-----------------------------------


// ---- functions for XPlus only

    function weaverx_pp_xp_text_option($postid, $optid, $msg, $before = '', $after = ''): void
    {
        $val = esc_textarea(get_post_meta($postid, $optid, true));
        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
        echo "{$before}<input type='text' size='20' id='$optid' name='{$optid}' value='{$val}' />&nbsp; {$msg}{$after}";
    }
endif;

?>
