<?php
/*
Plugin Name: Weaver Xtreme Plus
Plugin URI: https://plus.weavertheme.com
Description: Weaver Xtreme Plus - Add new premium options to Weaver Xtreme
Author: Bruce Wampler
Author URI: https://weavertheme.com/about
Version: 4.0
License: GPL

Weaver Xtreme Plus
Copyright (C) 2014-2020 Bruce E. Wampler - weaver@weavertheme.com

GPL License: http://www.opensource.org/licenses/gpl-license.php

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

define( 'WEAVER_XPLUS_VERSION', '4.0' );    // this has to correspond to version in license db for updates
define( 'WEAVER_XPLUS_MINIFY', '.min' );
define( 'WEAVERX_THEMEDIRECTORY', 'themes/weaver-xtreme' );
define( 'WEAVERX5_THEMEDIRECTORY', 'themes/weaver-xtreme-5' );
//define ('WEAVERX_PLUS_TEST_MODE', false );	// development only, comment out when not used

// this is the URL our updater / license checker pings. This should be the URL of the site with EDD installed
define( 'WEAVER_PLUS_STORE_URL', 'https://shop.weavertheme.com' ); // you should use your own CONSTANT name, and be sure to replace it throughout this file - REQUIRES http:

// the name of your product. This should match the download name in EDD *** exactly ***
// you should use your own CONSTANT name, and be sure to replace it throughout this file

define( 'WEAVER_XPLUS_LICENSE', 'Weaver Xtreme Plus Plugin' );

define( 'WEAVER_XPLUS_KEY', 'weaverxplus_key' );
define( 'WEAVER_XPLUS_KEY_STATUS', 'weaverxplus_key_status' );

$ts = false;
if ( function_exists( 'wvrx_ts_installed' ) ) {            // for simple case where show_posts gets installed first
	$ts = true;
} else {
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );    // need this for is_plugin_active
	$ts = is_plugin_active( 'weaverx-theme-support/weaverx-ts.php' );
}


$template_dir = get_template_directory();        // path to root template directory

if ( stripos( $template_dir, WEAVERX_THEMEDIRECTORY ) !== false
     || stripos( $template_dir, WEAVERX5_THEMEDIRECTORY ) !== false ) {

	function weaverxplus_plugin_installed() {
		return WEAVER_XPLUS_VERSION;
	}

	register_deactivation_hook( __FILE__, 'weaverxplus_deactivate' );

	function weaverxplus_deactivate() {
		// auto-generate a Plus backup in case they overwrite with free save settings
		$opts = get_option( apply_filters( 'weaverx_options', 'weaverx_settings' ), array() );
		$compressed = array_filter( $opts, 'strlen' ); // filter out all null options (strlen == 0)
		update_option( 'weaverx_plus_backup', $compressed );
		if ( function_exists( 'weaverx_alert' ) ) {
			weaverx_alert( __( 'A backup of your Weaver Xtreme Plus Settings has been saved. You can use it to restore the current Plus settings from the Save/Restore tab when you re-activate Plus.', 'weaver-xtreme-plus' ) );
		}
	}

//===============================================================
// connect plugin to WP
// Set up Admin
// 1. Add Admin Menu and Admin scripts
// 2. Add runtime scripts

// no admin needed...

// Add any scripts needed by the plugin runtime

	add_action( 'wp_enqueue_scripts', 'weaverxplus_enqueue_scripts' );    // enqueue runtime scripts
	function weaverxplus_enqueue_scripts() {    // action definition
		//-- Weaver Xtreme Plus js lib - requires jQuery... - no lib currently needed

		if ( function_exists( 'weaverx_getopt' ) ) {
			$use_sm = weaverx_getopt( 'use_smartmenus' );
			if ( $use_sm ) {
				// handle must be weaverxSMLib so won't load if Weaver Xtreme already loaded
				wp_enqueue_script( 'weaverxSMLib', weaverxplus_plugins_url( '/js/smartmenus/jquery.smartmenus', WEAVER_XPLUS_MINIFY . '.js' )
					, array( 'jquery' ), WEAVER_XPLUS_VERSION );
			}
		}
	}

	add_action( 'admin_enqueue_scripts', 'weaverxplus_admin_enqueue_scripts' );    // enqueue runtime scripts
	function weaverxplus_admin_enqueue_scripts() {    // action definition

		//-- Weaver Xtreme Plus js lib - requires jQuery... - no lib currently needed
		// IMPORTANT! Weaver Xtreme now dequeues this script as a fix for deprecated jQuery.fn.load
		// That was a simple compatibility fix as the Autosize only helped for old style legacy textareas,
		// and browsers handle that better than in 2016.

		// wp_enqueue_script( 'wvrxplusAutosize', weaverxplus_plugins_url( '/js/autosize/wvr-jquery.autosize', WEAVER_XPLUS_MINIFY . '.js' ), array( 'jquery' ) );

		// add plugin admin CSS here, too.
	}

// =============================== utility functions =============================

	if ( ! function_exists( 'weaverxplus_plugins_url' ) ) {      // this must be in the plugin root to work right
		function weaverxplus_plugins_url( $file, $ext ) {
			return plugins_url( $file, __FILE__ ) . $ext;
		}
	}

	function weaverxplus_admin_plugin() {
		require_once( dirname( __FILE__ ) . '/includes/weaver_xplus_admin_top.php' ); // NOW - load the admin stuff
		weaverxplus_admin_page();
	}

	function weaverxplus_admin_menu() {
		$page = add_theme_page(
			'Weaver Xtreme Plus', '<span class="dashicons dashicons-plus"></span> Xtreme Plus', 'manage_options', 'weaverxplus', 'weaverxplus_admin_plugin' );
		/* using registered $page handle to hook stylesheet loading for this admin page */
		add_action( 'admin_print_styles-' . $page, 'weaverxplus_admin_scripts' );
	}

	add_action( 'admin_menu', 'weaverxplus_admin_menu', 6 );

	add_action( 'admin_menu', 'weaverxplus_add_page_fields' );

	function weaverxplus_add_page_fields() {
		if ( ! defined( 'WVRX_TS_VERSION' ) ) {            // Put up a message if no Theme Support plugin
			add_meta_box( 'page-box', __( 'Weaver Xtreme Options For This Page (Xtreme Plus Per Page Options)', 'weaver-xtreme-plus' /*adm*/ ), 'weaverxplus_page_extras_load', 'page', 'normal', 'high' );
			add_meta_box( 'post-box', __( 'Weaver Xtreme Options For This Post (Xtreme Plus Per Post Options)', 'weaver-xtreme-plus' /*adm*/ ), 'weaverxplus_post_extras_load', 'post', 'normal', 'high' );
		}

	}

	function weaverxplus_page_extras_load() {    // not used in 2.2
		_e( 'NOTICE: <em>Weaver Xtreme Plus</em> <strong>requires</strong> that the <em>Weaver Xtreme Theme Support Plugin</em> be installed to provide Per Page Options.', 'weaver-extreme-plus' );
	}

	function weaverxplus_post_extras_load() {    // not used in 2.2
		_e( 'NOTICE: <em>Weaver Xtreme Plus</em> <strong>requires</strong> that the <em>Weaver Xtreme Theme Support Plugin</em> be installed to provide Per Post Options.', 'weaver-extreme-plus' );
	}


	function weaverxplus_admin_scripts() {
		/* called only on the admin page, enqueue our special style sheet here (for tabbed pages) */

		$sheet = get_template_directory_uri() . '/assets/css/fonts' . WEAVERX_MINIFY . '.css';
		$sheet_name = 'weaverxplus-font-sheet';
		wp_register_style( $sheet_name, $sheet, array(), WEAVER_XPLUS_VERSION, 'all' );
		wp_enqueue_style( $sheet_name );

		wp_enqueue_style( 'atw_sw_Stylesheet', weaverxplus_plugins_url( '/atw-admin-style', WEAVER_XPLUS_MINIFY . '.css' ), array(), WEAVER_XPLUS_VERSION );

		wp_enqueue_script( 'atw_Yetii', weaverxplus_plugins_url( '/js/yetii/yetii', WEAVER_XPLUS_MINIFY . '.js' ), array(), WEAVER_XPLUS_VERSION );
		wp_enqueue_script( 'atw_Hide', weaverxplus_plugins_url( '/js/theme/hide-css', WEAVER_XPLUS_MINIFY . '.js' ), array(), WEAVER_XPLUS_VERSION );
	}


	add_action( 'weaverxplus_add_admin', 'weaverxplus_add_admin_action' );
	function weaverxplus_add_admin_action() {
		//if (function_exists('weaverx_getopt')) {	// avoid issues when previewing a different theme from Customizer
		require_once( dirname( __FILE__ ) . '/includes/weaver_xplus_admin_actions.php' ); // NOW - load the plugin admin actions
		require_once( dirname( __FILE__ ) . '/includes/weaver_xplus_license.php' );
		//}
	}

	//if (function_exists('weaverx_getopt')) {
	require_once( dirname( __FILE__ ) . '/includes/weaver_xplus_fileio.php' ); // NOW - load the plugin
	require_once( dirname( __FILE__ ) . '/includes/weaver_xplus_runtime_lib.php' ); // NOW - load the plugin
	require_once( dirname( __FILE__ ) . '/includes/weaver_xplus_actions.php' ); // NOW - load the plugin
	require_once( dirname( __FILE__ ) . '/includes/weaver_xplus_extramenu.php' ); // NOW - load the plugin
	require_once( dirname( __FILE__ ) . '/includes/weaver_xplus_shortcodes.php' ); // NOW - load the
	//}

// Licensing stuff -----------------------------------------


	function weaverxplus_plugin_updater() {
		// retrieve our license key from the DB
		$license_key = trim( get_option( WEAVER_XPLUS_KEY ) );;
		$stat = get_option( WEAVER_XPLUS_KEY_STATUS );

		// setup the updater
		if ( $stat == 'active' || $stat == 'valid' ) {
			if ( ! class_exists( 'EDD_SL_Plugin_Updater' ) ) {
				// load EDD updater
				require_once( dirname( __FILE__ ) . '/includes/WVRX_EDD_SL_Plugin_Updater.php' );
			}

			$edd_updater = new EDD_SL_Plugin_Updater(
				WEAVER_PLUS_STORE_URL, __FILE__, array(
					'version'   => WEAVER_XPLUS_VERSION,        // current version number
					'license'   => $license_key,                // license key (used get_option above to retrieve from DB)
					'item_name' => WEAVER_XPLUS_LICENSE,        // name of this plugin
					'author'    => 'Bruce Wampler',             // author of this plugin
					'url'       => home_url(),
				)
			);
		}
	}

	add_action( 'admin_init', 'weaverxplus_plugin_updater', 0 );    // hook into WP's updating

} // end of load only if weaver template


