<?php
if ( !defined('ABSPATH')) exit; // Exit if accessed directly
/*
Weaver Xtreme Plus Social Shortcode/Widget - Version 1.0

CODE

This code is Copyright 2011 by Bruce Wampler, all rights reserved.
This code is licensed under the terms of the accompanying license file: license.html.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/
/* ============================ weaverxplus_extra_menu =============================== */
$weaverxplus_social_services = array(
	array ('icon'=>'month', 'site'=>'# Enter URL to your calendar' , 'blurb'=>'Our calendar'),
    array ('icon'=>'cart', 'site'=>'# Enter URL of your site\'s shopping cart' , 'blurb'=>'This site\'s Cart'),
    array ('icon'=>'codepen', 'site'=>'codepen.io' , 'blurb'=>'Codepen: An HTML, CSS, and JavaScript code editor in your browser'),
	array ('icon'=>'digg', 'site'=>'digg.com' , 'blurb'=>'Digg: The best news, videos and pictures on the web as voted on by the Digg community'),
	array ('icon'=>'dribbble', 'site'=>'dribbble.com' , 'blurb'=>'Dribbble is show and tell for creatives'),
    array ('icon'=>'dropbox', 'site'=>'dropbox.com' , 'blurb'=>'Dropbox: Your stuff, anywhere'),
    array ('icon'=>'download', 'site'=>'# Enter URL of your site\'s download' , 'blurb'=>'This site\'s download page'),
	array ('icon'=>'mail', 'site'=>'# E-mail link (mailto:you@example.com or url)' , 'blurb'=>'Send Email to this Site\'s Admin'),
	array ('icon'=>'facebook', 'site'=>'facebook.com' , 'blurb'=>'Facebook: social networking'),
    array ('icon'=>'facebook-alt', 'site'=>'facebook.com' , 'blurb'=>'Facebook: social networking'),
	array ('icon'=>'flickr', 'site'=>'www.flickr.com' , 'blurb'=>'flickr: Share photos and video.'),
    array ('icon'=>'feed', 'site'=>'# Enter URL of your site\'s feed' , 'blurb'=>'This site\'s RSS feed'),
	array ('icon'=>'foursquare', 'site'=>'foursquare.com' , 'blurb'=>'Foursquare helps you find the perfect places'),
    array ('icon'=>'github', 'site'=>'github.com' , 'blurb'=>'Github: Build software better, together.'),
    array ('icon'=>'googleplus', 'site'=>'plus.google.com' , 'blurb'=>'Google+: Real-life sharing rethought for the web'),
    array ('icon'=>'googleplus-alt', 'site'=>'plus.google.com' , 'blurb'=>'Google+: Real-life sharing rethought for the web'),
	array ('icon'=>'info', 'site'=>'# Enter URL of your site\'s info' , 'blurb'=>'This site\'s info page'),
    array ('icon'=>'instagram', 'site'=>'instagram.com' , 'blurb'=>"Instagram: Capture and Share the World's Moments"),
	array ('icon'=>'linkedin', 'site'=>'www.linkedin.com' , 'blurb'=>'LinkedIn: Professional contact information'),
    array ('icon'=>'linkedin-alt', 'site'=>'www.linkedin.com' , 'blurb'=>'LinkedIn: Professional contact information'),
	array ('icon'=>'audio', 'site'=>'#Enter address of podcast' , 'blurb'=>'Listen to our podcast'),
    array ('icon'=>'path', 'site'=>'path.com' , 'blurb'=>'Path: Quality Internet Goods'),
    array ('icon'=>'pinterest', 'site'=>'pinterest.com' , 'blurb'=>'Pintrest: All the things that inspire you.'),
    array ('icon'=>'pinterest-alt', 'site'=>'pinterest.com' , 'blurb'=>'Pintrest:All the things that inspire you.'),
    array ('icon'=>'phone', 'site'=>'# Enter URL of your phone link' , 'blurb'=>'Our phone number'),
    array ('icon'=>'image', 'site'=>'# Enter URL of your photo site' , 'blurb'=>'Our Photos'),
    array ('icon'=>'pocket', 'site'=>'getpocket.com' , 'blurb'=>'Pocket: When you find something you want to view later.'),
    array ('icon'=>'polldaddy', 'site'=>'polldaddy.com' , 'blurb'=>'Polldaddy: Surveys your way.'),
	array ('icon'=>'reddit', 'site'=>'www.reddit.com' , 'blurb'=>'reddit: User-generated news links'),
	array ('icon'=>'skype', 'site'=>'www.skype.com' , 'blurb'=>'Skype: Video and phone calling'),
    array ('icon'=>'spotify', 'site'=>'spotify.com' , 'blurb'=>'Spotify: Music for everyone.'),
	array ('icon'=>'stumbleupon', 'site'=>'www.stumbleupon.com' , 'blurb'=>'StumbleUpon: discover the best of the web'),
	array ('icon'=>'tumblr', 'site'=>'www.tumblr.com' , 'blurb'=>'Tumblr: blogging'),
	array ('icon'=>'twitter', 'site'=>'twitter.com' , 'blurb'=>'Twitter'),
    array ('icon'=>'twitch', 'site'=>'twitch.tv' , 'blurb'=>'Twitch is the world\'s leading video platform and community for gamers'),
	array ('icon'=>'vimeo', 'site'=>'vimeo.com' , 'blurb'=>'Vimeo: Video Sharing'),
	array ('icon'=>'wordpress', 'site'=>'www.wordpress.org' , 'blurb'=>'WordPress: blogging'),
	array ('icon'=>'youtube', 'site'=>'youtube.com' , 'blurb'=>'YouTube: video sharing'),
	array ('icon'=>'video', 'site'=>'#Enter your own video link' , 'blurb'=>'Watch our video'),
);

function weaverxplus_has_socialbuttons() { return true;}

class weaverxplus_Widget_Social extends WP_Widget {

		function __construct() {
				$widget_ops = array( 'classname'=>'weaverxplus_social',
									'description' => __('Display Social Buttons as set in Weaver Xtreme Plus Social Shortcode Settings.','weaver-xtreme-plus' ));
				parent::__construct( 'weaverxplus_social', __('Wvr X-Plus Social Buttons','weaver-xtreme-plus'), $widget_ops );
		}

		function widget($args, $instance) {
				// Get menu

				$instance['title'] = apply_filters('widget_title', $instance['title'], $instance, $this->id_base);

				echo $args['before_widget'];

				if ( !empty($instance['title']) )
						echo $args['before_title'] . $instance['title'] . $args['after_title'];

				echo weaverxplus_social_generate_code(36, 1000, true, '', '', 'weaver-social-widget');

				echo $args['after_widget'];
		}

		function update( $new_instance, $old_instance ) {
				$instance['title'] = strip_tags( stripslashes($new_instance['title']) );
				return $instance;
		}

		function form( $instance ) {
				$title = isset( $instance['title'] ) ? $instance['title'] : '';
?>
				<p>
						<label for="<?php echo $this->get_field_id('title'); ?>"><?php echo('Title:' /*a*/ ) ?></label>
						<input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php weaverx_plus_esc_textarea($title); ?>" />
				</p>
				<p><em>Select Social Buttons to display from the Weaver Xtreme Plus Shortcodes menu. You can style with '.weaver-social'.</em>
				</p>
<?php
		}
}

function weaverxplus_social_shortcode($args = '') {
	// [extra_menu menu='custom-menu-name' style='style-name']
	extract(shortcode_atts(array(
		'tag' => '',
		'font_size' => '',      // default height for menu bar use
		'number' => '1000',      // only show first number buttons
        'color' => '',
        'class' => '',
        'names' => ''
	), $args));

	return weaverxplus_social_generate_code($font_size, $number, false, $tag, $color, $class, $names);
}

function weaverxplus_save_social() {

	global $weaverxplus_social_services;

    $soc = weaverxplus_init_social();

	if (isset($_POST['wvp_add_social_to_menu'])) weaverxplus_setopt('wvp_add_social_to_menu', weaverxplus_default_int($_POST['wvp_add_social_to_menu'],1,34,''));

	foreach ($weaverxplus_social_services as $service) {
		$id = $service['icon'];

		if (isset($_POST[$id.'_use']))
            $soc[$id.'_use'] = 'checked';
		else
            $soc[$id.'_use'] = false;

		if (isset($_POST[$id.'_stay']))
            $soc[$id.'_stay'] = 'checked';
		else
            $soc[$id.'_stay'] = false;

		if (isset($_POST[$id.'_order']))
			$soc[$id.'_order'] = weaverxplus_default_int($_POST[$id.'_order'], 0, 10000, '');
		else
			$soc[$id.'_order'] = '';

		if (isset($_POST[$id.'_hover']) && $_POST[$id.'_hover'] != '')
			$soc[$id.'_hover'] = weaverx_filter_textarea(stripslashes($_POST[$id . '_hover']));
		else
			$soc[$id.'_hover'] = $service['blurb'];

		if (isset($_POST[$id.'_url']))
			$soc[$id.'_url'] = weaverx_filter_textarea(stripslashes($_POST[$id . '_url']));
		else
			$soc[$id.'_url'] = '';

		if (isset($_POST[$id.'_custom']))
			$soc[$id.'_custom'] = weaverx_filter_textarea(strip_slashes($_POST[$id . '_custom']));
		else
			$soc[$id.'_custom'] = '';
	}

    //echo '<hr />'; print_r($soc);
	weaverxplus_setopt('social', $soc, true);
    echo '<div id="message" class="updated fade"><p><strong>Social Options Saved</strong></p></div>';

}

function weaverxplus_init_social() {
	// social opts are kept in an array saved in weaverxplus_plus:['social']
	global $weaverxplus_social_services;

	$soc = weaverxplus_getopt('social');

    if ( $soc ) {
        return $soc;
    }

    $soc = array();

	foreach ($weaverxplus_social_services as $service) {
	   $id = $service['icon'];
	   if (!isset($soc[$id.'_use'])) {
			  $soc[$id.'_use'] = false;
	   }
	   if (!isset($soc[$id.'_order'])) {
			  $soc[$id.'_order'] = '';
	   }
	   if (!isset($soc[$id.'_hover'])) {
			  $soc[$id.'_hover'] = $service['blurb'];
	   }
	   if (!isset($soc[$id.'_url'])) {
			  $soc[$id.'_url'] = '';
	   }
	   if (!isset($soc[$id.'_stay'])) {
			  $soc[$id.'_stay'] = false;
	   }
	   if (!isset($soc[$id.'_custom'])) {
			  $soc[$id.'_custom'] = '';
	   }
	}

	weaverxplus_setopt('social', $soc, true);
}

function weaverxplus_social_generate_code($font_size='', $number=1000, $is_widget=true, $tag='', $color='', $class='', $names='') {
	global $weaverxplus_social_services;

	$soc = weaverxplus_init_social();

	$out = '';

	// need to sort the buttons according to the order field. This code may not be the best way to do this,
	// but it was easier that figuring sorting the array of services.
	$sorted = array();
	$active_services = array();

    if ( $names != '' ) {   // list from id list
        $sorted_ids = array();
        $names = explode(',',str_replace(' ','',$names));       // list
        foreach ( $names as $name ) {
            foreach ($weaverxplus_social_services as $service) { // find the active service that matches the next sorted id
                if ( isset($service['icon']) && $name == $service['icon'] ) {
                    $sorted_ids[] = $name;
                    $active_services[] = $service;
                }
            }
        }
        //$out .= print_r($sorted_ids, true);

    } else {    // normal list

        foreach ($weaverxplus_social_services as $service) {  // find all active buttons
           $id = $service['icon'];

           if (!isset($soc[$id.'_use']) || !$soc[$id.'_use']) {     // not set to use
                  continue;
           }
		   if (isset($soc[$id.'_order']) && $soc[$id.'_order'] != '')
				$order = $soc[$id.'_order'];
           else
				$order = 100000;
           $sorted[$id] = $order;
           array_push($active_services,$service);   // order doesn't matter here, so just push
         }
        asort($sorted);     // sort the list of service names

        $sorted_ids = array_keys($sorted);  // get the keys into an array - will be a sorted list of services
    }

	$displayed = 0;

	$rm = ($is_widget) ? '4' : '0'; // use 4 with 36px icon font-size for optimal in 25% sidebars
    $font_style = '';

    if ( $font_size != 0 )
        $font_style = 'style="font-size:' . $font_size . 'px;margin-right:' . $rm . 'px;"';
    else
        $font_style = 'style="margin-right:' . $rm . 'px;"';


    $color_style = '';
    if ( $color ) {
        $color_style = ' style="color:' . $color . '"';
    }

    $tag_before = '';       // wrap each icon with this tag
    $tag_after = '';

    if ($tag) {
        $tag_before = "<{$tag}>";
        $tag_after = "</{$tag}>";
    }

	$out .= '<div class="' . trim("weaver-social {$class}") . '">';

	foreach($sorted_ids as $use_id) {
	   foreach ($active_services as $service) { // find the active service that matches the next sorted id
            $id = $service['icon'];
            if ($id != $use_id)
                continue;
            $title = isset($soc[$id.'_hover']) ? $soc[$id.'_hover'] : '';         // $service['blurb'];
            $url = isset($soc[$id.'_url']) ? $soc[$id.'_url'] : '';
            $target = '_blank';
			if (isset($soc[$id.'_stay']) && $soc[$id.'_stay']) $target = '_self';

            $icon = '<span class="wvr-social-icon genericon genericon-' . $id . '" '. $font_style .'></span>';


			$out .= $tag_before . '<a class="wvr-social-a"' . $color_style . ' href="' . $url . '" target="' . $target . '" title="' . $title . '">'
			  . $icon . "</a>{$tag_after}\n";

		   if (++$displayed >= $number) {
                $out .= '</div>' . "\n";
                return $out;                     // bail when display number reached
		   }
		   break;
	   }
	} // end foreach

	$out .= '</div>' . "\n";
	if ($is_widget)
	   $out .= '<div style="clear:both;"></div>' . "\n";
	return $out;
}

weaverxplus_add_shortcode('social','weaverxplus_social_shortcode');
/* ============================ weaverxplus_social =============================== */

add_action('widgets_init', "weaverxplus_load_social_widget");
function weaverxplus_load_social_widget() {
	register_widget("weaverxplus_Widget_Social");
}
?>
