<?php

// ----------------------------------- Weaver X-Plus Flex Columns -----------------
define('WVRX_DEF_FLEX_COLS', 2);
class WeaverX_Widget_Columns extends WP_Widget {


	function __construct() {
		$widget_ops = array('classname' => 'wvrx-flex-colsumns',
		 'description' => __('Displays multiple text areas arranged in customizable columns using CSS flex layout. Use arbitrary text, HTML, or shortcodes in each text area.','weaver-xtreme-plus' /*adm*/));

		$control_ops = array('width' => 490, 'height' => 50);
		parent::__construct('wvrx_columns', __('Wvr X-Plus Flex Columns','weaver-xtreme-plus' /*adm*/), $widget_ops, $control_ops);
	}

	function widget( $args, $instance ) {
		extract($args);

		$title = apply_filters( 'widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);

		$warnings = '';

		for ( $i = 1; $i <= $instance['max_cols'] ; $i++ ) {

			if ( !isset($instance["text{$i}"]) )
				$instance["text{$i}"] = '';

			if ( !isset($instance["boxcss{$i}"]) )
				$instance["boxcss{$i}"] = '';


			$text[$i] = apply_filters( 'weaverxp_text', $instance["text{$i}"], $instance );
			$boxcss[$i] = str_replace(array('{','}'), '', $instance["boxcss{$i}"]);
		}

		$id_start = strpos($before_widget,'wvrx_columns-');
		if ( $id_start !== false ) {
			$per_widget_ID = 'wvrx_columns-';
			for ( $i = $id_start + 13 ; $before_widget[$i] != '"' && $i < 60 ; $i++ ) {		// 13 == strlen('wvrx_columns-');
				$per_widget_ID .= $before_widget[$i];
			}
		} else {
			$per_widget_ID = '';		// bail
			$warnings .= __('Current Theme incompatible with Flex Columns. Invalid Widget ID.', 'weaver-xtreme-plus') . '<br />';
		}

		// generate required options for this widget with inline <style>

		// build preset arrays of 13 values (including index 0) for each predefined layout.
		$c2_eq = array(100, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50);
		$c3_eq = array(100, 33.333, 33.333, 33.333, 33.333, 33.333, 33.333, 33.333, 33.333, 33.333, 33.333, 33.333, 33.333);
		$c4_eq = array(100, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25);
		$c2_1_2 = array(100, 33.333, 66.666, 33.333, 66.666, 33.333, 66.666, 33.333, 66.666, 33.333, 66.666, 33.333, 66.666);
		$c2_2_1 = array(100, 66.666, 33.333, 66.666, 33.333, 66.666, 33.333, 66.666, 33.333, 66.666, 33.333, 66.666, 33.333);
		$c3_2_1_1 = array(100, 50, 25, 25, 50, 25, 25, 50, 25, 25, 50, 25, 25);
		$c3_1_1_2 = array(100, 25, 25, 50, 25, 25, 50, 25, 25, 50, 25, 25, 50);
		$c3_1_2_1 = array(100, 25, 50, 25, 25, 50, 25, 25, 50, 25, 25, 50, 25);

		$max_cols = $instance['max_cols'];

		$full_min = $instance['full_min'];
		if ( !$full_min ) $full_min = 768;
		$tab_max = $full_min - 1;
		$tab_min = $instance['tablet_min'];
		if ( !$tab_min || $tab_min > $tab_max )
			$tab_min = 581;
		$phone_max = $tab_min - 1;


		if ( $instance['cols_per_row'] == 'custom') {	// fill in with custom values
			$full[0] = 100; $tablet[0] = 100;	// 0 index
			for ( $i = 1 ; $i <= $max_cols ; $i++ ) {
				$full[$i] = $instance["full{$i}"];
				$tablet[$i] = $instance["tablet{$i}"];
			}
			if ( !$full[1])
				$full = $c2_eq;		// fall back to c2 equal
			$phone_cols = ($instance['phone_cols'] > 1 ) ? 50 : 100;
		} else {
			$preset = $instance['cols_per_row'];
			$full = ${$preset};
			if ($preset == 'c4_eq')
				$tablet = $c2_eq; 		// force 50% for 4 columns on tablets
			else
				$tablet = ${$preset};	// make tablets same for most presets
			$phone_cols = 100;
		}
		if ( !$tablet[1] )
			$tablet = $full;

		// #{$per_widget_ID}{margin:0;padding:0;}

		echo "<style type='text/css'>
#{$per_widget_ID} .wvrx-flex-cols [class*='wvrx-fb-col'] {-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box;}
.ie8 #{$per_widget_ID} .wvrx-flex-cols [class*='wvrx-fb-col'], .ie9 #{$per_widget_ID} .wvrx-flex-cols [class*='wvrx-fb-col'] {width:49% !important;margin-left:.5%!important;margin-right:.5% !important;float:left;}
#{$per_widget_ID} .wvrx-flex-cols {display:-webkit-flex;display:-ms-flexbox;display:flex;overflow:hidden;margin:0;padding:0;
flex-flow:{$instance['flex_direction']} wrap;justify-content:{$instance['justify_content']};
align-items:{$instance['align_items']};-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box;}\n";

	if ($instance['widget_css']) {
		echo "#{$per_widget_ID} .wvrx-flex-cols { {$instance['widget_css']} }\n";
	}
	if ($instance['widget_box_css']) {
		echo "#{$per_widget_ID} .wvrx-flex-cols [class*='wvrx-fb-col']{ {$instance['widget_box_css']} }\n";
	}

	if ($instance['widget_lr_margin']) {
		$spacing = 2 * $instance['widget_lr_margin'];
		echo "#{$per_widget_ID} .wvrx-flex-cols [class*='wvrx-fb-col'] {margin-left:{$instance['widget_lr_margin']}px;margin-right:{$instance['widget_lr_margin']}px;}\n";
	} else {
		$spacing = 0;
	}

	if ($instance['widget_tb_margin'])
		echo "#{$per_widget_ID} .wvrx-flex-cols [class*='wvrx-fb-col'] {margin-top:{$instance['widget_tb_margin']}px;margin-bottom:{$instance['widget_tb_margin']}px;}\n";

	for ( $i = 1 ; $i <= $max_cols ; $i++ ) {
		echo "#{$per_widget_ID} .wvrx-fb-col-{$i} {order:{$i};}";	// allows per box CSS override
	}

	echo "
@media screen and (min-width: {$full_min}px) { /* desktop */
";
		for ( $i = 1 ; $i <= $max_cols ; $i++ ) {
			$w = $full[$i];
			if (! $w ) {
				$w = 100;
			}
			echo "#{$per_widget_ID} .wvrx-fb-col-{$i} {flex-basis: calc({$w}% - {$spacing}px);}";
		}

		echo "\n}
@media screen and (min-width:{$tab_min}px) and (max-width:{$tab_max}px) { /* small tablet */
";
		for ( $i = 1 ; $i <= $max_cols ; $i++ ) {
			$w = $tablet[$i];
			if (! $w ) {
				$w = 50;
			}
			echo "#{$per_widget_ID} .wvrx-flex-cols .wvrx-fb-col-{$i} {flex-basis: calc({$w}% - {$spacing}px);}";
		}
echo "\n}
@media screen and (max-width:{$phone_max}px) { /* phone */
#{$per_widget_ID} .wvrx-flex-cols [class*='wvrx-fb-col'] {flex-basis:{$phone_cols}%;}
}";

// Needs special rules for print
echo "
@media print {
";
		for ( $i = 1 ; $i <= $max_cols ; $i++ ) {
			$w = $full[$i];
			if (! $w ) {
				$w = 100;
			}
			echo "#{$per_widget_ID} .wvrx-fb-col-{$i} {flex-basis:0 !important;min-width:calc({$w}% - {$spacing}px);width:calc({$w}% - {$spacing}px);}";
		}

		echo "\n}";


// OMG - we have to emit special rules for IE11 - yep, really.

echo "
@media screen and (min-width: {$full_min}px) and (-ms-high-contrast: active) and (-ms-high-contrast: none) {
";
		for ( $i = 1 ; $i <= $max_cols ; $i++ ) {
			$w = $full[$i];
			if (! $w ) {
				$w = 100;
			}
			echo "#{$per_widget_ID} .wvrx-fb-col-{$i} {flex-basis:0 !important;min-width:calc({$w}% - {$spacing}px);width:calc({$w}% - {$spacing}px);}";
		}

		echo "\n}
@media screen and (min-width:{$tab_min}px) and (max-width:{$tab_max}px) and (-ms-high-contrast: active) and (-ms-high-contrast: none) {
";
		for ( $i = 1 ; $i <= $max_cols ; $i++ ) {
			$w = $tablet[$i];
			if (! $w ) {
				$w = 50;
			}
			echo "#{$per_widget_ID} .wvrx-flex-cols .wvrx-fb-col-{$i} {flex-basis:0 !important;min-width:calc({$w}% - {$spacing}px);}";
		}
echo "\n}
@media screen and (max-width:{$phone_max}px) and (-ms-high-contrast: active) and (-ms-high-contrast: none) {
#{$per_widget_ID} .wvrx-flex-cols [class*='wvrx-fb-col'] {flex-basis:0 !important;min-width:{$phone_cols}%;}
}";			// +since 3.
echo "
</style>\n";

		echo $before_widget;

		if ( !empty( $title ) ) {
			echo $before_title . $title . $after_title;
		}

		$class = str_replace(array('#', '.'), '' , $instance['widget_class'] );
		$class = str_replace(',', ' ', $class);
		if ( $class != '' )
			$class = ' ' . $class;


		echo "\n" . '<div class="wvrx-flex-cols' . $class . '">' . "\n";
				for ( $i = 1 ; $i <= $instance['max_cols'] ; $i++ ) {
					$area = isset($text[$i]) ? rtrim($text[$i]) : '';
					if ( $area != '' ) {
						$style = '';
						if ($boxcss[$i] != '') {
							$style = ' style="' . $boxcss[$i] . '"';
						}
						echo '<div class="wvrx-fb-col-' . $i. '"' . $style . '>' . $area . "</div>\n";
					}
				}
		echo '</div><div style="clear: both;padding:0; margin:0;"></div>' . "\n";


		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);

		if ( current_user_can('unfiltered_html') ) {
			for ( $i = 1 ; $i <= $instance['max_cols'] ; $i++ ) {
				$instance["text{$i}"] 	=  $new_instance["text{$i}"];
				$instance["boxcss{$i}"] =  $new_instance["boxcss{$i}"];
				$instance["full{$i}"] 	=  $new_instance["full{$i}"];
				$instance["tablet{$i}"] =  $new_instance["tablet{$i}"];
			}
		}
		else {
			for ( $i = 1 ; $i <= $instance['max_cols'] ; $i++ ) {
				$instance["text{$i}"] 	= stripslashes( wp_filter_post_kses( addslashes($new_instance["text{$i}"]) ) ); // wp_filter_post_kses() expects slashed
				$instance["boxcss{$i}"] = stripslashes( wp_filter_post_kses( addslashes($new_instance["boxcss{$i}"]) ) );
				$instance["full{$i}"] 	= stripslashes( wp_filter_post_kses( addslashes($new_instance["full{$i}"]) ) );
				$instance["tablet{$i}"] = stripslashes( wp_filter_post_kses( addslashes($new_instance["tablet{$i}"]) ) );
			}
		}

		$max_cols = $new_instance['max_cols'];
		if ($max_cols < 2 ) $max_cols = 4;
		if ( $max_cols > 12 ) $max_cols = 12;
		$instance['max_cols'] = $max_cols;

		$phone_cols = $new_instance['phone_cols'];
		if ($max_cols < 2 ) $max_cols = 1;
		else $max_phone = 2;
		$instance['phone_cols'] = $phone_cols;

		$instance['cols_per_row'] = $this->instance_default($new_instance['cols_per_row'], '2-eq');

		$instance['justify_content'] = $this->instance_default($new_instance['justify_content'], 'space-around');

		$instance['flex_direction'] = $this->instance_default($new_instance['flex_direction'], 'row');
		$instance['align_items'] = $this->instance_default($new_instance['align_items'], 'stretch');

		$instance['widget_lr_margin'] = $this->instance_default($new_instance['widget_lr_margin'], '');
		$instance['widget_tb_margin'] = $this->instance_default($new_instance['widget_tb_margin'], '');
		$instance['widget_css'] 	  = $this->instance_default($new_instance['widget_css'], '');
		$instance['widget_box_css']   = $this->instance_default($new_instance['widget_box_css'], '');

		$instance['widget_class'] 	  = $new_instance['widget_class'];
		$instance['full_min'] 		  = $this->instance_default($new_instance['full_min'], 768);
		$instance['tablet_min'] 	  = $this->instance_default($new_instance['tablet_min'], 581);

		return $instance;
	}

	function instance_default($new, $default = '') {
		if (!isset($new) || !$new )
			return $default;
		return $new;
	}

	// ******  FORM FORM FORM FORM ******

	function form( $vars ) {
		// every "var" needs to be included here so that the values are in fact defined - at least to default values.
		$vars = wp_parse_args( (array) $vars, array( 'title' => '',
			'text1' => '', 'text2' => '', 'text3' => '', 'text4' => '', 'text5' => '', 'text6' => '',
			'text7' => '', 'text8' => '', 'text9' => '', 'text10' => '', 'text11' => '', 'text12' => '',
			'boxcss1' => '', 'boxcss2' => '', 'boxcss3' => '', 'boxcss4' => '', 'boxcss5' => '', 'boxcss6' => '',
			'boxcss7' => '', 'boxcss8' => '', 'boxcss9' => '', 'boxcss10' => '', 'boxcss11' => '', 'boxcss12' => '',
			'full1' => '', 'full2' => '', 'full3' => '', 'full4' => '', 'full5' => '', 'full6' => '',
			'full7' => '', 'full8' => '', 'full9' => '', 'full10' => '', 'full11' => '', 'full12' => '',
			'tablet1' => '', 'tablet2' => '', 'tablet3' => '', 'tablet4' => '', 'tablet5' => '', 'tablet6' => '',
			'tablet7' => '', 'tablet8' => '', 'tablet9' => '', 'tablet10' => '', 'tablet11' => '', 'tablet12' => '',
			'phone_cols' => '1', 'widget_lr_margin' => '', 'widget_tb_margin' => '', 'widget_css' => '', 'widget_box_css' => '',
			'full_min' => 768, 'tablet_min' => 581, 'widget_class' => '', 'justify_content' => 'space-around',
			'flex_direction' => 'row', 'align_items' => 'stretch',
			'max_cols' => WVRX_DEF_FLEX_COLS, 'cols_per_row' => 2) );


		$title = strip_tags($vars['title']);
		$guide_url = "//guide.weavertheme.com/x-plus-flex-widget-usage-and-customizations/";

?>
		<a href="<?php echo $guide_url; ?>" target="_blank" >
		<?php echo _e('Click for Flex Columns Tutorial', 'weaver-xtreme-plus'); ?></a><br />
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><strong style="color:blue"><?php _e('Title:', 'weaver-xtreme-plus'); ?></strong></label>
		<input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" style="width:85%;" /></p>
<?php
		echo '<h3>' . __('Column Content Text Boxes', 'weaver-xtreme-plus') . '</h3>';
?>
<label for="<?php echo $this->get_field_id('max_cols'); ?>"><strong style="color:blue"><?php echo('Number of Available Text Boxes:'); ?></strong></label>
	<select id="<?php echo $this->get_field_id('max_cols'); ?>" name="<?php echo $this->get_field_name('max_cols'); ?>">
<?php
		for ( $i = 2 ; $i <= 12 ; $i++) {
			$selected = $i == $vars['max_cols'] ? ' selected="selected"' : '';
			echo '<option'. $selected .' value="' . $i .'">'. $i .'</option>';
		}
?>
	</select>&nbsp;
<?php
	echo '<small style="color:red;font-weight:bold;">' . __('Click "Save" to activate','weaver-xtreme-plus') . '</small><br />';
		for ( $i = 1 ; $i <= $vars['max_cols'] ; $i++ ) { ?>
			<strong style="color:blue;"><?php _e('Text Box ', 'weaver-xtreme-plus'); echo $i;?> &nbsp;&nbsp;&nbsp;</strong><?php _e("CSS, no {}'s:", 'weaver-xtreme-plus'); ?></small>
			<textarea  rows="1" cols="33" id="<?php echo $this->get_field_id("boxcss{$i}"); ?>" name="<?php echo $this->get_field_name("boxcss{$i}"); ?>"><?php echo $vars["boxcss{$i}"]; ?></textarea><br />
			<textarea class="widefat" rows="3" cols="60" id="<?php echo $this->get_field_id("text{$i}"); ?>" name="<?php echo $this->get_field_name("text{$i}"); ?>"><?php echo $vars["text{$i}"]; ?></textarea>

<?php	}


	echo '<h3>' . __('Column Layout and Widths', 'weaver-xtreme-plus') . '</h3>';	// --------------------------
?>
<p>
<label for="<?php echo $this->get_field_id('cols_per_row'); ?>"><strong style="color:blue"><?php echo('Columns per row:'); ?></strong></label>
	<select id="<?php echo $this->get_field_id('cols_per_row'); ?>" name="<?php echo $this->get_field_name('cols_per_row'); ?>">
<?php
		$col_opts = array ('c2_eq' => '2 - Equal Width', 'c3_eq' => '3 - Equal Width', 'c4_eq' => '4 - Equal Width',
						   'c2_1_2' => '2 - 33.3%:66.6%', 'c2_2_1' => '2 - 66.6%:33.3%', 'c3_2_1_1' => '3 - 50%:25%:25%', 'c3_1_1_2' => '3 - 25%:25%:50%',
						   'c3_1_2_1' => '3 - 25%:50%:25%', 'custom' => 'Custom' );
		foreach ( $col_opts as $val => $label )  {
			$selected = $vars['cols_per_row'] == $val ? ' selected="selected"' : '';
			echo '<option' . $selected . ' value="' . $val .'">' .  $label . '</option>';
		}
?>
	</select>
	<?php echo '<small style="color:red;font-weight:bold;">' . __('Click "Save" to activate','weaver-xtreme-plus') . '</small>'; ?>

<br />
<?php
		if ($vars['cols_per_row'] != 'custom') {
			echo '<p>' . __('You can select <em>Columns per row : Custom</em> to define your own column layout.', 'weaver-xtreme-plus') .'</p>';
		}
?>
	</p>

<?php
		if ($vars['cols_per_row'] == 'custom') {
			_e('Set width in % for each column. Rows will wrap when total width of consecutive boxes reaches 100%. Set both Desktop and Small Tablet sized for best layouts.', 'weaver-xtreme-plus');
			echo '<br /><br />';
			_e('<strong style="color:blue">Desktop Row Layout</strong>', 'weaver-xtreme-plus'); echo '<br />';
			for ( $i = 1 ; $i <= $vars['max_cols'] ; $i++ ) {
?>
				<label style="white-space: nowrap;" for="<?php echo $this->get_field_id("full{$i}"); ?>">&nbsp;&nbsp;<?php _e('Box ', 'weaver-xtreme-plus'); echo $i; ?>:
				<input id="<?php echo $this->get_field_id("full{$i}"); ?>" name="<?php echo $this->get_field_name("full{$i}"); ?>" type="text"
				value="<?php echo esc_attr($vars["full{$i}"]); ?>" size="5" />%</label>
<?php
			}
			echo '<br />' . __('<strong style="color:blue">Small Tablet Row Layout</strong> <small>(Default: Desktop values):</small>', 'weaver-xtreme-plus');
			 echo '<br />';
			for ( $i = 1 ; $i <= $vars['max_cols'] ; $i++ ) {
?>
				<label style="white-space: nowrap;" for="<?php echo $this->get_field_id("tablet{$i}"); ?>">&nbsp;&nbsp;<?php _e('Col ', 'weaver-xtreme-plus'); echo $i; ?>:
				<input id="<?php echo $this->get_field_id("tablet{$i}"); ?>" name="<?php echo $this->get_field_name("tablet{$i}"); ?>" type="text"
				value="<?php echo esc_attr($vars["tablet{$i}"]); ?>" size="5" />%</label>
<?php
			}

			echo '<br />';
?>
			<label for="<?php echo $this->get_field_id('phone_cols'); ?>"><?php _e('<strong style="color:blue">Phone Row Layout</strong> - Columns (equal width):', 'weaver-xtreme-plus'); ?>
		<select id="<?php echo $this->get_field_id('phone_cols'); ?>" name="<?php echo $this->get_field_name('phone_cols'); ?>">
<?php
			for ( $i = 1 ; $i <= 2 ; $i++) {
				$selected = $i == $vars['phone_cols'] ? ' selected="selected"' : '';
				echo '<option'. $selected .' value="' . $i .'">'. $i .'</option>';
			}
?>
		</select><br /><br />
<?php
		}
	echo '<span  style="color:blue">';_e('Responsive Layout Trigger Widths:'); echo '</span><br />';
	 _e('Min width of Desktop:', 'weaver-xtreme-plus');
?>
		<input id="<?php echo $this->get_field_id('full_min'); ?>" name="<?php echo $this->get_field_name('full_min'); ?>" type="text"
				value="<?php echo esc_attr($vars['full_min']); ?>" size="4" />px &nbsp;
<?php	echo '<span  style="color:blue">'; _e('Min width of Tablet:', 'weaver-xtreme-plus'); echo '</span>';
?>
				<input id="<?php echo $this->get_field_id('tablet_min'); ?>" name="<?php echo $this->get_field_name('tablet_min'); ?>" type="text"
				value="<?php echo esc_attr($vars['tablet_min']); ?>" size="4" />px
<?php
		echo '<h3>' . __('Style Options for this Widget Instance', 'weaver-xtreme-plus') . '</h3>'; // ------------------------------

		echo '<p>' . __('You can use multiple Flex Columns Widgets in the same Widget Area for more control of column layouts.', 'weaver-xtreme-plus') . '</p>';

?>
<label for="<?php echo $this->get_field_id('justify_content'); ?>"><strong style="color:blue"><?php echo('Flex Justify Content:'); ?></strong></label>
	<select id="<?php echo $this->get_field_id('justify_content'); ?>" name="<?php echo $this->get_field_name('justify_content'); ?>">
<?php
		$just_opts = array ('space-around' => 'Space Around [&middot;&square;&middot;&square;&middot;&square;&middot;]', 'space-between' => 'Space Between [&square;&middot;&square;&middot;&square;]', 'center' => 'Center [&middot;&middot;&square;&square;&square;&middot;&middot;]',
						   'flex-start' => 'Flex Start [&square;&square;&square;&middot;&middot;]', 'flex-end' => 'Flex End [&middot;&middot;&square;&square;&square;]' );
		foreach ( $just_opts as $val => $label )  {
			$selected = $vars['justify_content'] == $val ? ' selected="selected"' : '';
			echo '<option' . $selected . ' value="' . $val .'">' .  $label . '</option>';
		}
?>
	</select> - <?php _e('Automatic', 'weaver-xtreme-plus'); ?> <br /><div style="margin-left: 1.5em;">
<?php
		_e(' horizontal spacing when columns in a row total less than 100% - (e.g., 32%,32%,32%). An alternative to using the Left/Right Spacing option.','weaver-xtreme-plus'); echo '</div>';
?>
<label for="<?php echo $this->get_field_id('flex_direction'); ?>"><strong style="color:blue"><?php echo('Flex Direction:'); ?></strong></label>
	<select id="<?php echo $this->get_field_id('flex_direction'); ?>" name="<?php echo $this->get_field_name('flex_direction'); ?>">
<?php
		$dir_opts = array ('row' => 'In Rows', 'row-reverse' => 'Row Reverse', 'column' => 'In Columns',
						   'column-reverse' => 'Column Reverse' );
		foreach ( $dir_opts as $val => $label )  {
			$selected = $vars['flex_direction'] == $val ? ' selected="selected"' : '';
			echo '<option' . $selected . ' value="' . $val .'">' .  $label . '</option>';
		}
?>
	</select> -
	<?php _e('<em>In Rows</em> most typical', 'weaver-xtreme-plus'); ?>

	<br /><label for="<?php echo $this->get_field_id('align_items'); ?>"><strong style="color:blue"><?php echo('Flex Align Items:'); ?></strong></label>
	<select id="<?php echo $this->get_field_id('align_items'); ?>" name="<?php echo $this->get_field_name('align_items'); ?>">
<?php
		$items_opts = array ('stretch' => 'Stretch', 'flex-start' => 'Flex Start', 'flex-end' => 'Flex End',
						   'center' => 'Center', 'baseline' => 'Baseline' );
		foreach ( $items_opts as $val => $label )  {
			$selected = $vars['align_items'] == $val ? ' selected="selected"' : '';
			echo '<option' . $selected . ' value="' . $val .'">' .  $label . '</option>';
		}
?>
	</select> -
<?php _e('<em>Stretch</em> makes equal height rows', 'weaver-xtreme-plus'); ?>

<br /><br />
<?php

		echo '<strong  style="color:blue">'; _e('Spacing between text content areas', 'weaver-xtreme-plus'); echo '</strong><br />';
?>
		<label for="<?php echo $this->get_field_id('widget_lr_margin'); ?>"><?php _e('Left/Right', 'weaver-xtreme-plus');?>:</label>
				<input id="<?php echo $this->get_field_id("widget_lr_margin"); ?>" name="<?php echo $this->get_field_name('widget_lr_margin'); ?>" type="text"
				value="<?php echo esc_attr($vars['widget_lr_margin']); ?>" size="3" />px &nbsp;&nbsp;&nbsp;
		<label for="<?php echo $this->get_field_id("widget_tb_margin"); ?>"><?php _e('Top/Bottom', 'weaver-xtreme-plus');?>:</label>
				<input id="<?php echo $this->get_field_id("widget_tb_margin"); ?>" name="<?php echo $this->get_field_name("widget_tb_margin"); ?>" type="text"
				value="<?php echo esc_attr($vars['widget_tb_margin']); ?>" size="3" />px <br /><br />

			<?php echo '<strong  style="color:blue">'; _e("Custom CSS for this Widget (No {}'s)", 'weaver-xtreme-plus');  echo '</strong>'; ?>
			<br />
			<textarea class="widefat" rows="1" cols="60" id="<?php echo $this->get_field_id('widget_css'); ?>" name="<?php echo $this->get_field_name('widget_css'); ?>"><?php echo $vars['widget_css']; ?></textarea>
			<br /><br /><strong  style="color:blue">
			<?php _e('Add classes to this Widget <small>(No "#" or "." - separate by space)</small>: ', 'weaver-xtreme-plus'); ?></strong>
			<input id="<?php echo $this->get_field_id('widget_class'); ?>" name="<?php echo $this->get_field_name('widget_class'); ?>" type="text"
				value="<?php echo esc_attr($vars['widget_class']); ?>" style="width:100%;" />


<?php 		echo '<h3>' . __('Style Options for Text Boxes', 'weaver-xtreme-plus') . '</h3>';	// ----------------------------

			echo '<strong style="color:blue">'; _e("Custom CSS for all Text Boxes (No {}'s)", 'weaver-xtreme-plus'); ?></strong>
			<br />
			<textarea class="widefat" rows="1" cols="60" id="<?php echo $this->get_field_id('widget_box_css'); ?>" name="<?php echo $this->get_field_name('widget_box_css'); ?>"><?php echo $vars['widget_box_css']; ?></textarea>
			<br />
<?php
echo '<p><strong style="color:red;">' . __('You MUST click "Save" to see the results of settings!','weaver-xtreme-plus') . '</strong></p>';
	}
}


add_filter('weaverxp_text', 'do_shortcode');

//----------------------------------------------------------------------------------------------------

/* -------------- widget_area --------------- */
function weaverxplus_widget_area_shortcode($args = '') {
	/* implement [widget_area id='name'] shortcode */

	extract(shortcode_atts(array(
		'area' => '#',
		'class' => '',
        'area_style' => 'widget',
		'style' => ''
	), $args));

    // widget-area widget-area-footer l-widget-area-footer m-widget-area-footer s-widget-area-footerwidget-cols-3 widget-smart-rm border s-font-size font-consolas
    //real footer: widget-area widget-cols-3 widget-smart-rm border s-font-size font-consolas

	unset( $GLOBALS['wvr_widget_number']);     // clear for each widget
	$GLOBALS['wvr_widget_number'] = false;

    $styles = array('top', 'bottom', 'primary', 'secondary', 'header', 'footer');

    $class = trim("widget-area widget-area-{$area_style} l-widget-area-{$area_style} m-widget-area-{$area_style} s-widget-area-{$area_style} " . trim($class) . ' ');

    if ( $style )
        $style = ' style=' . bracket($style, '"', '"');

    if (in_array( $area_style, $styles ) ) {
        $thestyle = $area_style;
        if ( in_array($area_style,array('footer','header') ) )
            $thestyle = $thestyle . '_sb';
        $class .= ' ' . weaverx_area_class( $thestyle, 'pad' );
        $class = trim( $class );
    } else {
        $area_style = 'widget';
    }

	$area = 'per-page-' . $area;  // retrieve meta value
	$bad = '<h3>[widget_area] - Area ' . $area . ' not defined.</h3>';
	$id_tag = 'extra-widget-x' . weaverx_generate_id();


	$content = "<div id=\"{$id_tag}\" class=\"{$class}\" {$style}>\n";

	if (strlen($area) > 0) {              // want to display some areas
		if ( !is_active_sidebar($area)) return $bad;
        weaverx_t_set('use_widget_area', $area_style );

		ob_start();
		$success = dynamic_sidebar($area);
		$content .= ob_get_clean();
		if ($success && $content) {
			$content .= "\n<div style='clear:both;'></div></div>\n";	// fixed 3.1 - add clear
		} else {
			$content = $bad;
		}
	}

	return $content;
}

function bracket($txt,$head,$tail){
    $lead = strpos($txt, $head);
    if ($lead === false || $lead != 0)
        $txt = $head . $txt;
    $end = strrchr($txt, $tail);
    if ($end === false || strlen($end) > 1)
        $txt = $txt . $tail;
    return $txt;
}

add_shortcode('widget_area', 'weaverxplus_widget_area_shortcode');

// ------------------------------ weaverx_showhide ------------------------------------------

function weaverxplus_has_img($img) {
	if (stristr($img,'.png') || stristr($img,'.gif') || stristr($img,'.jpg'))
		return true;
	else
		return false;
}

function weaverxplus_showhide_shortcode($args = '', $text) {

	extract(shortcode_atts(array(
	   'start' => 'hide',      // 'hide' or 'show'
	   'show' => '',
	   'hide' => '',
	   'class' => ''
	), $args));

	$rand = "sh_".rand();
	$url = weaverx_relative_url('assets/images/theme/');

	$is_img = 'img';

	$text = do_shortcode($text);    // allow nested shortcodes

	if ($show == '') {
		$show = $url . 'show.png';
		$show_img = '<img src="' . $show . '" alt="show" />';
	} else if (weaverxplus_has_img($show)) {
		$show_img = '<img src="' . $show . '" alt="show" />';
	} else {
		$is_img = 'text';
		$show_img = '<span class="weaverx_showhide_show">' . $show . '</span>';   // text only
	}

	if ($hide == '') {
		$hide = $url . 'hide.png';
		$hide_img = '<img src="' . $hide . '" alt="hide" />';
	} else if (weaverxplus_has_img($hide)) {
		$hide_img = '<img src="' . $hide . '" alt="hide" />';
	} else {
		$is_img = 'text';
		$hide_img = '<span class="weaverx_showhide_hide">' . $hide . '</span>';   // text only
	}

	if ($start == 'hide') {
		$style = 'style="display:none;"';
	} else {
		$style = 'style="display:block;"';
		$show_img = $hide_img;
	}

	if ($class != '') {
		if ($class[0] == '.') $class = substr($class,1);
		$class = 'class="' . $class . '"';
	}

	$out = "<a style='text-decoration:none;' href=\"javascript:void(null);\" onclick=\"weaverx_ToggleDIV(document.getElementById('" .
		$rand . "'), this, '" . $show . "', '" . $hide . "', '" . $is_img . "')\">";

	$lead = stripos($text,'</p>');

	if ($lead !== false && $lead == 0) { // have </p> to start, so can break
		$out .= $show_img . '</a></p>';
		$text = substr($text,4);        // strip the </p>
		$out .= '<div id="'. $rand . '"' . $style .  ' ' . $class . '>';
		$out .= $text;
		$out .= "</p></div><p>";
	} else {                            // no paragraph - so make inline
		$out .= $show_img . '</a>';
		$has_p = stripos($text,'</p>');
		if ($has_p > 0) {
			$out .= '</p>'; // after the </a> to make span work
		}
		$out .= '<span id="'. $rand . '" ' . $style . ' ' . $class . '>';
		if ($has_p > 0) {
			$out .= '<p>'; // to make span work
			$lead_br = stripos($text,'<br />');
			if ($lead_br !== false && $lead_br == 0)
				$text = substr($text,6);
		}
		$out .= $text;

		if ($has_p !== false) {
			if ($has_p > 0)
				$out .= "</p></span><p>";
			else
				$out .= "</p></span>";
		} else {
			$out .= "</span>";
		}
	}

	return $out;
}

add_shortcode('showhide', 'weaverxplus_showhide_shortcode');



// ------------------------------ parallax ---------------------------------------

function weaverxplus_parallax_shortcode( $args = '', $text )
{
	extract(shortcode_atts(array(
		'img' => '',
		'height' => '400',
		'class' => ''
	), $args));

	if (strlen($img) < 1)
		return '<strong>' . __('Parallax Shortcode requires image link','weaver-xtreme-plus') . '<strong>';

	$content = do_shortcode($text);

	$url = str_replace('http://', '//', $img);

	return "\n<!-- Parallax Image -->
<section class='parallax-base wvrx-fullwidth {$class}' style='background-image:url({$url}); height:{$height}px;'>
<div class='parallax-content'>\n
{$content}
</div></section>\n";

}

add_shortcode('parallax', 'weaverxplus_parallax_shortcode');


// ------------------------------ php ---------------------------------------

function weaverxplus_php_do_eval($code) {
	$char_codes = array( '&#8216;', '&#8217;', '&#8220;', '&#8221;', '&#8242;', '&#8243;', '&#8211;', '&#8212;', '&#8230;', '&#215;' );
	$replacements = array( "'", "'", '"', '"', "'", '"', '--', '---', '...', 'x' );
	$php = str_replace( $char_codes, $replacements, $code );    // untexturize

	$php  .= ';';

	$err_level = error_reporting(0);
	$out = '';
	ob_start();

	if(version_compare(PHP_VERSION, '5.0.0', '>')) {
	   try { eval($php); } catch(Exception $e) {}
	} else {
		eval($php);
	}

	$out .= ob_get_clean();
	error_reporting($err_level);
	return $out;
}

function weaverxplus_php_shortcode($args = '', $code) {
    if ( !weaverxplus_getopt('wvrxp_enable_p') )
        return '<strong>You first must enable [ php ] on the Xtreme Plus PHP admin tab.</strong>';

	return weaverxplus_php_do_eval($code);
}

add_shortcode('php', 'weaverxplus_php_shortcode');


/* -------------- popup_link --------------- */
function weaverxplus_popup_link_shortcode($args = '', $link) {
	/* implement [popup_link opt1="val1" opt2="value"]link-html[/popup_link] shortcode */

	extract(shortcode_atts(array(
		'href' => '#',
		'w' => '100',
		'h' => '100',
		'scrollbars' => false
	), $args));

	$link = do_shortcode($link);

	$sb = $scrollbars ? 'scrollbars=1,' : 'scrollbars=no,';

	$content = '<a href="' . $href . '" onClick="window.open(this.href,' .
	"'_blank','toolbar=no,location=no,directories=no,status=no,{$sb}resizable=no, menubar=no, width=$w,height=$h');return(false)\">$link</a>";
	return $content;
}

add_shortcode('popup_link', 'weaverxplus_popup_link_shortcode');


/* -------------- search --------------- */

function weaverxplus_search_shortcode($args = '') {
	extract(shortcode_atts(array(
        'button' => '',
        'class' => '',
        'max_width' => '90',
        'size' => '40'
	), $args));

    $out =
'<div class="' . trim("weaverx-plus-search {$class}") . '"><form style="display:inline;" role="search" method="get" class="search-form" action="' . esc_url( home_url( '/' ) ) . '">
	<label><span class="screen-reader-text">' . _x( 'Search for:', 'label' ) . '</span>
		<input style="max-width:' . $max_width . '%;" type="search" size=' . $size . ' class="search-field" placeholder="' . esc_attr_x( 'Search &hellip;', 'placeholder' ) . '" value="' . get_search_query() . '" name="s" title="' . esc_attr_x( 'Search for:', 'label' ) . '" />
	</label>';
    if ( $button )
        $out .= '<input type="submit" class="search-submit-plus" value="'. esc_attr_x( 'Search', 'submit button' ) .  '" />';

    $out .= '</form></div>';

	return $out;
}

weaverxplus_add_shortcode('search', 'weaverxplus_search_shortcode');




/* -------------- weaverxplus_feed --------------- */
function weaverxplus_feed_shortcode($args = '') {
	/* implement [weaver_feed feed='ur'] shortcode */

	extract(shortcode_atts(array(
		'feed' => '#',
		'show_sitename' => 1,
		'show_content' => 1,
		'feed_content' => false,
		'excerpt' => false,
		'target' => '_self',
		'trusted' => false,
		'title_style' => '',
        'more_msg' => ' Click Article Title for full article at original site.',
		'items' => 10
	), $args));

	$err_msg = '[weaver_feed] invalid values provided.';

	$show_sitename = weaverxplus_tf($show_sitename);
	$show_content = weaverxplus_tf($show_content);
	$excerpt = weaverxplus_tf($excerpt);
	$feed_content = weaverxplus_tf($feed_content);

    weaverx_t_clear_all();
	weaverx_t_set('more_msg',$more_msg);

	if ($title_style != '') {
		$title_style = 'style=' . weaverxplus_bracket($title_style, '"', '"');
	}

	$ent_title = '<header class="entry-header"><div class="entry-hdr"><h2 class="entry-title" ' . $title_style .'>';

	while ( stristr($feed, 'http') != $feed )   // strip anything before http
		$feed = substr($feed, 1);

	if ( empty($feed) )
		return $err_msg;

	// self-url destruction sequence
	if ( $feed == site_url() || $feed == home_url() )
		return '[weaver_feed] - feed must not be own site.';

	$rss = fetch_feed($feed);
	$sitedesc = '';
	$sitelink = '';

	if ( ! is_wp_error($rss) ) {
		$sitedesc = esc_attr(strip_tags(@html_entity_decode($rss->get_description(), ENT_QUOTES, get_option('blog_charset'))));
		$sitetitle = esc_html(strip_tags($rss->get_title()));
		$sitelink = esc_url(strip_tags($rss->get_permalink()));
		while ( stristr($sitelink, 'http') != $sitelink )
			$sitelink = substr($sitelink, 1);
	} else {
		if ( is_admin() || current_user_can('edit_theme_options') )
			$err_msg = '<p>' . sprintf( __('<strong>RSS Error</strong>: %s','weaver-xtreme-plus'), $rss->get_error_message() ) . '</p>';
		return $err_msg;
	}

	if ( empty($sitetitle) )
		$sitetitle = empty($sitedesc) ? __('Unknown Feed','weaver-xtreme-plus') : $sitedesc;

	$feed = esc_url(strip_tags($feed));

	if ( $sitetitle ) {
		$sitetitle = '<h2 class="entry-title feed-title">'
		. '<a href="' . $feed . '" title="' . esc_attr(__( 'Syndicate this content', 'weaver-xtreme-plus' )) . '" target="_blank"><span class="genericon genericon-feed"></span></a>&nbsp;&nbsp;'
		. "<a href='$sitelink' title='$sitedesc' target='_blank'>$sitetitle</a></h2>";
	}

	$out = "<div class='weaver-feed'>\n";
	if ($show_sitename) {
		$out .= $sitetitle . "\n";     // add a title for whole feed
	}

	$items = (int) $items;
	if ( $items < 1 || 20 < $items )
			$items = 10;

	if ( !$rss->get_item_quantity() ) {
		$out .= '<p>' . __( 'An error has occurred; the feed is probably down. Try again later.','weaver-xtreme-plus') . '</p></div>';
		$rss->__destruct();
		unset($rss);
		return $out;
	}
	$rss_items = $rss->get_items(0, $items);

	// +++++++++++ feed article loop ++++++++++++

	foreach ( $rss_items as $item ) {
		$out .= '<article class="post type-post hentry category-uncategorized post-feed">' . "\n";

		$link = $item->get_link();
		while ( stristr($link, 'http') != $link )
			$link = substr($link, 1);
		$link = esc_url(strip_tags($link));
		$title = esc_attr(strip_tags($item->get_title()));
		if ( empty($title) )
			$title = __('Untitled','weaver-xtreme-plus');

		if (! $feed_content)
			$desc = @html_entity_decode( $item->get_description(), ENT_QUOTES, get_option('blog_charset') );
		else
			$desc = @html_entity_decode( $item->get_content(), ENT_QUOTES, get_option('blog_charset') );

		if (!$trusted) {
			$desc = str_replace( array("\n", "\r"), ' ', esc_attr( strip_tags( $desc ) ) );
		}

		if ($excerpt) {
			$desc = wp_html_excerpt( $desc, 300 );

			// Append ellipsis. Change existing [...] to [&hellip;].
			if ( '[...]' == substr( $desc, -5 ) )
				$desc = substr( $desc, 0, -5 ) . '[&hellip;]';
			elseif ( '[&hellip;]' != substr( $desc, -10 ) )
				$desc .= ' [&hellip;]';
            $desc .= ' ' . $more_msg;
		}

		if (!$trusted)
			$desc = esc_html( $desc );

        $desc = str_replace('Continue reading', $more_msg, $desc);

		$date = '';
		$date = $item->get_date( 'U' );
		if ( $date ) {
			$date = date_i18n( get_option( 'date_format' ), $date );
		}

		$author = $item->get_author();
		if ( is_object($author) ) {
			$author = $author->get_name();
			$author = esc_html( strip_tags( $author ) );
		} else {
			$author = '';
		}

		if ( $link == '' ) $link = '#';

		$out .= $ent_title . '<a href="' . $link . '" title="Permalink to ' . $title . '" target="' . $target . '">' . $title . "</a></h2></div>\n";

		// now match logic for posted_on
		$out .= weaverxplus_posted_on_code($date, $author) . "</header> <!-- entry-header -->\n";

		if ($show_content) {
			$out .= "<div class='entry-content'>\n" . $desc . "\n</div> <!-- entry-content -->\n";
		}

		$out .= "</article> <!-- post-feed -->\n";
	}
	$out .= "</div> <!-- weaver-feed -->\n";
	$rss->__destruct();
	unset($rss);
    weaverx_t_clear_all();
	return $out;
}

function weaverxplus_bracket($txt,$head,$tail){
    $lead = strpos($txt, $head);
    if ($lead === false || $lead != 0)
        $txt = $head . $txt;
    $end = strrchr($txt, $tail);
    if ($end === false || strlen($end) > 1)
        $txt = $txt . $tail;
    return $txt;
}

function weaverxplus_posted_on_code($date, $author) {

		$leftm = '8';

		$on = "\t<div class=\"entry-meta\" style=\"margin-botom:-5px;margin-top:-10px;\"><div " . weaverx_meta_info_class( 'post_info_top' ) . ">\n\t\t";

		$on .= '<span class="sep">Posted on </span><time class="entry-date" >' . $date .
			'<span class="by-author"> <span class="sep"> by </span> <span class="author vcard">' . $author . '</span></span>';
		$on .= "\n    </div></div><!-- .entry-meta -->\n";
		return $on;
}

function weaverxplus_tf($val) {
	if ($val === false) return false;
	if ($val == 'false') return false;
	if ($val == 'no') return false;
	if ($val === 0 || $val == '0') return false;
	return true;
}

weaverxplus_add_shortcode('feed', 'weaverxplus_feed_shortcode');




function weaverxplus_show_disclaimer() {
		$text = weaverxplus_getopt('disclaimer');
		if (!empty($text)) {
				echo('<div class="weaver-comment-disclaimer">'. do_shortcode($text) .'</div>');
		}
}
add_action('comment_form', 'weaverxplus_show_disclaimer', 99);


function weaverxplus_has_linkbuttons() {return true;}

define('WEAVERXPLUS_NUM_BUTTONS',8);

class weaverxplus_Widget_Buttons extends WP_Widget {

	function __construct() {
	   $widget_ops = array( 'classname'=>'weaverxplus_buttons',
		  'description' => __('Display Link Buttons as set in Weaver Xtreme Plus Link Buttons Shortcode Settings.','weaver-xtreme-plus'));
	   parent::__construct( 'weaverxplus_buttons', __('Wvr X-Plus Link Buttons','weaver-xtreme-plus'), $widget_ops );
	}

   function widget($args, $instance) {
   // Get menu

	$instance['title'] = apply_filters('widget_title', $instance['title'], $instance, $this->id_base);
	$start = $instance['start'];
	$end = $instance['end'];
	$list = $instance['list'];

	echo $args['before_widget'];

	if ( !empty($instance['title']) )
	   echo $args['before_title'] . $instance['title'] . $args['after_title'];

	echo weaverxplus_buttons_generate_code($start,$end,$list);

	echo $args['after_widget'];
   }

   function update( $new_instance, $old_instance ) {
		$instance['title'] = strip_tags( stripslashes($new_instance['title']) );
		$instance['start'] = (int) $new_instance['start'];
		if ($instance['start'] < 1 ||  $instance['start'] > 64) $instance['start'] = 1;
		$instance['end'] = (int) $new_instance['end'];
		if ($instance['end'] < 1 ||  $instance['end'] > 64) $instance['start'] = 64;
		$instance['list'] = trim($new_instance['list']);

		return $instance;
   }

function form( $instance ) {
	$title = isset( $instance['title'] ) ? $instance['title'] : '';
	$start = isset($instance['start']) ? absint($instance['start']) : 1;
	$end = isset($instance['end']) ? absint($instance['end']) : 64;
	$list = isset( $instance['list'] ) ? $instance['list'] : '';

?>
			  <p>
			  <label for="<?php echo $this->get_field_id('title'); ?>"><?php echo('Title:' /*a*/ ) ?></label>
			  <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php weaverx_plus_esc_textarea($title); ?>" />
			  </p>
			  <p><label for="<?php echo $this->get_field_id('start'); ?>">Start number:</label>
			  <input id="<?php echo $this->get_field_id('start'); ?>" name="<?php echo $this->get_field_name('start'); ?>" type="text" value="<?php weaverx_plus_esc_textarea($start); ?>" size="3" />
			  </p>
			  <p><label for="<?php echo $this->get_field_id('end'); ?>">End number:</label>
			  <input id="<?php echo $this->get_field_id('end'); ?>" name="<?php echo $this->get_field_name('end'); ?>" type="text" value="<?php weaverx_plus_esc_textarea($end); ?>" size="3" />
			  </p>
			  <p style="text-align:center;"><em>- or -</em></p>
			  <p><label for="<?php echo $this->get_field_id('list'); ?>">Comma separated list of numbers:</label>
			  <input id="<?php echo $this->get_field_id('list'); ?>" name="<?php echo $this->get_field_name('list'); ?>" type="text" value="<?php weaverx_plus_esc_textarea($list); ?>" size="24" />
			  </p>

			  <p><em>Select Buttons to display from the Weaver Xtreme Plus Shortcodes menu. You can style with '.weaver-buttons'.</em>
			  </p>
<?php
   }
}


function weaverxplus_buttons_shortcode($args = '') {
   // [weaver_extra_menu menu='custom-menu-name' style='style-name']
	extract(shortcode_atts(array(
	   'start' => '1',   // range or list of values
	   'end' => '',
	   'list' => '',
	   'wrap' => 'div'
	), $args));

	if ($end == '') {
	   if (weaverxplus_isset('buttons')) {
		  $buttons = weaverxplus_getopt('buttons');
		  if (isset($buttons['maxbuttons']))
			 $end = $buttons['maxbuttons'];
		  else
			 $end = weaverxplus_WEAVERXPLUS_NUM_BUTTONS;
	   }
	}
	$out = weaverxplus_buttons_generate_code($start,$end,$list,$wrap);
	return $out;
}

function weaverxplus_buttons_generate_code($start=1, $end=64,$list='', $wrap = 'div') {

	if (!weaverxplus_isset('buttons')) return 'No buttons defined.';
	$buttons = weaverxplus_getopt('buttons');
	$maxbuttons = $buttons['maxbuttons'];
	//echo '<pre>'; print_r($buttons); echo '</pre>';

	$out = '';

	if ($start < 1) $start = 1;                  // stay sane
	if ($end > $maxbuttons) $end = $maxbuttons;
	$out .= '<' . $wrap . ' class="weaver-buttons">';
	if ($list != '') {   // list specified - it has priority
	   $list_vals = explode(',',trim($list));
	   foreach ($list_vals as $item) {
		  $out .= weaverxplus_buttons_button($buttons,trim($item));
	   }
	} else {     // start:end
		 for ($i = $start ; $i <= $end ; $i++) {
			 $out .= weaverxplus_buttons_button($buttons,$i);
		 } // end for
	}

	$out .= "</{$wrap}>\n";

	return $out;
}



function weaverxplus_buttons_button($buttons,$i) {
   // code for one button
	$out = '';
	$btn_class = 'wvr-btn-' . $i;
	$i--;                // users start at 1, we start at 0
	$id = 'b'.$i;
	if ( !isset($buttons[$id.'_img_url']))
		return '';
	$img_url = $buttons[$id.'_img_url'];

	if ($img_url == '')
	   return $out;

	$title = $buttons[$id.'_hover'];
	$url = $buttons[$id.'_link_url'];
	if ($buttons[$id.'_blank']) $blank = ' target="_blank"';
	else $blank = '';


   if ($url != '')
	  $out .= '<a href="' . $url . '" title="' . $title . '"' . $blank . '>';

   $out .= '<img class="' . $btn_class . '" src="' . $img_url . '" title="'. $title . '" alt="' . $title .
	'" style="border:0;padding-right:3px;padding-bottom:3px;z-index:20;" />';

	// $out .= '<img class="btn-' . $i+1 . '" src="' . $img_url . '" title="'. $title . '" alt="' . $title .
	// '" style="border:0;padding-right:3px;padding-bottom:3px;z-index:20;" />';

   if ($url != '')
	  $out .= '</a>';
   $out .= "\n";
   return $out;
}

/* ============================ weaverxplus_buttons =============================== */
weaverxplus_add_shortcode('buttons','weaverxplus_buttons_shortcode');

add_action('widgets_init', "weaverxplus_load_widgets");
function weaverxplus_load_widgets() {
	register_widget("weaverxplus_Widget_Buttons");
	register_widget('WeaverX_Widget_Columns');
}

//=========================== weaver II Pro compatibility ===========================

weaverxplus_add_shortcode('weaver_extra_menu','weaverxplus_extra_menu_shortcode');
weaverxplus_add_shortcode('weaver_buttons','weaverxplus_buttons_shortcode');
weaverxplus_add_shortcode('weaver_sc', 'weaverxplus_sc_shortcode');
weaverxplus_add_shortcode('weaver_social','weaverxplus_social_shortcode');
weaverxplus_add_shortcode('weaver_feed', 'weaverxplus_feed_shortcode');
weaverxplus_add_shortcode('weaver_php', 'weaverxplus_php_shortcode');
weaverxplus_add_shortcode('weaver_popup_link', 'weaverxplus_popup_link_shortcode');
weaverxplus_add_shortcode('weaver_search', 'weaverxplus_search_shortcode');
weaverxplus_add_shortcode('weaver_showhide', 'weaverxplus_showhide_shortcode');
weaverxplus_add_shortcode('aspen_showhide', 'weaverxplus_showhide_shortcode');
weaverxplus_add_shortcode('weaver_widget_area', 'weaverxplus_widget_area_shortcode');

// === incompatible shortcodes...
function weaverxplus_gadget_shortcode($args) {
	return '<strong>&#91;weaver_gadget] Weaver II Pro shortcode not supported by Weaver Xtreme Plus.</strong>';
}
function weaverxplus_slider_shortcode($args) {
	return '<strong>&#91;weaver_slider] Weaver II Pro shortcode not supported by Weaver Xtreme Plus.</strong>';
}
weaverxplus_add_shortcode('weaver_gadget','weaverxplus_gadget_shortcode');
weaverxplus_add_shortcode('weaver_slider','weaverxplus_slider_shortcode');
?>
