<?php
// ================================ Licensing Actions ============================
/*
 *  All the function name and constants used in this code MUST have unique slugs - e.g. weaverxplus_ or weaver_ii or whatever
 *
 */


// License processing is handled by actions - either added to a theme such as Aspen or Weaver II, or in the admin pages of a plugin
// Name the action// whatever you need - e.g. weaverx_ or weaver_ii_

//add_action('weaverx_show_licenses','weaverxplus_show_licenses');   // show the options to enter and activate a license
add_action('weaverx_check_licenses','weaverxplus_check_licenses'); // see if the license exists and is activated
add_action('weaverxplus_check_license_options','weaverxplus_process_license_options');   // process the options from the show_licenses code. Needs nonces or whatever,

function weaverxplus_show_licenses() {
	$license    = get_option( WEAVER_XPLUS_KEY );         // keep our licenses in separate WP db entries - a litte against the norms, but having them separate is best
	$status     = get_option( WEAVER_XPLUS_KEY_STATUS );

/* FORM DESIGN
 *  Weaver Xtreme Plus License Key: [                      ] Update Key
 *
 *  License Status: active [deactivate] | inactive [Activate]  | Invalid - please enter new key
 *
 *  [Check License Status] - Confirm that license is valid on the server.
 *
 */
?>

<div class="a-plus">
<p><strong style="font-size:120%;">Weaver Xtreme Plus Activation</strong>
<?php
	if (!is_multisite() || (is_multisite() && current_user_can('manage_network_themes')) ) {
?>
<form name="save_license_form" method="post">
<p>
<label class="description" for="ap_license_key"><?php _e('Current Weaver Xtreme Plus license key: '); ?></label>

<input id="ap_license_key" name="ap_license_key" type="text" class="regular-text" value="<?php esc_attr_e( $license ); ?>" />
<input class="button-secondary" type="submit" name="update_ap_license" value="Update License Key"/>
<?php weaverx_nonce_field('update_ap_license'); ?>

<?php

	switch ($status) {
		case 'active':          // -------------- License is active
		case 'valid':
?>
<p>
<label class="description" for="ap_license_deactivate"><?php _e('License Status: <em>Activated</em> &nbsp;&nbsp;&nbsp;'); ?></label>


<input type="submit" class="button-secondary" name="ap_license_deactivate" value="Deactivate License on this site"/>
<?php    weaverx_nonce_field('ap_license_deactivate'); ?>
<br />
<input style="margin-left:190px;margin-top:10px;" type="submit" class="button-secondary" name="ap_license_verify" value="Verify License for this site"/>
<?php    weaverx_nonce_field('ap_license_verify'); ?>
</p>
<?php
			break;

		case 'deactivated':     // --------------- License is inactive
?>
<p>
<label class="description" for="ap_license_activate"><?php _e('License Status: <em>Deactivated</em> &nbsp;&nbsp;&nbsp;'); ?></label>
<input type="submit" class="button-secondary" name="ap_license_activate" value="Activate License on this site"/>
<?php    weaverx_nonce_field('ap_license_activate'); ?>
<br />
<input style="margin-left:190px;margin-top:10px;" type="submit" class="button-secondary" name="ap_license_verify" value="Verify License for this site"/>
<?php    weaverx_nonce_field('ap_license_verify'); ?>
</p>
<?php
			break;

		default:                // ----------------- license invalid or blank
			if ( '' == $license ) {
?><br />
Please enter your <em>Weaver Xtreme Plus Plugin</em> license key. Your key was provided when you purcahsed the plugin. You can view
your purchase history at <a href="//shop.weavertheme.com/your-account/purchase-history/" target="_blank">Shop.WeaverTheme.com</a><br /><br />
<?php
				break;
			}
			if ( weaverxplus_activate_license($license ) ) {
				echo "<p><strong>Your license has automatically been activated or reactivated.";

			} else {
?>
<p>
License Status: <em style="color:red;font-weight:bold;">Invalid / Not Activated</em> - The current License Key is not valid or is not activated.
<br />
You may have manually deactivated this site from your shop license management account - click the "Update License Key" button to try to activate, or you may reactivate this site on the shop account.</em>.
<br />Your Key may have expired, or may be entered incorrectly. License server may be temporarily unavailable. <strong>Note:</strong> This plugin will continue to function, but you will not get automatic updates until it has been activated.
<?php
			}
?>
</p>
<br />
<input type="submit" class="button-secondary" name="ap_license_status" value="Retrieve License Status Code"/><br /><br />
<?php
	weaverx_nonce_field('ap_license_status');
?>
<br />
<input type="submit" class="button-secondary" name="ap_license_clear_all" value="Clear All License Settings"/>
If your site and the license server get "out of sync", this option shoud allow you to start the registration over.<br /><br />
<?php
	weaverx_nonce_field('ap_license_clear_all');
	} // end of switch
?>
</form>
<?php
	} else {
		echo "<p>You do not have a role that allows you to set the Plugin License</p>\n";
	}
?>
</div>
<br />
<?php
}

function weaverxplus_check_licenses() {
	if ( defined( 'WEAVERX_PLUS_TEST_MODE' ) )
		return;
	if (!is_multisite() || (is_multisite() && current_user_can('manage_network_themes')) ) {
		if (get_option( WEAVER_XPLUS_KEY_STATUS ) != 'active')
			echo '<div style="display:inline-block;background-color:#F88;border:1px solid black;padding:2px;margin-right:4px;font-weight:bold;font-style:italic;">Please Activate Weaver Xtreme Plus from<br >the Xtreme Plus Activate License Key Tab.</div>';
	}
}


function weaverxplus_process_license_options() {


	if (weaverxplus_submitted('update_ap_license')) {     // update license key...
		if (isset($_POST['ap_license_key'])) {

			$new = trim($_POST['ap_license_key']);

			$old = get_option( WEAVER_XPLUS_KEY );

			if( $old && $old != $new ) {
				weaverxplus_deactivate_license( $old );
				delete_option( WEAVER_XPLUS_KEY_STATUS );
			}
			update_option( WEAVER_XPLUS_KEY , $new );

			if ($new == '') {
				if ($old)
					weaverxplus_save_msg('Previous license deactivated, license key cleared.');
				else
					weaverxplus_error_msg('Please enter a license key.');
				return;
			}

			$success = weaverxplus_activate_license ($new);
			if (!$success) {
				update_option ( WEAVER_XPLUS_KEY_STATUS, 'invalid' );
				$stat = weaverxplus_check_license_status($new);
				weaverxplus_error_msg( 'Unable to activate "' . $new . '" key. License status: ' . $stat . '.');
			} else {
				weaverxplus_save_msg("License Key Updated and Activated");
			}
		}
	}

	if ( weaverxplus_submitted('ap_license_deactivate') ) {

		$old = get_option( WEAVER_XPLUS_KEY );
		if (! weaverxplus_deactivate_license( $old )) {
			$stat = weaverxplus_check_license_status($old);
			weaverxplus_error_msg("License Deactivation Failed - License sever may be down. License status: $stat.");
		}
		else
			weaverxplus_save_msg("License Deactivated");
	}

	if ( weaverxplus_submitted('ap_license_activate') ) {

		$old = get_option( WEAVER_XPLUS_KEY );
		if (! weaverxplus_activate_license( $old )) {
			$stat = weaverxplus_check_license_status($old);
			weaverxplus_error_msg("License Activation Failed - License sever may be down. License status: $stat.");
		}
		else
			weaverxplus_save_msg("License Activated");
	}

	if ( weaverxplus_submitted('ap_license_clear_all') ) {
		$old = get_option( WEAVER_XPLUS_KEY );
		if ($old)
			weaverxplus_deactivate_license( $old ); // try to deactivate it
		delete_option(WEAVER_XPLUS_KEY);
		delete_option(WEAVER_XPLUS_KEY_STATUS);
		weaverxplus_save_msg("Any existing license key has been deactivated for this site, and other status codes cleared.");

	}

	if ( weaverxplus_submitted('ap_license_status') || weaverxplus_submitted('ap_license_verify') ) {

		$old = get_option( WEAVER_XPLUS_KEY );
		if (!isset($old)) {
			weaverxplus_error_msg('No license key has been set yet. Please enter your license key and use the Activate button.');
			return;
		}
		$stat = weaverxplus_check_license_status($old);
		weaverxplus_save_msg("License Status Code : $stat. <span style='font-weight:normal'> (For security reasons, unknown keys are considered expired.)</span>");
		if ($stat != 'valid' && $stat != 'active')
			update_option( WEAVER_XPLUS_KEY_STATUS, 'invalid' );
		else if ($stat == 'valid') {
			$success = weaverxplus_activate_license ($old);
			if (!$success) {
				$stat = weaverxplus_check_license_status($old);
				weaverxplus_error_msg( 'Unable to automatically activate "' . $old . '" key. License status: ' . $stat . '.');
				delete_option(WEAVER_XPLUS_KEY_STATUS);
				delete_option(WEAVER_XPLUS_KEY);
			} else {
				weaverxplus_save_msg("License Key is Activated");
				update_option( WEAVER_XPLUS_KEY_STATUS, 'active' );
			}
		}

	}
}

/************************************
* this illustrates how to activate
* a license key
*************************************/

function weaverxplus_activate_license($license) {

	// data to send in our API request
	$api_params = array(
		'edd_action'=> 'activate_license',
		'license'       => $license,
		'item_name' => urlencode( WEAVER_XPLUS_LICENSE ), // the name of our product in EDD
		'url'        => home_url()
	);

	// Call the custom API.
		$response = wp_remote_post( WEAVER_PLUS_STORE_URL, array( 'timeout' => 20, 'sslverify' => false, 'body' => $api_params ) );


	// make sure the response came back okay
	if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {

		if ( is_wp_error( $response ) ) {
			$message = $response->get_error_message();
		} else {
			$message = __( 'An error occurred, please try again.' );
		}
		$message = 'WARNING: ' . $message;
		weaverx_alert ($message);
		return false;
	}

	// decode the license data
	$license_data = json_decode( wp_remote_retrieve_body( $response ) );

	if ( false === $license_data->success ) {

		switch( $license_data->error ) {

			case 'expired' :
				$message = sprintf(
					__( 'Your license key expired on %s.','weaver-xtreme-plus'  ),
					date_i18n( get_option( 'date_format' ), strtotime( $license_data->expires, current_time( 'timestamp' ) ) )
				);
				break;

			case 'revoked' :
				$message = __( 'Your license key has been disabled.','weaver-xtreme-plus' );
				break;

			case 'missing' :
				$message = __( 'Invalid license.','weaver-xtreme-plus' );
				break;

			case 'invalid' :
			case 'site_inactive' :
				$message = __( 'Your license is not active for this URL.','weaver-xtreme-plus' );
				break;

			case 'item_name_mismatch' :
				$message = sprintf( __( 'This appears to be an invalid license key for %s.','weaver-xtreme-plus' ), WEAVER_XPLUS_LICENSE );
				break;

			case 'no_activations_left':
				$message = __( 'Your license key has reached its activation limit.' );
				break;

			default :
				$message = __( 'An error occurred, please try again.' );
				break;
		}
		update_option( WEAVER_XPLUS_KEY_STATUS, 'invalid' );

		weaverx_alert(__( 'Failure to activate: ', 'weaver-xtreme-plus') . $message);

		return false;

	}

    	// $license_data->license will be either "active" or "inactive"

	if (isset($license_data->license) && ($license_data->license == 'active' || $license_data->license == 'valid')) {
		update_option( WEAVER_XPLUS_KEY_STATUS, 'active' );
		return true;
	}

	else {
		update_option( WEAVER_XPLUS_KEY_STATUS, 'invalid' );
		return false;
	}

	return false;

}

function weaverxplus_deactivate_license( $license ) {
	// deactivate a license
	// data to send in our API request
		$api_params = array(
			'edd_action'=> 'deactivate_license',
			'license'   => $license,
			'item_name' => urlencode( WEAVER_XPLUS_LICENSE ), // the name of our product in EDD
			'url'		=> home_url()
		);

		// Call the custom API.
		$response = wp_remote_post( WEAVER_PLUS_STORE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );

		// make sure the response came back okay
		if ( is_wp_error( $response ) )
			return false;

		// decode the license data
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );

		// $license_data->license will be either "deactivated" or "failed"
		if( isset($license_data->license) && $license_data->license == 'deactivated' )
			update_option( WEAVER_XPLUS_KEY_STATUS, 'deactivated' );
		else
			delete_option( WEAVER_XPLUS_KEY_STATUS );

		return true;
}

/************************************
* this illustrates how to check if
* a license key is still valid
* the updater does this for you,
* so this is only needed if you
* want to do something custom
*************************************/

function weaverxplus_check_license_status($license) {

		$api_params = array(
			'edd_action' => 'check_license',
			'license' => $license,
			'item_name' => urlencode( WEAVER_XPLUS_LICENSE ),
			'url' => home_url()
		);

		// Call the custom API.
		$response = wp_remote_post( WEAVER_PLUS_STORE_URL, array( 'timeout' => 20, 'body' => $api_params, 'sslverify' => false ) );

		if ( is_wp_error( $response ) )
			return 'Unable to get license status from license server. The server may be temporarily down.';

		$license_data = json_decode( wp_remote_retrieve_body( $response ) );


		if(!isset($license_data->license))
			return 'invalid - no data for license';
		else
			return $license_data->license;
}
?>
