<?php
if ( !defined('ABSPATH')) exit; // Exit if accessed directly
/*
Weaver Xtreme Plus Extra Menus - Version 1.0

EXTRAMENU
CODE

This code is Copyright 2014 by Bruce Wampler, all rights reserved.
This code is licensed under the terms of the accompanying license file: license.html.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/
/* ============================ weaverxplus_extra_menu =============================== */

function weaverxplus_has_extra_menu() { return true; }

class weaverxplus_Widget_Vertical_Menu extends WP_Widget {

	function __construct() {
		$widget_ops = array( 'classname'=>'weaverxp_extra_menu',
			'description' => 'Use this widget to add one of your custom menus as a widget.'
			. ' You can define Accordion, Standard, Simple Horizontal, or Simple Vertical Menu Styling.' );
		parent::__construct( 'weaverxplus_nav_menu', 'Wvr X-Plus Menus' , $widget_ops );
	}

	function widget($args, $instance) {
		if (!isset($instance['nav_menu'])) {
			_e('Please "Save" Weaver X-Plus Menus Widget Settings first to display menu.','weaver-xtreme-plus');
			return;
		}
		// Get menu
		$nav_menu = wp_get_nav_menu_object( $instance['nav_menu'] );

		$instance['title'] = apply_filters('widget_title', $instance['title'], $instance, $this->id_base);

		$menu_type = $instance['menu_type'];
		if (!$menu_type) $menu_type = 'accordion';

		$menu_style = $instance['menu_style'];
		if (!$menu_style) $menu_style ='extra';

		$add_class = $instance['add_class'];
		if (!$add_class) $add_class ='';


		echo $args['before_widget'];

		if ( !empty($instance['title']) )
			echo $args['before_title'] . $instance['title'] . $args['after_title'];

		echo weaverxplus_extra_menu_generate_code($nav_menu, $menu_style, $menu_type, $add_class );

		echo $args['after_widget'];
}

function update( $new_instance, $old_instance ) {
	$instance['title'] = strip_tags( stripslashes($new_instance['title']) );
	$instance['nav_menu'] = (int) $new_instance['nav_menu'];
	$instance['menu_style'] = $new_instance['menu_style'];
	$instance['menu_type'] = $new_instance['menu_type'];
	$instance['add_class'] = strip_tags( stripslashes($new_instance['add_class']) );
	return $instance;
}

function form( $instance ) {
	$title = isset( $instance['title'] ) ? $instance['title'] : '';
	$nav_menu = isset( $instance['nav_menu'] ) ? $instance['nav_menu'] : '';
	$menu_style = isset( $instance['menu_style'] ) ? $instance['menu_style'] : '';
	$menu_type = isset( $instance['menu_type'] ) ? $instance['menu_type'] : '';

	$add_class = isset( $instance['add_class'] ) ? $instance['add_class'] : '';


	// Get menus
	$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );

	$types = array ('Vertical - Accordion' => 'accordion',
					'Vertical - Simple' => 'vertical',
					'Standard Menu' => 'standard',
					'Horizontal' => 'horizontal');

	$styles = array ('Extra Menu Options' => 'extra', 'Primary Menu Options' => 'primary',
		'Secondary Menu Options' => 'secondary', 'Mini Menu *' => 'header_mini', 'No Styling' => 'none');

	// If no menus exists, direct the user to go and create some.
	if ( !$menus ) {
		echo '<p>'. sprintf( 'No menus have been created yet. <a href="%s">Create some</a>.', admin_url('nav-menus.php') ) .'</p>';
		return;
	}
?>
	<p>
	<label for="<?php echo $this->get_field_id('title'); ?>"><?php echo('Title:' /*a*/ ) ?></label>
	<input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo weaverx_plus_esc_textarea($title); ?>" />
	</p>
	<p>
	<label for="<?php echo $this->get_field_id('nav_menu'); ?>"><?php echo('Select Menu (from defined Custom Menus):' /*a*/ ); ?></label><br />
	<select id="<?php echo $this->get_field_id('nav_menu'); ?>" name="<?php echo $this->get_field_name('nav_menu'); ?>">
<?php
		foreach ( $menus as $menu ) {
			$selected = $nav_menu == $menu->term_id ? ' selected="selected"' : '';
			echo '<option'. $selected .' value="'. $menu->term_id .'">'. $menu->name .'</option>';
		}
?>
	</select>
	</p>

	<p>
	<label for="<?php echo $this->get_field_id('menu_type'); ?>"><?php echo('Menu Type:'); ?></label><br />
	<select id="<?php echo $this->get_field_id('menu_type'); ?>" name="<?php echo $this->get_field_name('menu_type'); ?>">
<?php
		foreach ( $types as $type => $val) {
			$selected = $menu_type == $val ? ' selected="selected"' : '';
			echo '<option'. $selected .' value="' . $val .'">'. $type .'</option>';
		}
?>
	</select>
	</p>

	<p>
	<label for="<?php echo $this->get_field_id('menu_style'); ?>"><?php echo('Style Menu Using:' /*a*/ ); ?></label><br />
	<select id="<?php echo $this->get_field_id('menu_style'); ?>" name="<?php echo $this->get_field_name('menu_style'); ?>">
<?php
		foreach ( $styles as $style => $val) {
			$selected = $menu_style == $val ? ' selected="selected"' : '';
			echo '<option'. $selected .' value="' . $val .'">'. $style .'</option>';
		}
?>
	</select>
	<br /><small>* Mini Menu Style doesn't work with Accordion or Standard Menus.</small>
	</p>

	<p>
	<label for="<?php echo $this->get_field_id('add_class'); ?>"><?php echo('Additional Classes to Wrap Menu:'  ) ?></label>
	<input type="text" class="widefat" id="<?php echo $this->get_field_id('add_class'); ?>" name="<?php echo $this->get_field_name('add_class'); ?>" value="<?php echo weaverx_plus_esc_textarea($add_class); ?>" />
	</p>
<?php
   }
}

// -------- end if class ------

function weaverxplus_extra_menu_shortcode($args = '') {
	extract(shortcode_atts(array(
		'menu_name' => 'primary',      // default menu name
        'menu_style' => 'extra',
		'menu_type' => 'accordion', // default menu style id (should be class)
		'class' => ''
	), $args));

	return weaverxplus_extra_menu_generate_code($menu_name, $menu_style , $menu_type, $class);
}

function weaverxplus_extra_menu_generate_code(
                            $menu_name,             // menu name as defined in Custom Menu
                            $menu_style = 'extra', // where the options come from
                            $menu_type = 'accordion',
                            $class= ''          // add a class list to the menu's classes
                            ) {

    ob_start();
    weaverx_extra_menu( $menu_name, $menu_style, $menu_type, $class );
    $out = ob_get_clean();
	return $out;
}



function weaverx_extra_menu(
    $menu_name,             // menu name as defined in Custom Menu
    $menu_style = 'extra',  // where the options come from
    $menu_type = 'accordion',   // accordion (like mobile w/o menu icon), standard, horizontal
    $add_class = ''          // add a class list to the menu's classes
    ) {

    if ( $menu_style == 'header_mini' && $menu_type != 'horizontal' && $menu_type != 'vertical' ) {
        echo '<br /> <strong>WEAVER EXTRA MENU ERROR: Mini Menu (header_mini) style only works with horizontal or simple vertical menus.</strong><br />';
        return;
    }

    $m_opts = 'm_' . $menu_style;

    if (weaverx_getopt( $m_opts . '_hide') == 'hide' )
        return;

    // get options common to all menu types

    $menu_id = $menu_style . '-x' . weaverx_generate_id();

    $menu = apply_filters('weaverx_menu_name', $menu_name );

    $the_menu = wp_get_nav_menu_object($menu);

    $no_hide = isset( $GLOBALS['wvrx_sc_show_hide']  );

    $class = weaverx_menu_class( $m_opts, $no_hide );

    if ( $menu_type == 'horizontal' ) {

        // need to generate bg, text color, hover on the fly.

        //require_once(get_template_directory() . '/includes/generatecss.php');
        $tag = '#' . $menu_id . ' .wvrx-horizontal-menu';
        echo '<style type="text/css">';
        if ( $menu_style == 'none' ) {
            echo "{$tag}{background-color:transparent;}";
        } else {
            weaverx_plus_put_color( 'echo', $m_opts . '_color', $tag . ' a' );
            weaverx_plus_put_bgcolor( 'echo', $m_opts . '_bgcolor', $tag );
            weaverx_plus_put_color( 'echo', $m_opts . '_hover_color', $tag . ' a:hover' );
        }
        echo '</style>';

        $align = weaverx_getopt( $m_opts . '_align' );


        if ($align == 'center') {
            $add_class .= ' hm-center';
        } else if ( $align == 'right' ) {
            $add_class .= ' hm-alignright';
        }


        echo "\n\n<div id=\"{$menu_id}\" class=\"menu-horizontal extra-menu-xplus menu-type-horizontal {$class}\">\n";
        $align = weaverx_getopt( $m_opts . '_align' );

        wp_nav_menu( array(
            'fallback_cb'     => '',
            'menu'            => $the_menu,
            'menu_class'      => 'wvrx-horizontal-menu',
            'container'       => 'div',
            'container_class' => trim($add_class)
        ));

        weaverx_clear_both('header-mini');
        echo "\n</div><!-- /#nav-header-mini -->\n";
        weaverx_clear_both('extra-menu');

    } elseif ( $menu_type == 'vertical' ) {

        // need to generate bg, text color, hover on the fly.

        //require_once(get_template_directory() . '/includes/generatecss.php');
        $tag = '#' . $menu_id . '.menu-vertical';
        echo '<style type="text/css">';
        if ( $menu_style == 'none' ) {
            echo "{$tag}{background-color:transparent;}{$tag} a{color:#0000EE;}";
        } else {
            /* =Menu Vertical -- default styling for Vertical Menu */

            // Basic menu colors
            $m_color = weaverx_getopt_default( $m_opts . '_color','black');

            // Menu Text color
            weaverx_f_write ('echo',
"{$tag}{border-bottom:3px solid $m_color;border-top:1px solid $m_color;}
{$tag} li a{border-top:2px solid $m_color;}
{$tag} ul ul a{border-top:1px solid $m_color;}\n"
            );

            weaverx_plus_put_color( 'echo', $m_opts . '_color', $tag . ' li a,' . $tag . ' ul ul a');
            weaverx_plus_put_bgcolor( 'echo', $m_opts . '_bgcolor', $tag. ' li a,' . $tag . ' ul ul a' );

            weaverx_plus_put_color( 'echo', $m_opts . '_hover_color', $tag . ' li a:hover,' . $tag . ' li a:focus,' . $tag . 'ul ul a:hover' );
            weaverx_plus_put_bgcolor( 'echo', $m_opts . '_hover_bgcolor', $tag . ' li a:hover,' . $tag . ' li a:focus,' . $tag . 'ul ul a:hover' );
        }
        echo '</style>';


        echo "\n\n<div id=\"{$menu_id}\" class=\"menu-vertical extra-menu-xplus menu-type-vertical {$class}\">\n";

        wp_nav_menu( array(
            'fallback_cb'     => '',
            'menu'            => $the_menu,
            'menu_class'      => 'wvrx-vertical-menu',
            'container'       => 'div',
            'container_class' => trim($add_class)
        ));

        weaverx_clear_both('header-mini');
        echo "\n</div><!-- /#nav-header-mini -->\n";
        weaverx_clear_both('extra-menu');

    } else {

		$left = weaverx_getopt($m_opts . '_html_left');
        $right = weaverx_getopt($m_opts . '_html_right');

		if ( $left ) {
            $hide = ' ' . weaverx_getopt($m_opts . '_hide_left');
            $left = '<span class="wvrx-menu-html wvrx-menu-left' . $hide .'">' . do_shortcode( $left ) . '</span>';
			$left = str_replace('%','%%',$left);	// wp_nav_menu uses sprintf! This will almost always fix the issue.

        }

        if ( $right ) {
            $hide = ' ' . weaverx_getopt($m_opts . '_hide_right');
            $right = '<span class="wvrx-menu-html wvrx-menu-right ' . $hide . '">' . do_shortcode( $right ) . '</span>';
			$right = str_replace('%','%%',$right);	// wp_nav_menu uses sprintf! This will almost always fix the issue.
        }

		$use_smart = weaverx_getopt( 'use_smartmenus' );

		if ( $use_smart ) {							// ==================  SMART MENUS
			if ( $menu_type == 'accordion' ) {
				$menu_class = 'weaverx-theme-menu sm sm-vertical wvrx-menu';
			} else {
				$menu_class = 'weaverx-theme-menu sm wvrx-menu collapsed';

				$hamburger = weaverx_getopt("{$m_opts}_hamburger");
				if ( $hamburger == '' )
					$hamburger = '<span class="genericon genericon-menu"></span>';
				$left = '<span href="" class="wvrx-menu-button">' . "{$hamburger}</span>{$left}";
			}
			if (is_rtl())
				$menu_class .= ' sm-rtl';
		} else {									// ===================== WVRX MENUS
			$menu_class = 'weaverx-theme-menu wvrx-menu wvrx-extra-menu menu-hover';
		}


        $align = weaverx_getopt( $m_opts . '_align' );

        if ($menu_type == 'standard') {
            if ($align == 'center') {
                $menu_class .= ' wvrx-center-menu';
            } else if ( $align == 'right' ) {
                $menu_class .= ' menu-alignright';
            } else {
                $menu_class .= ' menu-alignleft';
            }
        }


        echo "\n\n<div id=\"{$menu_id}-x\" class=\"menu-{$menu_style} extra-menu-xplus menu-type-{$menu_type}\">\n";
        wp_nav_menu( array(
            'fallback_cb'     => '',
            'menu'            => $the_menu,
			'menu_id'		  => $menu_id,
            'menu_class'      => $menu_class,
            'container'       => 'div',
            'container_class' => trim('wvrx-menu-container ' . $class . ' ' . $add_class),
            'items_wrap'      => $left . $right . '<div class="wvrx-menu-clear"></div><ul id="%1$s" class="%2$s">%3$s</ul><div style="clear:both;"></div>',
			'walker'		  => new weaverx_Walker_Nav_Menu()
        ));

        echo "\n</div><div class='clear-menu-extra' style='clear:both;'></div><!-- /.menu-extra -->\n\n";

		if ( ! $use_smart ) {		// built-in or SmartMenus?
			if (!isset($GLOBALS['wvrx_extra_menu_scripts']) || empty($GLOBALS['wvrx_extra_menu_scripts']) )
				$GLOBALS['wvrx_extra_menu_scripts'] = array();

			$val = "jQuery('#{$menu_id}').thmfdnMenu({";    // build jQuery script to output after wrapper
			if ( $menu_type == 'accordion' ) {
				$val .= "hideToggle:true,hideMobileClass:'not-hidden',mobileBreakpoint: 9999,";
			}
			$GLOBALS['wvrx_extra_menu_scripts'][] = $val . "toggleButtonID: '{$menu_id}-toggle-button'});";
		} else {
			weaverx_plus_smartmenu_action( $menu_id. '-x', $m_opts, $menu_type );
		}
    }
}
//--

function weaverx_plus_put_color($sout, $id, $tag, $important = false) {
	// put color and CSS+

	if (($color = weaverx_getopt( $id )) && $color != 'inherit') {
		if ($important)
			weaverx_f_write($sout, sprintf("$tag {color:$color !important;}\n"));
		else
			weaverx_f_write($sout, sprintf("$tag {color:$color;}\n"));
	}

	weaverx_plus_put_css_plus( $sout, $id, $tag );
}


function weaverx_plus_put_bgcolor($sout, $opt, $tag, $important = false ) {
	// put bgcolor and CSS+

	$imp = ($important) ? ' !important' : '';

	if (($color = weaverx_getopt($opt)) && $color != 'inherit') {
		weaverx_f_write($sout, sprintf("$tag {background-color:{$color}{$imp};}\n"));
	}

	weaverx_plus_put_css_plus( $sout, $opt, $tag );
}

function weaverx_plus_put_css_plus( $sout, $id, $tag ) {

	if ( ($style = weaverx_getopt($id . '_css')) ) {
		if ( strpos( $style, '%selector') !== false ) {     // user is using $selectors
			$tags = explode(',', $tag );
			foreach ( $tags as $selector ) {
				$replaced = str_replace( '%selector%', trim( $selector ), $style);
				weaverx_f_write( $sout, apply_filters( 'weaverx_css', sprintf( "%s %s\n", $selector, $replaced ) ) );
			}
		} else {
			weaverx_f_write( $sout, apply_filters( 'weaverx_css', sprintf( "%s %s\n", $tag, $style ) ) );
		}
	}
}



add_shortcode('extra_menu','weaverxplus_extra_menu_shortcode');
add_action('widgets_init', "weaverxplus_load_menu_widget");
function weaverxplus_load_menu_widget() {
		register_widget("weaverxplus_Widget_Vertical_Menu");
}
?>
