<?php
if ( !defined('ABSPATH')) exit; // Exit if accessed directly
/*
Weaver Xtreme Plus Shortcoder

This code is Copyright 2011 by Bruce Wampler, all rights reserved.
This code is licensed under the terms of the accompanying license file: license.html.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

/* =========================== shortcoder ========================== */
function weaverxplus_has_shortcoder() { return true; }

function weaverxplus_save_shortcoder() {
	/* Save options from plus header: wvrx_plus_save_header */


	if (!weaverxplus_isset('wvpsc_num_opts')) weaverxplus_setopt('wvpsc_num_opts',3);

	if (isset($_POST['wvpsc_num_opts'])) weaverxplus_setopt('wvpsc_num_opts', weaverxplus_default_int($_POST['wvpsc_num_opts'],1,25,2));

	for ($i = 1 ; $i <= weaverxplus_getopt('wvpsc_num_opts') && $i < 256; $i++ ) {
		$base = 'wvpsc_' . $i . '_';
		if (isset($_POST[$base . 'id'])) {
			$val = filter_var(strtolower(trim(weaverx_filter_textarea($_POST[$base . 'id']))), FILTER_SANITIZE_EMAIL); // close enough
			weaverxplus_setopt($base . 'id', $val);
		}
		if (isset($_POST[$base . 'text'])) {
			weaverxplus_setopt($base . 'text', weaverx_filter_textarea(stripslashes($_POST[$base . 'text'])));
		}

	}
	weaverxplus_update_opts();
	/* and let the user know something happened */
	echo '<div id="message" class="updated fade"><p><strong>Weaver Xtreme Plus Shortcoder Options Saved</strong></p></div>';
}

/* -------------- weaverxplus_sc --------------- */
function weaverxplus_sc_shortcode($args = '') {
	extract(shortcode_atts(array(
		'id' => '',
		'v1' => '', 'v2' =>'', 'v3' =>'', 'v4' =>'', 'v5' =>'',
		'v6' =>'', 'v7' =>'', 'v8' =>'', 'v9' =>'',
		'php' => ''
	), $args));

	$text = "[*** ERROR: Weaver X-Plus Shortcoder undefined id: '$id' *** ]";

	$out = '';  // no php yet

	if ($php != '') {
		if (function_exists('weaverxplus_php_do_eval')) {
			$out = weaverxplus_php_do_eval($php);
		} else {
			$out = '[**** ERROR: shortcoder: php not allowed ****]';
		}
	}

	for ($i = 1 ; $i <= weaverxplus_getopt('wvpsc_num_opts') && $i < 256; $i++ ) { // look for our id
		$base = 'wvpsc_' . $i . '_';
		$cur_id = weaverxplus_getopt($base . 'id');
		if ($cur_id == $id) {
			$text = weaverxplus_getopt($base . 'text');
			break;
		}
	}
	for ($i = 1 ; $i <= 9 ; $i++) {     // process parameters
		$name = 'v' . $i;
		if ($$name != '') {
			$text = str_replace( "%$name%", $$name, $text );    // replace params
		}
	}
	if ($out != '') {
		$text = str_replace('%php%', $out, $text);
	}

	return do_shortcode($text);
}

weaverxplus_add_shortcode('shortcoder', 'weaverxplus_sc_shortcode');

?>
