<?php
// Runtime actions and filters
//

add_action( 'weaverxplus_action', 'weaverxplus_actions' );

function weaverxplus_actions( $action ) {

	switch ( $action ) {
		// do_action('weaverxplus_action','footer');    // right after inject post-footer in footer.php, outside #wrapper
		// do_action('weaverxplus_action','postfooter');    // right after outside #wrapper
		// do_action('weaverxplus_action','head');       // stuff like other style files, in <head> block, near top (header.php)
		// do_action('weaverxplus_action','header_area_top'); // after inject header, right before header_image (header.php)
		// do_action('weaverxplus_action','header_area_bottom'); // right before </header>, after header_image (header.php)
		// do_action('weaverxplus_action','after_infobar'); // between #infobar and #content

		case 'postfooter':
			weaverxplus_do_postfooter();
			break;

		case 'head':
			weaverxplus_do_head();
			break;


		default:
			//echo '<h2 style="background-color:red; padding:10px; border:2px solid black;">Weaver Xtreme Plus: ' . $action . '</h2>';
			break;
	}
}

// ==========================================  PER POST CSS ========================================

add_action( 'weaverx_per_post', 'weaverxplus_per_post' );

function weaverxplus_per_post( $post_id ) {
	$bgcolor = get_post_meta( $post_id, '_pp_bgcolor', true );
	$color = get_post_meta( $post_id, '_pp_color', true );
	$fullwidth = get_post_meta( $post_id, '_pp_bg_fullwidth', true );
	$padding = get_post_meta( $post_id, '_pp_lr_padding', true );
	$padding_tb = get_post_meta( $post_id, '_pp_tb_padding', true );
	$margin = get_post_meta( $post_id, '_pp_margin', true );
	$post_style = get_post_meta( $post_id, '_pp_post_styles', true );

	$post_bg = get_post_meta( $post_id, '_pp_bgimg', true );
	$post_mobile_bg = get_post_meta( $post_id, '_pp_mobile_bgimg', true );
	$post_parallax = get_post_meta( $post_id, '_pp_use_parallax', true );
	$post_parallax_h = trim( get_post_meta( $post_id, '_pp_parallax_height', true ) );


	if ( $bgcolor || $color || $fullwidth || strlen( $padding ) > 0 ||
	     strlen( $padding_tb ) > 0 || strlen( $margin ) > 0 || strlen( $post_style ) > 0 ||
	     strlen( $post_bg ) > 0 || strlen( $post_mobile_bg ) > 0 || $post_parallax ) {

		$id = "#post-{$post_id}";
		echo '<style type="text/css">' . "\n";
		if ( $bgcolor ) {
			echo "{$id}{background-color:{$bgcolor};}\n";
		}
		if ( $color ) {
			echo "{$id}{color:{$color};}\n";
		}
		if ( $fullwidth ) {
			echo '.is-desktop #content, .is-desktop #container {overflow:visible !important;}';
			$cname = '.is-desktop ' . $id;        // this method required for proper iPad display
			echo $cname . '{position:relative;overflow:visible !important;}' .
			     $cname . ':before{content:"";position:absolute;top:0;bottom:0;left:-9998px;right:0;border-left:9999px solid ' .
			     $fullwidth . ';box-shadow:9999px 0 0 ' . $fullwidth . ";z-index:-1;}\n";
		}
		if ( strlen( $padding ) > 0 ) {
			echo "{$id}{padding-left:{$padding}em;padding-right:{$padding}em;}\n";
		}
		if ( strlen( $padding_tb ) > 0 ) {
			echo "{$id}{padding-top:{$padding_tb}em;padding-bottom:{$padding_tb}em;}\n";
		}
		if ( strlen( $margin ) > 0 ) {
			echo "{$id}{margin:{$margin};}\n";
		}

		// Parallax

		if ( $post_parallax ) {
			$height = strlen( $post_parallax_h ) > 0 ? $post_parallax_h : 400;
			if ( strlen( $post_bg ) > 0 ) {
				$desk = strlen( $post_mobile_bg ) > 0 ? '.is-desktop ' : '';
				$url = str_replace( 'http://', '//', $post_bg );
				echo "{$desk}{$id}-p.parallax{min-height:{$height}px;height:auto !important;background-position:50% 50%;background-repeat:no-repeat;
background-attachment:fixed;-webkit-background-size:cover;-moz-background-size:cover;-o-background-size:cover;background-size:cover;
background-image:url({$url});}
{$desk}#content {$id}.post{background-image:none;}\n";
			}
			if ( strlen( $post_mobile_bg ) > 0 ) {
				$url = str_replace( 'http://', '//', $post_mobile_bg );
				echo ".is-mobile {$id}-p.parallax{min-height:{$height}px;height:auto !important;background-position:50% 50%;background-repeat:no-repeat;
background-attachment:fixed;-webkit-background-size:cover;-moz-background-size:cover;background-size:cover;
background-image:url({$url});}
.is-mobile #content {$id}.post{background-image:none;}\n";
			}
			echo ".ie8  {$id}-p.parallax,.is-ipad {$id}-p.parallax,.is-iphone {$id}-p.parallax{background-attachment:scroll;}\n"; // Why doesn't iOS do this????

		} else {                // regular bg image - not parallax

			if ( strlen( $post_bg ) > 0 ) {
				$desk = strlen( $post_mobile_bg ) > 0 ? '.is-desktop ' : '';
				$url = str_replace( 'http://', '//', $post_bg );
				echo "{$desk}#content {$id}{background-image:url({$url});}\n";
			}
			if ( strlen( $post_mobile_bg ) > 0 ) {
				$url = str_replace( 'http://', '//', $post_bg );
				echo ".is-mobile {$id}{background-image:url({$url});}\n";
			}
		}

		// Finally, put the per post style last.

		if ( strlen( $post_style ) > 0 ) {
			weaverxplus_pp_styles( $post_style, '#post-' . $post_id );
		}

		echo '</style>' . "\n";
		if ( $post_parallax ) {

			$the_post = get_post();
			if ( empty( $the_post ) || post_password_required() ) {
				$excerpt = '';
			} else {
				$excerpt = do_shortcode( trim( $the_post->post_excerpt ) );
			}

			//echo '<p>'  . print_r($the_post, true) . '</p>';
			$fullwidth = ' wvrx-fullwidth';
			if ( weaverx_get_per_post_value( '_pp_parallax_not_wide' ) ) {
				$fullwidth = '';
			}

			echo "\n<!-- Parallax Image for {$id} -->
<section id='post-{$post_id}-p' class='parallax{$fullwidth}'><div class='parallax-content'>\n
{$excerpt}
</div></section>\n";
		}
	}
}

add_action( 'weaverx_per_page', 'weaverxplus_per_page' );

function weaverxplus_pp_styles( $post_style, $post_id ) {
	$rules = explode( '}', trim( $post_style ) );

	foreach ( $rules as $rule ) {
		$rule = trim( $rule );
		if ( strlen( $rule ) > 1 ) {        // must have some content to the rule!
			if ( $rule[0] == '+' ) {
				echo( substr( $rule, 1 ) . "}\n" );
			} elseif ( $rule[0] == '|' ) {
				echo $post_id . substr( $rule, 1 ) . "}\n";
			} else {
				echo( "{$post_id} {$rule}}\n" );
			}    // add the post id to the front of each rule
		}
	}

}

function weaverxplus_per_page() {
	$post_id = get_the_ID(); //$wp_query->get_queried_object_id();
	$bgcolor = get_post_meta( $post_id, '_pp_bgcolor', true );
	$post_style = get_post_meta( $post_id, '_pp_post_styles', true );
	$ratio = weaverx_get_per_page_value( '_pp_video_aspect' );        // override the global value for this page
	if ( $bgcolor || strlen( $post_style ) > 0 || $ratio != '' ) {
		$id = ( is_single() ) ? ".postid-{$post_id}" : ".page-id-{$post_id}";
		echo '<style type="text/css">' . "\n";
		if ( $bgcolor ) {
			echo $id . "{background-color:{$bgcolor};}\n";
		}
		if ( strlen( $post_style ) > 0 ) {
			weaverxplus_pp_styles( $post_style, $id );
		}

		if ( $ratio != '' ) {
			$ratio = explode( ':', $ratio );
			if ( $ratio[0] ) {
				$r_pc = ( $ratio[1] / $ratio[0] ) * 100.0;
			} else {
				$r_pc = 56.25;
			}
			echo sprintf( ".has-header-video .header-image .wp-custom-header{padding-bottom:%.5f%%;}\n", $r_pc );
		}

		echo '</style>' . "\n";
	}
}

function weaverplus_post_class( $classes ) {
	// add per post class name
	global $post;

	if ( ! is_object( $post ) ) {
		return $classes;
	}        // fix version 3.0.1
	$post_id = $post->ID;

	$class = get_post_meta( $post_id, '_pp_post_class', true );
	if ( strlen( $class ) > 0 ) {
		$classes[] = $class;
	}

	return $classes;
}

add_filter( 'post_class', 'weaverplus_post_class' );

// == FI Links ==
function wvrx_plus_fi_link( $the_fi, $before, $href, $fi_img, $who = 'page' ) {

	$nolink = ( $who == 'page' ) ? weaverx_getopt( 'page_fi_nolink' ) : weaverx_getopt( 'page_fi_nolink' );
	if ( $nolink ) {
		return $before . $fi_img;
	}

	return $the_fi;
}

add_filter( 'weaverx_fi_link', 'wvrx_plus_fi_link', 10, 5 );

// === version ==

add_action( 'weaverxplus_show_version', 'weaverxplus_show_version_action' );

function weaverxplus_show_version_action() {
	echo '<!-- Weaver Xtreme Plus ' . WEAVER_XPLUS_VERSION . " --> ";
}

// === Alternate per page subtheme ===

add_action( 'weaverx_alt_theme', 'weaverxplus_alt_theme' );

function weaverxplus_alt_theme( $who ) {

	// Handle loading alt theme val from file instead of database
	// If .wxb, then simply override all settings
	// If .wxt, then load default theme settings, clear and override non-diamond settings
	// Force inline CSS, don't use pre-set CSS definitions

	// have to get page id a bit earlier than weaverx theme, so do it this way

	$alt_theme = weaverx_getopt( 'alt_theme_' . $who );    // look for archive-like alt-theme

	if ( $alt_theme == '' ) {                                // might be a per page alt-theme
		global $post;

		if ( is_object( $post ) ) {
			weaverx_set_cur_page_id( get_the_ID() );
		}    // we're on a page now, so set the post id for the rest of the session
		else {
			weaverx_set_cur_page_id( 0 );
		}    // no page

		$alt_theme = weaverx_get_per_page_value( '_pp_alt_theme' );
	}

	if ( $alt_theme ) {

		$filename = weaverx_f_uploads_base_dir() . 'weaverx-subthemes/' . $alt_theme;    // build file name
		$contents = weaverx_f_get_contents( $filename );        // read the settings file
		if ( ! $contents ) {// was there a file there?
			return;
		}
		//weaverx_alert('alt theme:' . $alt_theme . '|' . $contents);

		/* $alt_names = array( 'alt_theme_blog','alt_theme_single','alt_theme_attchment','alt_theme_archive',
						    'alt_theme_category','alt_theme_tag','alt_theme_author','alt_theme_search','alt_theme_404' );
		$saved = array();
		foreach ( $alt_names as $alt ) {				// save main theme's alt themes
			$val = weaverx_getopt($alt);
			if ( $val != '' )
				$saved[] = $val;
		} */

		weaverxplus_set_to_alt_theme( $contents, true );

	}
}


function weaverxplus_set_to_alt_theme( $contents ) {
	// put renamed duplicate of weaverx_ex_set_current_to_serialized_values here so don't have to load theme support lib
	global $weaverx_opts_cache;    // need to mess with the cache


	if ( substr( $contents, 0, 10 ) == 'WXT-V01.00' ) {
		$type = 'theme';
	} elseif ( substr( $contents, 0, 10 ) == 'WXB-V01.00' ) {
		$type = 'backup';
	} else {
		$val = substr( $contents, 0, 10 );

		return weaverx_f_fail( __( "Wrong theme file format version", 'weaver-xtreme' /*adm*/ ) . ':' . $val );    /* simple check for one of ours */
	}
	$restore = array();
	$restore = unserialize( substr( $contents, 10 ) );

	if ( ! $restore ) {
		return weaverx_f_fail( __( "Unserialize failed", 'weaver-xtreme' /*adm*/ ) );
	}

	$version = weaverx_getopt( 'weaverx_version_id' );    // get something to force load

	if ( $type == 'theme' ) {
		// need to clear some settings
		// first, pickup the per-site settings that aren't theme related...
		$new_cache = array();
		foreach ( $weaverx_opts_cache as $key => $val ) {
			if ( isset( $key[0] ) && $key[0] == '_' )    // these are non-theme specific settings
			{
				$new_cache[ $key ] = $val;
			}    // keep
		}
		$opts = $restore['weaverx_base'];    // fetch base opts

		weaverx_delete_all_options( true );

		foreach ( $opts as $key => $val ) {
			if ( isset( $key[0] ) && $key[0] != '_' ) {
				weaverx_setopt( $key, $val, false );
			}    // overwrite with saved theme values
		}

		foreach ( $new_cache as $key => $val ) {    // set the values we need to keep
			weaverx_setopt( $key, $val, false );
		}
	} elseif ( $type == 'backup' ) {
		weaverx_delete_all_options( true );

		$opts = $restore['weaverx_base'];    // fetch base opts
		foreach ( $opts as $key => $val ) {
			weaverx_setopt( $key, $val, false );    // overwrite with saved values
		}
	}

	weaverx_setopt( 'weaverx_version_id', $version, false ); // keep version, force save of db


	weaverx_setopt( 'last_option', 'Weaver Xtreme', false );
	weaverx_setopt( '_inline_style', 'on', false );            // no inline

	return true;
}


// ==========================================  SmartMenus ========================================

add_action( 'weaverx_plus_smartmenu', 'weaverx_plus_smartmenu_action', 10, 3 );
function weaverx_plus_smartmenu_action( $menu_id, $menu_opt, $menu_type = 'standard' ) {

	$def = apply_filters( 'weaverx_plus_smjs', "{subIndicatorsText:'',subMenusMinWidth:'1em',subMenusMaxWidth:'25em'}", $menu_opt );
	// build jQuery script to invoke menu
	?>
	<script type='text/javascript'>
		jQuery('#<?php echo $menu_id; ?> .weaverx-theme-menu').smartmenus(<?php echo $def; ?>);
		<?php
		if ($menu_type == 'standard') { ?>
		jQuery('#<?php echo $menu_id;?> span.wvrx-menu-button').click(function () {
			var $this = jQuery(this), $menu = jQuery('#<?php echo $menu_id;?> ul');
			if (!$this.hasClass('collapsed')) {
				$menu.addClass('collapsed');
				$this.addClass('collapsed mobile-menu-closed');
				$this.removeClass('mobile-menu-open');
			} else {
				$menu.removeClass('collapsed');
				$this.removeClass('collapsed mobile-menu-closed');
				$this.addClass('mobile-menu-open');
			}
			return false;
		}).click();
		<?php } ?></script><?php
}


add_filter( 'weaverx_plus_smjs', 'weaverx_plus_smjs_filter', 10, 2 );

function weaverx_plus_smjs_filter( $js, $menu ) {
	$opt_base = 'sm-' . str_replace( 'm_', '', $menu ) . '-js-opt';
	$alt = weaverxplus_getopt( $opt_base );

	return $alt != '' ? $alt : $js;
}

add_filter( 'weaverx_menu_class', 'weaverx_menu_class_filter', 10, 2 );

function weaverx_menu_class_filter( $class, $menu ) {
	$use_smart = weaverx_getopt( 'use_smartmenus' );
	if ( $use_smart ) {
		$menu_class = 'weaverx-theme-menu sm wvrx-menu collapsed';
		if ( is_rtl() ) {
			$menu_class .= ' sm-rtl';
		}

		return $menu_class;
	}

	return $class;
}

// ==========================================  PLUS CSS ========================================

add_action( 'weaverxplus_css', 'weaverxplus_css_action' ); // output css
function weaverxplus_css_action( $sout ) {

	weaverx_f_write( $sout, sprintf( "\n/* Weaver Xtreme Plus CSS Styles - Version %s */\n", WEAVER_XPLUS_VERSION ) );
	//weaverx_f_write( $sout, $default_css_desk );
	//weaverx_f_write( $sout, $default_css_mobile );

// ----------------- SmartMenus ------------

	foreach ( array( 'primary', 'secondary', 'extra' ) as $menu ) {
		$opt = "sm-{$menu}";
		$media = '@media screen and (min-width: 768px){';
		$left = weaverxplus_getopt( "{$opt}-uparrow-x" );
		if ( $left == '' ) {
			$left = '33';
		}

		if ( weaverxplus_getopt( "{$opt}-uparrow" ) != '' ) {
			$bg = weaverx_getopt( "m_{$menu}_sub_bgcolor" );
			if ( ! $bg ) {
				$bg = weaverx_getopt( "m_{$menu}_bgcolor" );
			}
			if ( ! $bg ) {
				$bg = '#AAA';
			}
			$color =
				"{$media}.menu-{$menu}.menu-type-standard .sm > li > ul:before,.menu-{$menu}.menu-type-standard .sm > li > ul:after{
bottom:100%;left:{$left}px;border:solid transparent;content: '';height:0;width:0;position: absolute;}
.menu-{$menu}.menu-type-standard .sm > li > ul:after{border-bottom-color:{$bg};border-width:8px;margin-left:-8px;}\n";
			$media = '';    // @media emitted

			if ( weaverxplus_getopt( "{$opt}-uparrow-border" ) != '' ) {
				$b = weaverx_getopt( 'border_color' );
				if ( ! $b ) {
					$b = '#222';
				}
				$color .=
					".menu-{$menu}.menu-type-standard .sm > li > ul:before{border-bottom-color:{$b};border-width:9px;margin-left:-9px;}";
			}
			weaverx_f_write( $sout, $color );
		}

		// "m_{$menu}_align" is align option: left, right, center

		$align = weaverx_getopt_default( "m_{$menu}_align", 'align-left' );
		if ( weaverxplus_getopt( "{$opt}-downbelow" ) != '' ) {
			switch ( $align ) {
				case 'right':
					$css =
						"{$media}.menu-{$menu}.menu-type-standard .wvrx-menu.sm li a span.sub-arrow:after{font-size:70%!important;top:80%;right:44%;margin:0;}
.menu-{$menu}.menu-type-standard .wvrx-menu.sm ul a span.sub-arrow:after{top:33%;right:-1.0em;left:auto;margin-right:1em;}
.menu-{$menu}.menu-type-standard .wvrx-menu.sm li .has-submenu,.menu-{$menu}.menu-type-standard .wvrx-menu.sm li .children{padding-right:1em;padding-left:1em;}
.menu-{$menu}.menu-type-standard .wvrx-menu.sm ul .has-submenu,.menu-{$menu}.menu-type-standard .wvrx-menu.sm ul .children{padding-right:2.0em;}\n";
					break;

				case 'center':
					$css =
						"{$media}.menu-{$menu}.menu-type-standard .wvrx-menu.sm li a span.sub-arrow:after{font-size:70%!important;top:80%;right:44%;margin:0;}
.menu-{$menu}.menu-type-standard .wvrx-menu.sm ul a span.sub-arrow:after{top:33%;right:-1.0em;left:auto;margin-right:1.5em;}
.menu-{$menu}.menu-type-standard .wvrx-menu.sm li .has-submenu{padding-right:1em;padding-left:0.75em;}
.menu-{$menu}.menu-type-standard .wvrx-menu.sm ul .has-submenu,.menu-{$menu}.menu-type-standard .wvrx-menu.sm ul .children{padding-right:2.0em;}\n";
					break;

				case 'left':
				default:
					$css =
						"{$media}.menu-{$menu}.menu-type-standard .wvrx-menu.sm li a span.sub-arrow:after{font-size:70%!important;top:80%;left:45%;margin:0;}
.menu-{$menu}.menu-type-standard .wvrx-menu.sm ul a span.sub-arrow:after{top:33%;right:-1.0em;left:auto;margin-right:1.5em;}
.menu-{$menu}.menu-type-standard .wvrx-menu.sm li .has-submenu,.menu-{$menu}.menu-type-standard .wvrx-menu.sm li .children{padding-right:1em;padding-left:1em;}
.menu-{$menu}.menu-type-standard .wvrx-menu.sm ul .has-submenu,.menu-{$menu}.menu-type-standard .wvrx-menu.sm ul .children{padding-right:2.0em;}\n";
					break;
			}
			$media = '';    // @media emitted
			weaverx_f_write( $sout, $css );
		}

		if ( weaverx_getopt( "m_{$menu}_hide_arrows" ) ) {
			if ( $media != '' ) {
				weaverx_f_write( $sout, $media );
				$media = '';    // @media emitted
			}
			weaverx_f_write( $sout, ".menu-{$menu}.menu-type-standard .wvrx-menu.sm .has-submenu {padding-right:0.85em;}\n" );
		}


		if ( $media == '' )    // @media was emitted, so close
		{
			weaverx_f_write( $sout, "}\n" );
		}
	}


// ----------------- FONTS -----------------

	$gfonts = weaverx_plus_getopt_array( 'fonts_added' );
	if ( ! empty( $gfonts ) ) {
		weaverx_f_write( $sout, "/* Weaver Xtreme Plus Google Fonts Styles */\n" );
		foreach ( $gfonts as $gfont => $val ) {
			// $gfont has slug, $val has value array
			weaverx_f_write( $sout, ".font-{$gfont}{{$val['family']}}\n" );
		}
	}

// ======================= background areas ============================
	weaverx_f_write( $sout, "/* Weaver Xtreme Plus Background Images */\n" );
	$val = weaverx_getopt( '_bg_fullsite_url' );
	if ( $val != '' ) {
		weaverx_f_write( $sout,
			"html {background: url($val) no-repeat center center fixed; -webkit-background-size:cover;
-moz-background-size:cover;-o-background-size:cover;background-size:cover;}
body {background-color:transparent;}\n" );
		weaverx_f_write( $sout,
			".ie8 body { background-image: url('$val'); background-repeat:repeat;background-position:top left;background-attachment:fixed;}\n" );
	}
	weaverx_bgimg_style( $sout, '_bg_body_url', 'body' );
	weaverx_bgimg_style( $sout, '_bg_wrapper_url', '#wrapper' );
	weaverx_bgimg_style( $sout, '_bg_header_url', '#header' );

	weaverx_bgimg_style( $sout, '_bg_container_url', '#container' );
	weaverx_bgimg_style( $sout, '_bg_content_url', '#content' );
	weaverx_bgimg_style( $sout, '_bg_page_url', '#content .page' );
	weaverx_bgimg_style( $sout, '_bg_post_url', '#content .type-post' );
	weaverx_bgimg_style( $sout, '_bg_widgets_primary_url', '#primary-widget-area' );
	weaverx_bgimg_style( $sout, '_bg_widgets_secondary_url', '#secondary-widget-area' );
	weaverx_bgimg_style( $sout, '_bg_footer_url', '#colophon' );

}

function weaverx_bgimg_style( $sout, $id, $name ) {
	$val = weaverx_getopt( $id );
	if ( $val != '' ) {
		$fixid = str_replace( '_url', '', $id );
		$rpt = weaverx_getopt( $fixid . '_rpt' );
		$added = weaverx_getopt( $fixid . '_rpt_cssx' );
		if ( strlen( $rpt ) < 6 ) {
			$rpt = 'repeat';
		}  // set to default
		weaverx_f_write( $sout, $name . '{background-image:url(' . apply_filters( 'weaverx_css', parse_url( $val, PHP_URL_PATH ) ) . ");background-repeat:{$rpt};{$added}}\n" );
	}
}

/* INJECTION AREAS: (add UI with html_insertion action)
 *
 * footer - free
 * postfooter - free
 * prewrapper - free
 * preheader - free
 * header - free
 * -------------
 * premain
 * precontent
 * precomments
 * postcomments
 * postpostcontent
 * prefooter
 * premain
 * precontent
 * presidebar_left
 * presidebar_right
 */

//=============================================== THE CODE ============================================
//
// -- CONTENT AREA ACTIONS
//


// ------------------------------------------- <head> ----------------------------
function weaverxplus_do_head() {
// === include Google Fonts links

	$gfonts = weaverx_plus_getopt_array( 'fonts_added' );
	if ( ! empty( $gfonts ) ) {
		echo( "<!-- Weaver Xtreme Plus Google Fonts -->\n" );
		foreach ( $gfonts as $gfont ) {
			echo $gfont['link'] . "\n";
		}
	}
}

function weaverxplus_post_header() {
	weaverx_inject_area( 'postheader' );
}

add_action( 'weaverx_post_header', 'weaverxplus_post_header' );

add_action( 'wp_enqueue_scripts', 'weaverxplus_stylesheet', 999 );

function weaverxplus_stylesheet() {
	if ( ! weaverx_use_inline_css( weaverx_get_css_filename() ) ) { // don't generate inline CSS
		$vers = weaverx_getopt( 'style_version' );
		if ( ! $vers ) {
			$vers = '1';
		} else {
			$vers = sprintf( "%d", $vers );
		}
		wp_register_style( 'weaverxp-style-sheet', weaverx_get_css_url(), array( 'weaverx-style-sheet' ), $vers );
		wp_enqueue_style( 'weaverxp-style-sheet' );
	}
}

// ------------------------------------------- <footer> ----------------------------
function weaverxplus_do_postfooter() {
// right after #wrapper end
	if ( ! empty( $GLOBALS['wvrx_extra_menu_scripts'] ) ) {        // output scripts for any extra menus
		echo "<script type='text/javascript'> <!-- extra menus -->\n";
		foreach ( $GLOBALS['wvrx_extra_menu_scripts'] as $script ) {
			echo $script . "\n";
		}
		echo "</script>\n";
	}
}

// ------------------------------------------- Post Meta Info Lines -----------------

add_filter( 'weaverx_posted_in', 'weaverxplus_posted_in_filter', 10, 2 );
add_filter( 'weaverx_posted_on', 'weaverxplus_posted_on_filter', 10, 2 );


function weaverxplus_posted_on_filter( $po, $type ) {

	if ( ( $my_on = weaverx_getopt( 'custom_posted_on_single' ) ) != '' && $type == 'single' ) {
		return weaverxplus_post_info_line( $my_on );
	}

	if ( ( $my_on = weaverx_getopt( 'custom_posted_on' ) ) != '' && $type != 'single' ) {
		return weaverxplus_post_info_line( $my_on );
	}

	return $po;
}

function weaverxplus_posted_in_filter( $pi, $type ) {

	if ( ( $my_in = weaverx_getopt( 'custom_posted_in_single' ) ) != '' && $type == 'single' ) {
		$in = weaverxplus_post_info_line( $my_in );
		$in .= weaverx_edit_link( 'noecho' );

		return $in;
	}
	if ( ( $my_in = weaverx_getopt( 'custom_posted_in' ) ) != '' && $type != 'single' ) {
		$in = weaverxplus_post_info_line( $my_in );
		$in .= weaverx_edit_link( 'noecho' );

		return $in;
	}

	return $pi;
}


if ( ! function_exists( 'weaverxplus_post_info_line' ) ) {
	function weaverxplus_post_info_line( $info ) {
		// build a custom info line based on template in info
		/*
		%date%, %date-icon%, %author%, %author-icon%, %author-avatar%, %tag%, %tag-icon%, %tag:Label-if-are-tags%, %category%, %category-icon%,
		%comments%, %comments-icon%, %permalink%, %permalink-icon% (just the icon) $permalink:Permalink-text% %title% %post-format% %time%
		*/

		$out = $info;
		/* translators: used between list items, there is a space after the comma */
		$categories_list = get_the_category_list( __( ', ', 'weaver-xtreme-plus' ) );
		$cats = '';
		if ( $categories_list ) {
			$cats .= '<span class="cat-links">' . $categories_list . '</span>';
		} // End if categories

		/* translators: used between list items, there is a space after the comma */
		$tags_list = get_the_tag_list( '', __( ', ', 'weaver-xtreme-plus' ) );
		$tags = '';
		if ( $tags_list ) {
			$tags .= '<span class="tag-links">' . $tags_list . '</span>';
		} // End if categories

		$date = sprintf( '<a href="%s" title="%s" rel="bookmark"><time class="entry-date" datetime="%s" pubdate>%s</time></a>',
			esc_url( get_permalink() ),
			esc_attr( get_the_time() ),
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ) );
		$time = sprintf( '<time class="entry-time">%s</time>', esc_html( get_the_time() ) );

		$author = sprintf( '<span class="author vcard by-author"><a class="url fn n" href="%s" title="%s" rel="author">%s</a></span></span>',
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			sprintf( esc_attr( __( 'View all posts by %s', 'weaver-xtreme-plus' ) ), get_the_author() ),
			esc_html( get_the_author() ) );

		$author_name = esc_html( get_the_author() );

		$avatar = '<span class="post-avatar post-avatar-tiny"> ' .
		          get_avatar( get_the_author_meta( 'user_email' ), 22, null, 'avatar' ) . '</span>';

		$author_email = '<a href="mailto:' . esc_html( get_the_author_meta( 'user_email' ) ) . '">' . esc_html( get_the_author() ) . '</a>';

		$comments = '';
		$comments_icon = '';
		// need to strip these
		$com0 = weaverxplus_get_info_arg( 'comments0', $out );
		$out = weaverxplus_replace_info_text( 'comments0', $out, false );     // strip it out now
		if ( ! $com0 ) {
			$com0 = apply_filters( 'weaverxplus_comment_reply', __( 'Leave a reply', 'weaver-xtreme-plus' ) );
		}

		$com1 = weaverxplus_get_info_arg( 'comments1', $out );
		$out = weaverxplus_replace_info_text( 'comments1', $out, false );     // strip it out now
		if ( ! $com1 ) {
			$com1 = apply_filters( 'weaverxplus_comment_reply', __( '<b>1</b> Reply', 'weaver-xtreme-plus' ) );
		}

		$com2 = weaverxplus_get_info_arg( 'comments2', $out );
		$out = weaverxplus_replace_info_text( 'comments2', $out, false );     // strip it out now
		if ( ! $com2 ) {
			$com2 = apply_filters( 'weaverxplus_comment_reply', __( '<b>%</b> Replies', 'weaver-xtreme-plus' ) );
		}
		if ( comments_open() ) {    // fix with custom wording...

			// -------------------------------------------------------

			global $wpcommentspopupfile, $wpcommentsjavascript;
			$clink = '';
			$id = get_the_ID();
			$number = get_comments_number( $id );

			if ( post_password_required() ) {
				$clink .= __( 'Enter your password to view comments.', 'weaver-xtreme-plus' );
			} else {
				$clink .= '<a href="';
				if ( $wpcommentsjavascript ) {
					if ( empty( $wpcommentspopupfile ) ) {
						$home = home_url();
					} else {
						$home = get_option( 'siteurl' );
					}
					$clink .= $home . '/' . $wpcommentspopupfile . '?comments_popup=' . $id .
					          '" onclick="wpopen(this.href); return false"';
				} else { // if comments_popup_script() is not in the template, display simple comment link
					if ( 0 == $number ) {
						$clink .= get_permalink() . '#respond';
					} else {
						$clink .= get_comments_link();
					}
					$clink .= '"';
				}

				$title = the_title_attribute( array( 'echo' => 0 ) );

				$clink .= ' title="' . esc_attr( sprintf( __( 'Comment on %s', 'weaver-xtreme-plus' ), $title ) ) . '">';
				if ( $number > 1 ) {
					$ltext = $com2;
				} elseif ( $number == 0 ) {
					$ltext = $com0;
				} else {   // must be one
					$ltext = $com1;
				}
				$ltext = str_replace( '#', '%', $ltext );
				$clink .= str_replace( '%', number_format_i18n( $number ), $ltext ) . '</a>';
			}

			// ========================================================

			$comments .= '<span class="comments-link-text">' . $clink . '</span>';

			$comments_icon = str_replace( 'comments-link-text', 'comments-link-icon', $comments );
			$out = weaverxplus_replace_info_text( 'comments', $out, true );       // add conditional text for tags
		} // End if comments_open()

		$out = weaverxplus_replace_info_text( 'comments', $out, false );  // strip comments: if still there

		$title = esc_html( get_the_title() );

		$permalink_text = weaverxplus_get_info_arg( 'permalink', $out ); // alt permalink wording
		if ( ! $permalink_text ) {
			$permalink_text = __( 'permalink', 'weaver-xtreme-plus' );
		}

		$out = weaverxplus_replace_info_text( 'permalink', $out, false ); // strip it out now

		$permalink = '<span class="permalink"><a href="' . esc_url( get_permalink() ) . '" title="Permalink to ' .
		             $title . '" rel="bookmark">' . $permalink_text . '</a></span>';
		$permalink_icon = '<span class="permalink-icon"><a href="' . esc_url( get_permalink() ) . '" title="Permalink to ' .
		                  $title . '" rel="bookmark">' . $permalink_text . '</a></span>';

		$out = str_replace( '%date%', $date, $out );
		$out = str_replace( '%date-icon%', '<span class="entry-date-icon">&nbsp;</span>', $out );
		$out = str_replace( '%time%', $time, $out );
		if ( $author ) {
			$out = str_replace( '%author%', $author, $out );
			$out = str_replace( '%author-icon%', '<span class="by-author-icon">&nbsp;</span>', $out );
		} else {
			$out = str_replace( '%author%', '', $out );
			$out = str_replace( '%author-icon%', '', $out );
		}
		if ( $author_name ) {
			$out = str_replace( '%author-name%', $author_name, $out );
		} else {
			$out = str_replace( '%author-name%', '', $out );
		}
		if ( $cats ) {
			$out = str_replace( '%category%', $cats, $out );
			$out = str_replace( '%category-icon%', '<span class="cat-links-icon">&nbsp;</span>', $out );
		} else {
			$out = str_replace( '%category%', '', $out );
			$out = str_replace( '%category-icon%', '', $out );
		}
		if ( $tags ) {
			$out = str_replace( '%tag%', $tags, $out );
			$out = str_replace( '%tag-icon%', '<span class="tag-links-icon">&nbsp;</span>', $out );
			$out = weaverxplus_replace_info_text( 'tag', $out, true );    // add conditional text for tags
		} else {
			$out = str_replace( '%tag%', '', $out );
			$out = str_replace( '%tag-icon%', '', $out );
			$out = weaverxplus_replace_info_text( 'tag', $out, false );   // clean if no tags
		}
		$out = str_replace( '%avatar%', $avatar, $out );
		$out = str_replace( '%author-email%', $author_email, $out );
		$out = str_replace( '%permalink%', $permalink, $out );
		$out = str_replace( '%permalink-icon%', $permalink_icon, $out );
		$out = str_replace( '%comments%', $comments, $out );
		$out = str_replace( '%comments-icon%', $comments_icon, $out );
		$out = str_replace( '%title%', $title, $out );
		$out = str_replace( '%post-format%', get_post_format(), $out );
		$out = str_replace( '%day%', esc_attr( get_the_date( 'j' ) ), $out );
		$out = str_replace( '%day0%', esc_attr( get_the_date( 'd' ) ), $out );
		$out = str_replace( '%weekday%', esc_attr( get_the_date( 'l' ) ), $out );
		$out = str_replace( '%month%', esc_attr( get_the_date( 'F' ) ), $out );
		$out = str_replace( '%month0%', esc_attr( get_the_date( 'm' ) ), $out );
		$out = str_replace( '%month3%', esc_attr( get_the_date( 'M' ) ), $out );
		$out = str_replace( '%month-num%', esc_attr( get_the_date( 'n' ) ), $out );
		$out = str_replace( '%year%', esc_attr( get_the_date( 'Y' ) ), $out );

		return do_shortcode( $out );
	}
}

if ( ! function_exists( 'weaverxplus_replace_info_text' ) ) {
	function weaverxplus_replace_info_text( $name, $text, $do_replace ) {
		// replace with text or delete
		$out = $text;
		$start = strpos( $out, '%' . $name . ':' );
		if ( $start === false ) {
			return $out;
		}            // nothing to do
		$rest = substr( $out, $start + strlen( $name ) + 2 );   // rest of the string
		$endmark = strpos( $rest, '%' );               // where the % ends
		$string = substr( $rest, 0, $endmark );         // the string
		$rep = ( $do_replace ) ? $string : '';

		return str_replace( '%' . $name . ':' . $string . '%', $rep, $out );
	}
}

if ( ! function_exists( 'weaverxplus_get_info_arg' ) ) {
	function weaverxplus_get_info_arg( $name, $text ) {
		// get the value
		$out = $text;
		$start = strpos( $out, '%' . $name . ':' );
		if ( $start === false ) {
			return '';              // nothing to do
		}
		$rest = substr( $out, $start + strlen( $name ) + 2 );   // rest of the string
		$endmark = strpos( $rest, '%' );               // where the % ends
		$string = substr( $rest, 0, $endmark );         // the string

		return $string;
	}
}

// Enable font size & font family selects in the editor
function weaverxplus_mce_buttons( $buttons ) {
	array_unshift( $buttons, 'fontselect' ); // Add Font Select
	array_unshift( $buttons, 'fontsizeselect' ); // Add Font Select

	return $buttons;
}

// Theme not yet loaded, so need to fetch directly

$weaverx_opts = apply_filters( 'weaverx_switch_theme',
	get_option( apply_filters( 'weaverx_options', 'weaverx_settings' ), array() ) );

if ( ! isset( $weaverx_opts['_hide_editor_font_selection'] ) || ! $weaverx_opts['_hide_editor_font_selection'] ) {
	add_filter( 'mce_buttons_2', 'weaverxplus_mce_buttons' );
	add_filter( 'tiny_mce_before_init', 'weaverxplus_mce_google_fonts_array' );
	add_action( 'admin_init', 'weaverxplus_mce_google_fonts_styles' );
}

// Add custom Fonts to the Fonts list
function weaverxplus_mce_google_fonts_array( $initArray ) {
	//print_r($initArray);
	$fonts = '';
	$gfonts = weaverx_plus_getopt_array( 'fonts_added' );
	if ( ! empty( $gfonts ) ) {
		foreach ( $gfonts as $gfont ) {
			$fam = trim( str_replace( array( 'font-family:', "'", '"', ';' ), '', $gfont['family'] ) );
			$fonts .= $gfont['name'] . '=' . $fam . ';';
		}
	}

	// These are the default Weaver Xtreme Web Fonts - replace default tinyMCE fonts
	$initArray['font_formats'] = $fonts .
	                             "Open Sans=Open Sans,sans-serif;Open Sans Condensed=Open Sans Condensed,sans-serif;Alegreya Sans=Alegreya Sans,sans-serif;Archivo Black=Archivo Black,sans-serif;Droid Sans=Droid Sans,sans-serif;Exo 2=Exo 2,sans-serif;Lato=Lato,sans-serif;Roboto=Roboto,sans-serif;Roboto Condensed=Roboto Condensed,sans-serif;Source Sans Pro=Source Sans Pro,sans-serif;Arial=Arial,Helvetica,sans-serif;Arial Black=Arial Black,Helvetica,sans-serif;Arial Narrow=Arial Narrow,Arial,sans-serif;Impact=Impact,Arial Narrow Bold,sans-serif;Lucida Sans=Lucida Sans,Geneva,sans-serif;Trebuchet MS=Trebuchet MS,Tahoma,sans-serif;Verdana=Verdana,Geneva,sans-serif;Alegreya=Alegreya,serif;Arvo=Arvo,serif;Droid Serif=Droid Serif,serif;Lora=Lora,serif;Roboto Slab=Roboto Slab,serif;Source Serif Pro=Source Serif Pro,serif;Vollkorn=Vollkorn,serif;Times New Roman=TimesNewRoman,Times New Roman,serif;Cambria=Cambria,serif;Garamond=Garamond,TimesNewRoman,serif;Georgia=Georgia,Times,serif;Lucida Bright=Lucida Bright,Georgia,serif;Palatino=Palatino Linotype,Palatino,serif;Courier=Courier New,Courier,monospace;Consolas=Consolas,monospace;Inconsolata=Inconsolata,monospace;Papyrus=Papyrus,cursive,serif;Comic Sans MS=Comic Sans MS,cursive,serif;Handlee=Handlee,cursive;Ultra=Ultra,serif";

	$initArray['fontsize_formats'] = '6px 8px 9px 10px 11px 12px 13px 14px 15px 16px 18px 20px 22px 24px 28px 32px 48px 72px';

	return $initArray;
}


// Add Google Fonts for use with the editor
function weaverxplus_mce_google_fonts_styles() {
	if ( ! function_exists( 'weaverx_plus_getopt_array' ) ) {
		return;
	}
	//  Google Fonts links


	$gfonts = weaverx_plus_getopt_array( 'fonts_added' );
	if ( ! empty( $gfonts ) ) {
		foreach ( $gfonts as $gfont ) {
			$link = str_replace( 'href =', '', $gfont['link'] ); // try to fix a few things
			$href = stripos( $link, 'href=' );  // might be other things before href=
			if ( $href === false ) {
				continue;
			}
			$link = trim( substr( $link, $href + 5 ) ); // delete href= and all before
			if ( ! isset( $link[0] ) ) {
				continue;
			}
			$end = $link[0];    // allow either ' or " wrap
			if ( $end != "'" && $link != '"' ) {
				continue;
			}
			$url = '';
			if ( ! isset( $link[1] ) ) {
				continue;
			}
			for ( $i = 1; isset( $link[ $i ] ) && $link[ $i ] != $end; $i ++ ) {
				$url .= $link[ $i ];
			}
			//weaverx_alert('styles:' . $url);
			add_editor_style( str_replace( ',', '%2C', $url ) );
		}
	}
}

//add_action( 'admin_init', 'weaverxplus_mce_google_fonts_styles' );
?>
