<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
/**
 *   The template for displaying Author Archive pages.
 */
/*! ** DO NOT EDIT THIS FILE! It will be overwritten when the theme is updated! ** */

weaverx_set_cur_page_id( 0 );    // no page for this type

$sb_layout = weaverx_page_lead( 'author' );

// and next the content area.
weaverx_sb_precontent( 'author' );

// generate page content

if ( have_posts() ) {

	/* Queue the first post, that way we know
	* what author we're dealing with ( if that is the case ).
	*
	* We reset this later so we can run the loop
	* properly with a call to rewind_posts().
	*/
	the_post();
	// translators: %s author's URL
	$msg = apply_filters( 'weaverx_author_archives', esc_html__( 'Author Archives: %s', 'weaver-xtreme' ) );

	$titlew = '<span class="author-title-label">' . sprintf( $msg,
			'</span><span class="vcard archive-info"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( "ID" ) ) ) .
			'" title="' . esc_attr( get_the_author() ) . '" rel="me">' . esc_html( get_the_author() ) . '</a></span>' ); ?>


	<header class="page-header archive-title">
		<?php weaverx_archive_title( $titlew, 'author', ' author' ); ?>
	</header>

	<?php
	/* Since we called the_post() above, we need to
	* rewind the loop back to the beginning that way
	* we can run the loop properly, in full.
	*/
	rewind_posts();

	weaverx_content_nav( 'nav-above' );

	weaverx_author_info();

	/* The Loop */
	weaverx_archive_loop( 'author' );

	weaverx_content_nav( 'nav-below' );

} else {
	weaverx_not_found_search(  );
}

weaverx_sb_postcontent( 'author' );

weaverx_page_tail( 'author', $sb_layout );    // end of page wrap
