<?php

// # Weaver X-Plus SW Globals ==============================================================
$weaverxplus_opts_cache = false;  // internal cache for all settings


// ===============================  options =============================

function weaverxplus_getopt( $opt ) {
	global $weaverxplus_opts_cache;
	if ( ! $weaverxplus_opts_cache ) {
		$weaverxplus_opts_cache = get_option( 'weaverxplus_settings', array() );
	}

	if ( ! isset( $weaverxplus_opts_cache[ $opt ] ) )    // handles changes to data structure
	{
		return false;
	}

	return $weaverxplus_opts_cache[ $opt ];
}

function weaverxplus_isset( $name ) {
	global $weaverxplus_opts_cache;
	if ( ! $weaverxplus_opts_cache ) {
		$weaverxplus_opts_cache = get_option( 'weaverxplus_settings', array() );
	}

	return isset( $weaverxplus_opts_cache[ $name ] );
}

function weaverxplus_setpost_checkbox( $name ) {
	if ( isset( $_POST[ $name ] ) ) {
		weaverxplus_setopt( $name, 'checked' );
	} else {
		weaverxplus_setopt( $name, false );
	}
}

function weaverxplus_setopt( $opt, $val, $save = true ) {
	global $weaverxplus_opts_cache;
	if ( ! $weaverxplus_opts_cache ) {
		$weaverxplus_opts_cache = get_option( 'weaverxplus_settings', array() );
	}

	$weaverxplus_opts_cache[ $opt ] = $val;

	if ( $save ) {
		weaverxplus_update_opts();
	}
}


function weaverxplus_clear_opts() {
	global $weaverxplus_opts_cache;
	$weaverxplus_opts_cache = false;
	if ( current_user_can( 'manage_options' ) ) {
		delete_option( 'weaverxplus_settings' );
	}
}


function weaverxplus_update_opts() {
	global $weaverxplus_opts_cache;
	if ( current_user_can( 'manage_options' ) ) {
		update_option( 'weaverxplus_settings', $weaverxplus_opts_cache );
	}
}

function weaverxplus_default_int( $value, $min, $max, $default = '' ) {
	if ( ! is_numeric( $value ) || ! is_int( (int) $value ) ) {
		return $default;
	} else {
		if ( $value == '' || (int) $value < $min || (int) $value > $max ) {
			return $default;
		} else {
			return $value;
		}
	}
}

function weaverxplus_default_dec( $value, $min, $max, $default = '' ) {
	if ( ! is_numeric( $value ) ) {
		return $default;
	} else {
		if ( $value == '' || $value < $min || $value > $max ) {
			return $default;
		} else {
			return $value;
		}
	}
}

function weaverxplus_save_msg( $msg ) {
	echo '<div id="message" class="updated fade"><p><strong>' . $msg .
	     '</strong></p></div>';
}

function weaverxplus_error_msg( $msg ) {
	echo '<div id="message" class="updated fade" style="background:#F88;"><p><strong>' . $msg .
	     '</strong></p></div>';
}


// =============================== transient options =============================

if ( ! function_exists( 'weaverxplus_globals' ) ) {
	function weaverxplus_globals( $glb ) {
		return isset( $GLOBALS[ $glb ] ) ? $GLOBALS[ $glb ] : '';
	}
}

if ( ! function_exists( 'weaverxplus_t_set' ) ) {
	function weaverxplus_t_set( $opt, $val ) {
		$GLOBALS['weaverx_temp_opts'][ $opt ] = $val;
	}
}

if ( ! function_exists( 'weaverxplus_t_get' ) ) {
	function weaverxplus_t_get( $opt ) {
		return isset( $GLOBALS['weaverx_temp_opts'][ $opt ] ) ? $GLOBALS['weaverx_temp_opts'][ $opt ] : '';
	}
}

if ( ! function_exists( 'weaverxplus_t_clear' ) ) {
	function weaverxplus_t_clear( $opt ) {
		unset( $GLOBALS['weaverx_temp_opts'][ $opt ] );
	}
}

if ( ! function_exists( 'weaverxplus_t_clear_all' ) ) {
	function weaverxplus_t_clear_all() {
		unset( $GLOBALS['weaverx_temp_opts'] );
	}
}


function weaverxplus_help_link( $ref, $label ) {
	$url = plugins_url( 'help/' . $ref, __FILE__ );
	$help = '<a style="text-decoration:none;" href="' . esc_url( $url ) . '" target="_blank" title="' . $label . '">'
	        . '<span style="color:red; vertical-align: middle; margin-left:.25em;" class="dashicons dashicons-editor-help"></span>' . '</a>';
	echo( $help );
}

//======================================== runtime support filteres and actions ===============


remove_filter( 'weaverx_xtra_type', 'weaverx_xtra_type_filter' );
add_filter( 'weaverx_xtra_type', 'weaverxplus_xtra_type_filter' );

function weaverxplus_xtra_type_filter( $type ) {
	if ( $type[0] == '+' ) {
		return substr( $type, 1 );
	}

	return $type;
}

add_action( 'get_header', 'weaverxplus_get_header_action' );
function weaverxplus_get_header_action() {

	if ( function_exists( 'weaverx_getopt' ) ) {
		$code = weaverx_getopt( '_phpactions' );
		if ( $code ) {
			eval( $code );
			/*			ob_start();
						$code  .= ';';
						$err_level = error_reporting(0);
						if(version_compare(PHP_VERSION, '5.0.0', '>')) {
							try { eval($code); } catch(Exception $e) {}
						} else {
							eval($code);
						}
						$out = ob_get_clean();

						error_reporting($err_level);
						echo $out;
			*/
		}
	}
}

add_action( 'widgets_init', 'weaverxplus_widgets_init', 11 );

function weaverxplus_widgets_init() {
	// Header Horizontal Widget area

}

function weaverxplus_add_shortcode( $sc, $func ) {
	add_shortcode( $sc, $func );
}

function weaverxplus_show_help() {
	?>
	<div style="clear:both;"></div>
	<div class="a-plus">
		<br/>
		<span style="color:blue;font-weight:bold; font-size: larger;"><b>Weaver Xtreme Plus Help</b></span>&nbsp;
		<?php weaverxplus_help_link( 'plus-help.html', 'Help for Weaver Xtreme Plus plugin' ); ?>
		<p>Click the red ? to view the full Weaver Xtreme Plus help document.</p>
		<br/>
		<h3 style="color:green;text-decoration:underline;">Shortcode Summary</h3>
		<ul>
			<li><strong><code>[buttons start='first-to-show' end='last-to-show' list='1,3,2' wrap='div']</code></strong></li>
			<li><strong><code>[extra_menu menu_name='Menu Name' menu_style='menu-options' menu_type='accordion' class='your-class']</code></strong></li>
			<li><strong><code>[feed feed='url' items=10 show_sitename=0 show_content=1 feed_content=0 excerpt=0 trusted=0 title_style='' target='']</code></strong></li>
			<li><strong><code>[parallax img='url' height=400 class='custom-class']Slide Content[/parallax]</code></strong></li>
			<li><strong><code>[php]php code[/php]</code></strong></li>
			<li><strong><code>[popup_link href='url' h='height-px' w='width_px']link-content-text/image[/popup_link]</code></strong></li>
			<li><strong><code>[search class=your_class max_width=nn size=nn]</code></strong></li>
			<li><strong><code>[shortcoder id="myname" v1="optional-replacement" ... v9="replacement"]</code></strong></li>
			<li><strong><code>[showhide start='hide' show='html-on-show' hide='html-on-hide']text[/showhide]</code></strong></li>
			<li><strong><code>[social font_size=nn number='showcount' tag='wrap-tag' color=#000000]</code></strong></li>
			<li><strong><code>[widget_area area='area-name' area_style='area-style-name' class='alt-class-name' style='inline-style-rules']</code></strong></li>
		</ul>
		<h3 style="color:green;text-decoration:underline;">Widget Summary</h3>
		<ul>
			<li>Weaver X-Plus Menu - add menus in a widget</li>
			<li>Weaver X-Plus Link Buttons - show buttons in widget</li>
			<li>Weaver X-Plus Social Buttons - show social buttons in widget</li>
		</ul>
		<h3 style="color:green;text-decoration:underline;">Release Notes</h3>
		<pre>
= Version 2.2 =
* Tweak: Will now load custom CSS file after other plugins (with Weaver Xtreme 2.2 or later)
* Update: New Per Page / Per Post handling - requires Weaver Theme Support Plugin now
* Update: directions for adding Google Fonts using new Google interface
* Update: updated to new EDD api
* Fix: PHP version issue with Smart Menu JS output
* Fix: PHP 7 compatibility tweaks

</pre>
	</div>
	<?php
}

/*
    ================= nonce helpers =====================
*/
function weaverxplus_submitted( $submit_name ) {
	// do a nonce check for each form submit button
	// pairs 1:1 with weaverxplus__nonce_field
	$nonce_act = $submit_name . '_act';
	$nonce_name = $submit_name . '_nonce';

	if ( isset( $_POST[ $submit_name ] ) ) {
		if ( isset( $_POST[ $nonce_name ] ) && wp_verify_nonce( $_POST[ $nonce_name ], $nonce_act ) ) {
			return true;
		} else {
			die( "WARNING: invalid form submit detected ($submit_name). Probably caused by session time-out, or, rarely, a failed security check. Please contact WeaverTheme.com if you continue to receive this message." );
		}
	} else {
		return false;
	}
}

// admin helpers

function weaverxplus_nonce_field( $submit_name, $echo = true ) {
	// pairs 1:1 with sumbitted
	// will be one for each form submit button

	return wp_nonce_field( $submit_name . '_act', $submit_name . '_nonce', $echo );
}

/*
    ================= form helpers =====================
*/

function weaverxplus_form_checkbox( $id, $desc, $br = '<br />' ) {
?>
<div style="display:inline-block;padding-left:2.5em;text-indent:-1.7em;"><label><input type="checkbox" name="<?php echo $id ?>" id="<?php echo $id; ?>"
			<?php checked( weaverxplus_getopt( $id ) ); ?> >&nbsp;
		<?php echo $desc . '</label></div>' . $br . "\n";
		}

		// lib functions needed for theme previewer to work...

		function weaverx_plus_esc_textarea( $text, $echo = true ) {
			if ( current_user_can( 'unfiltered_html' ) ) {
				$out = esc_textarea( $text );
			} else {
				$out = esc_textarea( stripslashes( $text ) );
			}
			if ( $echo ) {
				echo $out;
			} else {
				return $out;
			}
		}

		function weaverx_plus_getopt_array( $opt ) {
			if ( function_exists( 'weaverx_getopt' ) ) {
				$val = weaverx_getopt( $opt );
			}
			if ( ! isset( $val ) || ! $val ) {
				return array();
			}

			return unserialize( $val );
		}

		//======================= runtime support: shortcode code ===============
		require_once( dirname( __FILE__ ) . '/weaver_xplus_social.php' ); // NOW - load the admin stuff
		//if (!weaverxplus_getopt('_wii_hide_shortcoder'))	// Shortcoder
		require_once( dirname( __FILE__ ) . '/weaver_xplus_code_shortcoder.php' );
		?>
