<?php
if ( !defined('ABSPATH')) exit; // Exit if accessed directly
/*
Weaver X Shortcodes Admin - admin code

This code is Copyright 2011 by Bruce E. Wampler, all rights reserved.
This code is licensed under the terms of the accompanying license file: license.txt.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/


function weaverxplus_extramenus_admin() {
?>
    <label><span style="color:blue;font-weight:bold; font-size: larger;"><b>Extra Menus [extra_menu]</b></span></label>&nbsp;
<?php weaverxplus_help_link('plus-help.html#extra_menus','Help for [extra_menu]'); ?>
<p><strong><code>[extra_menu menu_name='Menu Name' menu_style='menu-options' menu_type='accordion' class='your-class']</code></strong></p>
<ol>
  <li><strong>menu_name=</strong> - Which custom menu to display as defined in the Appearance : Menus admin page.<br />
    </li>
    <li><strong>menu_style=</strong> - Menu styled using one of 5 styles: <strong>extra, primary, secondary, header_mini, or none</strong>, Horizontal and Vertical menus use a subset of style options if extra, primary, or secondary specified.
    <br />
    </li>
    <li><strong>menu_type=</strong> - Type of menu to display: <strong>standard, accordion, vertical, or horizontal</strong> <br />
    </li>
    <li><strong>class=</strong> - If you specify a class, the class will be added to the container that wraps the menu. You can define the style using the Custom CSS option.</li>
</ol>
<p><strong>Weaver Xtreme Plus Extra Menu Widget</strong> - Display an extra menu in
the widget. The [extra_menu] parameters described above are included as drop-down selection boxes in the widget option box on the Widgets admin page.</p>
<p><strong style="color:red;">NOTE FOR CUSTOMIZER OPTIONS</strong> - Due to some technical limitations with how "Live Preview" of options
is handled by the Customizer, option changes involving the Text and Background colors of some Extra Menus will not
update properly when using the Customizer. They will display correctly from a standard browser view. We chose this approach
so that options for the standard menus will live update, which is an important feature.</p>
<?php
}


function weaverxplus_widgetarea_admin() {
?>
    <label><span style="color:blue;font-weight:bold; font-size: larger;"><b>Widget Area - [widget_area]</b></span></label>&nbsp;
<?php weaverxplus_help_link('plus-help.html#widget_areas','Help for [widget_area]'); ?>

    <p><strong><code>[widget_area area='area-name' area_style='area-style-name' class='alt-class-name' style='inline-style-rules']</code></strong></p>

<ol>
    <li><strong>area='area-name'</strong> - Name of the new widget area as defined in the Per Page Widget Areas - e.g., 'widget_area'.</li>
    <li><strong>area_style='area-style-name'</strong> - Styling from one of the standard Weaver Xtreme widget areas. These include: <em>top</em>, <em>bottom</em>, <em>header</em>, <em>footer</em>, <em>primary</em>, or <em>secondary</em>. </li>
    <li><strong>class='alt-class-name'</strong> - A extra class name added to the widget area's wrapping div. </li>
    <li><strong>style='inline-style-rules'</strong> - Added  inline style to wrap the widget area. For example:
    <code>style="your-rules;"</code>.
     </li>
    </ol>
<p>The <code>[widget_area]</code> shortcode allows you display a new widget area anywhere on a post or page.</p>
<?php
}


/*
Weaver Xtreme Plus Social Buttons - Version 1.0
*/
function weaverxplus_social_admin() {
?>
<label><span style="color:blue;font-weight:bold; font-size: larger;"><b>Social Buttons [social]</b></span></label>&nbsp;
<?php weaverxplus_help_link('plus-help.html#social_buttons','Social Buttons help'); ?>

<p><code>[social font_size=nn number='showcount' tag='wrap-tag' color=#000000 class=classname names=list,of,names]</code></p>
<p>
    <ol>
        <li><strong>font_size</strong> - Font-size of the icon (in px, don't include px). Will use text default font-size if not specified.</li>
        <li><strong>number</strong>< - Number if icons to show. Displayed in order specified on options below.</li>
        <li><strong>tag</strong> - If specified, each icon is wrapped with this HTML tag.</li>
        <li><strong>color</strong> - If specified, icon will be displayed with this color (including :hover). Otherwise, uses theme link colors.</li>
        <li><strong>class</strong> - a class name to wrap the entire group of social icons displayed</li>
        <li><strong>names</strong> - comma separated, ordered list of names of social icon to display, even if Use not checked.</li>
    </ol>
</p>

<p>The <code>[social]</code> shortcode allows you to add Social site buttons with links to your account or page.</p>

<p>To display social buttons,
check the "Use" checkbox for buttons you want to show. You must provide the full URL to your account link. For example: <code>http://facebook.com/wpweaver</code>.
You can specify the display order in the <em>Display Order</em> column using the WordPress ordering method used
to order your static pages: 10,15,30, etc. Lower numbers display first - they don't have to be sequential.
</p>
<p>
You can also use the <strong>names</strong> parameter to specify a list of icons to display, even if Use is not checked.
These will be displayed in the order listed. You still must provide the account link.
</p>
<p>
You can also change the "Social Site Description", which is the text displayed when the user hovers over the icon.
</p>
<p>Social buttons are really Genericons Font Icons, and are thus a "text" character link, and will be displayed using
the link color options specified for the location you use the social fonts - either via the shortcode or in a widget.
This also means the size of the social icons are controlled by the normal text font-size. The Social Widget, however,
is set to 36px by default, but can be overridden with custom CSS using the .weaverxplus_social class on the widget.</p>

<p style="font-size:small;font-style:italic;"><strong>A note about the URL:</strong> The exact form of the URL you add
for each button will depend on the service in question. Almost all of these services allow you to set up an account,
and then provide a URL address for other people to view your account's public page.</p>
<p>
<small>Note: you can click a service's icon on the list to open the site's main home page if you want
to learn more about a particular service.</small>
</p>
<form name="weaverxplus_linkbuttonoptions_form" method="post">
		<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="Save Social Buttons"/>

<br />
		<fieldset class="options">
		<br /><strong style="color:blue;">Social Button Options</strong><br />
			<br />
<?php
	weaverxplus_social_show_list();
?>
		<br />
		</fieldset>
		<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="Save Social Buttons"/>
		<input type="hidden" name="weaverxplus_save_social" value="Weaver Social Buttons Saved" />
		<?php weaverx_nonce_field('weaverx_plus_save_button'); ?>
</form>
<?php
}

function weaverxplus_social_show_list() {
	global $weaverxplus_social_services;

	$soc = weaverxplus_init_social();

	$baseurl = trailingslashit(get_template_directory_uri());  /* from codex example */
?>
	<div>
		<table class='even-odd'>
			<tr>
				<td><strong><small>Use</small></strong></td>
				<td style="text-align:center;font-weight:bold;"><small>Display<br />Order</small></td>
                <td></td>
				<td style="font-weight:bold;"><small>Social Site Description</small></td>
				<td style="font-weight:bold;"><small>Full URL link to your account</</td>
				<td style="font-weight:bold;"><small>Stay on<br />page</</td>
                <td>&nbsp;Name</td>
			</tr>
<?php
	$i = 1;
	foreach ( $weaverxplus_social_services as $service) {
		if ($i++ & 1) $rowbg = '#eee';
		else $rowbg = 'transparent';
		echo("<tr style=\"background:$rowbg;\">\n");


		$id = $service['icon'];
		if (!isset($soc[$id . '_use'])) $soc[$id . '_use'] = '';
		if (!isset($soc[$id . '_url'])) $soc[$id . '_url'] = '';
		if (!isset($soc[$id . '_order']))  $soc[$id . '_order'] = '';
		if (!isset($soc[$id . '_hover'])) $soc[$id . '_hover'] = '';
		if (!isset($soc[$id . '_stay'])) $soc[$id . '_stay'] = '';
		if (!isset($soc[$id . '_custom'])) $soc[$id . '_custom'] = '';
?>
	<td style="padding:5px;">
		<input type="checkbox" name="<?php echo $id ?>_use" id="<?php echo $id ?>_use" <?php echo ($soc[$id . '_use'] ? "checked" : ""); ?> />
	</td>
	<td style="padding:5px;">
		<input type="text" name="<?php echo $id ?>_order" id="<?php echo $id ?>_order"  style="width:50px;height:20px;" class="regular-text" value="<?php weaverx_plus_esc_textarea($soc[$id . '_order']); ?>" />
	</td>

<?php

		$img = "<span style='font-size:24px;color:black;' class='genericon genericon-{$id}'></span>";

		if ( $service['site'][0] == '#') {      // special case - no link
			echo '<td style="padding:5px;">' . $img . '</td>' . "\n";
			echo '<td style="width:340px;padding-left:10px; padding-right:10px;">';
?>
<input type="text" name="<?php echo $id ?>_hover" id="<?php echo $id ?>_hover"  style="width:340px;height:20px;" class="regular-text" value="<?php weaverx_plus_esc_textarea($soc[$id . '_hover']); ?>" /></td>
<?php
		} else {
			echo '<td style="padding:5px;"><a style="text-decoration:none;" href="//' . $service['site'] . '" target="_blank">' . $img . '</td>' . "\n";
?>
			<td style="width:340px;padding-left:10px; padding-right:10px;"><input type="text" name="<?php echo $id ?>_hover" id="<?php echo $id ?>_hover"  style="width:340px;height:20px;" class="regular-text" value="<?php weaverx_plus_esc_textarea($soc[$id . '_hover']); ?>" /></td>
<?php
			// echo '<td style="width:340px;padding-left:10px; padding-right:10px;">' . $service['blurb'] . "</td>\n";
		}
?>
	<td style="padding:5px;">
<?php
		if ( $service['site'][0] == '#') {      // special case - no link
		   echo ( substr($service['site'],1) . '<br />');
		}
?>
		<input type="text" name="<?php echo $id ?>_url" id="<?php echo $id ?>_url"  style="width:280px;height:20px;" class="regular-text" value="<?php weaverx_plus_esc_textarea($soc[$id . '_url']); ?>" />
	</td>
	<td style="padding:5px;">
		<input type="checkbox" name="<?php echo $id ?>_stay" id="<?php echo $id ?>_stay" <?php echo ($soc[$id . '_stay'] ? "checked" : ""); ?> />
	</td>
    <td>&nbsp;<?php echo $id;?>&nbsp;</td>

<?php

		echo ("</tr>\n");
	} // end foreach
?>
		</table>
	</div>

<?php
}



// ------------------- hide/show ---------------
function weaverxplus_showhide_admin() {
?>
<span style="color:blue;font-weight:bold; font-size: larger;">Show/Hide - [showhide]</span>
<?php weaverxplus_help_link('plus-help.html#showhide','Show/Hide help'); ?>

<p><code>[showhide]Content to show/hide[/showhide]</code></p>

<p>The <code>[showhide]</code> shortcode allows you to specify a
section of content that the user can selectively show or hide. It will be hidden by default.</p>

<p>Typically, one would place the shortcode immediately after some explanatory text. For example:<br /><br />
<code>Click to view lyrics [showhide]<br />
&nbsp;lyrics<br />
&nbsp;[/showhide]</code><br /><br />

When entered into the Page/Post editor as shown above, the explanatory text and show/hide button will be on a separate line,
and the content in a new paragraph following. If you place the <code>[showhide]CONTENT[/showhide]</code> on
the same line in the page/post editor, the explanatory text and content will be displayed on the same line.
</p>

<p><strong>Shortcode usage:</strong> <code>[showhide start='hide' show='html-on-show' hide='html-on-hide']text[/showhide]</code>
<br />
<ol>
	<li><strong>start='hide|show'</strong> - By default, the content will start hidden. Set this to 'show' to have the
	content start displayed.
	</li>
	<li><strong>show='img|text'; hide='img|text'</strong> - By default, a graphic + and - will be displayed to
	toggle between hidden and displayed. You can provide an alternative pair of images (just the image URL) or text strings. You can't mix
	images and text - both must be the same type. You can't use '[' or ']' in the text.
	</li>
</ol>
</p>
<p>The show and hide text/images are wrapped by a &lt;span&gt; with a class '.weaverx_showhide_show' and '.weaverx_showhide_hide', respectively.<p>

<?php
}


function weaverxplus_has_php() {return true;}
function weaverxplus_php_admin() {
?>
<span style="color:blue;font-weight:bold; font-size: larger;">
PHP - [php]</span> <?php weaverxplus_help_link('plus-help.html#php_code','PHP shortcode help'); ?></p>

<p><code>[php]php code[/php]</code></p>

<p>The <code>[php]</code> shortcode allows you to use php within a page, post, or text widget.</p>

<p><strong>Shortcode usage:</strong> <code>[php]php code[/php]</code>
<br />
The [php] and [/php] act like &lt;?php and ?&gt;. The PHP code is executed using the
PHP <em>exec()</em> function and any resulting output added to the HTML page. If your PHP has any errors,
or your system has exec() disabled, there will be no output.</p>
<p>
<span style="color:red;"><strong>Important note:</strong></span> If your php code
spans multiple lines (i.e., you use the Enter key), then you <em>must</em> use the HTML editor view,
<em>and</em> check the Raw HTML per page option in the page/post editor screen.
Short PHP snippets on just one line will work from either the HTML or Visual editors.
</p>
<form name="weaverxplus_php_form" method="post">
        <p><input type="checkbox" name="wvrxp_enable_p" id="wvrxp_enable_p" <?php echo (weaverxplus_getopt('wvrxp_enable_p') ? "checked" : ""); ?> />
        <strong>For site security reasons, you must check this to enable the [php] shortcode.</strong></p>
		<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="Save PHP Option"/>
		<input type="hidden" name="weaverxplus_save_php" value="PHP Option Saved" />
		<?php weaverx_nonce_field('weaverx_plus_save_button'); ?>
</form>

<?php
}

function weaverxplus_save_php() {
    // only one option...
    if (isset($_POST['wvrxp_enable_p'])) {
        weaverxplus_setopt('wvrxp_enable_p', 'checked', true);
    }
	else
        weaverxplus_setopt('wvrxp_enable_p', false, true);
    echo '<div id="message" class="updated fade"><p><strong>PHP Enabled/Disabled</strong></p></div>';
}


// ------------------------------ weaverxplus_popup ------------------------------------------
function weaverxplus_has_popup_link() {return true;}

function weaverxplus_popup_link_admin() {
?>
<span style="color:blue;font-weight:bold; font-size: larger;">Popup Link - [popup_link]</span>
<?php weaverxplus_help_link('plus-help.html#popup_link','Popup Link help'); ?></p>

<p><code>[popup_link href='url' h='height-px' w='width_px']link-content-text/image[/popup_link]</code></p>

<p>The <code>[popup_link]</code> shortcode allows you to display any web-address in a "popup" new browser window.
The power of this is that you can display content such as help, media, or whatever, in a new browser window
while the visitor continues to browser you site.</p>

<p><strong>Shortcode usage:</strong> <code>[popup_link href='url' h='height-px' w='width_px' scrollbars=false]link-content-text/image[/popup_link]</code>
<br />
<ol>
	<li><strong>link-content-text/image</strong> - This shortcodes works much like a standard &lt;a&gt; tag. The content
	between the beginning and closing shortcode tags will be displayed to identify the popup link. Just like with a regular
	&lt;a> tag, the link content can be an image or regular text. Note that this shortcode is fairly simple minded, and
	simply opens a minimally sized browser window. It does not use fancy JavaScript or Flash to accomplish the goal.
	</li>

	<li><strong>href=</strong> - The 'href' works just like the 'href' in a regular &lt;a> tag - it is the full url of a page
	you want displayed in a new browser window. This can be an external web page, or an internal site page. One of the
	intended uses of the <em>Weaver Pop Up Page Template</em> is to serve as a target for this shortcode. When you create a
	'Pop Up' page, and also check the 'Hide Entire Header', 'Hide Entire Footer', 'Hide Sidebars', and 'Hide Page on
	the Primary Menu' per page options, the page will be displayed only with the content you enter into the page
	content area with the page editor. This content could be an image, a media player, or whatever you want.
	</li>
	<li><strong>h=</strong> - The desired height of the popup window. Most browsers will honor this size request, but
	not all browsers do (Chrome has minimum window sizes at the moment, for example). This height should correspond to
	the exact height of your popup content. Most current browsers also will leave their top bar and other parts
	displayed along with your content.
	</li>
	<li><strong>w=</strong> - The desired width of the popup window. Like the 'h' value, some browsers have minimum display sizes.
	</li>
	<li><strong>scrollbars=false</strong> - Use scrollbars=true if you want scrollbars on the popup on all browsers.</li>
	</ol>
</p>

<?php
}

/* -------------- search --------------- */

function weaverxplus_has_search() {return true;}
function weaverxplus_search_admin() {
?>
<span style="color:blue;font-weight:bold; font-size: larger;">Search Form - [search]</span>
<?php weaverxplus_help_link('plus-help.html#search_form','Search Form help'); ?></p>
<p>The <code>[search]</code> shortcode allows you to display a search box within a page, post, or text widget.</p>
<p><strong>Shortcode usage:</strong> <code>[search button=1 class=your_class max_width=nn size=nn]</code>
</p>
<p>
<ol>
    <li><strong>button</strong> - if set to 1 or true, will add "Search" button to right of input area</li>
    <li><strong>class</strong> - a custom class name to wrap the search form</li>
    <li><strong>max_width</strong> - the maximum width in percent of the search form (Default: 90)</li>
    <li><strong>size</strong> - size of the form input area in characters (Default: 40)</li>
</ol>
</p>
<?php
}

// ------------------------------ weaverxplus_feed ------------------------------------------

function weaverxplus_has_feed() {return true;}

function weaverxplus_feed_admin() {
?>
<span style="color:blue;font-weight:bold; font-size: larger;">Show Feed - [feed]</span> <?php weaverxplus_help_link('plus-help.html#show_feed','Show Feed help'); ?>
<p><code>[feed feed='url' items=10 show_sitename=0 show_content=1 excerpt=0 feed_content=0 trusted=0 title_style='' target='_self']</code></p>

<p>The <code>[feed]</code> short code allows you to display an RSS or Atom feed from an external source.</p>

<p><strong>Shortcode usage:</strong> <br />
<code>[feed feed='url' items=10 show_sitename=0 show_content=1 feed_content=0 excerpt=0 trusted=0 title_style='']</code>
<br />
<ol>
	<li><strong>feed='url'</strong> - The url of the external feed.
	</li>
	<li><strong>items=10</strong> - By default, [feed] will display up to 10 items from the feed. Many feeds
	won't have even 10 items. You can limit the number of items displayed by providing a value between 1 and 20.
	</li>
	<li><strong>show_sitename=0|1</strong> - If set to '1', the feed will include an RSS icon with a link to the site's
	RSS feed, as well as the site's feed name. The default is '0', don't show the site name.
	</li>
	<li><strong>show_content=0|1</strong> - By default, the summary content of the feed will be included (1). If you
	include <code>show_content=0</code>, the site content will not be displayed.
	</li>
	<li><strong>excerpt=0|1</strong> - By default, the <em>summary</em> content of the feed will be displayed. This is usually
	short in feeds. If the default summary is too long, and you want the feed's content to be forced to be short, use <code>excerpt=1></code> which will
	force an excerpt.
	</li>
	<li><strong>feed_content=0|1</strong> - By default, the <em>summary</em> content of the feed will be displayed.
	If you want the feed's complete content to be displayed, including images, use <code>feed_content=1></code> which will
	force the full content to be displayed.
	</li>
	<li><strong>trusted=0|1</strong> - By default, [feed] won't trust external feeds - that means it will strip
	out any html from the feed content, and just show text. If you trust the feed, you can use <code>trusted=1</code>,
	and any HTML tags such as links will be retained.
	</li>
	<li><strong>target='_self'</strong> - Allows user to override standard target=_self value with new target such as _blank.
	</li>
	<li><strong>title_style='inline-style-rules'</strong> - Allows you to change the styling of the post title.
	Don't include the 'style=' or wrapping quotation marks. Do include a ';' at the end of each rule. The output will look like
	<code>style="your-rules;"</code> - using double quotation marks.
	This is most likely useful to reduce the title size (e.g., <code>style='font-size=95%;'</code>)
	</li>
	</ol>
</p>

<?php
}


function weaverxplus_parallax_admin() {
?>
<span style="color:blue;font-weight:bold; font-size: larger;">Parallax</span> <?php weaverxplus_help_link('plus-help.html#parallax','Show Feed help'); ?>
<p>
	Weaver Xtreme Plus supports the creation of Parallax based pages. Parallax pages are created using
	standard Posts or Weaver Show Sliders post types. There is a comprehensive tutorial in the Weaver Xtreme Plus
	help file. Click the red question mark above for more details.
</p>
<?php
}

// ------------------------------ weaverxplus_disclaimer ------------------------------------------

function weaverxplus_has_disclaimer() {return true;}

function weaverxplus_disclaimer_admin() {
?>
<span style="color:blue;font-weight:bold; font-size: larger;">Comment Policy / Disclaimer</span> <?php weaverxplus_help_link('plus-help.html#comment_policy','Comment Policy help'); ?>


<p>Comment Disclaimer allows you to display a disclaimer, other comment policy, or any thing else (including
shortcodes) right under the Post Comment button. Nothing will be displayed if the text box below is empty.</p>

	<form name="weaverxplus_disclaimer_form" method="post">
		<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="Save Comment Disclaimer Text"/>
		<br /><br />
		<fieldset class="options">
		<span style="font-weight:bold; color:blue;">Comment Policy / Disclaimer</span><br />
		<p>
			Enter text for you disclaimer. You can use basic HTML to format your disclaimer text. The HTML
			will be wrapped with &lt;div class="weaver-comment-disclaimer"> so you can add style
			using Weaver Xtreme's <em>Custom CSS Rules</em> option. While designed to
			add comment policy text, you can add anything you want, including shortcodes. Need a widget area after
			a comment block? Use the [widget_area] shortcode to add one.
		</p>
		<p>
			<textarea class="wvrx-edit" placeholder=" " name="disclaimer" rows=10 style="width: 90%"><?php weaverx_plus_esc_textarea(weaverxplus_getopt('disclaimer')); ?></textarea>
		</p>

		</fieldset>
		<br />
		<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="Save Comment Disclaimer Text"/>
		<input type="hidden" name="weaverxplus_save_disclaimer" value="Comment Disclaimer Saved" />
		<?php weaverx_nonce_field('weaverx_plus_save_button'); ?>
	</form>
	<hr />
<?php
}

function weaverxplus_save_disclaimer() {
	if (isset($_POST['disclaimer'])) {
		$val = $_POST['disclaimer'];
		if ($val == '')
			weaverxplus_setopt( 'disclaimer', '', true );
		else
			weaverxplus_setopt( 'disclaimer', weaverx_filter_textarea(stripslashes($_POST['disclaimer'])), true );
	}


	/* and let the user know something happened */
	echo '<div id="message" class="updated fade"><p><strong>Comment Disclaimer Text Saved</strong></p></div>';
}


// ------------------------------ weaverxplus_buttons ------------------------------------------

function weaverxplus_buttons_admin() {

	if (!weaverxplus_isset('buttons')) {
		weaverxplus_init_buttons();      // just in case!

	}
	$buttons = weaverxplus_getopt('buttons');
	$maxbuttons = $buttons['maxbuttons'];

?>
<div>
<label><span style="color:blue;font-weight:bold; font-size: larger;"><b>Link Buttons - [buttons] + Widget </b></span></label>&nbsp;
<?php weaverxplus_help_link('plus-help.html#link_buttons','Link Buttons help'); ?>


<p><code>[buttons start='first-to-show' end='last-to-show' list='1,3,2' wrap='div']</code></p>

<p>The <code>[buttons]</code> short code allows you to add image buttons with links.
You can specify which image to begin with (1 to <?php echo $maxbuttons;?>) with the 'start' parameter, and the same with the 'end'.
The defaults are start=1 and end=<?php echo $maxbuttons;?>, but images with no image URL defined won't be displayed.
You can specify different sets of images with different instances of the shortcode. You can style with <em>.weaver-buttons</em>.</p>

<p>If you specify a comma separated list with the 'list' parameter (e.g, <code>list='7,4,1,2'</code>), you can specify an
arbitrary set and order of buttons. If you do specify a 'list' parameter, then 'begin' and 'end' will be ignored.</p>
<p>The <code>wrap</code> parameter specifies the HTML tag used to
wrap the list of buttons. This will be 'div' by default, but 'span'
is useful for the menu bar HTML areas, and 'li' could be useful in some cases.</p>

<p>For each button you want to define, add a full URL to an image sized to the size you want your button to be.
It is best to keep the button image in your Media Library. Then add a hover message, and the complete URL to where the
button should link to (optional). Check the New Page box if you want the link to open a new tab or page when clicked.
</p>



<p>The defined buttons will be displayed in a horizontal list that will wrap when the width of the enclosing HTML block is reached.</p>

<p>If you want to use the shortcode to include buttons Buttons on your menu bar, add the [buttons] shortcode to the
<em>Main Options&rarr;Menus&rarr;(menu)&rarr;Left/Right HTML</em> option.
Use the <code>wrap='span'</code> parameter for the HTML areas.
</p>

<p><strong>Weaver Xtreme Plus Link Buttons Widget</strong> - When used in the <em>Weaver Xtreme Plus Link Buttons</em> widget, all buttons you've defined will be displayed using their actual size in the order defined. There are no other options for the widget version.
</p>
<br />
<form name="weaverxplus_linkbuttonoptions_form" method="post">
	<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="Save Link Buttons"/>

		<fieldset class="options">
<p>
	<strong>Number of images:&nbsp;</strong>
	<input type="text" name="maxbuttons" id="maxbuttons"  style="width:40px;height:20px;" class="regular-text" value="<?php echo esc_textarea($buttons['maxbuttons']); ?>" />
	&nbsp;&nbsp;<small>Enter number of buttons you need to define.</small>
</p>

<?php
	weaverxplus_buttons_show_list();
?>
	<br />
		</fieldset>
	<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="Save Link Buttons"/>
		<input type="hidden" name="weaverxplus_save_lbuttons" value="Weaver Link Buttons Options Saved" />

<?php 	weaverx_nonce_field('weaverx_plus_save_button'); ?>
</form>
</div>
<?php
}

function weaverxplus_buttons_show_list() {
	global $weaverxplus_buttons_services;

	if (!weaverxplus_isset('buttons')) {
		weaverxplus_init_buttons();      // just in case!
	}
	$buttons = weaverxplus_getopt('buttons');

	$baseurl = plugin_dir_url(__FILE__);  /* from codex example */
?>
	<div>
		<table class='even-odd'>
			<tr>
				<td style="font-weight:bold;padding:5px;"></td>
				<td style="font-weight:bold;padding:5px;"><small>Image</small></td>
				<td style="font-weight:bold;padding:5px;"><small>Button Image - Full URL <span style="font-weight:normal">(required)</span></small></td>
				<td style="font-weight:bold;padding:5px;"><small>Hover Text Description</small></td>
				<td style="font-weight:bold;padding:5px;"><small>Link - Full URL</</td>
				<td style="font-weight:bold;padding:5px;"><small>New<br />Page</small></td>
			</tr>
<?php

	for ( $i = 0 ; $i < $buttons['maxbuttons'] ; $i++) {
		if ($i & 1)
			echo("<tr>\n");
		else
			echo("<tr style=\"background:#eee;\">\n");
		$id = 'b' . $i;
?>
	<td>&nbsp;<?php echo $i+1;?>&nbsp;</td>
<?php
	if ( $buttons[$id.'_img_url'] == '') {      // special case - no link
		 echo '    <td style="padding:5px;"><img src="' . trailingslashit($baseurl) . 'images/default-button.png" alt="no link" /></td>' . "\n";
	} else {
		 echo '    <td style="padding:5px;"><img src="' . $buttons[$id . '_img_url'] . '" alt="button" /></td>' . "\n";
	}
?>
	<td>
		<input type="text" name="<?php echo $id ?>_img_url" id="<?php echo $id ?>_img_url"  style="width:240px;height:20px;" class="regular-text" value="<?php echo esc_textarea($buttons[$id . '_img_url']); ?>" /><?php //@@@ weaverx_media_lib_button($id . '_img_url'); ?>
	</td>
	<td style="width:200px;padding-left:10px; padding-right:10px;">
		<input type="text" name="<?php echo $id ?>_hover" id="<?php echo $id ?>_hover"  style="width:200px;height:20px;" class="regular-text" value="<?php echo esc_textarea($buttons[$id . '_hover']); ?>" />
	</td>

	<td style="padding:5px;">
		<input type="text" name="<?php echo $id ?>_link_url" id="<?php echo $id ?>_link_url"  style="width:240px;height:20px;" class="regular-text" value="<?php echo esc_textarea($buttons[$id . '_link_url']); ?>" />
	</td>
	<td style="padding:5px;">
		<input type="checkbox" name="<?php echo $id ?>_blank" id="<?php echo $id ?>_blank" <?php echo ($buttons[$id . '_blank'] ? "checked" : ""); ?> />
	</td>
<?php
	} // end for
?>
		</table>
	</div>

<?php
}

function weaverxplus_save_lbuttons() {


	if (!weaverxplus_isset('buttons')) {
	   weaverxplus_init_buttons();
	}

	$buttons = weaverxplus_getopt('buttons');

	if (isset($_POST['maxbuttons']) && $_POST['maxbuttons'] != $buttons['maxbuttons']) {
	   $buttons['maxbuttons'] = weaverxplus_default_int($_POST['maxbuttons'], 1, 64, 8);
	   weaverxplus_setopt('buttons', $buttons, true);
	   weaverxplus_init_buttons();
	   $buttons = weaverxplus_getopt('buttons');
	}
	$maxbuttons = $buttons['maxbuttons'];

	for ($i = 0 ; $i < $maxbuttons ; $i++) {
	   $id = 'b'.$i;
	   if (isset($_POST[$id.'_img_url'])) $buttons[$id.'_img_url'] = weaverx_filter_textarea(stripslashes($_POST[$id.'_img_url']));
	   if (isset($_POST[$id.'_hover'])) $buttons[$id.'_hover'] = weaverx_filter_textarea(stripslashes($_POST[$id.'_hover']));
	   if (isset($_POST[$id.'_link_url'])) $buttons[$id.'_link_url'] = weaverx_filter_textarea(stripslashes($_POST[$id.'_link_url']));
	   if (isset($_POST[$id.'_blank'])) $buttons[$id.'_blank'] = 'checked';
	   else $buttons[$id.'_blank'] = false;
	}
	weaverxplus_setopt('buttons', $buttons, true);

}

function weaverxplus_init_buttons() {
	// buttons opts are kept in an array saved in weaverxplus_plus: ['buttons']

	if (!weaverxplus_isset('buttons'))
	   $buttons = array();
	else
	   $buttons = weaverxplus_getopt('buttons');


	if (!isset($buttons['maxbuttons'])) $buttons['maxbuttons'] = WEAVERXPLUS_NUM_BUTTONS;

	for ($i = 0 ; $i < $buttons['maxbuttons'] ; ++$i) {
	   $id = 'b'.$i;
	   if (!isset($buttons[$id.'_img_url'])) $buttons[$id.'_img_url'] = '';
	   if (!isset($buttons[$id.'_hover'])) $buttons[$id.'_hover'] = '';
	   if (!isset($buttons[$id.'_link_url'])) $buttons[$id.'_link_url'] = '';
	   if (!isset($buttons[$id.'_blank'])) $buttons[$id.'_blank'] = false;
	}
	weaverxplus_setopt('buttons', $buttons, true);
}

// =======================================>>> Save/Restore <<<=================================
function weaverxplus_download_link($desc, $ext, $nonce, $time) {
	$downloader = plugins_url() . '/weaver-xtreme-plus/includes/downloader.php';
	$download_img_path = plugins_url() . '/weaver-xtreme-plus/includes/images/download.png';
	$filename = 'weaverx-settings-' . $time . '.' . $ext;
	$href = $downloader . "?_wpnonce={$nonce}&_ext={$ext}&_file={$filename}";
?>
	<a style="text-decoration: none;" href="<?php echo esc_url($href); ?>">
	<span class="download-link"><img src="<?php echo esc_url($download_img_path); ?>" />
	<?php _e('Download', 'weaver-xtreme-plus' /*adm*/); echo '</span></a> - ';
    echo $desc; echo ' &nbsp;';
	_e('Save as:', 'weaver-xtreme-plus' /*adm*/); echo ' ' . $filename . "<br /><br />\n";
}

function weaverxplus_save_restore() {

	$nonce = wp_create_nonce('weaverxplus_download');
	$time = date('Y-m-d-Hi');
?>
<br /><br /><br />
<h3 >
	<?php _e('Save Various Settings To Your Computer','weaver-xtreme-plus' /*adm*/); ?>
</h3>
<p>
	<?php _e('This option allows you to save various sets of options by downloading to your own computer.','weaver-xtreme-plus' /*adm*/); ?>
	<?php _e('<small>Note: "Theme" and "Backup" settings for Basic and X-Plus saved via Theme Options : Save/Restore.</small>','weaver-xtreme-plus' /*adm*/); ?>
	<br />
	<h4><em><?php _e('Download Various Options "Sets" To Your Computer','weaver-xtreme-plus' /*adm*/); ?></em></h4>
<?php
	weaverxplus_download_link( __('<strong>Save ALL Settings</strong> - Basic Weaver Xtreme, X-Plus, X-Plus Shortcodes, including &diams;, &star;, and &starf;.', 'weaver-xtreme-plus' /*adm*/),
		'wxall', $nonce, $time );
	weaverxplus_download_link( __('<strong>Save X-Plus Shortcodes</strong> - Weaver Xtreme Plus shortcode settings only.', 'weaver-xtreme-plus' /*adm*/),
		'wxplus', $nonce, $time );
	weaverxplus_download_link( __('<strong>Save HTML/Text</strong> - HTML, text, and custom widget widths.', 'weaver-xtreme-plus' /*adm*/),
		'wxtext', $nonce, $time );
	weaverxplus_download_link( __('<strong>Save Added Fonts</strong> - Fonts you have added.', 'weaver-xtreme-plus' /*adm*/),
		'wxfont', $nonce, $time );
	weaverxplus_download_link( __('<strong>Save Colors</strong> - Save color settings, <em>not</em> including CSS+.', 'weaver-xtreme-plus' /*adm*/),
		'wxcolor', $nonce, $time );
	weaverxplus_download_link( __('<strong>Save Colors and CSS+</strong> - Save color settings, <em>including</em> CSS+.', 'weaver-xtreme-plus' /*adm*/),
		'wxcolorcss', $nonce, $time );
	weaverxplus_download_link( __('<strong>Save &diams; Options</strong> - Site specific diamond options.', 'weaver-xtreme-plus' /*adm*/),
		'wxsite', $nonce, $time );
?>
</p>

<h3 >
	<?php _e('Restore Settings From Your Computer','weaver-xtreme-plus' /*adm*/); ?>
</h3>
<p>
<?php _e('This option allows you to restore various sets of options by uploading prefiously saved settings from your own computer. Option sets are determined by file extension as listed in the Save section above.','weaver-xtreme-plus' /*adm*/); ?>
<form enctype="multipart/form-data" action="<?php echo $_SERVER["REQUEST_URI"]; ?>" method="POST">
		<fieldset class="options">
<p>
	<?php _e('Select settings file to upload:','weaver-xtreme-plus' /*adm*/); ?> <input style="border:1px solid #ccc; width:400px;" name="plusuploaded" type="file" />
			<input type="hidden" name="plusuploadit" value="yes" />&nbsp;<?php _e('(Replaces current settings with those in settings file.)','weaver-xtreme-plus' /*adm*/); ?>
</p>

<?php
?>
	<br />
		</fieldset>
	<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="Restore Options from specified File"/>
		<input type="hidden" name="weaverxplus_save_do_restore" value="Weaver Options Restored" />
<?php 	weaverx_nonce_field('weaverx_plus_save_button'); ?>
</form>
<hr />
<p>
<?php _e('Click the following button to clear all the shortcode settings from Weaver Xtreme Plus. You can clear &starf;Plus options
on the Theme Options: Save/Restore tab.','weaver-xtreme-plus' /*adm*/); ?>
</p>
<form onSubmit="return confirm('<?php _e('Are you sure you want to reset Weaver Xtreme Plus Shortcode Options?','weaver-xtreme-plus' /*adm*/); ?>');" enctype="multipart/form-data" action="<?php echo $_SERVER["REQUEST_URI"]; ?>" method="POST">

<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="<?php _e('Clear Weaver Xtreme Plus Shortcode Options','weaver-xtreme-plus' /*adm*/); ?>"/>
		<input type="hidden" name="weaverxplus_save_do_clear" value="<?php _e('Weaver Shortcode Options Cleared','weaver-xtreme-plus' /*adm*/); ?>" />

<?php weaverx_nonce_field('weaverx_plus_save_button'); ?>
</form>
</p>
<?php
}

function weaverxplus_save_do_clear() {
	weaverxplus_clear_opts();
	weaverxplus_save_msg( __('Weaver Xtreme options set to uploaded options.','weaver-xtreme-plus' /*adm*/) );
}

function weaverxplus_save_do_restore() {

	if (!(isset($_POST['plusuploadit']) && $_POST['plusuploadit'] == 'yes')) return;

   // upload theme from users computer
	// they've supplied and uploaded a file

	$ok = true;     // no errors so far

	if (isset($_FILES['plusuploaded']['name']))
		$filename = $_FILES['plusuploaded']['name'];
	else
		$filename = "";

	if (isset($_FILES['plusuploaded']['tmp_name'])) {
		$openname = $_FILES['plusuploaded']['tmp_name'];
	} else {
		$openname = "";
	}

	//Check the file extension
	$check_file = strtolower($filename);
	$pat = '.';				// PHP version strict checking bug...
	$end = explode($pat, $check_file);
	$ext_check = end($end);


	if ($filename == "") {
		$errors[] = __('You didn\'t select a file to upload.','weaver-xtreme-plus' /*adm*/) . "<br />";
		$ok = false;
	}

	$exts = array('wxall','wxplus','wxtext','wxcolor','wxcolorcss','wxfont','wxsite');

	if ($ok && !in_array( $ext_check, $exts) ) {
		if ( in_array( $ext_check, array('wxb', 'wxt') ) )
		$errors[] = __("You must restore settings from '.wxb' and '.wxt' files from the Theme Options : Save/Restore tab.",
			'weaver-xtreme-plus' /*adm*/) . '<br />';
		else
			$errors[] = __("Setting files must have 'wxall', 'wxplus', 'wxtext', 'wxcolor', 'wxcolorcss', or 'wxsite' as extension.",
			'weaver-xtreme-plus' /*adm*/) . '<br />';
		$ok = false;
	}

		if ($ok) {
			if (!weaverx_f_exists($openname)) {
				$errors[] = '<strong><em style="color:red;">' .
__('Sorry, there was a problem uploading your file.
You may need to check your folder permissions or other server settings.','weaver-xtreme-plus' /*adm*/) .
'</em></strong><br />(' . __('Trying to use file','weaver-xtreme-plus' /*adm*/) . ' <em>' . $openname . '</em>)';
				$ok = false;
			}
		}
	if (!$ok) {
		echo '<div id="message" class="updated fade"><p><strong><em style="color:red;">' .
		__('ERROR','weaver-xtreme-plus' /*adm*/) . '</em></strong></p><p>';
		foreach($errors as $error){
			echo $error.'<br />';
		}
		echo '</p></div>';
	} else {    // OK - read file and save to My Saved Theme
		// $handle has file handle to temp file.
		$contents = weaverx_f_get_contents($openname);

		if ( ! weaverxplus_set_to_serialized_values($contents, $ext_check ) ) {
				echo '<div id="message" class="updated fade"><p><strong><em style="color:red;">' .
__('Sorry, there was a problem uploading your file.
The file you picked was not a valid Weaver Xtreme Plus settings file.','weaver-xtreme-plus' /*adm*/) .
'</em></strong></p></div>';
		} else {
			weaverxplus_save_msg( __('Weaver Xtreme options set to uploaded options set.','weaver-xtreme-plus' /*adm*/) );
		}
	}
}

function weaverxplus_set_to_serialized_values($contents, $ext)  {
	global $weaverx_opts_cache;	// need to mess with the cache

	$restore = array();
	$restore = unserialize($contents);

	if (!$restore) return weaverx_f_fail(__("Unserialize failed",'weaver-xtreme-plus' /*adm*/));

	if ($restore['header'] != 'WVRX-PLUS1' || $restore['ext'] != $ext)
		return weaverx_f_fail(__("Wrong settings file format version",'weaver-xtreme-plus' /*adm*/)); 	/* simple check for one of ours */

	$version = weaverx_getopt('weaverx_version_id');	// get something to force load opts_cache

	switch ($ext) {
		case 'wxall':		// everything!
			weaverx_delete_all_options();
			$opts = $restore['weaverx'];			// fetch base opts
			//if (isset($opts['fonts_added']) ) {
			//	$opts['fonts_added'] = serialize($opts['fonts_added']);
			//}
			foreach ($opts as $key => $val) {
				weaverx_setopt($key, $val, false);	// overwrite with saved values
			}

			weaverx_setopt('weaverx_version_id',$version); // keep version, force save of db
			weaverx_setopt('wvrx_css_saved','');
			weaverx_setopt('last_option','Weaver Xtreme');

			weaverxplus_clear_opts();
			$opts = $restore['weaverxplus'];		// fetch plus opts
			foreach ($opts as $key => $val) {
				weaverxplus_setopt($key, $val, false);	// overwrite with saved values
			}
			weaverxplus_update_opts();

			break;

		case 'wxplus':		// shortcode settings
			weaverxplus_clear_opts();
			$opts = $restore['weaverxplus'];		// fetch plus opts
			foreach ($opts as $key => $val) {
				weaverxplus_setopt($key, $val, false);	// overwrite with saved values
			}
			weaverxplus_update_opts();
			break;

		case 'wxfont':		// added fonts
			if ( isset($restore['wxfont']) ) {
				weaverx_setopt('fonts_added', $restore['wxfont']);
			}
			/* if really need to serialize
			if ( isset($restore['wxfont_array']) ) {
				$fonts = $restore['wxfont_array'];
				weaverx_setopt('fonts_added', serialize($fonts));
				weaverx_setopt('wvrx_css_saved','');
			}
			*/
			break;

		case 'wxtext':		// opts with text
			if ( isset( $restore['wxtext'] ) ) {
				$opts = $restore['wxtext'];			// fetch base opts
				foreach ($opts as $key => $val) {
					weaverx_setopt($key, $val, false);	// overwrite with saved values
				}
				weaverx_setopt('wvrx_css_saved','');
			}
			break;

		case 'wxcolor':		// colors only
			if ( isset( $restore['wxcolor'] ) ) {
				$opts = $restore['wxcolor'];			// fetch base opts
				foreach ($opts as $key => $val) {
					weaverx_setopt($key, $val, false);	// overwrite with saved values
				}
				weaverx_setopt('wvrx_css_saved','');
			}
			break;

		case 'wxcolorcss':	// colors + CSS+
			if ( isset( $restore['wxcolorcss'] ) ) {
				$opts = $restore['wxcolorcss'];			// fetch base opts
				foreach ($opts as $key => $val) {
					weaverx_setopt($key, $val, false);	// overwrite with saved values
				}
				weaverx_setopt('wvrx_css_saved','');
			}
			break;

		case 'wxsite':	// diamond options
			if ( isset( $restore['wxsite'] ) ) {
				$opts = $restore['wxsite'];			// fetch base opts
				foreach ($opts as $key => $val) {
					weaverx_setopt($key, $val, false);	// overwrite with saved values
				}
				weaverx_setopt('wvrx_css_saved','');
			}
			break;

		default:
			return false;
	}
	weaverx_save_opts('xplus',true);
	return true;
}
?>
