<?php
/*
Weaver X Theme Support - admin code

This code is Copyright 2011 by Bruce E. Wampler, all rights reserved.
This code is licensed under the terms of the accompanying license file: license.txt.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

require_once(dirname( __FILE__ ) . '/weaver_xplus_features_admin.php'); // NOW - load the admin stuff
require_once(dirname( __FILE__ ) . '/weaver_xplus_license.php' );

function weaverxplus_admin_page() {

    weaverxplus_submits();
	do_action('weaverxplus_check_license_options');
?>

<div class="atw-wrap">
    <h2>Weaver Xtreme Plus Administration - Version <?php echo WEAVER_XPLUS_VERSION;?>
	<span style="float:right;font-size:small;margin-left:1em;"><?php weaverxplus_check_licenses(); ?></span>
    <span style="float:right;color:white;background:#57A;padding:4px;font-weight:bold;font-size:14px;"><a href="<?php echo site_url('/wp-admin/themes.php?page=WeaverX'); ?>" style="color:white;text-decoration:none;">Weaver Xtreme Admin</a></span>
    </h2>
<br />
    <hr />
<p>This page provides option values and basic documentation for Weaver Xtreme Plus.
</p>

<p style="font-weight:bold;">You can get more complete help for any of these features by clicking the "Weaver Xtreme Plus Help" tab.</p>

<div id="tabwrap_plus" style="padding-left:5px;">
    <div id="tab-container-plus" class='yetiisub'>
	<ul id="tab-container-plus-nav" class='yetiisub'>

    <li><a href="#tab-extramenu" style="background:#D4FAC3;" title="Extra Menus"><?php echo(weaverxplus_t_('Extra Menus' )); ?></a></li>

	<li><a href="#tab-smartmenus" style="background:#D4FAC3;" title="smart Menus"><?php echo(weaverxplus_t_('SmartMenus' )); ?></a></li>

    <li><a href="#tab-linkbuttons" style="background:#D4FAC3;" title="Link Buttons - shortcode & widget"><?php echo(weaverxplus_t_('Link Buttons' /*a*/ )); ?></a></li>
    <li><a href="#tab-social" style="background:#D4FAC3;" title="Social Buttons"><?php echo(weaverxplus_t_('Social Buttons' )); ?></a></li>

    <li><a href="#tab-widgetarea" style="background:#FAFAAC;" title="Extra Widget Area"><?php echo(weaverxplus_t_('Widget Area' )); ?></a></li>
    <li><a href="#tab-shortcoder" style="background:#FAFAAC;" title="Shortcoder"><?php echo(weaverxplus_t_('Shortcoder' /*a*/ )); ?></a></li>
    <li><a href="#tab-search" style="background:#FAFAAC;" title="Search Form Shortcode"><?php echo(weaverxplus_t_('Search Form' /*a*/ )); ?></a></li>
    <li><a href="#tab-feed" style="background:#FAFAAC;" title="Show Feed Shortcode"><?php echo(weaverxplus_t_('Show Feed' /*a*/ )); ?></a></li>
    <li><a href="#tab-showhide" style="background:#FAFAAC;" title="Show/Hide Shortcode"><?php echo(weaverxplus_t_('Show/Hide Text' /*a*/ )); ?></a></li>
    <li><a href="#tab-popup" style="background:#FAFAAC;" title="Popup Link Shortcode"><?php echo(weaverxplus_t_('Popup Link' /*a*/ )); ?></a></li>
    <li><a href="#tab-php" style="background:#FAFAAC;" title="Include PHP Shortcode"><?php echo(weaverxplus_t_('PHP' /*a*/ )); ?></a></li>
	<li><a href="#tab-parallax" style="background:#FAFAAC;" title="Parallax"><?php echo(weaverxplus_t_('Parallax' /*a*/ )); ?></a></li>


    <li><a href="#tab-comment" style="background:#D6D9FF;" title="Comment Policy"><?php echo(weaverxplus_t_('Comment Policy' /*a*/ )); ?></a></li>

<?php
if (!is_multisite() || (is_multisite() && current_user_can('manage_network_themes')) ) {
?>
    <li style="clear:both;margin-left:60px;margin-top:3px;"><a href="#tab-register" style="background:#FFFF00;"><?php echo(weaverxplus_t_('Activate License Key' /*a*/ )); ?></a></li>
<?php
}
?>
    <li style="margin-top:3px;"><a href="#tab-saverestore" style="background:#FFFF00;"><?php echo(weaverxplus_t_('X-Plus Save/Restore' /*a*/ )); ?></a></li>
    <li style="margin-top:3px;"><a href="#tab-help" style="background:#FFFF00;"><?php echo(weaverxplus_t_('X-Plus Help' /*a*/ )); ?></a></li>


	</ul>
        <hr />

<?php   /* IMPORTANT - in spite of the id's, these MUST be in the correct order - the same as the above list... */
?>


        <div id="tab-extramenu" class="tab_plus" > <!-- Tab Group -->
<?php
            if (function_exists('weaverxplus_extramenus_admin')) {
                weaverxplus_extramenus_admin();
            }
?>
	</div>

<!-- ******* -->

        <div id="tab-smartmenus" class="tab_plus" > <!-- Smart Menus -->
<?php
            if (!function_exists('weaverxplus_smartmenus_admin')) {
                require_once('weaver_xplus_admin_smartmenus.php');
                weaverxplus_smartmenus_admin();
            }
?>
        </div>

<!-- ******* -->

        <div id="tab-linkbuttons" class="tab_plus" > <!-- Link Buttons -->
<?php
            if (function_exists('weaverxplus_buttons_admin')) {
                weaverxplus_buttons_admin();
            }
?>
	</div>

        <!-- ******* -->

    <div id="tab-social" class="tab_plus" > <!-- Tab Group -->
<?php
            if (function_exists('weaverxplus_social_admin')) {
                weaverxplus_social_admin();
            }
?>
	</div>


        <!-- ******* -->

        <div id="tab-widgetarea" class="tab_plus" > <!-- Tab Group -->
<?php
            if (function_exists('weaverxplus_widgetarea_admin')) {
                weaverxplus_widgetarea_admin();
            }
?>
	</div>


        <!-- ******* -->

        <div id="tab-shortcoder" class="tab_plus" > <!-- Shortcoder -->
<?php
            if (function_exists('weaverxplus_has_shortcoder')) {
                require_once('weaver_xplus_admin_shortcoder.php');
                weaverxplus_shortcoder_admin();
            }
?>
        </div>

        <!-- ******* -->


        <div id="tab-search" class="tab_plus" > <!-- Search -->
<?php
        if (function_exists('weaverxplus_has_search')) {
            weaverxplus_search_admin();
        }
?>
        </div>

        <!-- ******* -->

        <div id="tab-feed" class="tab_plus" > <!-- Show Feed -->
<?php
            if (function_exists('weaverxplus_feed_admin')) {
                weaverxplus_feed_admin();
            }
?>
        </div>

        <!-- ******* -->

        <div id="tab-showhide" class="tab_plus" > <!-- Show/Hide -->
<?php
            if (function_exists('weaverxplus_showhide_admin')) {
                weaverxplus_showhide_admin();
            }
?>
        </div>

        <!-- ******* -->

        <div id="tab-popup" class="tab_plus" > <!-- Popup Link -->
<?php
            if (function_exists('weaverxplus_has_popup_link')) {
                weaverxplus_popup_link_admin();
            }
?>
        </div>

        <!-- ******* -->

        <div id="tab-php" class="tab_plus" > <!-- PHP -->
<?php
            if (function_exists('weaverxplus_has_php')) {
                weaverxplus_php_admin();
            }
?>
        </div>

		<!-- ******* -->

        <div id="tab-parallax" class="tab_plus" > <!-- PHP -->
<?php
                weaverxplus_parallax_admin();
?>
        </div>


        <!-- ******* -->

        <div id="tab-comment" class="tab_plus" > <!-- Comment Policy -->
<?php
            if (function_exists('weaverxplus_has_disclaimer')) {
                weaverxplus_disclaimer_admin();
            }
?>
        </div>

        <!-- ******* -->
<?php
if (!is_multisite() || (is_multisite() && current_user_can('manage_network_themes')) ) {
?>
        <div id="tab-register" class="tab_plus" >      <!-- Help -->
        <br /><div style="clear:both;"></div><?php weaverxplus_show_licenses(); ?>
        </div>
<?php
} else {
	echo '<br /><div style="clear:both;"></div>';
}
?>
        <!-- ******* -->

        <div id="tab-saverestore" class="tab_plus" >      <!-- Help -->
        <?php weaverxplus_save_restore(); ?>
        </div>

        <!-- ******* -->

        <div id="tab-help" class="tab_plus" >      <!-- Help -->
        <?php weaverxplus_show_help(); ?>
        </div>

</div> <!-- #tabwrap_plus -->
<hr />
</div>

<script type="text/javascript">
	var tabber2 = new Yetii({
	id: 'tab-container-plus',
	tabclass: 'tab_plus',
	persist: true
	});
</script>


<?php
} // end weaverxplus_admin



function weaverxplus_t_($s) {
    return $s;
}



// ========================================= FORM DISPLAY ===============================

function weaverxplus_value_row($th,$id,$desc,$width='') {
    $style = '';
    if ($width != '') {
        $style = ' style="width:' . $width . ';"';
    }
?>
    <tr>
	<th scope="row" align="right"<?php echo $style . '>' . $th; ?>:&nbsp;</th>
	<td>
	    <input type="text" style="width:60px;height:22px;" class="regular-text" name="<?php echo $id; ?>"
                id="<?php echo $id; ?>" value="<?php weaverx_plus_esc_textarea(weaverxplus_getopt($id)); ?>" />
	</td>
	<td style="padding-left: 10px"><small><?php echo $desc; ?></small></td>
    </tr>
<?php
}


function weaverxplus_submits() {
    // process settings for plugin parts

    if (!weaverxplus_submitted('weaverx_plus_save_button')) {		// did they submit anything? weaverx_plus_save_button
        return;
    }

    $actions = array('weaverxplus_save_admin_opts','weaverxplus_save_settings','weaverxplus_restore_psettings',
        'weaverxplus_save_social', 'weaverxplus_save_php',
        'weaverxplus_save_lbuttons', 'weaverxplus_save_disclaimer',
        'weaverxplus_save_shortcoder',
		'weaverxplus_save_do_restore', 'weaverxplus_save_do_clear',
		'weaverxplus_save_smartmenus'

        );


    foreach ($actions as $functionName) {
		if ( isset($_POST[$functionName]) ) {
			// @@@@        weaverx_alert('submit:' . $functionName);
			if (function_exists($functionName)) {
				$functionName();
			}
		}
    }
}

require_once(dirname( __FILE__ ) . '/weaver_xplus_code_smartmenus.php');

?>
