<?php
if ( !defined('ABSPATH')) exit; // Exit if accessed directly
/*
Weaver Xtreme Plus SmartMenus

This code is Copyright 2011 by Bruce Wampler, all rights reserved.
This code is licensed under the terms of the accompanying license file: license.html.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

function weaverxplus_smartmenus_admin() {
?>
	<div>
    <label><span style="color:blue;font-weight:bold; font-size: larger;"><b>Smart Menus</b></span></label>&nbsp;
<?php weaverxplus_help_link('plus-help.html#smart-menus','SmartMenus help'); ?>

<p>Extra options for Smart Menus. These options apply only to SmartMenus, and not the default Weaver Xtreme menus. "Use SmartMenus"
must <em>also</em> be checked on the "Theme Options : Main Options : Menus" for each menu. Please see the information
in the Help file by clicking the red ? above.</p>

	<form name="weaverxplus_options_form" method="post">
	<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="Save Plus SmartMenus Options"/>
	<br />
		<fieldset class="options">
		<br /><h3 style="color:blue;">Define Settings for Smart Menus</h3>

		<?php
	if ( !weaverx_getopt('use_smartmenus')) {
		echo "<h3><em style='color:red;'>Warning!</em> 'Use SmartMenus' not checked on Menus theme settings tab.</h3>\n";
	}
?>
<?php
	weaverxplus_sm_opts('primary');
	weaverxplus_sm_opts('secondary');
	weaverxplus_sm_opts('extra');
?>
	<br />
	</fieldset>
	<br />
	<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="Save Plus Smart Menus Options"/>
	<input type="hidden" name="weaverxplus_save_smartmenus" value="Weaver Xtreme Plus Smart Menus Options Saved" />
	<?php weaverxplus_nonce_field('weaverx_plus_save_button'); ?>
	</form>
	<hr />
	</div>
<?php
}

function weaverxplus_sm_opts($menu) {

	if ($menu == 'secondary' )
        echo("<div style=\"width:99%;background:#eee;padding:8px;border-right:2px solid #eee;\">\n");
	else
        echo("<div style=\"width:99%;padding:8px;border:1px solid #ddd;\">\n");

	$opt = "sm-{$menu}";

?>

	<h3><em>Options for <?php echo ucfirst($menu);?> Menu</em></h3>

	<strong>Mobile Menu "Hamburger" Button</strong> -
	Any HTML allowed, including text and images. (Default: <em>&lt;span class="genericon genericon-menu"&gt;&lt;/span&gt;</em>)
	<br />
	<textarea name="<?php echo $opt . '-hamburger'; ?>" rows=1 style="width: 500px"><?php echo(weaverx_plus_esc_textarea(weaverx_getopt("m_{$menu}_hamburger"))); ?></textarea>

	<br /><br />

	<label><input type="checkbox" id="<?php echo($opt . '-downbelow'); ?>" name="<?php echo($opt . '-downbelow'); ?>"
<?php checked(weaverxplus_getopt("{$opt}-downbelow")); ?> /> Use centered down-arrow below main menu items.</label>
<br />

<label><input type="checkbox" id="<?php echo($opt . '-uparrow'); ?>" name="<?php echo($opt . '-uparrow'); ?>"
<?php checked(weaverxplus_getopt("{$opt}-uparrow")); ?> /> Use up-arrow on first level submenu.</label>
<br />
<span style="margin-left:2em;"></span>
<label><input type="checkbox" id="<?php echo($opt . '-uparrow-border'); ?>" name="<?php echo($opt . '-uparrow-border'); ?>"
<?php checked(weaverxplus_getopt("{$opt}-uparrow-border")); ?> /> Add border to up-arrow <small>(Recommended: Also check "Add Border to Submenus" on Main Options : Menus tab.)</small></label>

<br />
<span style="margin-left:2em;"></span>
<input type="text" name="<?php echo($opt . '-uparrow-x'); ?>" id="<?php echo($opt . '-uparrow-x'); ?>"  style="width:50px;height:20px;" class="regular-text" value="<?php weaverx_plus_esc_textarea(weaverxplus_getopt($opt . '-uparrow-x')); ?>" />px&nbsp;&nbsp;
Hoizontal offset from left side of up-arrow. (Default: 33px)


<br /><small>Note: checking the "Use up-arrow" option will add JavaScript to the option below if it is not set.
If you have set values, you should add the appropriate OffsetX/Y values to make room for the arrow.
Hint: If you just want to customize submenu widths or offsets, you can check "Use up-arrow" to copy
the default values to the Initialization box below, then uncheck the option and modify the values.</small>

	 <br /><br /><strong>SmartMenus JavaScript Initialization</strong> - Include JS array constant, enclosed in { and }.
	 Note: this is a very advanced option and require good understanding of JavaScript and the SmartMenus capabilities to be used effectively. More information in the Help file.<br />
	<textarea name="<?php echo $opt . '-js-opt'; ?>" rows=3 style="width: 700px"><?php echo(weaverx_plus_esc_textarea(weaverxplus_getopt($opt . '-js-opt'))); ?></textarea>

	<br>
<?php
	 echo("</div>\n");
}

?>
