<?php
if ( !defined('ABSPATH')) exit; // Exit if accessed directly
/*
Weaver Xtreme Plus Shortcoder

This code is Copyright 2011 by Bruce Wampler, all rights reserved.
This code is licensed under the terms of the accompanying license file: license.html.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

function weaverxplus_shortcoder_admin() {

	$num_imgs = weaverxplus_getopt('wvpsc_num_opts');
	if ($num_imgs < 1) {
		weaverxplus_setopt('wvpsc_num_opts',2);
		$num_imgs = 2;
	}
	?>

	<div>
    <label><span style="color:blue;font-weight:bold; font-size: larger;"><b>Shortcoder [shortcoder]</b></span></label>&nbsp;
<?php weaverxplus_help_link('plus-help.html#shortcoder','Shortcoder help'); ?>

<p><strong><code>[shortcoder id="myname" v1="optional-replacement" ... v9="replacement"]</code></strong></p>


	<p>This [shortcoder] shortcode allows you to define your own named shortcodes. These really serve as "macros" - an easy way
	to define constant text or other fixed content you would like to add to your pages, posts, or widget areas.
	The content you define can include other <em>shortcodes</em> and <em>basic HTML</em>, as well as <em>Raw HTML</em>
	or <em>Scripts</em> if you have the role permissions to do that.</p>

	<p>[shortcoder] supports nine (9) optional parameters, v1 to v9, that allow you to pass values to your shortcode
	definition text. The value of any parameter will replace the equivalent parameter specified as %v1% in your text.
	For example, if you had a shorcode "name" and definition text contained "My name is %v1%.", and you use the shortcode
	[shortcoder id="name" v1="Bruce"], the output included in your content would be "My name is Bruce." This allows
	you to use the same shortcode in different pages or posts and supply variable content.</p>

	<form name="weaverxplus_options_form" method="post">
	<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="Save Plus Shortcoder Options"/>
	<br />
		<fieldset class="options">
		<br /><strong style="color:blue;">Define Custom Shortcodes</strong>
		<p>You can add an arbitrary number of your own [shortcoder] definitions by id.</p>
		<?php
	for ($i = 1 ; $i <= $num_imgs ; ++$i) {
		weaverxplus_sc_add($i);
	}
?>
	<br /><strong>Custom shortcodes definitions allowed:</strong><input name="wvpsc_num_opts" id="wvpsc_num_opts" type="text" style="width:40px;height:20px;" class="regular-text" value="<?php weaverx_plus_esc_textarea(weaverxplus_getopt('wvpsc_num_opts')); ?>" />
	&nbsp;<small>Enter number of Shortcoder definitions you need (25 max).</small>
	</fieldset>
	<br />
	<input class="button-primary" type="submit" name="weaverx_plus_save_button" value="Save Plus Shortcoder Options"/>
	<input type="hidden" name="weaverxplus_save_shortcoder" value="Weaver Xtreme Plus Shortcoder Options Saved" />
	<?php weaverxplus_nonce_field('weaverx_plus_save_button'); ?>
	</form>
	<hr />
	</div>
	<div style="clear:both;"></div>
<?php
}

function weaverxplus_sc_add($i) {
	$opt_base = 'wvpsc_' . $i . '_';
	if ($i & 1)
        echo("<div style=\"width:99%;background:#eee;padding:4px;border-right:2px solid #eee;\">\n");
	else
        echo("<div style=\"width:99%;padding:4px;border:1px solid #ddd;\">\n");
?>

	<strong><em>Define Custom Shortcode</em></strong>
<?php
	if (weaverxplus_getopt($opt_base . 'id') != '')
		echo '&nbsp;&nbsp;To use, add <code>[shortcoder id="' . trim(weaverxplus_getopt($opt_base . 'id')) . '"]</code> wherever shortcodes are supported.' ;
?>
	<br /><div style="margin-left:12px;">
	<strong>Shortcode ID:</strong>
	<input name="<?php echo $opt_base . 'id'; ?>" id="<?php echo $opt_base . 'id'; ?>" type="text" style="width:100px;height:20px;" class="regular-text" value="<?php weaverx_plus_esc_textarea(weaverxplus_getopt($opt_base . 'id')); ?>" />
	&nbsp;<small>Enter an ID name for your shortcode - your choice (will be filtered to valid format)</small><br />
	<strong>Shortcode definition:</strong><br />
	<textarea name="<?php echo $opt_base . 'text'; ?>" rows=4 style="width: 600px"><?php echo(weaverx_plus_esc_textarea(weaverxplus_getopt($opt_base . 'text'))); ?></textarea>

	<br>
	</div>
<?php
	 echo("</div>\n");
}

?>
