<?php
//
// Weaver Xtreme Plus Admin Actions and Filters
//

add_action('weaverxplus_admin','weaverxplus_admin_actions');

function weaverxplus_admin_actions( $action ) {

	switch ($action) {
		// do_action('weaverxplus_admin','head_section');    // (admin-advancedopts.php) Advanced Opts: Advanced Opt: <HEAD> section, at bottom
		// do_action('weaverxplus_admin','html_insertion');  // (admin-advancedopts.php) HTML Insertion - at bottom
		// do_action('weaverxplus_admin','site_opts');       // (admin-advancedopts.php) Site Opts - at bottom
		// do_action('weaverxplus_admin','mobile_opts');     // (admin-advancedopts.php) - Mobile tab, at bottom
		// do_action('weaverxplus_admin','help');            // (admin-help.php) - Help tab, above Aspen Help list
		// do_action('weaverxplus_admin','general_appearance');  // (admin-mainopts.php) - General Appearance tab, at bottom
		// do_action('weaverxplus_admin','header_opts');     // (admin-mainopts.php) - at bottom of Main Options:Header
		// do_action('weaverxplus_admin','menu_bar');        // (admin-mainopts.php) - Menu tab, at bottom
		// do_action('weaverxplus_admin','links');           // (admin-mainopts.php) - Links tab, at bottom
		// do_action('weaverxplus_admin','content_areas');   // (admin-mainopts.php) - Content areas, at bottom
		// do_action('weaverxplus_admin','post_specifics');  // (admin-mainopts.php) - Post Specifics tab, at bottom
		// do_action('weaverxplus_admin','footer_opts');     // (admin-mainopts.php) - Footer tab, above Site Copyright
		// do_action('weaverxplus_admin','widget_areas');    // (admin-mainopts.php) - widget areas tab, at bottom
		// do_action('weaverxplus_admin','layout');          // (admin-mainopts.php) - Layout tab, at bottom
		// do_action('weaverxplus_admin','weaverxplus_admin'); // (admin-pro.php) - only called if pro installed, at bottom of Weaver Xtreme Plus page
		// do_action('weaverxplus_admin','save_restore');    // (admin-saverestore.php) - Save/Restore tab, near bottom, above Reset to default
		// do_action('weaverxplus_admin','show_subthemes');  // (admin-subthemes.php) - on Aspen Subthemes tab before visit our website
		// do_action('weaverxplus_admin','process_options'); // (admin-top.php) - to handle processing of options
		// do_action('weaverxplus_admin','admin_options');   // (admin-top.php) - Admin Opts, at bottom


		case 'weaverxplus_admin':
			weaverxplus_admin();
			break;

		case 'footer_opts':
			weaverxplus_footeropts();
			break;

		case 'fonts':
			weaverxplus_fonts_pro_admin();
			break;

		case 'general_appearance':
			weaverxplus_general_apperarance();
			break;

		case 'header_opts':
			weaverxplus_mainopts_header();
			break;

		case 'head_section':
			weaverxplus_actions_filters();       // Add arbitrary PHP to the
			break;

		case 'post_specifics':
			weaverxplus_post_specifics();
			break;

		case 'process_options':
			weaverxplus_process_options();
			break;

        case 'reset_weaverxplus':
            delete_option( 'weaverx_plus_backup' );
            weaverxplus_clear_opts();
            break;

        case 'save_restore':                    // add plus save/restore options (plus backup on deactivate)
            weaverxplus_save_restore_autobackup();
            break;

		case 'save_restore_files':
			weaverxplus_saverestore_files();
			break;

		case 'layout':
			weaverplus_layout();
			break;

		// cases with no Pro extensions

		case 'admin_options':
		case 'content_areas':
		case 'help':
		case 'html_insertion':      // use filter weaverxplus_html_inject_filter
		//case 'layout':
		case 'links':
		case 'menu_bar':
		case 'mobile_opts':
		//case 'process_options':     // process submitted options
		case 'show_subthemes':
		case 'site_opts':
		case 'widget_areas':
			break;

		default:
			//echo '<h3 style="background-color:#afa;border:2px solid green;"><strong>Weaver Xtreme Plus Admin: ' . $action . '</strong></h3>';
			break;
	}
}


function weaverxplus_update_options_action($opts) {
    // this adds a weaverx_plus_backup entry to the db to protect user from deactivating Pro, then saving from Free
    update_option('weaverx_plus_backup', $opts);
}

add_action('weaverxplus_update_options', 'weaverxplus_update_options_action' );

// =========================== filters ============================

add_filter('weaverxplus_html_inject', 'weaverxplus_html_inject_filter');

function weaverxplus_html_inject_filter($areas) {
	$new_areas = array (
		array('name'=>'', 'id'=>'submit', 'info' => '', 'help' => ''),

		array('name' => 'Additional Insertion Areas' . weaverxplus_pro_stamp(2), 'id' => 'pro_insert', 'info' => '', 'help' => ''),

        array ('name'=>'Pre Header', 'id'=>'preheader', 'info' =>
			'This code will be inserted just before the #header &lt;div&gt;. It will have the same width as the #wrapper area.
            This area may require extra styling to eliminate unwanted margins. (Area ID: #inject_preheader) (&star;Plus)',
			'help' => ''),

        array ('name'=>'Header Top', 'id'=>'header', 'info' =>
			'This code will be inserted at the top of the #header &lt;div&gt;, before the top menu. It will have the same width as the header area. (Area ID: #inject_header)  (&star;Plus)',
			'help' => ''),

		array ('name'=>'Post Header', 'id'=>'postheader', 'info' =>
			'This code will be inserted between the #header &lt;div&gt; and the #container &lt;div&gt;. It will have the same width as the #wrapper area. (Area ID: #inject_postheader)  (&star;Plus)',
			'help' => ''),

        array ('name'=>'Container Top', 'id'=>'container_top', 'info' =>
			'This code will be inserted inside the #container &lt;div&gt; that wraps content, including before the top widget areas. It will have the same width as the container area. (Area ID: #inject_container_top)  (&star;Plus)',
			'help' => ''),

		array ('name'=>'Pre Content', 'id'=>'postinfobar', 'info' =>
			'This code will be inserted between the #infobar &lt;div&gt and the #content &lt;div&gt; that wraps content, including before the top widget areas. It will have the same width as the container area. (Area ID: #inject_postinfobar))',
			'help' => ''),

		array ('name'=>'Content Top', 'id'=>'precontent', 'info' =>
			'This code will be inserted inside the #content div that wraps content. The width will be the same as the content and depends on sidebars defined. (Area ID: #inject_precontent) (&star;Plus)',
			'help' => ''),

        array ('name'=>'Page Content Bottom', 'id'=>'pagecontentbottom', 'info' =>
			'This code will be at the bottom of page (including post single page view and page with posts) content. It will have the same width as the content area. (Area ID: #inject_pagecontentbottom) (&star;Plus)',
			'help' => ''),

		array ('name'=>'Post-Post Content', 'id'=>'postpostcontent', 'info' =>
			'This code will be inserted after the content area of each post (not page). (Area class: .inject_postpostcontent) (&star;Plus)',
			'help' => ''),

		array('name'=>'', 'id'=>'submit', 'info' => '', 'help' => ''),

		array ('name'=>'Pre-Comments', 'id'=>'precomments', 'info' =>
			'This code will be inserted just before the #comments div where comments are displayed. If comments
are open for the page, this area will include the class <em>.precomments-comments</em>, if closed <em>.precomments-nocomments</em>. (Area ID: #inject_precomments) (&star;Plus)',
			'help' => ''),

		array ('name'=>'Post-Comments', 'id'=>'postcomments', 'info' =>
			'This code will be inserted right after the #comments div where comments are displayed. If comments
are open for the page, this area will include the class <em>.postcomments-comments</em>, if closed <em>.postcomments-nocomments</em>. (Area ID: #inject_postcomments) (&star;Plus)',
			'help' => ''),
		array ('name'=>'Pre-Footer', 'id'=>'prefooter', 'info' =>
			'This code will be inserted just before the footer #colophon div. (Area ID: #inject_prefooter) (&star;Plus)',
			'help' => ''),

		array('name'=>'', 'id'=>'submit', 'info' => '', 'help' => ''),

		array ('name'=>'Primary Sidebar Top', 'id'=>'presidebar',
'info' => 'This code will be inserted inside the primary sidebar area at the top. Not shown if no primary sidebar defined. (Area ID: #inject_presidebar) (&star;Plus)',
			'help' => ''),

        array ('name'=>'Fixed Browser Top', 'id'=>'fixedtop', 'info' =>
			'This code will be inserted in a fixed location at the top of the (non-IE8) desktop browser window. It will have the same width as the Wrapper Area. <em>You will need to add a Top Margin to the Wrapper Area.</em> Do not make this area too tall! (Area ID: #inject_fixedtop) (&star;Plus)',
			'help' => ''),
        array ('name'=>'Fixed Browser Bottom', 'id'=>'fixedbottom', 'info' =>
			'This code will be inserted in a fixed location at the bottom of the (non-IE8) desktop browser window. It will have the same width as the Wrapper Area. <em>You will need to add a Bottom Margin to the Wrapper Area.</em> Do not make this area too tall! (Area ID: #inject_fixedbottom) (&star;Plus)',
			'help' => ''),

	);
	return array_merge($areas,$new_areas);
}


add_filter('weaverxplus_menu_inject', 'weaverxplus_menu_inject_filter');

function weaverxplus_menu_inject_filter($areas) {

    $extra = array (
        array('name' => 'Extra Menu', 'id' => 'm_extra', 'type' => 'menu_opts',
		'info' => 'Style the [extra_menu] shortcode or Extra Menu Widget' . weaverxplus_pro_stamp(2))

    );
    return array_merge($areas, $extra);
}

//============================================================= THE CODE ========================================================
//
// -- Actions and Filters
//
function weaverxplus_actions_filters() {
?>
	<br />
<br />

	<div class="atw-option-header"><span style="color:black; padding:.2em;" class="dashicons dashicons-hammer"></span>Actions and Filters  <?php echo weaverxplus_pro_stamp(1); ?>
<?php weaverxplus_help_link('plus-help.html#ActionsFilters','Help for Actions and Filters');?></div><br />
	<p><strong>This Option for Advanced Users!</strong> You can add arbitrary PHP code here. This option is intended to allow
	you to add WordPress Actions and Filters to the Visitor View of your site. This PHP code is executed at the very
	beginning of the theme's header.php template file before any HTML is emitted.
	Do NOT bracket the code with &lt;?php and ?&gt; at the beginning and end.
	If your code doesn't seem to do anything, you probably have a PHP error. See the Help file for more technical details.</p>
<?php
	$php = stripslashes(wp_check_invalid_utf8(addslashes(weaverx_getopt('_phpactions'))));
	weaverx_textarea(weaverx_getopt('_phpactions'), '_phpactions', 2, __('/* php code */','weaver-xtreme-plus' /*adm*/), $style = 'width:95%;', $class='wvrx-edit', false);
}

// ========================================== MAIN OPTIONS : FOOTER =======================================
function weaverxplus_footeropts() {

}

// ========================================== MAIN OPTIONS : LAYOUT =======================================
function weaverplus_layout() {
	$opts = array(
		array('name' => __('Alternate Themes:', 'weaver-xtreme' /*adm*/), 'type' => 'note',
		'info' => __('Save Alternate Theme settings from the Save/Restore tab. They also can be used for Per Page Alternate Themes.', 'weaver-xtreme' /*adm*/)),
		array('name' => '<small>' . __('Blog Theme', 'weaver-xtreme' /*adm*/) . '</small>', 'id' => 'alt_theme_blog', 'type' => '+select_alt_theme',
		'info' => __('Alternate Theme for default blog. Does NOT include "Page with Posts". (&starf;Plus)', 'weaver-xtreme' /*adm*/),
		'value' => ''
	  ),
		array('name' => '<small>' . __('Post Single Page Theme', 'weaver-xtreme' /*adm*/) . '</small>', 'id' => 'alt_theme_single', 'type' => '+select_alt_theme',
		'info' => __('Alternate Theme for Post Single Page view. (&starf;Plus)', 'weaver-xtreme' /*adm*/),
		'value' => ''
	  ),array('name' => '<small>' . __('Attachments Theme', 'weaver-xtreme' /*adm*/) . '</small>', 'id' => 'alt_theme_attchment', 'type' => '+select_alt_theme',
		'info' => __('Alternate Theme for attachment pages. (&starf;Plus)', 'weaver-xtreme' /*adm*/),
		'value' => ''
	  ),array('name' => '<small>' . __('Date Archive Theme', 'weaver-xtreme' /*adm*/) . '</small>', 'id' => 'alt_theme_archive', 'type' => '+select_alt_theme',
		'info' => __('Alternate Theme for archive by date pages. (&starf;Plus)', 'weaver-xtreme' /*adm*/),
		'value' => ''
	  ),array('name' => '<small>' . __('Category Archive Theme', 'weaver-xtreme' /*adm*/) . '</small>', 'id' => 'alt_theme_category', 'type' => '+select_alt_theme',
		'info' => __('Alternate Theme for category archive pages. (&starf;Plus)', 'weaver-xtreme' /*adm*/),
		'value' => ''
	  ),array('name' => '<small>' . __('Tags Archive Theme', 'weaver-xtreme' /*adm*/) . '</small>', 'id' => 'alt_theme_tag', 'type' => '+select_alt_theme',
		'info' => __('Alternate Theme for tag archive pages. (&starf;Plus)', 'weaver-xtreme' /*adm*/),
		'value' => ''
	  ),array('name' => '<small>' . __('Author Archive Theme', 'weaver-xtreme' /*adm*/), 'id' => 'alt_theme_author', 'type' => '+select_alt_theme',
		'info' => __('Alternate Theme for author archive pages. (&starf;Plus)', 'weaver-xtreme' /*adm*/),
		'value' => ''
	  ),array('name' => '<small>' . __('Search Theme', 'weaver-xtreme' /*adm*/) . '</small>', 'id' => 'alt_theme_search', 'type' => '+select_alt_theme',
		'info' => __('Alternate Theme for search pages. (&starf;Plus)', 'weaver-xtreme' /*adm*/),
		'value' => ''
	  ),array('name' => '<small>' . __('404 Theme', 'weaver-xtreme' /*adm*/) . '</small>', 'id' => 'alt_theme_404', 'type' => '+select_alt_theme',
		'info' => __('Alternate Theme for 404 (not found) pages. (&starf;Plus)', 'weaver-xtreme' /*adm*/),
		'value' => ''
	  ),
	);
	weaverx_form_show_options($opts);
}

// ========================================== MAIN OPTIONS : GENERAL APPEARANCE =======================================

function weaverxplus_general_apperarance() {

// ==================   BACKGROUND IMAGES ====================
?>
        <a id="background-images"></a>
		<div class="atw-row-header" style="font-weight:bold;font-size:larger;width:90%;" ><span style="padding:.2em;" class="dashicons dashicons-format-image"></span>Background Image
		<?php weaverxplus_help_link('plus-help.html#BackgroundImages','Help on Background Images'); echo weaverxplus_pro_stamp(2); ?></div>
		<br />

		<table class="optiontable">
<?php

		weaverx_bgimg_widerow('<span class="i-left dashicons dashicons-admin-links"></span>Full Screen Site BG Image','_bg_fullsite_url','Full screen centered auto-sized BG image.','250px');

		weaverx_bgimg_widerow('<span class="i-left dashicons dashicons-admin-links"></span>Site BG Image','_bg_body_url','Background image for entire site (body)');
		weaverx_repeat_row('_bg_body_rpt');

		weaverx_bgimg_widerow('<span class="i-left dashicons dashicons-admin-links"></span>Wrapper BG Image','_bg_wrapper_url','Background image for outer wrapper (#wrapper)');
		weaverx_repeat_row('_bg_wrapper_rpt');

		weaverx_bgimg_widerow('<span class="i-left dashicons dashicons-admin-links"></span>Header BG Image','_bg_header_url','Background image for header (#header)');
		weaverx_repeat_row('_bg_header_rpt');


		weaverx_bgimg_widerow('<span class="i-left dashicons dashicons-admin-links"></span>Container BG Image','_bg_container_url','Background image for Container - (#container)');
		weaverx_repeat_row('_bg_container_rpt');

		weaverx_bgimg_widerow('<span class="i-left dashicons dashicons-admin-links"></span>Content BG Image','_bg_content_url','Background image for Content - wraps page/post area (#content)');
		weaverx_repeat_row('_bg_content_rpt');

		weaverx_bgimg_widerow('<span class="i-left dashicons dashicons-admin-links"></span>Page content BG Image','_bg_page_url','Background image for Page content area (#content .page)');
		weaverx_repeat_row('_bg_page_rpt');

		weaverx_bgimg_widerow('<span class="i-left dashicons dashicons-admin-links"></span>Post BG Image','_bg_post_url','Background image for Post content area (#content .post)');
		weaverx_repeat_row('_bg_post_rpt');

		weaverx_bgimg_widerow('<span class="i-left dashicons dashicons-admin-links"></span>Primary Sidebar Area BG Image','_bg_widgets_primary_url','Background image for primary widget area (#primary-widget-area)');
		weaverx_repeat_row('_bg_widgets_primary_rpt');

		weaverx_bgimg_widerow('<span class="i-left dashicons dashicons-admin-links"></span>Secondary Sidebar Areas BG Image','_bg_widgets_secondary_url','Background image for secondary widget areas (#secondary-widget-area)');
		weaverx_repeat_row('_bg_widgets_secondary_rpt');

		weaverx_bgimg_widerow('<span class="i-left dashicons dashicons-admin-links"></span>Footer BG Image','_bg_footer_url','Background image for Footer area (#colophon)');
		weaverx_repeat_row('_bg_footer_rpt');

	echo "</table>\n<hr /><p>";
?>
Use the <em>Additional CSS</em> option to specify additional background CSS options, each ending with a semi-colon (;).
Valid options include: background-position, background-size, background-origin, background-clip, and background-attachment. Useful example: <code>background-size: 100% auto;</code> - makes bg image full width of container, height depends on container. See this <a href="//www.w3schools.com/cssref/css3_pr_background.asp" title="background CSS" target="_blank">W3 Schools page</a> for more information about background styling.
<?php

	echo "</p>\n";

}

// ========================================== UI code for bg images ==========================================
function weaverx_bgimg_widerow($th,$rid,$desc,$width='') {
	$style = '';
	$style_desc = 'style="padding-left: 10px"';
	if ($width != '') {
		$style = ' style="width:' . $width . ';"';
	}
?>
	<tr>
		<th scope="row" align="right"<?php echo $style . '>' . $th; ?>:&nbsp;</th>
		<td>
			<input name="<?php weaverx_sapi_main_name($rid); ?>" type="text" style="width:340px;height:22px;" class="regular-text"
				id="<?php echo $rid; ?>" value="<?php echo (weaverx_plus_esc_textarea(weaverx_getopt($rid))); ?>" />
<?php           weaverx_media_lib_button($rid); ?>
		</td>
		<td <?php echo $style_desc;?>><small><?php echo $desc; ?></small></td>
	</tr>
<?php

}

function weaverx_repeat_row($rid) {
?>
	<tr>
		<th scope="row" align="right">&nbsp;</th>
		<td colspan="2" style="font-size:80%;">
			<input type="radio" name="<?php weaverx_sapi_main_name($rid); ?>"
				value="repeat" <?php echo(weaverx_getopt($rid) == 'repeat' ? 'checked' : ''); ?> /> repeat &nbsp;
			<input type="radio" name="<?php weaverx_sapi_main_name($rid); ?>"
				value="repeat-x" <?php echo(weaverx_getopt($rid) == 'repeat-x' ? 'checked' : ''); ?> /> repeat-x &nbsp;
			<input type="radio" name="<?php weaverx_sapi_main_name($rid); ?>"
				value="repeat-y" <?php echo(weaverx_getopt($rid) == 'repeat-y' ? 'checked' : ''); ?> /> repeat-y &nbsp;
			<input type="radio" name="<?php weaverx_sapi_main_name($rid); ?>"
				value="no-repeat" <?php echo(weaverx_getopt($rid) == 'no-repeat' ? 'checked' : ''); ?> /> no-repeat &nbsp;&nbsp;

			<input name="<?php weaverx_sapi_main_name($rid.'_cssx'); ?>" type="text" style="width:240px;height:22px;" class="regular-text"
				id="<?php echo $rid; ?>" value="<?php echo (weaverx_plus_esc_textarea(weaverx_getopt($rid.'_cssx'))); ?>" /> Additional CSS
		</td>
	</tr>
<?php
}

// ========================================== MAIN OPTIONS : HEADER =======================================
function weaverxplus_mainopts_header() {

}

function weaverxplus_post_specifics() {
	$atw = 'Replace Info Lines with custom info line templates. Advanced options: see help file' . weaverxplus_pro_stamp(1);
	$opts = array (
		array( 'type' => 'submit'),
		array('name' => 'Custom Post Info Lines', 'id' => '-info', 'type' => '=subheader_alt',
		  'info' => $atw, 'help' => 'help.html#CustomInfo'),
		array('name' => '<small>Top Post Info Line<small>', 'id' => 'custom_posted_on', 'type' => '+textarea',
		  'info' => 'Custom template for top post info line. See help file! (&star;Plus)'),
		array('name' => '<small>Bottom Post Info Line<small>', 'id' => 'custom_posted_in', 'type' => '+textarea',
		  'info' => 'Custom template for bottom post info line. (&star;Plus)'),
		array('name' => '<small>Top Post Info Line (Single)<small>', 'id' => 'custom_posted_on_single', 'type' => '+textarea',
		  'info' => 'Custom template for top post info line on single pages. (&star;Plus)'),
		array('name' => '<small>Bottom Post Info Line (Single)<small>', 'id' => 'custom_posted_in_single', 'type' => '+textarea',
		  'info' => 'Custom template for bottom post info line on single pages. (&star;Plus)')
	);
	weaverx_form_show_options($opts);
}

/* =========================== fonts admin code =========================== */
$GLOBALS['g_fonts'] = array(
        array ('id' => '', 'fam' => '', 'link' => ''),

        array ('id' => 'Oswald', 'fam' => "'Oswald', sans-serif;",
               'link' => 'Oswald:400,700'),
        array ('id' => 'PT Sans', 'fam' => "'PT Sans', sans-serif;",
               'link' => 'PT+Sans:400,700,400italic,700italic'),
        array ('id' => 'Raleway', 'fam' => "'Raleway', sans-serif;",
               'link' => 'Raleway:400,700'),
        array ('id' => 'Ubuntu', 'fam' => "'Ubuntu', sans-serif;",
               'link' => 'Ubuntu:400,700,400italic,700italic'),
        array ('id' => 'Montserrat', 'fam' => "'Montserrat', sans-serif;",
               'link' => 'Montserrat:400,700'),
        array ('id' => 'PT Sans Narrow', 'fam' => "'PT Sans Narrow', sans-serif;",
               'link' => 'PT+Sans+Narrow:400,700'),

        array ('id' => 'Yanone Kaffeesatz', 'fam' => "'Yanone Kaffeesatz', sans-serif;",
               'link' => 'Yanone+Kaffeesatz:400,700'),
        array ('id' => 'Oxygen', 'fam' => "'Oxygen', sans-serif;",
               'link' => 'Oxygen:400,700'),
        array ('id' => 'Titillium Web', 'fam' => "'Titillium Web', sans-serif;",
               'link' => 'Titillium+Web:400,400italic,700,700italic'),
        array ('id' => 'Noto Sans', 'fam' => "'Noto Sans', sans-serif;",
               'link' => 'Noto+Sans:400,700,400italic,700italic'),
        array ('id' => 'Dosis', 'fam' => "'Dosis', sans-serif;",
               'link' => 'Dosis:400,500,700,800'),


        array ('id' => 'Bitter', 'fam' => "'Bitter', serif;",
               'link' => 'Bitter:400,700,400italic'),

        array ('id' => 'Merriweather', 'fam' => "'Merriweather', serif;",
               'link' => 'Merriweather:400,400italic,700,700italic'),
        array ('id' => 'PT Serif', 'fam' => "'PT Serif', serif;",
               'link' => 'PT+Serif:400,700,400italic,700italic'),
        array ('id' => 'Playfair Display', 'fam' => "'Playfair Display', serif;",
               'link' => 'Playfair+Display:400,700,400italic,700italic'),

        array ('id' => 'Rokkitt', 'fam' => "'Rokkitt', serif;",
               'link' => 'Rokkitt:400,700'),
        array ('id' => 'Noto Serif', 'fam' => "'Noto Serif', serif;",
               'link' => 'Noto+Serif:400,700,400italic,700italic'),

        array ('id' => 'Indie Flower', 'fam' => "'Indie Flower', cursive;",
               'link' => 'Indie+Flower'),
        array ('id' => 'Dancing Script', 'fam' => "'Dancing Script', cursive;",
               'link' => 'Dancing+Script'),


        array ('id' => 'Droid Sans Mono', 'fam' => "'Droid Sans Mono', Courier, monospace;",
               'link' => 'Droid+Sans+Mono'),
        array ('id' => 'Ubuntu Mono', 'fam' => "'Ubuntu Mono', Courier, monospace;",
               'link' => 'Ubuntu+Mono'),
        array ('id' => 'Nova Mono', 'fam' => "'Nova Mono', Courier, monospace;",
               'link' => 'Nova+Mono'),

    );

function weaverxplus_fonts_pro_admin() {
//return;

    // link: <link href='//fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,400,700' rel='stylesheet' type='text/css'>
?>
<div><a id="fonts_top" name="fonts_top"></a>
	<div class="atw-row-header" style="font-weight:bold;font-size:larger;width:90%;" ><span style="padding:.2em;" class="dashicons dashicons-editor-textcolor"></span>Weaver Xtreme Plus Font Control <?php echo weaverxplus_pro_stamp(2); ?> (&diams;)</div>

	<p>The Weaver Xtreme Plus Font Control panel allows you add free fonts from
	<?php weaverx_site('/webfonts', '//www.google.com','Google Web Fonts'); ?><strong>Google Web Fonts</strong></a>,
    <?php weaverx_site('', '//www.fontsquirrel.com','Font Squirrel'); ?><strong>Font Squirrel</strong></a>,
    or virtually any other free or commercial font source directly to all the
    <em>Font Family</em> text options found in various options.</p>
    <p>It is easiest to add a Google Font: carefully follow the instructions
    in <strong>Step 1</strong>, then add that new font to all the <em>Font Family</em> selections in the options by clicking the
    <em>Add New Font</em> button in <strong>Step 2</strong>. Note: Google has changed their web font selection interface. To use
	it, you must use Chrome, Safari, or Firefox. Internet Explorer browsers are not supported by the Google Font interface.</p>
    <p>For more details about adding Google Fonts, Font Squirrel, or other free fonts, please read additional instructions in the
	Weaver Xtreme Plus Help document!<?php weaverxplus_help_link('plus-help.html#font_control','Font Control'); ?>
	</p>
	<p>For best results, <strong>please</strong> follow <span style="color:red;">Steps 1 and 2</span> for each font you want to use. Read
	the instructions for each step carefully. <small>Note that each font you add will incur some slight overhead required to load the font
    into the visitor's browser, so after you've settled on specific fonts, you should delete unused fonts. Using font-families added here will
    display as generic sans-serif in the WordPress Page/Post editor, but will display properly on the actual page/post.</small></p>
	<hr />

<fieldset class="options">

	<h3><span style="color:red; text-decoration:underline;font-weight:bold;font-size:larger;">Step 1.</span> Specify Font Source and Font Family</h3>

	<div style="float:left;border:1px solid #aaa;padding:4px;width:80%;">
    <strong>Popular Google Fonts:</strong><br />
    <select name="<?php weaverx_sapi_main_name('g_font_sel'); ?>" id="g_font_sel">
    <?php
	foreach ($GLOBALS['g_fonts'] as $font)  { ?>
		<option value="<?php echo $font['id'] ?>" <?php selected( (weaverx_getopt( 'g_font_sel' ) == $font['id']));?>><?php echo $font['id']; ?></option>
    <?php } ?>
	</select> Select a Google Font (leave blank to use &lt;link&gt; / <em>font-family:</em> fields below)
    &nbsp;&nbsp;<strong>Click to show font examples:</strong><?php weaverx_help_link('font-demo.html', 'Font Examples'); ?>

<h4 style="color:red;">-- OR -- follow these directions to add your favorite font from Google or other source - <em>*** IMPORTANT! Add only one font at a time ***</em>.</h4>

        <ol>

        <li><em>Google Fonts:</em> Go to <?php weaverx_site('/webfonts', '//www.google.com','Google Web Fonts'); ?><strong>Google Web Fonts</strong></a> site to select a font (including desired style options).
		Click the red + circle to add the font to the <em>Family Selected</em> pop-up box that will be displayed on the bottom right.
        <br />
        <em>Other Font Sources</em>: See Weaver Xtreme Plus Help document<?php weaverxplus_help_link('plus-help.html#font_control','Font Control'); ?>
        </li>

		<li><em>Google Fonts:</em> Open the <em>Family Selected</em> box. From the "Embed Font" section, copy the &lt;link&gt;</strong> code here:
		(You can normally specify <em>only one font</em> here!)<br />
        <em>Other Font Sources</em>: Paste appropriate <strong> &lt;link&gt;</strong> or <strong>&lt;script&gt;</strong> code here.
		<br />
		<strong>Combining font loading definitions:</strong> If the &lt;link&gt; or &lt;script&gt code is identical for different font-families from the <em>same</em> source, only add the value <em>once</em> with the first font-family. For example, you can create a Google Font link that includes multiple families. You need the &lt;link&gt; only once, but need a separate font-family (item 3) for <em>each</em> family.<br />
	<?php weaverx_textarea(weaverx_getopt('font_google_link'), 'font_google_link', 1, __('&lt;link&gt; or &lt;script&gt; font source','weaver-xtreme-plus' /*adm*/)); ?>
		</li>

		<li><em>Google Fonts:</em> From the <em>Family Selected</em> box, from "Specify in CSS" section, copy the <em>font-family:</em> code here:<br />
        <em>Other Font Sources</em>: Paste font's CSS <em>font-family:</em> code here:<br />
	<?php weaverx_textarea(weaverx_getopt('font_google_font_family'), 'font_google_font_family', 1, __('font-family: font-name,fallback_family;','weaver-xtreme-plus' /*adm*/)); ?>
		</li>
        </ol>
        <h4 style="color:red">Proceed to Step 2.</h4>

	</div><div style="clear:both;"></div>

	<div>
    <h3><span style="color:red; text-decoration:underline;font-weight:bold;font-size:larger;">Step 2.</span> Add New Font to <em>Font Family</em> option list</em></h3>
<?php // we save 'fonts_added' serialized when used, but put it in this hidden input as ascii so that it can fake out sapi and still be usable.
?>
    <input name="<?php weaverx_sapi_main_name('fonts_added'); ?>" id="fonts_google" type="hidden" value="<?php echo esc_html(weaverx_getopt('fonts_added')); ?>" />

	<strong>Click <em>Save Settings</em> button to add the above Font specification to the list of available Font Families</strong>
    <br />


<?php
    $gfonts = weaverx_plus_getopt_array('fonts_added');

    if ( !empty($gfonts) ) {
        weaverx_sapi_submit();

        echo '<h3>Remove Added Fonts</h3>';
        foreach ($gfonts as $gfont => $val) {
            // $gfont has slug, $val values
            $id = 'chk-' . $gfont;
?>
            <div style="margin:0;margin-left:2em;padding:0;height:.6em;">
            <input type="checkbox" name="<?php weaverx_sapi_main_name($id); ?>" id="<?php echo $id; ?>"
                <?php checked(weaverx_getopt_checked( $id )); ?> >
            <span style="margin-left:.5em;font-style:italic;font-weight:bold;"> <?php echo $val['name']; ?></span>
            &nbsp;&nbsp;&nbsp;<small>Check to delete</small>
            </div><br />
<?php
        }
?>      <br />
        <strong>Click <em>Save Settings</em> to remove the checked Fonts.</strong>
<?php
    }
?>
</div>
</div>
<?php
}

add_filter('weaverx_add_font_family', 'weaverxplus_add_font_family');

function weaverxplus_add_font_family($opt_array) {

    $gfonts = weaverx_plus_getopt_array('fonts_added');

    if ( !empty($gfonts) ) {
		$old_fonts = $opt_array;
        $add = array();
        $add[] =  array('val' => 'default', 'desc' => ('Inherit') );

        unset($old_fonts[0]);   // kill the inherit entry in original

        foreach ($gfonts as $gfont => $val ) {
            // $gfont has slug, $val has vals
            $add[] = array('val' => $gfont, 'desc' => $val['name'] . ' &star;');
        }
        return array_merge( $add, $old_fonts);
    }

    return $opt_array;
}


// ================================== weaverxplus_admin ==================================
function weaverxplus_admin() {
    weaverxplus_show_help();
}

function weaverxplus_process_options() {
	// if (weaverx_submitted('whatever')) {}

	if (weaverx_submitted('xp_backup_settings')) {
        $name = weaverx_savebackup();
        if ($name !== false)
            weaverx_save_msg(__('All current main and advanced options backed up in:', 'weaver-xtreme' ).' "'. $name . '.wxb"');
        else
            weaverx_save_msg(__('ERROR: Saving backup failed.', 'weaver-xtreme' ));
    }

    if (weaverx_submitted('xp_filesavetheme')) {
        $base = sanitize_file_name($_POST['savethemename']);
        $temp_url =  weaverx_write_current_theme($base);
        if ($temp_url == '')
            weaverx_save_msg(__('Invalid name supplied to save theme to file.', 'weaver-xtreme' ));
        else
            weaverx_save_msg(__("All current main and advanced options saved in ", 'weaver-xtreme' ) . $temp_url);
    }

    if (weaverx_submitted('xp_restoretheme')) {
        $base = $_POST['wvx_restorename'];
        $valid = validate_file($base);		// make sure an ok file name
        $fn = weaverx_f_uploads_base_dir() .'weaverx-subthemes/'.$base;

        if ($valid < 1 && weaverx_upload_theme($fn)) {

            weaverx_save_msg(__("Weaver Xtreme theme restored from file: ", 'weaver-xtreme' ) . $base);
        } else {
            weaverx_save_msg('<em style="color:red;">'. __('INVALID FILE NAME PROVIDED - Try Again', 'weaver-xtreme' ). "($fn)" . '</em>');
        }
    }

    if (weaverx_submitted('xp_deletetheme')) {
        $myFile = isset($_POST['selectName']) ? $_POST['selectName'] : '';
        $valid = validate_file($myFile);
        if ($valid < 1 && $myFile != "None") {
            weaverx_f_delete(weaverx_f_uploads_base_dir() .'weaverx-subthemes/'.$myFile);
            echo '<div style="background-color: rgb(255, 251, 204);" id="message" class="updated fade"><p>File: <strong>'.$myFile.'</strong> has been deleted.</p></div>';
        } else {
            echo '<div style="background-color: rgb(255, 251, 204);" id="message" class="updated fade"><p>File: <strong>'.$myFile.'</strong> invalid file name, not deleted.</p></div>';
        }
    }


    if ( weaverx_submitted( 'restore_plus_backup' ) ) {
        $proopts = get_option('weaverx_plus_backup');
        if ( !$proopts ) {
            weaverx_save_msg(("Restore of Previous Weaver Xtreme Plus Settings failed - no settings found."));
            return;
        }
        weaverx_delete_all_options();
        weaverx_wpupdate_option( 'weaverx_settings', $proopts );
        weaverx_save_msg(("Previous Weaver Xtreme Plus Settings restored from WordPress database."));
    }

    if ( weaverx_getopt( 'g_font_sel' ) ) {
        $font_sel = weaverx_getopt( 'g_font_sel' );
        foreach ($GLOBALS['g_fonts'] as $font)  {
            if ( $font['id'] == $font_sel ) {
                $slug = sanitize_title( $font_sel );
                $gfonts = weaverx_plus_getopt_array( 'fonts_added' );

                $vals = array( 'name' => $font_sel,
                              'link' => "<link href='//fonts.googleapis.com/css?family={$font['link']}' rel='stylesheet' type='text/css'>",
                              'family' => "font-family:{$font['fam']}");
                $gfonts[$slug] = $vals;

                // If this entry duplicates an existing entry, it will be replaced
                weaverx_setopt('font_google_link', '', false);             // clear entries
                weaverx_setopt('font_google_font_family', '', false);

                weaverx_setopt_array('fonts_added', $gfonts, true);
                weaverx_save_msg(('Predefined Google Font Added to Font Family list: ') . '<em>' . $font['id'] . '</em>');
                break;
            }
        }
        weaverx_setopt('g_font_sel', false );
    }

    if ( weaverx_getopt('font_google_link') != '' || weaverx_getopt('font_google_font_family') ) {

        // ok, they specified a new font

        $link = weaverx_getopt('font_google_link');
        $family = weaverx_getopt('font_google_font_family');

		if ( $link && strpos( $link, '|') !== false ) {
			weaverx_error_msg(__('You must specify only one font at a time: ', 'weaver_xtreme' ) . esc_html($link) . '/' . esc_html($family));
		} elseif (!$family || strpos($family, 'font-family') === false) {  // basic test
            weaverx_error_msg(__('You must specify at least a <em>font-family</em> value: ', 'weaver_xtreme' ) . esc_html($link) . '/' . esc_html($family));
        } else {
            $fam_list = explode( ',', str_replace('font-family:','',$family) );

            $name = trim( str_replace(array("'",'"',';'), '', $fam_list[0] ) ); // try to support different variants of font family specifications
            $slug = sanitize_title($name);

            $gfonts = weaverx_plus_getopt_array( 'fonts_added' );

			// optimization/fix for CloudFlare bug - pre-replace 'http:' with ''.
			$link = str_replace ('//fonts.googleapis.com' , '//fonts.googleapis.com', $link);

            $vals = array( 'name' => $name, 'link' => $link, 'family' => $family);
            $gfonts[$slug] = $vals;

            // If this entry duplicates an existing entry, it will be replaced
            weaverx_setopt('font_google_link', '', false);             // clear entries
            weaverx_setopt('font_google_font_family', '', false);

            weaverx_setopt_array('fonts_added', $gfonts, true);
            weaverx_save_msg(('New Font Added to Font Family list: ') . '<em>' . $name . '</em>');
        }
    }

    if ( weaverx_getopt('fonts_added') ) {
        // This is a hack forced by SAPI! We have to check each and every time to see if they are deleting a font
        $gfonts = weaverx_plus_getopt_array('fonts_added');

        $newval = array();
        $changed = false;

        foreach ($gfonts as $gfont => $val ) {
            $id = 'chk-' . $gfont;
            if ( weaverx_getopt($id) ) {
				weaverx_setopt($id, false);		// gotta "uncheck" it!
                $changed = true;
            }
            else
                $newval[$gfont] = $gfonts[$gfont];
        }
        if ( $changed ) {
            weaverx_setopt_array('fonts_added', $newval);
            weaverx_save_msg(('Checked Added Fonts Removed'));
        }
    }

	weaverxplus_process_license_options();
}

function weaverxplus_save_restore_autobackup() {

    $pro_saved = get_option( 'weaverx_plus_backup' ,array());
    $pro_style_date = '';
    if (!empty($pro_saved))
        $pro_style_date = $pro_saved['style_date'];

    if ( !$pro_style_date )
       return;

?>
    <br /><br />
	<span class="submit"><input type="submit" name="restore_plus_backup" value="Restore Plus Backup Settings"/></span>
	<strong>Restore from Previous Weaver Xtreme Plus saved settings.</strong> <em>Last save: <?php echo $pro_style_date; ?></em>
    <br />
    These Plus settings were saved when you deactivated Weaver Xtreme Plus. This option is useful
    to restore those Plus settings if you have saved options while using just the free version which results in the loss
    of your previous Plus settings.
<?php
    weaverx_nonce_field('restore_plus_backup');
}


//	================= general helpers =====================


function weaverxplus_pro_stamp($left = 0) {
	$ap =  '<strong style="margin-left:' . $left . 'em;color:#c00;">(&star;Weaver Xtreme Plus)</strong>';
	return $ap;
}

// ===================== Smart Menus settings ================
function xxweaverxplus_save_smartmenus() {
	/* Save options from save smartmenus */


	if (isset($_POST['wvpsc_num_opts'])) weaverxplus_setopt('wvpsc_num_opts', weaverxplus_default_int($_POST['wvpsc_num_opts'],1,25,2));

	foreach (array('primary','secondary','extra') as $menu) {
		$opt_base = "sm-{$menu}";
		if (isset($_POST[$opt_base . '-js-opt'])) {
			weaverxplus_setopt($opt_base . '-js-opt', weaverx_filter_textarea(stripslashes($_POST[$opt_base . '-js-opt'])));
		}
	}

	weaverxplus_update_opts();
	/* and let the user know something happened */
	echo '<div id="message" class="updated fade"><p><strong>Weaver Xtreme Plus SmartMenu Options Saved</strong></p></div>';
}


// ==============================================   SAVE/RESTORE Files: PLUS ===========================================
function weaverxplus_saverestore_files() {
    /* admin tab for saving and restoring theme */
    $weaverx_theme_dir = weaverx_f_uploads_base_dir() .'weaverx-subthemes/';
?>

    <h3>You can save all your current settings in a backup file:</h3>
    <ol >
     <li>Save <em>all</em> your current settings in a backup file on your site's file system (in <?php echo($weaverx_theme_dir);?>).
      -or-</li>
    <li>Save only <em>theme related</em> settings to a file you name on your Site's file system (in <?php echo($weaverx_theme_dir);?>.</li>
    </ol>
	<p>Settings will survive theme updates.</p>
<?php if (weaverx_allow_multisite()) : ?>
    <h3>You can restore a saved theme or backup file by:</h3>
    <ol >
    <li>Restoring a theme/backup that you saved in a file on your site (to current settings). -or-</li>
    <li>Uploading a theme/backup from a file saved on your own computer (to current settings). </li>
    </ol>
	<h3>Creating settings file for Per Page subtheme selection</h3>
	<p style="font-size:100%;">
		One of the uses for settings saved in files is to allow you to select one to use on a Per Page basis.
		When you do this, it is <em>critical</em> to be sure you don't lose your main site settings!
		So, <strong>before</strong> you start to create a Per Page style, first SAVE your current settings to retrieve later.
		This can be by downloading a full backup to your own computer, saving to a file on the host, or using the "Save Current Theme Settings"
		to the WP database. This last one is easiest, but it is also easy to accidentally overwrite the saved settings!
	</p>
	<p style="font-size:100%;">
		So, once you have saved your main theme, make whatever modifications you need for the per page design.
		You might not want to do that on a live site! When you are ready, save either all settings, or, most commonly, just the theme
		related settings to the host file system. Now you can open the page, and pick the theme settings you just saved
		from the Weaver Xtreme Plus per page options section. Save the page. And restore the original site-wide theme.
		When the given page is loaded, the settings from the WP Database will be replaced with the saved settings saved
		in the file for just that page. The settings in the WP database will not be altered.
	</p>
<?php endif; ?>
<?php if (!weaverx_allow_multisite()) : ?>
    <h4>You will be unable to restore your saved file directly</h4>
    <p>Since this is a WordPress Multi-site installation, you are restricted from uploading
    a Weaver Xtreme theme/backup from a saved file. However, the save file capability gives you the ability
    to save your work so you can transfer it to a WordPress site where you have full admin
    capabilities (non-Multi-site installation, for example), or to share with others. Please
    note that you <em>can</em> save your settings in the WordPress Database which will allow you
    to explore other predefined themes without losing your work.
    </p>
<?php endif; ?>
  <br />
    <div class="atw-option-subheader">Save All Current Settings in Backup File (&starf;Xtreme Plus)</div><br />
     <strong>Backup</strong> <u>all</u> current options in a <strong>file</strong> on your
     WordPress Site's <em><?php echo($weaverx_theme_dir);?></em> directory named 'weaverx_backup_yyyy-mm-dd-hhmm.wxb'
     where the last part is a GMT based date and time stamp.
<?php if (weaverx_allow_multisite()) : ?>
    You will be able to restore this theme later using the <strong>Restore Saved Theme/Backup</strong> section.
<?php endif; ?>
    Please be sure you've saved any changes you might have made.<br />
     <form enctype="multipart/form-data" name='wxp_backup_settings' method='post'>
	<span class='submit'><input name='xp_backup_settings' type='submit' value='Backup All Current Settings'/></span>
    <?php weaverx_nonce_field('xp_backup_settings'); ?>
    </form><br />

    <div class="atw-option-subheader">Save Current Theme Related Settings to File (&starf;Xtreme Plus)</div><br />
     <strong>Save</strong> current <em>theme related</em> settings, either by downloading
    to <strong>your computer</strong> or saving a <strong>file</strong> on your WordPress Site's <em><?php echo($weaverx_theme_dir);?></em> directory.
<?php if (weaverx_allow_multisite()) : ?>
    You will be able to restore this theme later using the <strong>Restore Saved Theme/Backup</strong> section.
<?php endif; ?>
    <em>Theme related</em> settings include most standard Weaver settings <em>except</em>: Site Copyright, SEO settings,
    Weaver Pro HTML Insert areas, Background Images, FavIcons, and Weaver II Pro shortcode settings.<br /><br />

  <strong>Save as file on this website's server</strong>
 <p>Please provide a name for your file, then click the "Save File" button. <b>Warning:</b> Duplicate names will
    automatically overwrite existing file without notification.</p>
 <form enctype="multipart/form-data" name='savetheme' method='post'><table cellspacing='10' cellpadding='5'>
    <tr>
    <td>Name for saved theme: <input type="text" name="savethemename" size="30" />&nbsp;<small>(Please use a meaningful
    name - do not provide file extension. Name might be altered to standard form.)</small></td></tr>
	<tr>
	<td><span class='submit'><input name='xp_filesavetheme' type='submit' value='Save Theme in File'/></span>&nbsp;&nbsp;
	<strong>Save Theme in File</strong> - <small>Theme will be saved in <em><?php echo($weaverx_theme_dir);?></em>
	directory on your site server.</small></td>
        </tr>
    </table>
    <?php weaverx_nonce_field('xp_filesavetheme'); ?>
 </form><br />

<?php if (weaverx_allow_multisite()) : ?>


    <div class="atw-option-subheader">Restore Saved Theme/Backup from file (&starf;Xtreme Plus)</div><br />
    You can restore a previously saved theme (.wxt) or backup (.wxb) file directly from your WordPress
    Site's <em><?php echo($weaverx_theme_dir);?></em> directory, or from a file saved on your computer.
    Note: after you restore a saved theme, it will be loaded into the current settings. A <em>theme</em> restore will
    replace only settings that are not site-specific. A <em>backup</em> file will replace all current settings.
    If you've uploaded the theme from your computer, you might then want to also save a local copy on your
    website server.<br /><br />

    <form enctype="multipart/form-data" name='localrestoretheme' method='post'><table cellspacing='10' cellpadding='5'>
    <table>
    <tr><td><strong>Restore from file saved on this website's server</strong></td></tr>
    <tr>
        <td>Select theme/backup file: <?php  weaverx_subtheme_list('wvx_restorename'); ?>&nbsp;Note: <strong>.wxt</strong> are Theme definitions. <strong>.wxb</strong> are full backups. (Restores to current settings.)</td></tr>
	<tr>
	<td><span class='submit'><input name='xp_restoretheme' type='submit' value='Restore Theme/Backup'/></span>&nbsp;&nbsp;
	<strong>Restore</strong> a theme/backup you've previously saved on your site's <em><?php echo($weaverx_theme_dir);?></em> directory. Will replace current settings.</td>
    </tr>
        <tr><td>&nbsp;</td></tr>
    </table>
    <?php weaverx_nonce_field('xp_restoretheme') ; ?>
    </form>

    <br />

    <form enctype="multipart/form-data" name='maintaintheme' method='post'>
    <div class="atw-option-subheader" >Subtheme and Backup File Maintenance (&starf;Xtreme Plus)</div><br />
        <?php weaverx_subtheme_list('selectName'); ?>

        <span class='submit'><input name='xp_deletetheme' type='submit' value='Delete Subtheme/Backup File'/></span>
          <strong>Warning!</strong> This action can't be undone, so be sure you mean to delete a file!
	  <?php weaverx_nonce_field('xp_deletetheme'); ?>
    </form>
<?php endif; ?>
    <br />
<?php
}

function weaverx_subtheme_list($lbl) {
    // output the form to select a file list from weaverii-subthemes directory
?>
    <select name="<?php echo($lbl);?>" id="<?php echo($lbl);?>">
	<option value="None">-- Select File --</option>
<?php
	    // echo the theme file list
	    $theme_dir = weaverx_f_uploads_base_dir() . 'weaverx-subthemes/';
	    if($media_dir = opendir($theme_dir)){
		while ($m_file = readdir($media_dir)) {
		    $len = strlen($m_file);
		    $ext = $len > 4 ? substr($m_file,$len-4,4) : '';
		    if($ext == '.wxt' || $ext == '.wxb' ) {
		        echo '<option value="'.$m_file.'">'.$m_file.'</option>';
		    }
		}
	    }
?>
    </select>
<?php
}

function weaverx_savebackup() {
    /* generate file name with current date and time to save backup file */
    $name = 'wvrx_bak_' . date('Y-m-d-Hi');

    if ( weaverx_write_backup($name, false) )
		return $name;
    else
		return false;
}

function weaverx_write_current_theme($savefile) {
     return weaverx_write_backup($savefile, true);		// write a theme save file
}

function weaverx_write_backup($savefile, $is_theme = true) {
    /*	write the current settings to a file, return true or false
	$savefile is a base-name - no directory, no extension
    */

    global $weaverx_pro_opts;
    global $weaverx_opts_cache;


    $save_dir = weaverx_f_uploads_base_dir() . 'weaverx-subthemes';
    $save_url = weaverx_f_uploads_base_url() . 'weaverx-subthemes';

    if ($is_theme)
		$ext = '.wxt';
    else
		$ext = '.wxb';

    $usename = strtolower(sanitize_file_name($savefile));
    $usename = str_replace($ext,'',$usename);
    if (strlen($usename) < 1) return '';
    $usename = $usename . $ext;

    $wii_theme_dir_exists = weaverx_f_mkdir($save_dir);
    $wii_theme_dir_writable = $wii_theme_dir_exists;

   if (!weaverx_f_is_writable($save_dir)) {
        $wii_theme_dir_writable = false;
    }

    $filename = trailingslashit($save_dir) . $usename;

    if (!$wii_theme_dir_writable || !$wii_theme_dir_exists || !($handle = weaverx_f_open($filename, 'w')) ) {
	weaverx_f_file_access_fail('Unable to create file. Probably a file system permission problem. File: ' . $filename);
	return '';
    }

    $tosave = weaverx_get_save_settings($is_theme);

    /* file open, ready to write - so let's write something - either a backup or a theme */

    weaverx_f_write($handle, $tosave);	// write all Weaver II settings to user save file
    weaverx_f_close($handle);

    return trailingslashit($save_url) . $usename;
}

function weaverx_upload_backup($file_basename) {

    return weaverx_upload_theme( weaverx_f_uploads_base_dir() . 'weaverx-subthemes/' . $file_basename . '.wxb' );
}


function weaverx_upload_theme($filename) {

    if (!weaverx_f_exists($filename)) return weaverx_f_fail("Can't open $filename");     	/* can't open */

    $contents = weaverx_f_get_contents($filename);

    if (!$contents) return weaverx_f_fail("Can't open $filename");

    return weaverx_ex_set_current_to_serialized_values($contents);	//weaverx_ex_set_current_to_serialized_values
 }


/* end weaverx_saverestore_admin */
?>
