<?php
// will down load current settings based on db setting
// __ added - 12/11/14

	$wp_root = dirname(__FILE__) .'/../../../../';
	if(file_exists($wp_root . 'wp-load.php')) {
		require_once($wp_root . "wp-load.php");
	} else if(file_exists($wp_root . 'wp-config.php')) {
		require_once($wp_root . "wp-config.php");
	} else {
		exit;
	}



function weaverxplus_filter_strip_default( $var ) {
	if (!is_string($var) )
		return true;
	return strlen( $var ) && $var != 'default';
}

	@error_reporting(0);

	$nonce = '';
	$weaverx_fn = '';
	$ext = '';

	if (isset($_GET['_wpnonce']))
		$nonce = $_GET['_wpnonce'];

	if (isset($_GET['_file']))
		$weaverx_fn = $_GET['_file'];

	if (isset($_GET['_ext']))
		$ext = $_GET['_ext'];

	if ( !$nonce || !$weaverx_fn || !$ext ) {
		@header('Content-Type: ' . get_option('html_type') . '; charset=' . get_option('blog_charset'));
		wp_die(__('Sorry - invalid download','weaver-xtreme-plus' /*adm*/));
	}

	if (! wp_verify_nonce($nonce, 'weaverxplus_download')) {
		@header('Content-Type: ' . get_option('html_type') . '; charset=' . get_option('blog_charset'));
		wp_die(__('Sorry - download must be initiated from admin panel.','weaver-xtreme-plus' /*adm*/) . ':' . $nonce);
	}

	if (headers_sent()) {
		@header('Content-Type: ' . get_option('html_type') . '; charset=' . get_option('blog_charset'));
		wp_die(__('Headers Sent: The headers have been sent by another plugin - there may be a plugin conflict.','weaver-xtreme-plus' /*adm*/));
	}

	$weaverx_opts = get_option( apply_filters('weaverx_options','weaverx_settings') ,array());
	$weaverxplus_opts = get_option('weaverxplus_settings' ,array());

	$weaverx_opts = array_filter( $weaverx_opts,  'weaverxplus_filter_strip_default' );
	$weaverxplus_opts = array_filter( $weaverxplus_opts,  'weaverxplus_filter_strip_default' );

	$save = array();

	$save['header'] = 'WVRX-PLUS1';		// format
	$save['ext'] = $ext;				// the extension

	$text = array('_perpagewidgets','header_html_text','footer_html_text','m_primary_html_left','m_primary_html_right','m_secondary_html_left',
	'm_secondary_html_right','info_home_label','m_extra_html_left','m_extra_html_right','excerpt_more_msg','post_icons',
	'custom_posted_on','custom_posted_in','custom_posted_on_single','custom_posted_in_single','copyright','custom_shadow',
	'head_opts','_althead_opts','_phpactions');

	switch ($ext) {
		case 'wxall':		// everything!
			unset( $weaverx_opts['wvrx_css_saved'] );
			//if (isset($weaverx_opts['fonts_added']) ) {
			//	$weaverx_opts['fonts_added'] = unserialize($weaverx_opts['fonts_added']);
			//}
			$save['weaverx'] = $weaverx_opts;
			$save['weaverxplus'] = $weaverxplus_opts;
			break;

		case 'wxplus':		// shortcode settings
			$save['weaverxplus'] = $weaverxplus_opts;
			break;

		case 'wxfont':	// added fonts
			if (isset($weaverx_opts['fonts_added']) ) {
				$save['wxfont'] = $weaverx_opts['fonts_added'];
			}
			/* if need to unserialize
			if (isset($weaverx_opts['fonts_added']) ) {
				$fonts = unserialize($weaverx_opts['fonts_added']);
				$save['wxfont_array'] = $fonts;
			}
			*/
			break;

		case 'wxtext':		// opts with text
			$temp = array();
			// '_url', '_cols_list', '_insert'
			foreach ($weaverx_opts as $opt => $val) {
				if ( strpos($opt, '_url') !== false || strpos($opt, '_cols_list') !== false
					|| strpos($opt, '_insert') !== false || in_array($opt, $text) ) { // found one
					$temp[$opt] = $val;
				}
			}
			$save['wxtext'] = $temp;
			break;

		case 'wxcolor':		// colors only
			$temp = array();
			foreach ($weaverx_opts as $opt => $val) {
				if ( ( strpos($opt, '_color') !== false || strpos($opt, '_bgcolor') !== false ) && strpos($opt, '_css') === false ) { // found one
					$temp[$opt] = $val;
				}
			}
			$save['wxcolor'] = $temp;
			break;

		case 'wxcolorcss':	// colors + CSS+
			$temp = array();
			foreach ($weaverx_opts as $opt => $val) {
				if ( ( strpos($opt, '_color') !== false || strpos($opt, '_bgcolor') !== false ) ) { // found one
					$temp[$opt] = $val;
				}
			}
			$save['wxcolorcss'] = $temp;
			break;

		case 'wxsite':	// diamond options
			$temp = array();
			foreach ($weaverx_opts as $opt => $val) {
				if ($opt[0] == '_')
					$temp[$opt] = $val;
			}
			$save['wxsite'] = $temp;
			break;
	}

	$weaverx_settings = serialize($save); /* serialize full set of options right now */

	//$weaverx_settings = print_r($save['weaverxplus'], true);
	/* $bom = pack("CCC", 0xef, 0xbb, 0xbf);
	if (0 === strncmp($weaverx_settings, $bom, 3)) {
        $weaverx_settings = substr($weaverx_settings, 3);
	} */

	header('Content-Description: File Transfer');
	header('Content-Type: application/octet-stream');
	header('Content-Disposition: attachment; filename='.$weaverx_fn);
	header('Content-Transfer-Encoding: binary');
	header('Expires: 0');
	header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
	header('Pragma: public');
	header('Content-Length: ' . strlen($weaverx_settings));
	echo $weaverx_settings;
	exit;
?>
